/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import com.google.common.collect.ImmutableList;
import io.trino.operator.aggregation.TypedSet;
import io.trino.spi.PageBuilder;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.Convention;
import io.trino.spi.function.Description;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.OperatorDependency;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.function.TypeParameter;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.type.BlockTypeOperators;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.List;

@ScalarFunction(value="array_distinct")
@Description(value="Remove duplicate values from the given array")
public final class ArrayDistinctFunction {
    public static final String NAME = "array_distinct";
    private final PageBuilder pageBuilder;

    @TypeParameter(value="E")
    public ArrayDistinctFunction(@TypeParameter(value="E") Type elementType) {
        this.pageBuilder = new PageBuilder((List)ImmutableList.of((Object)elementType));
    }

    @TypeParameter(value="E")
    @SqlType(value="array(E)")
    public Block distinct(@TypeParameter(value="E") Type type, @OperatorDependency(operator=OperatorType.IS_DISTINCT_FROM, argumentTypes={"E", "E"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION}, result=InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL)) BlockTypeOperators.BlockPositionIsDistinctFrom elementIsDistinctFrom, @OperatorDependency(operator=OperatorType.HASH_CODE, argumentTypes={"E"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION}, result=InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL)) BlockTypeOperators.BlockPositionHashCode elementHashCode, @SqlType(value="array(E)") Block array) {
        if (array.getPositionCount() < 2) {
            return array;
        }
        if (array.getPositionCount() == 2) {
            boolean distinct = elementIsDistinctFrom.isDistinctFrom(array, 0, array, 1);
            if (distinct) {
                return array;
            }
            return array.getSingleValueBlock(0);
        }
        if (this.pageBuilder.isFull()) {
            this.pageBuilder.reset();
        }
        BlockBuilder distinctElementsBlockBuilder = this.pageBuilder.getBlockBuilder(0);
        TypedSet distinctElements = TypedSet.createDistinctTypedSet(type, elementIsDistinctFrom, elementHashCode, distinctElementsBlockBuilder, array.getPositionCount(), NAME);
        for (int i = 0; i < array.getPositionCount(); ++i) {
            distinctElements.add(array, i);
        }
        this.pageBuilder.declarePositions(distinctElements.size());
        return distinctElementsBlockBuilder.getRegion(distinctElementsBlockBuilder.getPositionCount() - distinctElements.size(), distinctElements.size());
    }

    @SqlType(value="array(bigint)")
    public Block bigintDistinct(@SqlType(value="array(bigint)") Block array) {
        if (array.getPositionCount() == 0) {
            return array;
        }
        boolean containsNull = false;
        LongOpenHashSet set = new LongOpenHashSet(array.getPositionCount());
        int distinctCount = 0;
        if (this.pageBuilder.isFull()) {
            this.pageBuilder.reset();
        }
        BlockBuilder distinctElementBlockBuilder = this.pageBuilder.getBlockBuilder(0);
        for (int i = 0; i < array.getPositionCount(); ++i) {
            if (array.isNull(i)) {
                if (containsNull) continue;
                containsNull = true;
                distinctElementBlockBuilder.appendNull();
                ++distinctCount;
                continue;
            }
            long value = BigintType.BIGINT.getLong(array, i);
            if (set.contains(value)) continue;
            set.add(value);
            ++distinctCount;
            BigintType.BIGINT.appendTo(array, i, distinctElementBlockBuilder);
        }
        this.pageBuilder.declarePositions(distinctCount);
        return distinctElementBlockBuilder.getRegion(distinctElementBlockBuilder.getPositionCount() - distinctCount, distinctCount);
    }
}

