/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar.annotations;

import com.google.common.base.CaseFormat;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.metadata.OperatorNameUtil;
import io.trino.operator.annotations.FunctionsParserHelper;
import io.trino.operator.scalar.ScalarHeader;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.ScalarOperator;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class ScalarImplementationHeader {
    private final String name;
    private final Optional<OperatorType> operatorType;
    private final ScalarHeader header;

    private ScalarImplementationHeader(String name, ScalarHeader header) {
        this.name = Objects.requireNonNull(name);
        this.operatorType = Optional.empty();
        this.header = Objects.requireNonNull(header);
    }

    private ScalarImplementationHeader(OperatorType operatorType, ScalarHeader header) {
        this.name = OperatorNameUtil.mangleOperatorName(operatorType);
        this.operatorType = Optional.of(operatorType);
        this.header = Objects.requireNonNull(header);
    }

    private static String annotatedName(AnnotatedElement annotatedElement) {
        if (annotatedElement instanceof Class) {
            return ((Class)annotatedElement).getSimpleName();
        }
        if (annotatedElement instanceof Method) {
            return ((Method)annotatedElement).getName();
        }
        Preconditions.checkArgument((boolean)false, (Object)"Only Classes and Methods are supported as annotated elements.");
        return null;
    }

    private static String camelToSnake(String name) {
        return CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, name);
    }

    public static List<ScalarImplementationHeader> fromAnnotatedElement(AnnotatedElement annotated) {
        ImmutableList result;
        ScalarFunction scalarFunction = annotated.getAnnotation(ScalarFunction.class);
        ScalarOperator scalarOperator = annotated.getAnnotation(ScalarOperator.class);
        Optional<String> description = FunctionsParserHelper.parseDescription(annotated);
        ImmutableList.Builder builder = ImmutableList.builder();
        if (scalarFunction != null) {
            String baseName = scalarFunction.value().isEmpty() ? ScalarImplementationHeader.camelToSnake(ScalarImplementationHeader.annotatedName(annotated)) : scalarFunction.value();
            builder.add((Object)new ScalarImplementationHeader(baseName, new ScalarHeader(description, scalarFunction.hidden(), scalarFunction.deterministic())));
            for (String alias : scalarFunction.alias()) {
                builder.add((Object)new ScalarImplementationHeader(alias, new ScalarHeader(description, scalarFunction.hidden(), scalarFunction.deterministic())));
            }
        }
        if (scalarOperator != null) {
            builder.add((Object)new ScalarImplementationHeader(scalarOperator.value(), new ScalarHeader(description, true, true)));
        }
        Preconditions.checkArgument((!(result = builder.build()).isEmpty() ? 1 : 0) != 0);
        return result;
    }

    public String getName() {
        return this.name;
    }

    public Optional<OperatorType> getOperatorType() {
        return this.operatorType;
    }

    public Optional<String> getDescription() {
        return this.header.getDescription();
    }

    public boolean isHidden() {
        return this.header.isHidden();
    }

    public boolean isDeterministic() {
        return this.header.isDeterministic();
    }

    public ScalarHeader getHeader() {
        return this.header;
    }
}

