/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.unnest;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.SizeOf;
import io.trino.memory.context.LocalMemoryContext;
import io.trino.operator.DriverContext;
import io.trino.operator.Operator;
import io.trino.operator.OperatorContext;
import io.trino.operator.OperatorFactory;
import io.trino.operator.unnest.ArrayOfRowsUnnester;
import io.trino.operator.unnest.ArrayUnnester;
import io.trino.operator.unnest.MapUnnester;
import io.trino.operator.unnest.ReplicatedBlockBuilder;
import io.trino.operator.unnest.Unnester;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.LongArrayBlock;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.sql.planner.plan.PlanNodeId;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class UnnestOperator
implements Operator {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(UnnestOperator.class);
    private static final int MAX_ROWS_PER_BLOCK = 1000;
    private final OperatorContext operatorContext;
    private final LocalMemoryContext systemMemoryContext;
    private final List<Integer> replicateChannels;
    private final List<Type> replicateTypes;
    private final List<Integer> unnestChannels;
    private final List<Type> unnestTypes;
    private final boolean withOrdinality;
    private final boolean outer;
    private boolean finishing;
    private Page currentPage;
    private int currentPosition;
    private final List<Unnester> unnesters;
    private final List<ReplicatedBlockBuilder> replicatedBlockBuilders;
    private final int outputChannelCount;
    private int[] outputEntriesPerPosition = new int[0];
    private boolean[] ordinalityNull = new boolean[0];
    private int currentBatchOutputRowCount;

    public UnnestOperator(OperatorContext operatorContext, List<Integer> replicateChannels, List<Type> replicateTypes, List<Integer> unnestChannels, List<Type> unnestTypes, boolean withOrdinality, boolean outer) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        this.systemMemoryContext = operatorContext.newLocalUserMemoryContext(UnnestOperator.class.getSimpleName());
        this.replicateChannels = ImmutableList.copyOf((Collection)Objects.requireNonNull(replicateChannels, "replicateChannels is null"));
        this.replicateTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(replicateTypes, "replicateTypes is null"));
        Preconditions.checkArgument((replicateChannels.size() == replicateTypes.size() ? 1 : 0) != 0, (Object)"replicate channels or types has wrong size");
        this.replicatedBlockBuilders = (List)replicateTypes.stream().map(type -> new ReplicatedBlockBuilder()).collect(ImmutableList.toImmutableList());
        this.unnestChannels = ImmutableList.copyOf((Collection)Objects.requireNonNull(unnestChannels, "unnestChannels is null"));
        this.unnestTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(unnestTypes, "unnestTypes is null"));
        Preconditions.checkArgument((unnestChannels.size() == unnestTypes.size() ? 1 : 0) != 0, (Object)"unnest channels or types has wrong size");
        this.unnesters = (List)unnestTypes.stream().map(UnnestOperator::createUnnester).collect(ImmutableList.toImmutableList());
        this.withOrdinality = withOrdinality;
        this.outer = outer;
        int unnestOutputChannelCount = this.unnesters.stream().mapToInt(Unnester::getChannelCount).sum();
        this.outputChannelCount = unnestOutputChannelCount + replicateTypes.size() + (withOrdinality ? 1 : 0);
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public void finish() {
        this.finishing = true;
    }

    @Override
    public boolean isFinished() {
        return this.finishing && this.currentPage == null;
    }

    @Override
    public boolean needsInput() {
        return !this.finishing && this.currentPage == null;
    }

    @Override
    public void addInput(Page page) {
        Preconditions.checkState((!this.finishing ? 1 : 0) != 0, (Object)"Operator is already finishing");
        Objects.requireNonNull(page, "page is null");
        Preconditions.checkState((this.currentPage == null ? 1 : 0) != 0, (Object)"currentPage is not null");
        this.currentPage = page;
        this.currentPosition = 0;
        this.resetBlockBuilders();
        this.systemMemoryContext.setBytes(this.getRetainedSizeInBytes());
    }

    private void resetBlockBuilders() {
        int i;
        for (int i2 = 0; i2 < this.replicateTypes.size(); ++i2) {
            Block newInputBlock = this.currentPage.getBlock(this.replicateChannels.get(i2).intValue());
            this.replicatedBlockBuilders.get(i2).resetInputBlock(newInputBlock);
        }
        int positionCount = this.currentPage.getPositionCount();
        this.outputEntriesPerPosition = UnnestOperator.ensureCapacity(this.outputEntriesPerPosition, positionCount, true);
        for (i = 0; i < this.unnestTypes.size(); ++i) {
            int inputChannel = this.unnestChannels.get(i);
            Block unnestChannelInputBlock = this.currentPage.getBlock(inputChannel);
            Unnester unnester = this.unnesters.get(i);
            unnester.resetInput(unnestChannelInputBlock);
            int[] lengths = unnester.getOutputEntriesPerPosition();
            for (int j = 0; j < positionCount; ++j) {
                this.outputEntriesPerPosition[j] = Math.max(this.outputEntriesPerPosition[j], lengths[j]);
            }
        }
        if (this.outer) {
            this.ordinalityNull = UnnestOperator.ensureCapacity(this.ordinalityNull, positionCount, true);
            for (i = 0; i < this.outputEntriesPerPosition.length; ++i) {
                if (this.outputEntriesPerPosition[i] != 0) continue;
                this.outputEntriesPerPosition[i] = 1;
                this.ordinalityNull[i] = true;
            }
        }
    }

    @Override
    public Page getOutput() {
        if (this.currentPage == null) {
            return null;
        }
        if (this.currentPosition == this.currentPage.getPositionCount()) {
            this.currentPage = null;
            this.currentPosition = 0;
            return null;
        }
        int batchSize = this.calculateNextBatchSize();
        Block[] outputBlocks = this.buildOutputBlocks(batchSize);
        return new Page(outputBlocks);
    }

    private int calculateNextBatchSize() {
        int length;
        int position;
        int positionCount = this.currentPage.getPositionCount();
        int outputRowCount = 0;
        for (position = this.currentPosition; position < positionCount && outputRowCount + (length = this.outputEntriesPerPosition[position]) < 1000; ++position) {
            outputRowCount += length;
        }
        if (position == this.currentPosition) {
            this.currentBatchOutputRowCount = this.outputEntriesPerPosition[this.currentPosition];
            return 1;
        }
        this.currentBatchOutputRowCount = outputRowCount;
        return position - this.currentPosition;
    }

    private Block[] buildOutputBlocks(int batchSize) {
        Block[] outputBlocks = new Block[this.outputChannelCount];
        int channel = 0;
        for (int replicateIndex = 0; replicateIndex < this.replicateTypes.size(); ++replicateIndex) {
            outputBlocks[channel++] = this.replicatedBlockBuilders.get(replicateIndex).buildOutputBlock(this.outputEntriesPerPosition, this.currentPosition, batchSize, this.currentBatchOutputRowCount);
        }
        for (int unnestIndex = 0; unnestIndex < this.unnesters.size(); ++unnestIndex) {
            Unnester unnester = this.unnesters.get(unnestIndex);
            Block[] blocks = unnester.buildOutputBlocks(this.outputEntriesPerPosition, this.currentPosition, batchSize, this.currentBatchOutputRowCount);
            for (int j = 0; j < unnester.getChannelCount(); ++j) {
                outputBlocks[channel++] = blocks[j];
            }
        }
        if (this.withOrdinality) {
            outputBlocks[channel] = this.outer ? UnnestOperator.buildOrdinalityBlockWithNulls(this.outputEntriesPerPosition, this.ordinalityNull, this.currentPosition, batchSize, this.currentBatchOutputRowCount) : UnnestOperator.buildOrdinalityBlock(this.outputEntriesPerPosition, this.currentPosition, batchSize, this.currentBatchOutputRowCount);
        }
        this.currentPosition += batchSize;
        return outputBlocks;
    }

    private static Block buildOrdinalityBlock(int[] outputEntriesPerPosition, int offset, int inputEntryCount, int outputEntryCount) {
        long[] values = new long[outputEntryCount];
        int outputPosition = 0;
        for (int i = 0; i < inputEntryCount; ++i) {
            int currentOutputEntries = outputEntriesPerPosition[offset + i];
            for (int j = 1; j <= currentOutputEntries; ++j) {
                values[outputPosition++] = j;
            }
        }
        return new LongArrayBlock(outputEntryCount, Optional.empty(), values);
    }

    private static Block buildOrdinalityBlockWithNulls(int[] outputEntriesPerPosition, boolean[] ordinalityNull, int offset, int inputEntryCount, int outputEntryCount) {
        long[] values = new long[outputEntryCount];
        boolean[] isNull = new boolean[outputEntryCount];
        int outputPosition = 0;
        for (int i = 0; i < inputEntryCount; ++i) {
            if (ordinalityNull[offset + i]) {
                isNull[outputPosition++] = true;
                continue;
            }
            int currentOutputEntries = outputEntriesPerPosition[offset + i];
            for (int j = 1; j <= currentOutputEntries; ++j) {
                values[outputPosition++] = j;
            }
        }
        return new LongArrayBlock(outputEntryCount, Optional.of(isNull), values);
    }

    private static Unnester createUnnester(Type nestedType) {
        if (nestedType instanceof ArrayType) {
            Type elementType = ((ArrayType)nestedType).getElementType();
            if (elementType instanceof RowType) {
                return new ArrayOfRowsUnnester(elementType.getTypeParameters().size());
            }
            return new ArrayUnnester();
        }
        if (nestedType instanceof MapType) {
            return new MapUnnester();
        }
        throw new IllegalArgumentException("Cannot unnest type: " + nestedType);
    }

    public static int[] ensureCapacity(int[] buffer, int capacity, boolean forceReset) {
        if (buffer == null || buffer.length < capacity) {
            return new int[capacity];
        }
        if (forceReset) {
            Arrays.fill(buffer, 0);
        }
        return buffer;
    }

    public static boolean[] ensureCapacity(boolean[] buffer, int capacity, boolean forceReset) {
        if (buffer == null || buffer.length < capacity) {
            return new boolean[capacity];
        }
        if (forceReset) {
            Arrays.fill(buffer, false);
        }
        return buffer;
    }

    private long getRetainedSizeInBytes() {
        long size = (long)INSTANCE_SIZE + SizeOf.sizeOf((int[])this.outputEntriesPerPosition) + this.currentPage.getRetainedSizeInBytes();
        for (Unnester unnester : this.unnesters) {
            size += unnester.getRetainedSizeInBytes();
        }
        return size;
    }

    public static class UnnestOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final PlanNodeId planNodeId;
        private final List<Integer> replicateChannels;
        private final List<Type> replicateTypes;
        private final List<Integer> unnestChannels;
        private final List<Type> unnestTypes;
        private final boolean withOrdinality;
        private final boolean outer;
        private boolean closed;

        public UnnestOperatorFactory(int operatorId, PlanNodeId planNodeId, List<Integer> replicateChannels, List<Type> replicateTypes, List<Integer> unnestChannels, List<Type> unnestTypes, boolean withOrdinality, boolean outer) {
            this.operatorId = operatorId;
            this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
            this.replicateChannels = ImmutableList.copyOf((Collection)Objects.requireNonNull(replicateChannels, "replicateChannels is null"));
            this.replicateTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(replicateTypes, "replicateTypes is null"));
            Preconditions.checkArgument((replicateChannels.size() == replicateTypes.size() ? 1 : 0) != 0, (Object)"replicateChannels and replicateTypes do not match");
            this.unnestChannels = ImmutableList.copyOf((Collection)Objects.requireNonNull(unnestChannels, "unnestChannels is null"));
            this.unnestTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(unnestTypes, "unnestTypes is null"));
            Preconditions.checkArgument((unnestChannels.size() == unnestTypes.size() ? 1 : 0) != 0, (Object)"unnestChannels and unnestTypes do not match");
            this.withOrdinality = withOrdinality;
            this.outer = outer;
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, this.planNodeId, UnnestOperator.class.getSimpleName());
            return new UnnestOperator(operatorContext, this.replicateChannels, this.replicateTypes, this.unnestChannels, this.unnestTypes, this.withOrdinality, this.outer);
        }

        @Override
        public void noMoreOperators() {
            this.closed = true;
        }

        @Override
        public OperatorFactory duplicate() {
            return new UnnestOperatorFactory(this.operatorId, this.planNodeId, this.replicateChannels, this.replicateTypes, this.unnestChannels, this.unnestTypes, this.withOrdinality, this.outer);
        }
    }
}

