/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.window;

import com.google.common.collect.Iterables;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.ValueWindowFunction;
import io.trino.spi.function.WindowFunctionSignature;
import java.util.List;

@WindowFunctionSignature(name="first_value", typeVariable="T", returnType="T", argumentTypes={"T"})
public class FirstValueFunction
extends ValueWindowFunction {
    private final int argumentChannel;
    private final boolean ignoreNulls;

    public FirstValueFunction(List<Integer> argumentChannels, boolean ignoreNulls) {
        this.argumentChannel = (Integer)Iterables.getOnlyElement(argumentChannels);
        this.ignoreNulls = ignoreNulls;
    }

    public void processRow(BlockBuilder output, int frameStart, int frameEnd, int currentPosition) {
        int valuePosition;
        if (frameStart < 0) {
            output.appendNull();
            return;
        }
        if (this.ignoreNulls) {
            for (valuePosition = frameStart; valuePosition >= 0 && valuePosition <= frameEnd && this.windowIndex.isNull(this.argumentChannel, valuePosition); ++valuePosition) {
            }
            if (valuePosition > frameEnd) {
                output.appendNull();
                return;
            }
        }
        this.windowIndex.appendTo(this.argumentChannel, valuePosition, output);
    }
}

