/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.window.pattern;

import io.trino.memory.context.AggregatedMemoryContext;
import io.trino.memory.context.LocalMemoryContext;
import io.trino.operator.aggregation.WindowAccumulator;
import io.trino.operator.window.AggregationWindowFunctionSupplier;
import io.trino.operator.window.MappedWindowIndex;
import io.trino.operator.window.matcher.ArrayView;
import io.trino.operator.window.pattern.ProjectingPagesWindowIndex;
import io.trino.operator.window.pattern.SetEvaluator;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.BoundSignature;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;

public class MatchAggregation {
    private static final int ROWS_UNTIL_MEMORY_REPORT = 1000;
    private final BoundSignature boundSignature;
    private final Supplier<WindowAccumulator> accumulatorFactory;
    private final MappedWindowIndex mappedWindowIndex;
    private final SetEvaluator setEvaluator;
    private final AggregatedMemoryContext memoryContextSupplier;
    private final LocalMemoryContext memoryContext;
    private WindowAccumulator accumulator;
    private int rowsFromMemoryReport;
    private Block resultOnEmpty;

    private MatchAggregation(BoundSignature boundSignature, Supplier<WindowAccumulator> accumulatorFactory, List<Integer> argumentChannels, SetEvaluator setEvaluator, AggregatedMemoryContext memoryContextSupplier) {
        this.boundSignature = Objects.requireNonNull(boundSignature, "boundSignature is null");
        this.accumulatorFactory = Objects.requireNonNull(accumulatorFactory, "accumulatorFactory is null");
        this.mappedWindowIndex = new MappedWindowIndex(argumentChannels);
        this.setEvaluator = setEvaluator;
        this.memoryContextSupplier = memoryContextSupplier;
        this.memoryContext = memoryContextSupplier.newLocalMemoryContext(MatchAggregation.class.getSimpleName());
        this.resetAccumulator();
    }

    private MatchAggregation(BoundSignature boundSignature, MappedWindowIndex mappedWindowIndex, Supplier<WindowAccumulator> accumulatorFactory, SetEvaluator setEvaluator, WindowAccumulator accumulator, AggregatedMemoryContext memoryContextSupplier) {
        this.boundSignature = boundSignature;
        this.mappedWindowIndex = mappedWindowIndex;
        this.accumulatorFactory = accumulatorFactory;
        this.setEvaluator = setEvaluator;
        this.memoryContextSupplier = memoryContextSupplier;
        this.memoryContext = memoryContextSupplier.newLocalMemoryContext(MatchAggregation.class.getSimpleName());
        this.accumulator = accumulator;
    }

    public void reset() {
        this.resetAccumulator();
        this.setEvaluator.reset();
        this.rowsFromMemoryReport = 0;
    }

    private void resetAccumulator() {
        this.accumulator = this.accumulatorFactory.get();
    }

    public Block aggregate(int currentRow, ArrayView matchedLabels, long matchNumber, ProjectingPagesWindowIndex windowIndex, int partitionStart, int patternStart) {
        this.mappedWindowIndex.setDelegate(windowIndex);
        ArrayView positions = this.setEvaluator.resolveNewPositions(currentRow, matchedLabels, partitionStart, patternStart);
        for (int i = 0; i < positions.length(); ++i) {
            int position = positions.get(i);
            windowIndex.setLabelAndMatchNumber(position, matchedLabels.get(position + partitionStart - patternStart), matchNumber);
            this.accumulator.addInput(this.mappedWindowIndex, position, position);
        }
        this.mappedWindowIndex.setDelegate(null);
        this.rowsFromMemoryReport += positions.length();
        if (this.rowsFromMemoryReport >= 1000) {
            this.rowsFromMemoryReport = 0;
            this.memoryContext.setBytes(this.accumulator.getEstimatedSize() + this.setEvaluator.getAllPositionsSizeInBytes());
        }
        BlockBuilder blockBuilder = this.boundSignature.getReturnType().createBlockBuilder(null, 1);
        this.accumulator.evaluateFinal(blockBuilder);
        return blockBuilder.build();
    }

    public Block aggregateEmpty() {
        if (this.resultOnEmpty != null) {
            return this.resultOnEmpty;
        }
        BlockBuilder blockBuilder = this.boundSignature.getReturnType().createBlockBuilder(null, 1);
        this.accumulatorFactory.get().evaluateFinal(blockBuilder);
        this.resultOnEmpty = blockBuilder.build();
        return this.resultOnEmpty;
    }

    public ArrayView getAllPositions(ArrayView labels) {
        return this.setEvaluator.getAllPositions(labels);
    }

    public MatchAggregation copy() {
        WindowAccumulator accumulatorCopy;
        try {
            accumulatorCopy = this.accumulator.copy();
        }
        catch (UnsupportedOperationException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("aggregate function %s does not support copying", this.boundSignature.getName()), (Throwable)e);
        }
        return new MatchAggregation(this.boundSignature, this.mappedWindowIndex, this.accumulatorFactory, this.setEvaluator.copy(), accumulatorCopy, this.memoryContextSupplier);
    }

    public static class MatchAggregationInstantiator {
        private final BoundSignature boundSignature;
        private final Supplier<WindowAccumulator> accumulatorFactory;
        private final List<Integer> argumentChannels;
        private final SetEvaluator.SetEvaluatorSupplier setEvaluatorSupplier;

        public MatchAggregationInstantiator(BoundSignature boundSignature, AggregationWindowFunctionSupplier aggregationWindowFunctionSupplier, List<Integer> argumentChannels, List<Supplier<Object>> lambdaProviders, SetEvaluator.SetEvaluatorSupplier setEvaluatorSupplier) {
            this.boundSignature = boundSignature;
            this.argumentChannels = Objects.requireNonNull(argumentChannels, "argumentChannels is null");
            this.setEvaluatorSupplier = Objects.requireNonNull(setEvaluatorSupplier, "setEvaluatorSupplier is null");
            this.accumulatorFactory = () -> aggregationWindowFunctionSupplier.createWindowAccumulator(lambdaProviders);
        }

        public MatchAggregation get(AggregatedMemoryContext memoryContextSupplier) {
            Objects.requireNonNull(memoryContextSupplier, "memoryContextSupplier is null");
            return new MatchAggregation(this.boundSignature, this.accumulatorFactory, this.argumentChannels, this.setEvaluatorSupplier.get(), memoryContextSupplier);
        }
    }
}

