/*
 * Decompiled with CFR 0.152.
 */
package io.trino.security;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.configuration.ConfigurationLoader;
import io.airlift.log.Logger;
import io.airlift.stats.CounterStat;
import io.trino.connector.CatalogServiceProvider;
import io.trino.eventlistener.EventListenerManager;
import io.trino.metadata.QualifiedObjectName;
import io.trino.plugin.base.security.AllowAllSystemAccessControl;
import io.trino.plugin.base.security.DefaultSystemAccessControl;
import io.trino.plugin.base.security.FileBasedSystemAccessControl;
import io.trino.plugin.base.security.ForwardingSystemAccessControl;
import io.trino.plugin.base.security.ReadOnlySystemAccessControl;
import io.trino.security.AccessControl;
import io.trino.security.AccessControlConfig;
import io.trino.security.DefaultSystemAccessControlName;
import io.trino.security.SecurityContext;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.QueryId;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.classloader.ThreadContextClassLoader;
import io.trino.spi.connector.CatalogHandle;
import io.trino.spi.connector.CatalogSchemaName;
import io.trino.spi.connector.CatalogSchemaTableName;
import io.trino.spi.connector.ConnectorAccessControl;
import io.trino.spi.connector.ConnectorSecurityContext;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.function.FunctionKind;
import io.trino.spi.security.Identity;
import io.trino.spi.security.PrincipalType;
import io.trino.spi.security.Privilege;
import io.trino.spi.security.SystemAccessControl;
import io.trino.spi.security.SystemAccessControlFactory;
import io.trino.spi.security.SystemSecurityContext;
import io.trino.spi.security.TrinoPrincipal;
import io.trino.spi.security.ViewExpression;
import io.trino.spi.type.Type;
import io.trino.transaction.TransactionId;
import io.trino.transaction.TransactionManager;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.security.Principal;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.inject.Inject;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

public class AccessControlManager
implements AccessControl {
    private static final Logger log = Logger.get(AccessControlManager.class);
    private static final File CONFIG_FILE = new File("etc/access-control.properties");
    private static final String NAME_PROPERTY = "access-control.name";
    private final TransactionManager transactionManager;
    private final EventListenerManager eventListenerManager;
    private final List<File> configFiles;
    private final String defaultAccessControlName;
    private final Map<String, SystemAccessControlFactory> systemAccessControlFactories = new ConcurrentHashMap<String, SystemAccessControlFactory>();
    private final AtomicReference<CatalogServiceProvider<Optional<ConnectorAccessControl>>> connectorAccessControlProvider = new AtomicReference();
    private final AtomicReference<List<SystemAccessControl>> systemAccessControls = new AtomicReference();
    private final CounterStat authorizationSuccess = new CounterStat();
    private final CounterStat authorizationFail = new CounterStat();

    @Inject
    public AccessControlManager(TransactionManager transactionManager, EventListenerManager eventListenerManager, AccessControlConfig config, @DefaultSystemAccessControlName String defaultAccessControlName) {
        this.transactionManager = Objects.requireNonNull(transactionManager, "transactionManager is null");
        this.eventListenerManager = Objects.requireNonNull(eventListenerManager, "eventListenerManager is null");
        this.configFiles = ImmutableList.copyOf(config.getAccessControlFiles());
        this.defaultAccessControlName = Objects.requireNonNull(defaultAccessControlName, "defaultAccessControl is null");
        this.addSystemAccessControlFactory((SystemAccessControlFactory)new DefaultSystemAccessControl.Factory());
        this.addSystemAccessControlFactory((SystemAccessControlFactory)new AllowAllSystemAccessControl.Factory());
        this.addSystemAccessControlFactory((SystemAccessControlFactory)new ReadOnlySystemAccessControl.Factory());
        this.addSystemAccessControlFactory((SystemAccessControlFactory)new FileBasedSystemAccessControl.Factory());
    }

    public final void addSystemAccessControlFactory(SystemAccessControlFactory accessControlFactory) {
        Objects.requireNonNull(accessControlFactory, "accessControlFactory is null");
        if (this.systemAccessControlFactories.putIfAbsent(accessControlFactory.getName(), accessControlFactory) != null) {
            throw new IllegalArgumentException(String.format("Access control '%s' is already registered", accessControlFactory.getName()));
        }
    }

    public void setConnectorAccessControlProvider(CatalogServiceProvider<Optional<ConnectorAccessControl>> connectorAccessControlProvider) {
        if (!this.connectorAccessControlProvider.compareAndSet(null, connectorAccessControlProvider)) {
            throw new IllegalStateException("connectorAccessControlProvider already set");
        }
    }

    public void loadSystemAccessControl() {
        ImmutableList configFiles = this.configFiles;
        if (configFiles.isEmpty()) {
            if (!CONFIG_FILE.exists()) {
                this.loadSystemAccessControl(this.defaultAccessControlName, (Map<String, String>)ImmutableMap.of());
                log.info("Using system access control: %s", new Object[]{this.defaultAccessControlName});
                return;
            }
            configFiles = ImmutableList.of((Object)CONFIG_FILE);
        }
        List systemAccessControls = (List)configFiles.stream().map(this::createSystemAccessControl).collect(ImmutableList.toImmutableList());
        systemAccessControls.stream().map(SystemAccessControl::getEventListeners).flatMap(listeners -> ImmutableSet.copyOf((Iterable)listeners).stream()).forEach(this.eventListenerManager::addEventListener);
        this.setSystemAccessControls(systemAccessControls);
    }

    private SystemAccessControl createSystemAccessControl(File configFile) {
        SystemAccessControl systemAccessControl;
        HashMap properties;
        log.info("-- Loading system access control %s --", new Object[]{configFile});
        configFile = configFile.getAbsoluteFile();
        try {
            properties = new HashMap(ConfigurationLoader.loadPropertiesFrom((String)configFile.getPath()));
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to read configuration file: " + configFile, e);
        }
        String name = (String)properties.remove(NAME_PROPERTY);
        Preconditions.checkState((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (String)"Access control configuration does not contain '%s' property: %s", (Object)NAME_PROPERTY, (Object)configFile);
        SystemAccessControlFactory factory = this.systemAccessControlFactories.get(name);
        Preconditions.checkState((factory != null ? 1 : 0) != 0, (String)"Access control '%s' is not registered: %s", (Object)name, (Object)configFile);
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(factory.getClass().getClassLoader());){
            systemAccessControl = factory.create((Map)ImmutableMap.copyOf(properties));
        }
        log.info("-- Loaded system access control %s --", new Object[]{name});
        return systemAccessControl;
    }

    @VisibleForTesting
    public void loadSystemAccessControl(String name, Map<String, String> properties) {
        SystemAccessControl systemAccessControl;
        Objects.requireNonNull(name, "name is null");
        Objects.requireNonNull(properties, "properties is null");
        SystemAccessControlFactory factory = this.systemAccessControlFactories.get(name);
        Preconditions.checkState((factory != null ? 1 : 0) != 0, (String)"Access control '%s' is not registered", (Object)name);
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(factory.getClass().getClassLoader());){
            systemAccessControl = factory.create((Map)ImmutableMap.copyOf(properties));
        }
        systemAccessControl.getEventListeners().forEach(this.eventListenerManager::addEventListener);
        this.setSystemAccessControls((List<SystemAccessControl>)ImmutableList.of((Object)systemAccessControl));
    }

    @VisibleForTesting
    public void addSystemAccessControl(SystemAccessControl systemAccessControl) {
        this.systemAccessControls.updateAndGet(currentControls -> ImmutableList.builder().addAll((Iterable)currentControls).add((Object)systemAccessControl).build());
    }

    @VisibleForTesting
    public void setSystemAccessControls(List<SystemAccessControl> systemAccessControls) {
        Preconditions.checkState((boolean)this.systemAccessControls.compareAndSet(null, systemAccessControls), (Object)"System access control already initialized");
    }

    @Override
    public void checkCanImpersonateUser(Identity identity, String userName) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(userName, "userName is null");
        this.systemAuthorizationCheck(control -> control.checkCanImpersonateUser(new SystemSecurityContext(identity, Optional.empty()), userName));
    }

    @Override
    @Deprecated
    public void checkCanSetUser(Optional<Principal> principal, String userName) {
        Objects.requireNonNull(principal, "principal is null");
        Objects.requireNonNull(userName, "userName is null");
        this.systemAuthorizationCheck(control -> control.checkCanSetUser(principal, userName));
    }

    @Override
    public void checkCanReadSystemInformation(Identity identity) {
        Objects.requireNonNull(identity, "identity is null");
        this.systemAuthorizationCheck(control -> control.checkCanReadSystemInformation(new SystemSecurityContext(identity, Optional.empty())));
    }

    @Override
    public void checkCanWriteSystemInformation(Identity identity) {
        Objects.requireNonNull(identity, "identity is null");
        this.systemAuthorizationCheck(control -> control.checkCanWriteSystemInformation(new SystemSecurityContext(identity, Optional.empty())));
    }

    @Override
    public void checkCanExecuteQuery(Identity identity) {
        Objects.requireNonNull(identity, "identity is null");
        this.systemAuthorizationCheck(control -> control.checkCanExecuteQuery(new SystemSecurityContext(identity, Optional.empty())));
    }

    @Override
    public void checkCanViewQueryOwnedBy(Identity identity, Identity queryOwner) {
        Objects.requireNonNull(identity, "identity is null");
        this.systemAuthorizationCheck(control -> control.checkCanViewQueryOwnedBy(new SystemSecurityContext(identity, Optional.empty()), queryOwner));
    }

    @Override
    public Collection<Identity> filterQueriesOwnedBy(Identity identity, Collection<Identity> queryOwners) {
        for (SystemAccessControl systemAccessControl : this.getSystemAccessControls()) {
            queryOwners = systemAccessControl.filterViewQueryOwnedBy(new SystemSecurityContext(identity, Optional.empty()), queryOwners);
        }
        return queryOwners;
    }

    @Override
    public void checkCanKillQueryOwnedBy(Identity identity, Identity queryOwner) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(queryOwner, "queryOwner is null");
        this.systemAuthorizationCheck(control -> control.checkCanKillQueryOwnedBy(new SystemSecurityContext(identity, Optional.empty()), queryOwner));
    }

    @Override
    public void checkCanCreateCatalog(SecurityContext securityContext, String catalog) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(catalog, "catalog is null");
        this.systemAuthorizationCheck(control -> control.checkCanCreateCatalog(securityContext.toSystemSecurityContext(), catalog));
    }

    @Override
    public void checkCanDropCatalog(SecurityContext securityContext, String catalog) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(catalog, "catalog is null");
        this.systemAuthorizationCheck(control -> control.checkCanDropCatalog(securityContext.toSystemSecurityContext(), catalog));
    }

    @Override
    public Set<String> filterCatalogs(SecurityContext securityContext, Set<String> catalogs) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(catalogs, "catalogs is null");
        for (SystemAccessControl systemAccessControl : this.getSystemAccessControls()) {
            catalogs = systemAccessControl.filterCatalogs(securityContext.toSystemSecurityContext(), catalogs);
        }
        return catalogs;
    }

    @Override
    public void checkCanCreateSchema(SecurityContext securityContext, CatalogSchemaName schemaName, Map<String, Object> properties) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(schemaName, "schemaName is null");
        this.checkCanAccessCatalog(securityContext, schemaName.getCatalogName());
        this.systemAuthorizationCheck(control -> control.checkCanCreateSchema(securityContext.toSystemSecurityContext(), schemaName, properties));
        this.catalogAuthorizationCheck(schemaName.getCatalogName(), securityContext, (control, context) -> control.checkCanCreateSchema(context, schemaName.getSchemaName(), properties));
    }

    @Override
    public void checkCanDropSchema(SecurityContext securityContext, CatalogSchemaName schemaName) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(schemaName, "schemaName is null");
        this.checkCanAccessCatalog(securityContext, schemaName.getCatalogName());
        this.systemAuthorizationCheck(control -> control.checkCanDropSchema(securityContext.toSystemSecurityContext(), schemaName));
        this.catalogAuthorizationCheck(schemaName.getCatalogName(), securityContext, (control, context) -> control.checkCanDropSchema(context, schemaName.getSchemaName()));
    }

    @Override
    public void checkCanRenameSchema(SecurityContext securityContext, CatalogSchemaName schemaName, String newSchemaName) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(schemaName, "schemaName is null");
        this.checkCanAccessCatalog(securityContext, schemaName.getCatalogName());
        this.systemAuthorizationCheck(control -> control.checkCanRenameSchema(securityContext.toSystemSecurityContext(), schemaName, newSchemaName));
        this.catalogAuthorizationCheck(schemaName.getCatalogName(), securityContext, (control, context) -> control.checkCanRenameSchema(context, schemaName.getSchemaName(), newSchemaName));
    }

    @Override
    public void checkCanSetSchemaAuthorization(SecurityContext securityContext, CatalogSchemaName schemaName, TrinoPrincipal principal) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(schemaName, "schemaName is null");
        this.checkCanAccessCatalog(securityContext, schemaName.getCatalogName());
        this.systemAuthorizationCheck(control -> control.checkCanSetSchemaAuthorization(securityContext.toSystemSecurityContext(), schemaName, principal));
        this.catalogAuthorizationCheck(schemaName.getCatalogName(), securityContext, (control, context) -> control.checkCanSetSchemaAuthorization(context, schemaName.getSchemaName(), principal));
    }

    @Override
    public void checkCanShowSchemas(SecurityContext securityContext, String catalogName) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(catalogName, "catalogName is null");
        this.checkCanAccessCatalog(securityContext, catalogName);
        this.systemAuthorizationCheck(control -> control.checkCanShowSchemas(securityContext.toSystemSecurityContext(), catalogName));
        this.catalogAuthorizationCheck(catalogName, securityContext, ConnectorAccessControl::checkCanShowSchemas);
    }

    @Override
    public Set<String> filterSchemas(SecurityContext securityContext, String catalogName, Set<String> schemaNames) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(catalogName, "catalogName is null");
        Objects.requireNonNull(schemaNames, "schemaNames is null");
        if (this.filterCatalogs(securityContext, (Set<String>)ImmutableSet.of((Object)catalogName)).isEmpty()) {
            return ImmutableSet.of();
        }
        for (SystemAccessControl systemAccessControl : this.getSystemAccessControls()) {
            schemaNames = systemAccessControl.filterSchemas(securityContext.toSystemSecurityContext(), catalogName, schemaNames);
        }
        ConnectorAccessControl connectorAccessControl = this.getConnectorAccessControl(securityContext.getTransactionId(), catalogName);
        if (connectorAccessControl != null) {
            schemaNames = connectorAccessControl.filterSchemas(this.toConnectorSecurityContext(catalogName, securityContext), schemaNames);
        }
        return schemaNames;
    }

    @Override
    public void checkCanShowCreateSchema(SecurityContext securityContext, CatalogSchemaName schemaName) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(schemaName, "schemaName is null");
        this.checkCanAccessCatalog(securityContext, schemaName.getCatalogName());
        this.systemAuthorizationCheck(control -> control.checkCanShowCreateSchema(securityContext.toSystemSecurityContext(), schemaName));
        this.catalogAuthorizationCheck(schemaName.getCatalogName(), securityContext, (control, context) -> control.checkCanShowCreateSchema(context, schemaName.getSchemaName()));
    }

    @Override
    public void checkCanShowCreateTable(SecurityContext securityContext, QualifiedObjectName tableName) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(tableName, "tableName is null");
        this.checkCanAccessCatalog(securityContext, tableName.getCatalogName());
        this.systemAuthorizationCheck(control -> control.checkCanShowCreateTable(securityContext.toSystemSecurityContext(), tableName.asCatalogSchemaTableName()));
        this.catalogAuthorizationCheck(tableName.getCatalogName(), securityContext, (control, context) -> control.checkCanShowCreateTable(context, tableName.asSchemaTableName()));
    }

    @Override
    public void checkCanCreateTable(SecurityContext securityContext, QualifiedObjectName tableName, Map<String, Object> properties) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(tableName, "tableName is null");
        this.checkCanAccessCatalog(securityContext, tableName.getCatalogName());
        this.systemAuthorizationCheck(control -> control.checkCanCreateTable(securityContext.toSystemSecurityContext(), tableName.asCatalogSchemaTableName(), properties));
        this.catalogAuthorizationCheck(tableName.getCatalogName(), securityContext, (control, context) -> control.checkCanCreateTable(context, tableName.asSchemaTableName(), properties));
    }

    @Override
    public void checkCanDropTable(SecurityContext securityContext, QualifiedObjectName tableName) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(tableName, "tableName is null");
        this.checkCanAccessCatalog(securityContext, tableName.getCatalogName());
        this.systemAuthorizationCheck(control -> control.checkCanDropTable(securityContext.toSystemSecurityContext(), tableName.asCatalogSchemaTableName()));
        this.catalogAuthorizationCheck(tableName.getCatalogName(), securityContext, (control, context) -> control.checkCanDropTable(context, tableName.asSchemaTableName()));
    }

    @Override
    public void checkCanRenameTable(SecurityContext securityContext, QualifiedObjectName tableName, QualifiedObjectName newTableName) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(tableName, "tableName is null");
        Objects.requireNonNull(newTableName, "newTableName is null");
        this.checkCanAccessCatalog(securityContext, tableName.getCatalogName());
        this.systemAuthorizationCheck(control -> control.checkCanRenameTable(securityContext.toSystemSecurityContext(), tableName.asCatalogSchemaTableName(), newTableName.asCatalogSchemaTableName()));
        this.catalogAuthorizationCheck(tableName.getCatalogName(), securityContext, (control, context) -> control.checkCanRenameTable(context, tableName.asSchemaTableName(), newTableName.asSchemaTableName()));
    }

    @Override
    public void checkCanSetTableProperties(SecurityContext securityContext, QualifiedObjectName tableName, Map<String, Optional<Object>> properties) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(tableName, "tableName is null");
        Objects.requireNonNull(properties, "nonNullProperties is null");
        this.checkCanAccessCatalog(securityContext, tableName.getCatalogName());
        this.systemAuthorizationCheck(control -> control.checkCanSetTableProperties(securityContext.toSystemSecurityContext(), tableName.asCatalogSchemaTableName(), properties));
        this.catalogAuthorizationCheck(tableName.getCatalogName(), securityContext, (control, context) -> control.checkCanSetTableProperties(context, tableName.asSchemaTableName(), properties));
    }

    @Override
    public void checkCanSetTableComment(SecurityContext securityContext, QualifiedObjectName tableName) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(tableName, "tableName is null");
        this.checkCanAccessCatalog(securityContext, tableName.getCatalogName());
        this.systemAuthorizationCheck(control -> control.checkCanSetTableComment(securityContext.toSystemSecurityContext(), tableName.asCatalogSchemaTableName()));
        this.catalogAuthorizationCheck(tableName.getCatalogName(), securityContext, (control, context) -> control.checkCanSetTableComment(context, tableName.asSchemaTableName()));
    }

    @Override
    public void checkCanSetViewComment(SecurityContext securityContext, QualifiedObjectName viewName) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(viewName, "viewName is null");
        this.checkCanAccessCatalog(securityContext, viewName.getCatalogName());
        this.systemAuthorizationCheck(control -> control.checkCanSetViewComment(securityContext.toSystemSecurityContext(), viewName.asCatalogSchemaTableName()));
        this.catalogAuthorizationCheck(viewName.getCatalogName(), securityContext, (control, context) -> control.checkCanSetViewComment(context, viewName.asSchemaTableName()));
    }

    @Override
    public void checkCanSetColumnComment(SecurityContext securityContext, QualifiedObjectName tableName) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(tableName, "tableName is null");
        this.checkCanAccessCatalog(securityContext, tableName.getCatalogName());
        this.systemAuthorizationCheck(control -> control.checkCanSetColumnComment(securityContext.toSystemSecurityContext(), tableName.asCatalogSchemaTableName()));
        this.catalogAuthorizationCheck(tableName.getCatalogName(), securityContext, (control, context) -> control.checkCanSetColumnComment(context, tableName.asSchemaTableName()));
    }

    @Override
    public void checkCanShowTables(SecurityContext securityContext, CatalogSchemaName schema) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(schema, "schema is null");
        this.checkCanAccessCatalog(securityContext, schema.getCatalogName());
        this.systemAuthorizationCheck(control -> control.checkCanShowTables(securityContext.toSystemSecurityContext(), schema));
        this.catalogAuthorizationCheck(schema.getCatalogName(), securityContext, (control, context) -> control.checkCanShowTables(context, schema.getSchemaName()));
    }

    @Override
    public Set<SchemaTableName> filterTables(SecurityContext securityContext, String catalogName, Set<SchemaTableName> tableNames) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(catalogName, "catalogName is null");
        Objects.requireNonNull(tableNames, "tableNames is null");
        if (this.filterCatalogs(securityContext, (Set<String>)ImmutableSet.of((Object)catalogName)).isEmpty()) {
            return ImmutableSet.of();
        }
        for (SystemAccessControl systemAccessControl : this.getSystemAccessControls()) {
            tableNames = systemAccessControl.filterTables(securityContext.toSystemSecurityContext(), catalogName, tableNames);
        }
        ConnectorAccessControl connectorAccessControl = this.getConnectorAccessControl(securityContext.getTransactionId(), catalogName);
        if (connectorAccessControl != null) {
            tableNames = connectorAccessControl.filterTables(this.toConnectorSecurityContext(catalogName, securityContext), tableNames);
        }
        return tableNames;
    }

    @Override
    public void checkCanShowColumns(SecurityContext securityContext, CatalogSchemaTableName table) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(table, "table is null");
        this.checkCanAccessCatalog(securityContext, table.getCatalogName());
        this.systemAuthorizationCheck(control -> control.checkCanShowColumns(securityContext.toSystemSecurityContext(), table));
        this.catalogAuthorizationCheck(table.getCatalogName(), securityContext, (control, context) -> control.checkCanShowColumns(context, table.getSchemaTableName()));
    }

    @Override
    public Set<String> filterColumns(SecurityContext securityContext, CatalogSchemaTableName table, Set<String> columns) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(table, "tableName is null");
        if (this.filterTables(securityContext, table.getCatalogName(), (Set<SchemaTableName>)ImmutableSet.of((Object)table.getSchemaTableName())).isEmpty()) {
            return ImmutableSet.of();
        }
        for (SystemAccessControl systemAccessControl : this.getSystemAccessControls()) {
            columns = systemAccessControl.filterColumns(securityContext.toSystemSecurityContext(), table, columns);
        }
        ConnectorAccessControl connectorAccessControl = this.getConnectorAccessControl(securityContext.getTransactionId(), table.getCatalogName());
        if (connectorAccessControl != null) {
            columns = connectorAccessControl.filterColumns(this.toConnectorSecurityContext(table.getCatalogName(), securityContext), table.getSchemaTableName(), columns);
        }
        return columns;
    }

    @Override
    public void checkCanAddColumns(SecurityContext securityContext, QualifiedObjectName tableName) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(tableName, "tableName is null");
        this.checkCanAccessCatalog(securityContext, tableName.getCatalogName());
        this.systemAuthorizationCheck(control -> control.checkCanAddColumn(securityContext.toSystemSecurityContext(), tableName.asCatalogSchemaTableName()));
        this.catalogAuthorizationCheck(tableName.getCatalogName(), securityContext, (control, context) -> control.checkCanAddColumn(context, tableName.asSchemaTableName()));
    }

    @Override
    public void checkCanAlterColumn(SecurityContext securityContext, QualifiedObjectName tableName) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(tableName, "tableName is null");
        this.checkCanAccessCatalog(securityContext, tableName.getCatalogName());
        this.systemAuthorizationCheck(control -> control.checkCanAlterColumn(securityContext.toSystemSecurityContext(), tableName.asCatalogSchemaTableName()));
        this.catalogAuthorizationCheck(tableName.getCatalogName(), securityContext, (control, context) -> control.checkCanAlterColumn(context, tableName.asSchemaTableName()));
    }

    @Override
    public void checkCanDropColumn(SecurityContext securityContext, QualifiedObjectName tableName) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(tableName, "tableName is null");
        this.checkCanAccessCatalog(securityContext, tableName.getCatalogName());
        this.systemAuthorizationCheck(control -> control.checkCanDropColumn(securityContext.toSystemSecurityContext(), tableName.asCatalogSchemaTableName()));
        this.catalogAuthorizationCheck(tableName.getCatalogName(), securityContext, (control, context) -> control.checkCanDropColumn(context, tableName.asSchemaTableName()));
    }

    @Override
    public void checkCanRenameColumn(SecurityContext securityContext, QualifiedObjectName tableName) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(tableName, "tableName is null");
        this.checkCanAccessCatalog(securityContext, tableName.getCatalogName());
        this.systemAuthorizationCheck(control -> control.checkCanRenameColumn(securityContext.toSystemSecurityContext(), tableName.asCatalogSchemaTableName()));
        this.catalogAuthorizationCheck(tableName.getCatalogName(), securityContext, (control, context) -> control.checkCanRenameColumn(context, tableName.asSchemaTableName()));
    }

    @Override
    public void checkCanSetTableAuthorization(SecurityContext securityContext, QualifiedObjectName tableName, TrinoPrincipal principal) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(tableName, "tableName is null");
        Objects.requireNonNull(principal, "principal is null");
        this.checkCanAccessCatalog(securityContext, tableName.getCatalogName());
        this.systemAuthorizationCheck(control -> control.checkCanSetTableAuthorization(securityContext.toSystemSecurityContext(), tableName.asCatalogSchemaTableName(), principal));
        this.catalogAuthorizationCheck(tableName.getCatalogName(), securityContext, (control, context) -> control.checkCanSetTableAuthorization(context, tableName.asSchemaTableName(), principal));
    }

    @Override
    public void checkCanInsertIntoTable(SecurityContext securityContext, QualifiedObjectName tableName) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(tableName, "tableName is null");
        this.checkCanAccessCatalog(securityContext, tableName.getCatalogName());
        this.systemAuthorizationCheck(control -> control.checkCanInsertIntoTable(securityContext.toSystemSecurityContext(), tableName.asCatalogSchemaTableName()));
        this.catalogAuthorizationCheck(tableName.getCatalogName(), securityContext, (control, context) -> control.checkCanInsertIntoTable(context, tableName.asSchemaTableName()));
    }

    @Override
    public void checkCanDeleteFromTable(SecurityContext securityContext, QualifiedObjectName tableName) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(tableName, "tableName is null");
        this.checkCanAccessCatalog(securityContext, tableName.getCatalogName());
        this.systemAuthorizationCheck(control -> control.checkCanDeleteFromTable(securityContext.toSystemSecurityContext(), tableName.asCatalogSchemaTableName()));
        this.catalogAuthorizationCheck(tableName.getCatalogName(), securityContext, (control, context) -> control.checkCanDeleteFromTable(context, tableName.asSchemaTableName()));
    }

    @Override
    public void checkCanTruncateTable(SecurityContext securityContext, QualifiedObjectName tableName) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(tableName, "tableName is null");
        this.checkCanAccessCatalog(securityContext, tableName.getCatalogName());
        this.systemAuthorizationCheck(control -> control.checkCanTruncateTable(securityContext.toSystemSecurityContext(), tableName.asCatalogSchemaTableName()));
        this.catalogAuthorizationCheck(tableName.getCatalogName(), securityContext, (control, context) -> control.checkCanTruncateTable(context, tableName.asSchemaTableName()));
    }

    @Override
    public void checkCanUpdateTableColumns(SecurityContext securityContext, QualifiedObjectName tableName, Set<String> updatedColumnNames) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(tableName, "tableName is null");
        this.checkCanAccessCatalog(securityContext, tableName.getCatalogName());
        this.systemAuthorizationCheck(control -> control.checkCanUpdateTableColumns(securityContext.toSystemSecurityContext(), tableName.asCatalogSchemaTableName(), updatedColumnNames));
        this.catalogAuthorizationCheck(tableName.getCatalogName(), securityContext, (control, context) -> control.checkCanUpdateTableColumns(context, tableName.asSchemaTableName(), updatedColumnNames));
    }

    @Override
    public void checkCanCreateView(SecurityContext securityContext, QualifiedObjectName viewName) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(viewName, "viewName is null");
        this.checkCanAccessCatalog(securityContext, viewName.getCatalogName());
        this.systemAuthorizationCheck(control -> control.checkCanCreateView(securityContext.toSystemSecurityContext(), viewName.asCatalogSchemaTableName()));
        this.catalogAuthorizationCheck(viewName.getCatalogName(), securityContext, (control, context) -> control.checkCanCreateView(context, viewName.asSchemaTableName()));
    }

    @Override
    public void checkCanRenameView(SecurityContext securityContext, QualifiedObjectName viewName, QualifiedObjectName newViewName) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(viewName, "viewName is null");
        Objects.requireNonNull(newViewName, "newViewName is null");
        this.checkCanAccessCatalog(securityContext, viewName.getCatalogName());
        this.systemAuthorizationCheck(control -> control.checkCanRenameView(securityContext.toSystemSecurityContext(), viewName.asCatalogSchemaTableName(), newViewName.asCatalogSchemaTableName()));
        this.catalogAuthorizationCheck(viewName.getCatalogName(), securityContext, (control, context) -> control.checkCanRenameView(context, viewName.asSchemaTableName(), newViewName.asSchemaTableName()));
    }

    @Override
    public void checkCanSetViewAuthorization(SecurityContext securityContext, QualifiedObjectName viewName, TrinoPrincipal principal) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(viewName, "viewName is null");
        Objects.requireNonNull(principal, "principal is null");
        this.checkCanAccessCatalog(securityContext, viewName.getCatalogName());
        this.systemAuthorizationCheck(control -> control.checkCanSetViewAuthorization(securityContext.toSystemSecurityContext(), viewName.asCatalogSchemaTableName(), principal));
        this.catalogAuthorizationCheck(viewName.getCatalogName(), securityContext, (control, context) -> control.checkCanSetViewAuthorization(context, viewName.asSchemaTableName(), principal));
    }

    @Override
    public void checkCanDropView(SecurityContext securityContext, QualifiedObjectName viewName) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(viewName, "viewName is null");
        this.checkCanAccessCatalog(securityContext, viewName.getCatalogName());
        this.systemAuthorizationCheck(control -> control.checkCanDropView(securityContext.toSystemSecurityContext(), viewName.asCatalogSchemaTableName()));
        this.catalogAuthorizationCheck(viewName.getCatalogName(), securityContext, (control, context) -> control.checkCanDropView(context, viewName.asSchemaTableName()));
    }

    @Override
    public void checkCanCreateViewWithSelectFromColumns(SecurityContext securityContext, QualifiedObjectName tableName, Set<String> columnNames) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(tableName, "tableName is null");
        this.checkCanAccessCatalog(securityContext, tableName.getCatalogName());
        this.systemAuthorizationCheck(control -> control.checkCanCreateViewWithSelectFromColumns(securityContext.toSystemSecurityContext(), tableName.asCatalogSchemaTableName(), columnNames));
        this.catalogAuthorizationCheck(tableName.getCatalogName(), securityContext, (control, context) -> control.checkCanCreateViewWithSelectFromColumns(context, tableName.asSchemaTableName(), columnNames));
    }

    @Override
    public void checkCanCreateMaterializedView(SecurityContext securityContext, QualifiedObjectName materializedViewName, Map<String, Object> properties) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(materializedViewName, "materializedViewName is null");
        Objects.requireNonNull(properties, "properties is null");
        this.checkCanAccessCatalog(securityContext, materializedViewName.getCatalogName());
        this.systemAuthorizationCheck(control -> control.checkCanCreateMaterializedView(securityContext.toSystemSecurityContext(), materializedViewName.asCatalogSchemaTableName(), properties));
        this.catalogAuthorizationCheck(materializedViewName.getCatalogName(), securityContext, (control, context) -> control.checkCanCreateMaterializedView(context, materializedViewName.asSchemaTableName(), properties));
    }

    @Override
    public void checkCanRefreshMaterializedView(SecurityContext securityContext, QualifiedObjectName materializedViewName) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(materializedViewName, "materializedViewName is null");
        this.checkCanAccessCatalog(securityContext, materializedViewName.getCatalogName());
        this.systemAuthorizationCheck(control -> control.checkCanRefreshMaterializedView(securityContext.toSystemSecurityContext(), materializedViewName.asCatalogSchemaTableName()));
        this.catalogAuthorizationCheck(materializedViewName.getCatalogName(), securityContext, (control, context) -> control.checkCanRefreshMaterializedView(context, materializedViewName.asSchemaTableName()));
    }

    @Override
    public void checkCanDropMaterializedView(SecurityContext securityContext, QualifiedObjectName materializedViewName) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(materializedViewName, "materializedViewName is null");
        this.checkCanAccessCatalog(securityContext, materializedViewName.getCatalogName());
        this.systemAuthorizationCheck(control -> control.checkCanDropMaterializedView(securityContext.toSystemSecurityContext(), materializedViewName.asCatalogSchemaTableName()));
        this.catalogAuthorizationCheck(materializedViewName.getCatalogName(), securityContext, (control, context) -> control.checkCanDropMaterializedView(context, materializedViewName.asSchemaTableName()));
    }

    @Override
    public void checkCanRenameMaterializedView(SecurityContext securityContext, QualifiedObjectName viewName, QualifiedObjectName newViewName) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(viewName, "viewName is null");
        Objects.requireNonNull(newViewName, "newViewName is null");
        this.checkCanAccessCatalog(securityContext, viewName.getCatalogName());
        this.systemAuthorizationCheck(control -> control.checkCanRenameMaterializedView(securityContext.toSystemSecurityContext(), viewName.asCatalogSchemaTableName(), newViewName.asCatalogSchemaTableName()));
        this.catalogAuthorizationCheck(viewName.getCatalogName(), securityContext, (control, context) -> control.checkCanRenameMaterializedView(context, viewName.asSchemaTableName(), newViewName.asSchemaTableName()));
    }

    @Override
    public void checkCanSetMaterializedViewProperties(SecurityContext securityContext, QualifiedObjectName materializedViewName, Map<String, Optional<Object>> properties) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(materializedViewName, "materializedViewName is null");
        Objects.requireNonNull(properties, "nonNullProperties is null");
        this.checkCanAccessCatalog(securityContext, materializedViewName.getCatalogName());
        this.systemAuthorizationCheck(control -> control.checkCanSetMaterializedViewProperties(securityContext.toSystemSecurityContext(), materializedViewName.asCatalogSchemaTableName(), properties));
        this.catalogAuthorizationCheck(materializedViewName.getCatalogName(), securityContext, (control, context) -> control.checkCanSetMaterializedViewProperties(context, materializedViewName.asSchemaTableName(), properties));
    }

    @Override
    public void checkCanGrantExecuteFunctionPrivilege(SecurityContext securityContext, String functionName, Identity grantee, boolean grantOption) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(functionName, "functionName is null");
        this.systemAuthorizationCheck(control -> control.checkCanGrantExecuteFunctionPrivilege(securityContext.toSystemSecurityContext(), functionName, new TrinoPrincipal(PrincipalType.USER, grantee.getUser()), grantOption));
    }

    @Override
    public void checkCanGrantExecuteFunctionPrivilege(SecurityContext securityContext, FunctionKind functionKind, QualifiedObjectName functionName, Identity grantee, boolean grantOption) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(functionKind, "functionKind is null");
        Objects.requireNonNull(functionName, "functionName is null");
        this.systemAuthorizationCheck(control -> control.checkCanGrantExecuteFunctionPrivilege(securityContext.toSystemSecurityContext(), functionKind, functionName.asCatalogSchemaRoutineName(), new TrinoPrincipal(PrincipalType.USER, grantee.getUser()), grantOption));
        this.catalogAuthorizationCheck(functionName.getCatalogName(), securityContext, (control, context) -> control.checkCanGrantExecuteFunctionPrivilege(context, functionKind, functionName.asSchemaRoutineName(), new TrinoPrincipal(PrincipalType.USER, grantee.getUser()), grantOption));
    }

    @Override
    public void checkCanGrantSchemaPrivilege(SecurityContext securityContext, Privilege privilege, CatalogSchemaName schemaName, TrinoPrincipal grantee, boolean grantOption) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(schemaName, "schemaName is null");
        Objects.requireNonNull(privilege, "privilege is null");
        this.checkCanAccessCatalog(securityContext, schemaName.getCatalogName());
        this.systemAuthorizationCheck(control -> control.checkCanGrantSchemaPrivilege(securityContext.toSystemSecurityContext(), privilege, schemaName, grantee, grantOption));
        this.catalogAuthorizationCheck(schemaName.getCatalogName(), securityContext, (control, context) -> control.checkCanGrantSchemaPrivilege(context, privilege, schemaName.getSchemaName(), grantee, grantOption));
    }

    @Override
    public void checkCanDenySchemaPrivilege(SecurityContext securityContext, Privilege privilege, CatalogSchemaName schemaName, TrinoPrincipal grantee) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(schemaName, "schemaName is null");
        Objects.requireNonNull(privilege, "privilege is null");
        this.checkCanAccessCatalog(securityContext, schemaName.getCatalogName());
        this.systemAuthorizationCheck(control -> control.checkCanDenySchemaPrivilege(securityContext.toSystemSecurityContext(), privilege, schemaName, grantee));
        this.catalogAuthorizationCheck(schemaName.getCatalogName(), securityContext, (control, context) -> control.checkCanDenySchemaPrivilege(context, privilege, schemaName.getSchemaName(), grantee));
    }

    @Override
    public void checkCanRevokeSchemaPrivilege(SecurityContext securityContext, Privilege privilege, CatalogSchemaName schemaName, TrinoPrincipal revokee, boolean grantOption) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(schemaName, "schemaName is null");
        Objects.requireNonNull(privilege, "privilege is null");
        this.checkCanAccessCatalog(securityContext, schemaName.getCatalogName());
        this.systemAuthorizationCheck(control -> control.checkCanRevokeSchemaPrivilege(securityContext.toSystemSecurityContext(), privilege, schemaName, revokee, grantOption));
        this.catalogAuthorizationCheck(schemaName.getCatalogName(), securityContext, (control, context) -> control.checkCanRevokeSchemaPrivilege(context, privilege, schemaName.getSchemaName(), revokee, grantOption));
    }

    @Override
    public void checkCanGrantTablePrivilege(SecurityContext securityContext, Privilege privilege, QualifiedObjectName tableName, TrinoPrincipal grantee, boolean grantOption) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(tableName, "tableName is null");
        Objects.requireNonNull(privilege, "privilege is null");
        this.checkCanAccessCatalog(securityContext, tableName.getCatalogName());
        this.systemAuthorizationCheck(control -> control.checkCanGrantTablePrivilege(securityContext.toSystemSecurityContext(), privilege, tableName.asCatalogSchemaTableName(), grantee, grantOption));
        this.catalogAuthorizationCheck(tableName.getCatalogName(), securityContext, (control, context) -> control.checkCanGrantTablePrivilege(context, privilege, tableName.asSchemaTableName(), grantee, grantOption));
    }

    @Override
    public void checkCanDenyTablePrivilege(SecurityContext securityContext, Privilege privilege, QualifiedObjectName tableName, TrinoPrincipal grantee) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(tableName, "tableName is null");
        Objects.requireNonNull(privilege, "privilege is null");
        this.checkCanAccessCatalog(securityContext, tableName.getCatalogName());
        this.systemAuthorizationCheck(control -> control.checkCanDenyTablePrivilege(securityContext.toSystemSecurityContext(), privilege, tableName.asCatalogSchemaTableName(), grantee));
        this.catalogAuthorizationCheck(tableName.getCatalogName(), securityContext, (control, context) -> control.checkCanDenyTablePrivilege(context, privilege, tableName.asSchemaTableName(), grantee));
    }

    @Override
    public void checkCanRevokeTablePrivilege(SecurityContext securityContext, Privilege privilege, QualifiedObjectName tableName, TrinoPrincipal revokee, boolean grantOption) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(tableName, "tableName is null");
        Objects.requireNonNull(privilege, "privilege is null");
        this.checkCanAccessCatalog(securityContext, tableName.getCatalogName());
        this.systemAuthorizationCheck(control -> control.checkCanRevokeTablePrivilege(securityContext.toSystemSecurityContext(), privilege, tableName.asCatalogSchemaTableName(), revokee, grantOption));
        this.catalogAuthorizationCheck(tableName.getCatalogName(), securityContext, (control, context) -> control.checkCanRevokeTablePrivilege(context, privilege, tableName.asSchemaTableName(), revokee, grantOption));
    }

    @Override
    public void checkCanSetSystemSessionProperty(Identity identity, String propertyName) {
        Objects.requireNonNull(identity, "identity is null");
        Objects.requireNonNull(propertyName, "propertyName is null");
        this.systemAuthorizationCheck(control -> control.checkCanSetSystemSessionProperty(new SystemSecurityContext(identity, Optional.empty()), propertyName));
    }

    @Override
    public void checkCanSetCatalogSessionProperty(SecurityContext securityContext, String catalogName, String propertyName) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(catalogName, "catalogName is null");
        Objects.requireNonNull(propertyName, "propertyName is null");
        this.checkCanAccessCatalog(securityContext, catalogName);
        this.systemAuthorizationCheck(control -> control.checkCanSetCatalogSessionProperty(securityContext.toSystemSecurityContext(), catalogName, propertyName));
        this.catalogAuthorizationCheck(catalogName, securityContext, (control, context) -> control.checkCanSetCatalogSessionProperty(context, propertyName));
    }

    @Override
    public void checkCanSelectFromColumns(SecurityContext securityContext, QualifiedObjectName tableName, Set<String> columnNames) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(tableName, "tableName is null");
        Objects.requireNonNull(columnNames, "columnNames is null");
        this.checkCanAccessCatalog(securityContext, tableName.getCatalogName());
        this.systemAuthorizationCheck(control -> control.checkCanSelectFromColumns(securityContext.toSystemSecurityContext(), tableName.asCatalogSchemaTableName(), columnNames));
        this.catalogAuthorizationCheck(tableName.getCatalogName(), securityContext, (control, context) -> control.checkCanSelectFromColumns(context, tableName.asSchemaTableName(), columnNames));
    }

    @Override
    public void checkCanCreateRole(SecurityContext securityContext, String role, Optional<TrinoPrincipal> grantor, Optional<String> catalogName) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(role, "role is null");
        Objects.requireNonNull(grantor, "grantor is null");
        Objects.requireNonNull(catalogName, "catalogName is null");
        if (catalogName.isPresent()) {
            this.checkCanAccessCatalog(securityContext, catalogName.get());
            this.checkCatalogRoles(securityContext, catalogName.get());
            this.catalogAuthorizationCheck(catalogName.get(), securityContext, (control, context) -> control.checkCanCreateRole(context, role, grantor));
        } else {
            this.systemAuthorizationCheck(control -> control.checkCanCreateRole(securityContext.toSystemSecurityContext(), role, grantor));
        }
    }

    @Override
    public void checkCanDropRole(SecurityContext securityContext, String role, Optional<String> catalogName) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(role, "role is null");
        Objects.requireNonNull(catalogName, "catalogName is null");
        if (catalogName.isPresent()) {
            this.checkCanAccessCatalog(securityContext, catalogName.get());
            this.checkCatalogRoles(securityContext, catalogName.get());
            this.catalogAuthorizationCheck(catalogName.get(), securityContext, (control, context) -> control.checkCanDropRole(context, role));
        } else {
            this.systemAuthorizationCheck(control -> control.checkCanDropRole(securityContext.toSystemSecurityContext(), role));
        }
    }

    @Override
    public void checkCanGrantRoles(SecurityContext securityContext, Set<String> roles, Set<TrinoPrincipal> grantees, boolean adminOption, Optional<TrinoPrincipal> grantor, Optional<String> catalogName) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(roles, "roles is null");
        Objects.requireNonNull(grantees, "grantees is null");
        Objects.requireNonNull(grantor, "grantor is null");
        Objects.requireNonNull(catalogName, "catalogName is null");
        if (catalogName.isPresent()) {
            this.checkCanAccessCatalog(securityContext, catalogName.get());
            this.checkCatalogRoles(securityContext, catalogName.get());
            this.catalogAuthorizationCheck(catalogName.get(), securityContext, (control, context) -> control.checkCanGrantRoles(context, roles, grantees, adminOption, grantor));
        } else {
            this.systemAuthorizationCheck(control -> control.checkCanGrantRoles(securityContext.toSystemSecurityContext(), roles, grantees, adminOption, grantor));
        }
    }

    @Override
    public void checkCanRevokeRoles(SecurityContext securityContext, Set<String> roles, Set<TrinoPrincipal> grantees, boolean adminOption, Optional<TrinoPrincipal> grantor, Optional<String> catalogName) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(roles, "roles is null");
        Objects.requireNonNull(grantees, "grantees is null");
        Objects.requireNonNull(grantor, "grantor is null");
        Objects.requireNonNull(catalogName, "catalogName is null");
        if (catalogName.isPresent()) {
            this.checkCanAccessCatalog(securityContext, catalogName.get());
            this.checkCatalogRoles(securityContext, catalogName.get());
            this.catalogAuthorizationCheck(catalogName.get(), securityContext, (control, context) -> control.checkCanRevokeRoles(context, roles, grantees, adminOption, grantor));
        } else {
            this.systemAuthorizationCheck(control -> control.checkCanRevokeRoles(securityContext.toSystemSecurityContext(), roles, grantees, adminOption, grantor));
        }
    }

    @Override
    public void checkCanSetCatalogRole(SecurityContext securityContext, String role, String catalogName) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(role, "role is null");
        Objects.requireNonNull(catalogName, "catalogName is null");
        this.checkCanAccessCatalog(securityContext, catalogName);
        this.catalogAuthorizationCheck(catalogName, securityContext, (control, context) -> control.checkCanSetRole(context, role));
    }

    @Override
    public void checkCanShowRoleAuthorizationDescriptors(SecurityContext securityContext, Optional<String> catalogName) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(catalogName, "catalogName is null");
        if (catalogName.isPresent()) {
            this.checkCanAccessCatalog(securityContext, catalogName.get());
            this.checkCatalogRoles(securityContext, catalogName.get());
            this.catalogAuthorizationCheck(catalogName.get(), securityContext, ConnectorAccessControl::checkCanShowRoleAuthorizationDescriptors);
        } else {
            this.systemAuthorizationCheck(control -> control.checkCanShowRoleAuthorizationDescriptors(securityContext.toSystemSecurityContext()));
        }
    }

    @Override
    public void checkCanShowRoles(SecurityContext securityContext, Optional<String> catalogName) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(catalogName, "catalogName is null");
        if (catalogName.isPresent()) {
            this.checkCanAccessCatalog(securityContext, catalogName.get());
            this.checkCatalogRoles(securityContext, catalogName.get());
            this.catalogAuthorizationCheck(catalogName.get(), securityContext, ConnectorAccessControl::checkCanShowRoles);
        } else {
            this.systemAuthorizationCheck(control -> control.checkCanShowRoles(securityContext.toSystemSecurityContext()));
        }
    }

    @Override
    public void checkCanShowCurrentRoles(SecurityContext securityContext, Optional<String> catalogName) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(catalogName, "catalogName is null");
        if (catalogName.isPresent()) {
            this.checkCanAccessCatalog(securityContext, catalogName.get());
            this.checkCatalogRoles(securityContext, catalogName.get());
            this.catalogAuthorizationCheck(catalogName.get(), securityContext, ConnectorAccessControl::checkCanShowCurrentRoles);
        } else {
            this.systemAuthorizationCheck(control -> control.checkCanShowCurrentRoles(securityContext.toSystemSecurityContext()));
        }
    }

    @Override
    public void checkCanShowRoleGrants(SecurityContext securityContext, Optional<String> catalogName) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(catalogName, "catalogName is null");
        if (catalogName.isPresent()) {
            this.checkCanAccessCatalog(securityContext, catalogName.get());
            this.checkCatalogRoles(securityContext, catalogName.get());
            this.catalogAuthorizationCheck(catalogName.get(), securityContext, ConnectorAccessControl::checkCanShowRoleGrants);
        } else {
            this.systemAuthorizationCheck(control -> control.checkCanShowRoleGrants(securityContext.toSystemSecurityContext()));
        }
    }

    @Override
    public void checkCanExecuteProcedure(SecurityContext securityContext, QualifiedObjectName procedureName) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(procedureName, "procedureName is null");
        this.checkCanAccessCatalog(securityContext, procedureName.getCatalogName());
        this.systemAuthorizationCheck(control -> control.checkCanExecuteProcedure(securityContext.toSystemSecurityContext(), procedureName.asCatalogSchemaRoutineName()));
        this.catalogAuthorizationCheck(procedureName.getCatalogName(), securityContext, (control, context) -> control.checkCanExecuteProcedure(context, procedureName.asSchemaRoutineName()));
    }

    @Override
    public void checkCanExecuteFunction(SecurityContext context, String functionName) {
        Objects.requireNonNull(context, "context is null");
        Objects.requireNonNull(functionName, "functionName is null");
        this.systemAuthorizationCheck(control -> control.checkCanExecuteFunction(context.toSystemSecurityContext(), functionName));
    }

    @Override
    public void checkCanExecuteFunction(SecurityContext securityContext, FunctionKind functionKind, QualifiedObjectName functionName) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(functionKind, "functionKind is null");
        Objects.requireNonNull(functionName, "functionName is null");
        this.checkCanAccessCatalog(securityContext, functionName.getCatalogName());
        this.systemAuthorizationCheck(control -> control.checkCanExecuteFunction(securityContext.toSystemSecurityContext(), functionKind, functionName.asCatalogSchemaRoutineName()));
        this.catalogAuthorizationCheck(functionName.getCatalogName(), securityContext, (control, context) -> control.checkCanExecuteFunction(context, functionKind, functionName.asSchemaRoutineName()));
    }

    @Override
    public void checkCanExecuteTableProcedure(SecurityContext securityContext, QualifiedObjectName tableName, String procedureName) {
        Objects.requireNonNull(securityContext, "securityContext is null");
        Objects.requireNonNull(procedureName, "procedureName is null");
        Objects.requireNonNull(tableName, "tableName is null");
        this.systemAuthorizationCheck(control -> control.checkCanExecuteTableProcedure(securityContext.toSystemSecurityContext(), tableName.asCatalogSchemaTableName(), procedureName));
        this.catalogAuthorizationCheck(tableName.getCatalogName(), securityContext, (control, context) -> control.checkCanExecuteTableProcedure(context, tableName.asSchemaTableName(), procedureName));
    }

    @Override
    public List<ViewExpression> getRowFilters(SecurityContext context, QualifiedObjectName tableName) {
        Objects.requireNonNull(context, "context is null");
        Objects.requireNonNull(tableName, "tableName is null");
        ImmutableList.Builder filters = ImmutableList.builder();
        ConnectorAccessControl connectorAccessControl = this.getConnectorAccessControl(context.getTransactionId(), tableName.getCatalogName());
        if (connectorAccessControl != null) {
            connectorAccessControl.getRowFilters(this.toConnectorSecurityContext(tableName.getCatalogName(), context), tableName.asSchemaTableName()).forEach(arg_0 -> ((ImmutableList.Builder)filters).add(arg_0));
        }
        for (SystemAccessControl systemAccessControl : this.getSystemAccessControls()) {
            systemAccessControl.getRowFilters(context.toSystemSecurityContext(), tableName.asCatalogSchemaTableName()).forEach(arg_0 -> ((ImmutableList.Builder)filters).add(arg_0));
        }
        return filters.build();
    }

    @Override
    public Optional<ViewExpression> getColumnMask(SecurityContext context, QualifiedObjectName tableName, String columnName, Type type) {
        Objects.requireNonNull(context, "context is null");
        Objects.requireNonNull(tableName, "tableName is null");
        ImmutableList.Builder masks = ImmutableList.builder();
        ConnectorAccessControl connectorAccessControl = this.getConnectorAccessControl(context.getTransactionId(), tableName.getCatalogName());
        if (connectorAccessControl != null) {
            connectorAccessControl.getColumnMask(this.toConnectorSecurityContext(tableName.getCatalogName(), context), tableName.asSchemaTableName(), columnName, type).ifPresent(arg_0 -> ((ImmutableList.Builder)masks).add(arg_0));
        }
        for (SystemAccessControl systemAccessControl : this.getSystemAccessControls()) {
            systemAccessControl.getColumnMask(context.toSystemSecurityContext(), tableName.asCatalogSchemaTableName(), columnName, type).ifPresent(arg_0 -> ((ImmutableList.Builder)masks).add(arg_0));
        }
        ImmutableList allMasks = masks.build();
        if (allMasks.size() > 1) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_COLUMN_MASK, String.format("Column must have a single mask: %s", columnName));
        }
        return allMasks.stream().findFirst();
    }

    private ConnectorAccessControl getConnectorAccessControl(TransactionId transactionId, String catalogName) {
        CatalogServiceProvider<Optional<ConnectorAccessControl>> connectorAccessControlProvider = this.connectorAccessControlProvider.get();
        if (connectorAccessControlProvider == null) {
            return null;
        }
        return this.transactionManager.getCatalogHandle(transactionId, catalogName).flatMap(connectorAccessControlProvider::getService).orElse(null);
    }

    @Managed
    @Nested
    public CounterStat getAuthorizationSuccess() {
        return this.authorizationSuccess;
    }

    @Managed
    @Nested
    public CounterStat getAuthorizationFail() {
        return this.authorizationFail;
    }

    private void checkCanAccessCatalog(SecurityContext securityContext, String catalogName) {
        try {
            for (SystemAccessControl systemAccessControl : this.getSystemAccessControls()) {
                systemAccessControl.checkCanAccessCatalog(securityContext.toSystemSecurityContext(), catalogName);
            }
            this.authorizationSuccess.update(1L);
        }
        catch (TrinoException e) {
            this.authorizationFail.update(1L);
            throw e;
        }
    }

    private void systemAuthorizationCheck(Consumer<SystemAccessControl> check) {
        try {
            for (SystemAccessControl systemAccessControl : this.getSystemAccessControls()) {
                check.accept(systemAccessControl);
            }
            this.authorizationSuccess.update(1L);
        }
        catch (TrinoException e) {
            this.authorizationFail.update(1L);
            throw e;
        }
    }

    private void catalogAuthorizationCheck(String catalogName, SecurityContext securityContext, BiConsumer<ConnectorAccessControl, ConnectorSecurityContext> check) {
        ConnectorAccessControl connectorAccessControl = this.getConnectorAccessControl(securityContext.getTransactionId(), catalogName);
        if (connectorAccessControl == null) {
            return;
        }
        try {
            check.accept(connectorAccessControl, this.toConnectorSecurityContext(catalogName, securityContext));
            this.authorizationSuccess.update(1L);
        }
        catch (TrinoException e) {
            this.authorizationFail.update(1L);
            throw e;
        }
    }

    private void checkCatalogRoles(SecurityContext securityContext, String catalogName) {
        ConnectorAccessControl connectorAccessControl = this.getConnectorAccessControl(securityContext.getTransactionId(), catalogName);
        if (connectorAccessControl == null) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Catalog %s does not support catalog roles", catalogName));
        }
    }

    private List<SystemAccessControl> getSystemAccessControls() {
        List<SystemAccessControl> accessControls = this.systemAccessControls.get();
        if (accessControls != null) {
            return accessControls;
        }
        return ImmutableList.of((Object)((Object)new InitializingSystemAccessControl()));
    }

    private ConnectorSecurityContext toConnectorSecurityContext(String catalogName, SecurityContext securityContext) {
        return this.toConnectorSecurityContext(catalogName, securityContext.getTransactionId(), securityContext.getIdentity(), securityContext.getQueryId());
    }

    private ConnectorSecurityContext toConnectorSecurityContext(String catalogName, TransactionId requiredTransactionId, Identity identity, QueryId queryId) {
        return new ConnectorSecurityContext(this.transactionManager.getRequiredCatalogMetadata(requiredTransactionId, catalogName).getTransactionHandleFor(CatalogHandle.CatalogHandleType.NORMAL), identity.toConnectorIdentity(catalogName), queryId);
    }

    private static class InitializingSystemAccessControl
    extends ForwardingSystemAccessControl {
        private InitializingSystemAccessControl() {
        }

        protected SystemAccessControl delegate() {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.SERVER_STARTING_UP, "Trino server is still initializing");
        }
    }
}

