/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import io.trino.SessionRepresentation;
import io.trino.execution.QueryInfo;
import io.trino.execution.QueryState;
import io.trino.operator.RetryPolicy;
import io.trino.server.BasicQueryStats;
import io.trino.spi.ErrorCode;
import io.trino.spi.ErrorType;
import io.trino.spi.QueryId;
import io.trino.spi.resourcegroups.QueryType;
import io.trino.spi.resourcegroups.ResourceGroupId;
import java.net.URI;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class BasicQueryInfo {
    private final QueryId queryId;
    private final SessionRepresentation session;
    private final Optional<ResourceGroupId> resourceGroupId;
    private final QueryState state;
    private final boolean scheduled;
    private final URI self;
    private final String query;
    private final Optional<String> updateType;
    private final Optional<String> preparedQuery;
    private final BasicQueryStats queryStats;
    private final ErrorType errorType;
    private final ErrorCode errorCode;
    private final Optional<QueryType> queryType;
    private final RetryPolicy retryPolicy;

    @JsonCreator
    public BasicQueryInfo(@JsonProperty(value="queryId") QueryId queryId, @JsonProperty(value="session") SessionRepresentation session, @JsonProperty(value="resourceGroupId") Optional<ResourceGroupId> resourceGroupId, @JsonProperty(value="state") QueryState state, @JsonProperty(value="scheduled") boolean scheduled, @JsonProperty(value="self") URI self, @JsonProperty(value="query") String query, @JsonProperty(value="updateType") Optional<String> updateType, @JsonProperty(value="preparedQuery") Optional<String> preparedQuery, @JsonProperty(value="queryStats") BasicQueryStats queryStats, @JsonProperty(value="errorType") ErrorType errorType, @JsonProperty(value="errorCode") ErrorCode errorCode, @JsonProperty(value="queryType") Optional<QueryType> queryType, @JsonProperty(value="retryPolicy") RetryPolicy retryPolicy) {
        this.queryId = Objects.requireNonNull(queryId, "queryId is null");
        this.session = Objects.requireNonNull(session, "session is null");
        this.resourceGroupId = Objects.requireNonNull(resourceGroupId, "resourceGroupId is null");
        this.state = Objects.requireNonNull(state, "state is null");
        this.errorType = errorType;
        this.errorCode = errorCode;
        this.scheduled = scheduled;
        this.self = Objects.requireNonNull(self, "self is null");
        this.query = Objects.requireNonNull(query, "query is null");
        this.updateType = Objects.requireNonNull(updateType, "updateType is null");
        this.preparedQuery = Objects.requireNonNull(preparedQuery, "preparedQuery is null");
        this.queryStats = Objects.requireNonNull(queryStats, "queryStats is null");
        this.queryType = Objects.requireNonNull(queryType, "queryType is null");
        this.retryPolicy = Objects.requireNonNull(retryPolicy, "retryPolicy is null");
    }

    public BasicQueryInfo(QueryInfo queryInfo) {
        this(queryInfo.getQueryId(), queryInfo.getSession(), queryInfo.getResourceGroupId(), queryInfo.getState(), queryInfo.isScheduled(), queryInfo.getSelf(), queryInfo.getQuery(), Optional.ofNullable(queryInfo.getUpdateType()), queryInfo.getPreparedQuery(), new BasicQueryStats(queryInfo.getQueryStats()), queryInfo.getErrorType(), queryInfo.getErrorCode(), queryInfo.getQueryType(), queryInfo.getRetryPolicy());
    }

    @JsonProperty
    public QueryId getQueryId() {
        return this.queryId;
    }

    @JsonProperty
    public SessionRepresentation getSession() {
        return this.session;
    }

    @JsonProperty
    public Optional<ResourceGroupId> getResourceGroupId() {
        return this.resourceGroupId;
    }

    @JsonProperty
    public QueryState getState() {
        return this.state;
    }

    @JsonProperty
    public boolean isScheduled() {
        return this.scheduled;
    }

    @JsonProperty
    public URI getSelf() {
        return this.self;
    }

    @JsonProperty
    public String getQuery() {
        return this.query;
    }

    @JsonProperty
    public Optional<String> getUpdateType() {
        return this.updateType;
    }

    @JsonProperty
    public Optional<String> getPreparedQuery() {
        return this.preparedQuery;
    }

    @JsonProperty
    public BasicQueryStats getQueryStats() {
        return this.queryStats;
    }

    @Nullable
    @JsonProperty
    public ErrorType getErrorType() {
        return this.errorType;
    }

    @Nullable
    @JsonProperty
    public ErrorCode getErrorCode() {
        return this.errorCode;
    }

    @JsonProperty
    public Optional<QueryType> getQueryType() {
        return this.queryType;
    }

    @JsonProperty
    public RetryPolicy getRetryPolicy() {
        return this.retryPolicy;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("queryId", (Object)this.queryId).add("state", (Object)this.state).toString();
    }
}

