/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server;

import com.google.common.collect.ImmutableList;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.multibindings.MapBinder;
import com.google.inject.multibindings.Multibinder;
import io.airlift.concurrent.BoundedExecutor;
import io.airlift.concurrent.Threads;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConditionalModule;
import io.airlift.configuration.ConfigBinder;
import io.airlift.discovery.client.DiscoveryBinder;
import io.airlift.http.client.HttpClientBinder;
import io.airlift.http.server.HttpServerConfig;
import io.airlift.jaxrs.JaxrsBinder;
import io.airlift.json.JsonCodecBinder;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.trino.cost.CostCalculator;
import io.trino.cost.CostCalculatorUsingExchanges;
import io.trino.cost.CostCalculatorWithEstimatedExchanges;
import io.trino.cost.CostComparator;
import io.trino.cost.StatsAndCosts;
import io.trino.cost.StatsCalculatorModule;
import io.trino.cost.TaskCountEstimator;
import io.trino.dispatcher.DispatchExecutor;
import io.trino.dispatcher.DispatchManager;
import io.trino.dispatcher.DispatchQueryFactory;
import io.trino.dispatcher.FailedDispatchQueryFactory;
import io.trino.dispatcher.LocalDispatchQueryFactory;
import io.trino.dispatcher.QueuedStatementResource;
import io.trino.event.QueryMonitor;
import io.trino.event.QueryMonitorConfig;
import io.trino.execution.ClusterSizeMonitor;
import io.trino.execution.DynamicFiltersCollector;
import io.trino.execution.ExecutionFailureInfo;
import io.trino.execution.ExplainAnalyzeContext;
import io.trino.execution.ForQueryExecution;
import io.trino.execution.QueryExecution;
import io.trino.execution.QueryExecutionMBean;
import io.trino.execution.QueryIdGenerator;
import io.trino.execution.QueryManager;
import io.trino.execution.QueryManagerConfig;
import io.trino.execution.QueryPerformanceFetcher;
import io.trino.execution.QueryPreparer;
import io.trino.execution.RemoteTaskFactory;
import io.trino.execution.SqlQueryManager;
import io.trino.execution.StageInfo;
import io.trino.execution.TaskInfo;
import io.trino.execution.TaskManagerConfig;
import io.trino.execution.TaskStatus;
import io.trino.execution.resourcegroups.InternalResourceGroupManager;
import io.trino.execution.resourcegroups.LegacyResourceGroupConfigurationManager;
import io.trino.execution.resourcegroups.ResourceGroupManager;
import io.trino.execution.scheduler.BinPackingNodeAllocatorService;
import io.trino.execution.scheduler.ConstantPartitionMemoryEstimator;
import io.trino.execution.scheduler.EventDrivenTaskSourceFactory;
import io.trino.execution.scheduler.FixedCountNodeAllocatorService;
import io.trino.execution.scheduler.NodeAllocatorService;
import io.trino.execution.scheduler.NodeSchedulerConfig;
import io.trino.execution.scheduler.PartitionMemoryEstimatorFactory;
import io.trino.execution.scheduler.SplitSchedulerStats;
import io.trino.execution.scheduler.TaskDescriptorStorage;
import io.trino.execution.scheduler.TaskExecutionStats;
import io.trino.execution.scheduler.policy.AllAtOnceExecutionPolicy;
import io.trino.execution.scheduler.policy.ExecutionPolicy;
import io.trino.execution.scheduler.policy.PhasedExecutionPolicy;
import io.trino.failuredetector.FailureDetectorModule;
import io.trino.memory.ClusterMemoryManager;
import io.trino.memory.ForMemoryManager;
import io.trino.memory.LeastWastedEffortTaskLowMemoryKiller;
import io.trino.memory.LowMemoryKiller;
import io.trino.memory.MemoryManagerConfig;
import io.trino.memory.NoneLowMemoryKiller;
import io.trino.memory.TotalReservationLowMemoryKiller;
import io.trino.memory.TotalReservationOnBlockedNodesQueryLowMemoryKiller;
import io.trino.memory.TotalReservationOnBlockedNodesTaskLowMemoryKiller;
import io.trino.operator.ForScheduler;
import io.trino.operator.OperatorStats;
import io.trino.server.DynamicFilterService;
import io.trino.server.FailTaskRequest;
import io.trino.server.ForStatementResource;
import io.trino.server.ForWorkerInfo;
import io.trino.server.GenerateTraceTokenRequestFilter;
import io.trino.server.HttpRemoteTaskFactory;
import io.trino.server.NodeResource;
import io.trino.server.QueryExecutionFactoryModule;
import io.trino.server.QueryResource;
import io.trino.server.QuerySessionSupplier;
import io.trino.server.QueryStateInfoResource;
import io.trino.server.ResourceGroupStateInfoResource;
import io.trino.server.SessionSupplier;
import io.trino.server.StatementHttpExecutionMBean;
import io.trino.server.TaskUpdateRequest;
import io.trino.server.protocol.ExecutingStatementResource;
import io.trino.server.protocol.QueryInfoUrlFactory;
import io.trino.server.remotetask.RemoteTaskStats;
import io.trino.server.ui.WebUiModule;
import io.trino.server.ui.WorkerResource;
import io.trino.spi.memory.ClusterMemoryPoolManager;
import io.trino.sql.analyzer.AnalyzerFactory;
import io.trino.sql.analyzer.QueryExplainerFactory;
import io.trino.sql.planner.OptimizerStatsMBeanExporter;
import io.trino.sql.planner.PlanFragmenter;
import io.trino.sql.planner.PlanOptimizers;
import io.trino.sql.planner.PlanOptimizersFactory;
import io.trino.sql.planner.RuleStatsRecorder;
import io.trino.sql.planner.SplitSourceFactory;
import io.trino.sql.rewrite.DescribeInputRewrite;
import io.trino.sql.rewrite.DescribeOutputRewrite;
import io.trino.sql.rewrite.ExplainRewrite;
import io.trino.sql.rewrite.ShowQueriesRewrite;
import io.trino.sql.rewrite.ShowStatsRewrite;
import io.trino.sql.rewrite.StatementRewrite;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.weakref.jmx.guice.ExportBinder;

public class CoordinatorModule
extends AbstractConfigurationAwareModule {
    protected void setup(Binder binder) {
        this.install((Module)new WebUiModule());
        DiscoveryBinder.discoveryBinder((Binder)binder).bindHttpAnnouncement("trino-coordinator");
        JsonCodecBinder.jsonCodecBinder((Binder)binder).bindJsonCodec(TaskInfo.class);
        JaxrsBinder.jaxrsBinder((Binder)binder).bind(QueuedStatementResource.class);
        JaxrsBinder.jaxrsBinder((Binder)binder).bind(ExecutingStatementResource.class);
        binder.bind(StatementHttpExecutionMBean.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(StatementHttpExecutionMBean.class).withGeneratedName();
        binder.bind(QueryInfoUrlFactory.class).in(Scopes.SINGLETON);
        ConfigBinder.configBinder((Binder)binder).bindConfigDefaults(HttpServerConfig.class, config -> {
            config.setMaxRequestHeaderSize(DataSize.of((long)2L, (DataSize.Unit)DataSize.Unit.MEGABYTE));
            config.setMaxResponseHeaderSize(DataSize.of((long)2L, (DataSize.Unit)DataSize.Unit.MEGABYTE));
        });
        binder.install((Module)new FailureDetectorModule());
        JaxrsBinder.jaxrsBinder((Binder)binder).bind(NodeResource.class);
        JaxrsBinder.jaxrsBinder((Binder)binder).bind(WorkerResource.class);
        HttpClientBinder.httpClientBinder((Binder)binder).bindHttpClient("workerInfo", ForWorkerInfo.class);
        JsonCodecBinder.jsonCodecBinder((Binder)binder).bindJsonCodec(ExecutionFailureInfo.class);
        JsonCodecBinder.jsonCodecBinder((Binder)binder).bindJsonCodec(OperatorStats.class);
        JsonCodecBinder.jsonCodecBinder((Binder)binder).bindJsonCodec(StageInfo.class);
        JsonCodecBinder.jsonCodecBinder((Binder)binder).bindJsonCodec(StatsAndCosts.class);
        ConfigBinder.configBinder((Binder)binder).bindConfig(QueryMonitorConfig.class);
        binder.bind(QueryMonitor.class).in(Scopes.SINGLETON);
        JaxrsBinder.jaxrsBinder((Binder)binder).bind(QueryResource.class);
        JaxrsBinder.jaxrsBinder((Binder)binder).bind(QueryStateInfoResource.class);
        JaxrsBinder.jaxrsBinder((Binder)binder).bind(ResourceGroupStateInfoResource.class);
        binder.bind(QueryIdGenerator.class).in(Scopes.SINGLETON);
        binder.bind(QueryManager.class).to(SqlQueryManager.class).in(Scopes.SINGLETON);
        binder.bind(QueryPreparer.class).in(Scopes.SINGLETON);
        binder.bind(SessionSupplier.class).to(QuerySessionSupplier.class).in(Scopes.SINGLETON);
        binder.bind(InternalResourceGroupManager.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(InternalResourceGroupManager.class).withGeneratedName();
        binder.bind(ResourceGroupManager.class).to(InternalResourceGroupManager.class);
        binder.bind(LegacyResourceGroupConfigurationManager.class).in(Scopes.SINGLETON);
        binder.bind(DispatchManager.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(DispatchManager.class).as(generator -> generator.generatedNameOf(QueryManager.class));
        binder.bind(FailedDispatchQueryFactory.class).in(Scopes.SINGLETON);
        binder.bind(DispatchExecutor.class).in(Scopes.SINGLETON);
        binder.bind(DispatchQueryFactory.class).to(LocalDispatchQueryFactory.class);
        binder.bind(ClusterMemoryManager.class).in(Scopes.SINGLETON);
        binder.bind(ClusterMemoryPoolManager.class).to(ClusterMemoryManager.class).in(Scopes.SINGLETON);
        HttpClientBinder.httpClientBinder((Binder)binder).bindHttpClient("memoryManager", ForMemoryManager.class).withTracing().withConfigDefaults(config -> {
            config.setIdleTimeout(new Duration(30.0, TimeUnit.SECONDS));
            config.setRequestTimeout(new Duration(10.0, TimeUnit.SECONDS));
        });
        this.bindLowMemoryTaskKiller(MemoryManagerConfig.LowMemoryTaskKillerPolicy.NONE, NoneLowMemoryKiller.class);
        this.bindLowMemoryTaskKiller(MemoryManagerConfig.LowMemoryTaskKillerPolicy.TOTAL_RESERVATION_ON_BLOCKED_NODES, TotalReservationOnBlockedNodesTaskLowMemoryKiller.class);
        this.bindLowMemoryTaskKiller(MemoryManagerConfig.LowMemoryTaskKillerPolicy.LEAST_WASTE, LeastWastedEffortTaskLowMemoryKiller.class);
        this.bindLowMemoryQueryKiller(MemoryManagerConfig.LowMemoryQueryKillerPolicy.NONE, NoneLowMemoryKiller.class);
        this.bindLowMemoryQueryKiller(MemoryManagerConfig.LowMemoryQueryKillerPolicy.TOTAL_RESERVATION, TotalReservationLowMemoryKiller.class);
        this.bindLowMemoryQueryKiller(MemoryManagerConfig.LowMemoryQueryKillerPolicy.TOTAL_RESERVATION_ON_BLOCKED_NODES, TotalReservationOnBlockedNodesQueryLowMemoryKiller.class);
        ExportBinder.newExporter((Binder)binder).export(ClusterMemoryManager.class).withGeneratedName();
        this.install(ConditionalModule.conditionalModule(NodeSchedulerConfig.class, config -> NodeSchedulerConfig.NodeAllocatorType.FIXED_COUNT == config.getNodeAllocatorType(), innerBinder -> {
            innerBinder.bind(NodeAllocatorService.class).to(FixedCountNodeAllocatorService.class).in(Scopes.SINGLETON);
            innerBinder.bind(PartitionMemoryEstimatorFactory.class).toInstance(ConstantPartitionMemoryEstimator::new);
        }));
        this.install(ConditionalModule.conditionalModule(NodeSchedulerConfig.class, config -> NodeSchedulerConfig.NodeAllocatorType.BIN_PACKING == config.getNodeAllocatorType(), innerBinder -> {
            innerBinder.bind(BinPackingNodeAllocatorService.class).in(Scopes.SINGLETON);
            innerBinder.bind(NodeAllocatorService.class).to(BinPackingNodeAllocatorService.class);
            innerBinder.bind(PartitionMemoryEstimatorFactory.class).to(BinPackingNodeAllocatorService.class);
        }));
        binder.bind(ClusterSizeMonitor.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(ClusterSizeMonitor.class).withGeneratedName();
        binder.install((Module)new StatsCalculatorModule());
        binder.bind(TaskCountEstimator.class).in(Scopes.SINGLETON);
        binder.bind(CostCalculator.class).to(CostCalculatorUsingExchanges.class).in(Scopes.SINGLETON);
        binder.bind(CostCalculator.class).annotatedWith(CostCalculator.EstimatedExchanges.class).to(CostCalculatorWithEstimatedExchanges.class).in(Scopes.SINGLETON);
        binder.bind(CostComparator.class).in(Scopes.SINGLETON);
        binder.bind(DynamicFilterService.class).in(Scopes.SINGLETON);
        binder.bind(AnalyzerFactory.class).in(Scopes.SINGLETON);
        binder.bind(StatementRewrite.class).in(Scopes.SINGLETON);
        Multibinder rewriteBinder = Multibinder.newSetBinder((Binder)binder, StatementRewrite.Rewrite.class);
        rewriteBinder.addBinding().to(DescribeInputRewrite.class).in(Scopes.SINGLETON);
        rewriteBinder.addBinding().to(DescribeOutputRewrite.class).in(Scopes.SINGLETON);
        rewriteBinder.addBinding().to(ShowQueriesRewrite.class).in(Scopes.SINGLETON);
        rewriteBinder.addBinding().to(ShowStatsRewrite.class).in(Scopes.SINGLETON);
        rewriteBinder.addBinding().to(ExplainRewrite.class).in(Scopes.SINGLETON);
        binder.bind(PlanFragmenter.class).in(Scopes.SINGLETON);
        binder.bind(PlanOptimizersFactory.class).to(PlanOptimizers.class).in(Scopes.SINGLETON);
        binder.bind(RuleStatsRecorder.class).in(Scopes.SINGLETON);
        binder.bind(OptimizerStatsMBeanExporter.class).in(Scopes.SINGLETON);
        binder.bind(QueryExplainerFactory.class).in(Scopes.SINGLETON);
        binder.bind(ExplainAnalyzeContext.class).in(Scopes.SINGLETON);
        JsonCodecBinder.jsonCodecBinder((Binder)binder).bindJsonCodec(TaskInfo.class);
        JsonCodecBinder.jsonCodecBinder((Binder)binder).bindJsonCodec(TaskStatus.class);
        JsonCodecBinder.jsonCodecBinder((Binder)binder).bindJsonCodec(TaskUpdateRequest.class);
        JsonCodecBinder.jsonCodecBinder((Binder)binder).bindJsonCodec(FailTaskRequest.class);
        JsonCodecBinder.jsonCodecBinder((Binder)binder).bindJsonCodec(DynamicFiltersCollector.VersionedDynamicFilterDomains.class);
        binder.bind(RemoteTaskFactory.class).to(HttpRemoteTaskFactory.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(RemoteTaskFactory.class).withGeneratedName();
        binder.bind(RemoteTaskStats.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(RemoteTaskStats.class).withGeneratedName();
        HttpClientBinder.httpClientBinder((Binder)binder).bindHttpClient("scheduler", ForScheduler.class).withTracing().withFilter(GenerateTraceTokenRequestFilter.class).withConfigDefaults(config -> {
            config.setIdleTimeout(new Duration(30.0, TimeUnit.SECONDS));
            config.setRequestTimeout(new Duration(10.0, TimeUnit.SECONDS));
            config.setMaxConnectionsPerServer(250);
        });
        binder.bind(ScheduledExecutorService.class).annotatedWith(ForScheduler.class).toInstance((Object)Executors.newSingleThreadScheduledExecutor(Threads.threadsNamed((String)"stage-scheduler")));
        QueryManagerConfig queryManagerConfig = (QueryManagerConfig)this.buildConfigObject(QueryManagerConfig.class);
        ThreadPoolExecutor queryExecutor = new ThreadPoolExecutor(queryManagerConfig.getQueryExecutorPoolSize(), queryManagerConfig.getQueryExecutorPoolSize(), 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(1000), Threads.threadsNamed((String)"query-execution-%s"));
        queryExecutor.allowCoreThreadTimeOut(true);
        binder.bind(ExecutorService.class).annotatedWith(ForQueryExecution.class).toInstance((Object)queryExecutor);
        binder.bind(QueryExecutionMBean.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(QueryExecutionMBean.class).as(generator -> generator.generatedNameOf(QueryExecution.class));
        binder.bind(SplitSourceFactory.class).in(Scopes.SINGLETON);
        binder.bind(SplitSchedulerStats.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(SplitSchedulerStats.class).withGeneratedName();
        binder.bind(EventDrivenTaskSourceFactory.class).in(Scopes.SINGLETON);
        binder.bind(TaskDescriptorStorage.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(TaskDescriptorStorage.class).withGeneratedName();
        binder.bind(TaskExecutionStats.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(TaskExecutionStats.class).withGeneratedName();
        MapBinder executionPolicyBinder = MapBinder.newMapBinder((Binder)binder, String.class, ExecutionPolicy.class);
        executionPolicyBinder.addBinding((Object)"all-at-once").to(AllAtOnceExecutionPolicy.class);
        executionPolicyBinder.addBinding((Object)"phased").to(PhasedExecutionPolicy.class);
        this.install(new QueryExecutionFactoryModule());
        binder.bind(ExecutorCleanup.class).asEagerSingleton();
    }

    @Provides
    @Singleton
    public static ResourceGroupManager<?> getResourceGroupManager(ResourceGroupManager manager) {
        return manager;
    }

    @Provides
    @Singleton
    public static QueryPerformanceFetcher createQueryPerformanceFetcher(QueryManager queryManager) {
        return queryManager::getFullQueryInfo;
    }

    @Provides
    @Singleton
    @ForStatementResource
    public static ExecutorService createStatementResponseCoreExecutor() {
        return Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"statement-response-%s"));
    }

    @Provides
    @Singleton
    @ForStatementResource
    public static BoundedExecutor createStatementResponseExecutor(@ForStatementResource ExecutorService coreExecutor, TaskManagerConfig config) {
        return new BoundedExecutor((Executor)coreExecutor, config.getHttpResponseThreads());
    }

    @Provides
    @Singleton
    @ForStatementResource
    public static ScheduledExecutorService createStatementTimeoutExecutor(TaskManagerConfig config) {
        return Executors.newScheduledThreadPool(config.getHttpTimeoutThreads(), Threads.daemonThreadsNamed((String)"statement-timeout-%s"));
    }

    private void bindLowMemoryQueryKiller(MemoryManagerConfig.LowMemoryQueryKillerPolicy policy, Class<? extends LowMemoryKiller> clazz) {
        this.install(ConditionalModule.conditionalModule(MemoryManagerConfig.class, config -> policy == config.getLowMemoryQueryKillerPolicy(), binder -> binder.bind(LowMemoryKiller.class).annotatedWith(LowMemoryKiller.ForQueryLowMemoryKiller.class).to(clazz).in(Scopes.SINGLETON)));
    }

    private void bindLowMemoryTaskKiller(MemoryManagerConfig.LowMemoryTaskKillerPolicy policy, Class<? extends LowMemoryKiller> clazz) {
        this.install(ConditionalModule.conditionalModule(MemoryManagerConfig.class, config -> policy == config.getLowMemoryTaskKillerPolicy(), binder -> binder.bind(LowMemoryKiller.class).annotatedWith(LowMemoryKiller.ForTaskLowMemoryKiller.class).to(clazz).in(Scopes.SINGLETON)));
    }

    public static class ExecutorCleanup {
        private final List<ExecutorService> executors;

        @Inject
        public ExecutorCleanup(@ForStatementResource ExecutorService statementResponseExecutor, @ForStatementResource ScheduledExecutorService statementTimeoutExecutor, @ForQueryExecution ExecutorService queryExecutionExecutor, @ForScheduler ScheduledExecutorService schedulerExecutor) {
            this.executors = ImmutableList.builder().add((Object)statementResponseExecutor).add((Object)statementTimeoutExecutor).add((Object)queryExecutionExecutor).add((Object)schedulerExecutor).build();
        }

        @PreDestroy
        public void shutdown() {
            this.executors.forEach(ExecutorService::shutdownNow);
        }
    }
}

