/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.security;

import io.trino.security.AccessControl;
import io.trino.server.HttpRequestSessionContextFactory;
import io.trino.server.InternalAuthenticationManager;
import io.trino.server.ProtocolConfig;
import io.trino.server.ServletSecurityUtils;
import io.trino.server.security.AuthenticationFilter;
import io.trino.server.security.InternalPrincipal;
import io.trino.server.security.ResourceAccessType;
import io.trino.server.security.ResourceSecurity;
import io.trino.server.security.SecurityConfig;
import io.trino.server.ui.WebUiAuthenticationFilter;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.security.AccessDeniedException;
import io.trino.spi.security.Identity;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.ServiceUnavailableException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.FeatureContext;
import javax.ws.rs.core.MultivaluedMap;

public class ResourceSecurityDynamicFeature
implements DynamicFeature {
    private final ResourceAccessType resourceAccessType;
    private final AuthenticationFilter authenticationFilter;
    private final WebUiAuthenticationFilter webUiAuthenticationFilter;
    private final InternalAuthenticationManager internalAuthenticationManager;
    private final AccessControl accessControl;
    private final HttpRequestSessionContextFactory sessionContextFactory;
    private final Optional<String> fixedManagementUser;
    private final boolean fixedManagementUserForHttps;
    private final Optional<String> alternateHeaderName;

    @Inject
    public ResourceSecurityDynamicFeature(ResourceAccessType resourceAccessType, AuthenticationFilter authenticationFilter, WebUiAuthenticationFilter webUiAuthenticationFilter, InternalAuthenticationManager internalAuthenticationManager, AccessControl accessControl, HttpRequestSessionContextFactory sessionContextFactory, SecurityConfig securityConfig, ProtocolConfig protocolConfig) {
        this.resourceAccessType = Objects.requireNonNull(resourceAccessType, "resourceAccessType is null");
        this.authenticationFilter = Objects.requireNonNull(authenticationFilter, "authenticationFilter is null");
        this.webUiAuthenticationFilter = Objects.requireNonNull(webUiAuthenticationFilter, "webUiAuthenticationFilter is null");
        this.internalAuthenticationManager = Objects.requireNonNull(internalAuthenticationManager, "internalAuthenticationManager is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
        this.sessionContextFactory = Objects.requireNonNull(sessionContextFactory, "sessionContextFactory is null");
        this.fixedManagementUser = securityConfig.getFixedManagementUser();
        this.fixedManagementUserForHttps = securityConfig.isFixedManagementUserForHttps();
        this.alternateHeaderName = protocolConfig.getAlternateHeaderName();
    }

    public void configure(ResourceInfo resourceInfo, FeatureContext context) {
        ResourceSecurity.AccessType accessType = this.resourceAccessType.getAccessType(resourceInfo);
        switch (accessType) {
            case PUBLIC: {
                return;
            }
            case WEB_UI: {
                context.register((Object)this.webUiAuthenticationFilter);
                context.register((Object)new DisposeIdentityResponseFilter());
                return;
            }
            case AUTHENTICATED_USER: {
                context.register((Object)this.authenticationFilter);
                context.register((Object)new DisposeIdentityResponseFilter());
                return;
            }
            case MANAGEMENT_READ: 
            case MANAGEMENT_WRITE: {
                context.register((Object)new ManagementAuthenticationFilter(this.fixedManagementUser, this.fixedManagementUserForHttps, this.authenticationFilter));
                context.register((Object)new ManagementAuthorizationFilter(this.accessControl, this.sessionContextFactory, accessType == ResourceSecurity.AccessType.MANAGEMENT_READ, this.alternateHeaderName));
                context.register((Object)new DisposeIdentityResponseFilter());
                return;
            }
            case INTERNAL_ONLY: {
                context.register((Object)new InternalOnlyRequestFilter(this.internalAuthenticationManager));
                return;
            }
        }
        throw new IllegalArgumentException("Unknown mode: " + accessType);
    }

    @Priority(value=1000)
    private static class DisposeIdentityResponseFilter
    implements ContainerResponseFilter {
        private DisposeIdentityResponseFilter() {
        }

        public void filter(ContainerRequestContext request, ContainerResponseContext response) {
            Optional.ofNullable(request.getProperty("trino.authenticated-identity")).map(Identity.class::cast).ifPresent(Identity::destroy);
        }
    }

    @Priority(value=1000)
    private static class ManagementAuthenticationFilter
    implements ContainerRequestFilter {
        private final AuthenticationFilter fallbackAuthenticationFilter;
        private final Optional<String> fixedManagementUser;
        private final boolean fixedManagementUserForHttps;

        public ManagementAuthenticationFilter(Optional<String> fixedManagementUser, boolean fixedManagementUserForHttps, AuthenticationFilter fallbackAuthenticationFilter) {
            this.fixedManagementUser = Objects.requireNonNull(fixedManagementUser, "fixedManagementUser is null");
            this.fixedManagementUserForHttps = fixedManagementUserForHttps;
            this.fallbackAuthenticationFilter = Objects.requireNonNull(fallbackAuthenticationFilter, "fallbackAuthenticationFilter is null");
        }

        public void filter(ContainerRequestContext request) {
            if (this.fixedManagementUser.isPresent() && (this.fixedManagementUserForHttps || !request.getSecurityContext().isSecure())) {
                ServletSecurityUtils.setAuthenticatedIdentity(request, this.fixedManagementUser.get());
            } else {
                this.fallbackAuthenticationFilter.filter(request);
            }
        }
    }

    @Priority(value=2000)
    private static class ManagementAuthorizationFilter
    implements ContainerRequestFilter {
        private final AccessControl accessControl;
        private final HttpRequestSessionContextFactory sessionContextFactory;
        private final boolean read;
        private final Optional<String> alternateHeaderName;

        public ManagementAuthorizationFilter(AccessControl accessControl, HttpRequestSessionContextFactory sessionContextFactory, boolean read, Optional<String> alternateHeaderName) {
            this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
            this.sessionContextFactory = Objects.requireNonNull(sessionContextFactory, "sessionContextFactory is null");
            this.read = read;
            this.alternateHeaderName = Objects.requireNonNull(alternateHeaderName, "alternateHeaderName is null");
        }

        public void filter(ContainerRequestContext request) {
            if (request.getSecurityContext().getUserPrincipal() instanceof InternalPrincipal) {
                return;
            }
            try {
                Identity identity = this.sessionContextFactory.extractAuthorizedIdentity(Optional.ofNullable((Identity)request.getProperty("trino.authenticated-identity")), (MultivaluedMap<String, String>)request.getHeaders(), this.alternateHeaderName);
                if (this.read) {
                    this.accessControl.checkCanReadSystemInformation(identity);
                } else {
                    this.accessControl.checkCanWriteSystemInformation(identity);
                }
            }
            catch (AccessDeniedException e) {
                throw new ForbiddenException("Management only resource");
            }
            catch (TrinoException e) {
                if (StandardErrorCode.SERVER_STARTING_UP.toErrorCode().equals((Object)e.getErrorCode())) {
                    throw new ServiceUnavailableException(e.getMessage());
                }
                throw e;
            }
        }
    }

    @Priority(value=1000)
    private static class InternalOnlyRequestFilter
    implements ContainerRequestFilter {
        private final InternalAuthenticationManager internalAuthenticationManager;

        @Inject
        public InternalOnlyRequestFilter(InternalAuthenticationManager internalAuthenticationManager) {
            this.internalAuthenticationManager = Objects.requireNonNull(internalAuthenticationManager, "internalAuthenticationManager is null");
        }

        public void filter(ContainerRequestContext request) {
            if (InternalAuthenticationManager.isInternalRequest(request)) {
                this.internalAuthenticationManager.handleInternalRequest(request);
                return;
            }
            throw new ForbiddenException("Internal only resource");
        }
    }
}

