/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.trino.sql.planner.Partitioning;
import io.trino.sql.planner.PartitioningHandle;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.SystemPartitioningHandle;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class PartitioningScheme {
    private final Partitioning partitioning;
    private final List<Symbol> outputLayout;
    private final Optional<Symbol> hashColumn;
    private final boolean replicateNullsAndAny;
    private final Optional<int[]> bucketToPartition;
    private final Optional<Integer> partitionCount;

    public PartitioningScheme(Partitioning partitioning, List<Symbol> outputLayout) {
        this(partitioning, outputLayout, Optional.empty(), false, Optional.empty(), Optional.empty());
    }

    public PartitioningScheme(Partitioning partitioning, List<Symbol> outputLayout, Optional<Symbol> hashColumn) {
        this(partitioning, outputLayout, hashColumn, false, Optional.empty(), Optional.empty());
    }

    @JsonCreator
    public PartitioningScheme(@JsonProperty(value="partitioning") Partitioning partitioning, @JsonProperty(value="outputLayout") List<Symbol> outputLayout, @JsonProperty(value="hashColumn") Optional<Symbol> hashColumn, @JsonProperty(value="replicateNullsAndAny") boolean replicateNullsAndAny, @JsonProperty(value="bucketToPartition") Optional<int[]> bucketToPartition, @JsonProperty(value="partitionCount") Optional<Integer> partitionCount) {
        this.partitioning = Objects.requireNonNull(partitioning, "partitioning is null");
        this.outputLayout = ImmutableList.copyOf((Collection)Objects.requireNonNull(outputLayout, "outputLayout is null"));
        Set<Symbol> columns = partitioning.getColumns();
        Preconditions.checkArgument((boolean)ImmutableSet.copyOf(outputLayout).containsAll(columns), (String)"Output layout (%s) don't include all partition columns (%s)", outputLayout, columns);
        this.hashColumn = Objects.requireNonNull(hashColumn, "hashColumn is null");
        hashColumn.ifPresent(column -> Preconditions.checkArgument((boolean)outputLayout.contains(column), (String)"Output layout (%s) don't include hash column (%s)", (Object)outputLayout, (Object)column));
        Preconditions.checkArgument((!replicateNullsAndAny || columns.size() <= 1 ? 1 : 0) != 0, (Object)"Must have at most one partitioning column when nullPartition is REPLICATE.");
        this.replicateNullsAndAny = replicateNullsAndAny;
        this.bucketToPartition = Objects.requireNonNull(bucketToPartition, "bucketToPartition is null");
        this.partitionCount = Objects.requireNonNull(partitionCount, "partitionCount is null");
        Preconditions.checkArgument((partitionCount.isEmpty() || partitioning.getHandle().getConnectorHandle() instanceof SystemPartitioningHandle ? 1 : 0) != 0, (Object)"Connector partitioning handle should be of type system partitioning when partitionCount is present");
    }

    @JsonProperty
    public Partitioning getPartitioning() {
        return this.partitioning;
    }

    @JsonProperty
    public List<Symbol> getOutputLayout() {
        return this.outputLayout;
    }

    @JsonProperty
    public Optional<Symbol> getHashColumn() {
        return this.hashColumn;
    }

    @JsonProperty
    public boolean isReplicateNullsAndAny() {
        return this.replicateNullsAndAny;
    }

    @JsonProperty
    public Optional<int[]> getBucketToPartition() {
        return this.bucketToPartition;
    }

    @JsonProperty
    public Optional<Integer> getPartitionCount() {
        return this.partitionCount;
    }

    public PartitioningScheme withBucketToPartition(Optional<int[]> bucketToPartition) {
        return new PartitioningScheme(this.partitioning, this.outputLayout, this.hashColumn, this.replicateNullsAndAny, bucketToPartition, this.partitionCount);
    }

    public PartitioningScheme withPartitioningHandle(PartitioningHandle partitioningHandle) {
        Partitioning newPartitioning = this.partitioning.withAlternativePartitioningHandle(partitioningHandle);
        return new PartitioningScheme(newPartitioning, this.outputLayout, this.hashColumn, this.replicateNullsAndAny, this.bucketToPartition, this.partitionCount);
    }

    public PartitioningScheme withPartitionCount(int partitionCount) {
        return new PartitioningScheme(this.partitioning, this.outputLayout, this.hashColumn, this.replicateNullsAndAny, this.bucketToPartition, Optional.of(partitionCount));
    }

    public PartitioningScheme translateOutputLayout(List<Symbol> newOutputLayout) {
        Objects.requireNonNull(newOutputLayout, "newOutputLayout is null");
        Preconditions.checkArgument((newOutputLayout.size() == this.outputLayout.size() ? 1 : 0) != 0);
        Partitioning newPartitioning = this.partitioning.translate(symbol -> (Symbol)newOutputLayout.get(this.outputLayout.indexOf(symbol)));
        Optional<Symbol> newHashSymbol = this.hashColumn.map(this.outputLayout::indexOf).map(newOutputLayout::get);
        return new PartitioningScheme(newPartitioning, newOutputLayout, newHashSymbol, this.replicateNullsAndAny, this.bucketToPartition, this.partitionCount);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartitioningScheme that = (PartitioningScheme)o;
        return Objects.equals(this.partitioning, that.partitioning) && Objects.equals(this.outputLayout, that.outputLayout) && this.replicateNullsAndAny == that.replicateNullsAndAny && Objects.equals(this.bucketToPartition, that.bucketToPartition) && Objects.equals(this.partitionCount, that.partitionCount);
    }

    public int hashCode() {
        return Objects.hash(this.partitioning, this.outputLayout, this.replicateNullsAndAny, this.bucketToPartition, this.partitionCount);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("partitioning", (Object)this.partitioning).add("outputLayout", this.outputLayout).add("hashChannel", this.hashColumn).add("replicateNullsAndAny", this.replicateNullsAndAny).add("bucketToPartition", this.bucketToPartition).add("partitionCount", this.partitionCount).toString();
    }
}

