/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.Session;
import io.trino.json.ir.IrJsonPath;
import io.trino.metadata.ResolvedFunction;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.type.RowType;
import io.trino.spi.type.TimeType;
import io.trino.spi.type.TimeWithTimeZoneType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeId;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.VarcharType;
import io.trino.sql.PlannerContext;
import io.trino.sql.analyzer.Analysis;
import io.trino.sql.analyzer.ExpressionAnalyzer;
import io.trino.sql.analyzer.ResolvedField;
import io.trino.sql.analyzer.Scope;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.analyzer.TypeSignatureTranslator;
import io.trino.sql.planner.FunctionCallBuilder;
import io.trino.sql.planner.JsonPathTranslator;
import io.trino.sql.planner.LiteralEncoder;
import io.trino.sql.planner.QueryPlanner;
import io.trino.sql.planner.ScopeAware;
import io.trino.sql.planner.Symbol;
import io.trino.sql.tree.Array;
import io.trino.sql.tree.AtTimeZone;
import io.trino.sql.tree.BooleanLiteral;
import io.trino.sql.tree.Cast;
import io.trino.sql.tree.CurrentCatalog;
import io.trino.sql.tree.CurrentPath;
import io.trino.sql.tree.CurrentSchema;
import io.trino.sql.tree.CurrentTime;
import io.trino.sql.tree.CurrentUser;
import io.trino.sql.tree.DereferenceExpression;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.ExpressionRewriter;
import io.trino.sql.tree.ExpressionTreeRewriter;
import io.trino.sql.tree.Extract;
import io.trino.sql.tree.FieldReference;
import io.trino.sql.tree.Format;
import io.trino.sql.tree.FunctionCall;
import io.trino.sql.tree.GenericDataType;
import io.trino.sql.tree.GenericLiteral;
import io.trino.sql.tree.Identifier;
import io.trino.sql.tree.JsonArray;
import io.trino.sql.tree.JsonArrayElement;
import io.trino.sql.tree.JsonExists;
import io.trino.sql.tree.JsonObject;
import io.trino.sql.tree.JsonObjectMember;
import io.trino.sql.tree.JsonPathParameter;
import io.trino.sql.tree.JsonQuery;
import io.trino.sql.tree.JsonValue;
import io.trino.sql.tree.LabelDereference;
import io.trino.sql.tree.LambdaArgumentDeclaration;
import io.trino.sql.tree.LambdaExpression;
import io.trino.sql.tree.LikePredicate;
import io.trino.sql.tree.LongLiteral;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeRef;
import io.trino.sql.tree.NullLiteral;
import io.trino.sql.tree.Parameter;
import io.trino.sql.tree.QualifiedName;
import io.trino.sql.tree.Row;
import io.trino.sql.tree.RowDataType;
import io.trino.sql.tree.SubscriptExpression;
import io.trino.sql.tree.SymbolReference;
import io.trino.sql.tree.Trim;
import io.trino.sql.tree.TryExpression;
import io.trino.sql.util.AstUtils;
import io.trino.type.FunctionType;
import io.trino.type.LikePatternType;
import io.trino.util.Failures;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

class TranslationMap {
    private final Scope scope;
    private final Analysis analysis;
    private final Map<NodeRef<LambdaArgumentDeclaration>, Symbol> lambdaArguments;
    private final Optional<TranslationMap> outerContext;
    private final Session session;
    private final PlannerContext plannerContext;
    private final Symbol[] fieldSymbols;
    private final Map<ScopeAware<Expression>, Symbol> astToSymbols;

    public TranslationMap(Optional<TranslationMap> outerContext, Scope scope, Analysis analysis, Map<NodeRef<LambdaArgumentDeclaration>, Symbol> lambdaArguments, List<Symbol> fieldSymbols, Session session, PlannerContext plannerContext) {
        this(outerContext, scope, analysis, lambdaArguments, (Symbol[])fieldSymbols.toArray(new Symbol[0]).clone(), (Map<ScopeAware<Expression>, Symbol>)ImmutableMap.of(), session, plannerContext);
    }

    public TranslationMap(Optional<TranslationMap> outerContext, Scope scope, Analysis analysis, Map<NodeRef<LambdaArgumentDeclaration>, Symbol> lambdaArguments, List<Symbol> fieldSymbols, Map<ScopeAware<Expression>, Symbol> astToSymbols, Session session, PlannerContext plannerContext) {
        this(outerContext, scope, analysis, lambdaArguments, fieldSymbols.toArray(new Symbol[0]), astToSymbols, session, plannerContext);
    }

    public TranslationMap(Optional<TranslationMap> outerContext, Scope scope, Analysis analysis, Map<NodeRef<LambdaArgumentDeclaration>, Symbol> lambdaArguments, Symbol[] fieldSymbols, Map<ScopeAware<Expression>, Symbol> astToSymbols, Session session, PlannerContext plannerContext) {
        this.outerContext = Objects.requireNonNull(outerContext, "outerContext is null");
        this.scope = Objects.requireNonNull(scope, "scope is null");
        this.analysis = Objects.requireNonNull(analysis, "analysis is null");
        this.lambdaArguments = Objects.requireNonNull(lambdaArguments, "lambdaArguments is null");
        this.session = Objects.requireNonNull(session, "session is null");
        this.plannerContext = Objects.requireNonNull(plannerContext, "plannerContext is null");
        Objects.requireNonNull(fieldSymbols, "fieldSymbols is null");
        this.fieldSymbols = (Symbol[])fieldSymbols.clone();
        Objects.requireNonNull(astToSymbols, "astToSymbols is null");
        this.astToSymbols = ImmutableMap.copyOf(astToSymbols);
        Preconditions.checkArgument((scope.getLocalScopeFieldCount() == fieldSymbols.length ? 1 : 0) != 0, (String)"scope: %s, fields mappings: %s", (int)scope.getRelationType().getAllFieldCount(), (int)fieldSymbols.length);
        astToSymbols.keySet().stream().map(ScopeAware::getNode).forEach(TranslationMap::verifyAstExpression);
    }

    public TranslationMap withScope(Scope scope, List<Symbol> fields) {
        return new TranslationMap(this.outerContext, scope, this.analysis, this.lambdaArguments, fields.toArray(new Symbol[0]), this.astToSymbols, this.session, this.plannerContext);
    }

    public TranslationMap withNewMappings(Map<ScopeAware<Expression>, Symbol> mappings, List<Symbol> fields) {
        return new TranslationMap(this.outerContext, this.scope, this.analysis, this.lambdaArguments, fields, mappings, this.session, this.plannerContext);
    }

    public TranslationMap withAdditionalMappings(Map<ScopeAware<Expression>, Symbol> mappings) {
        HashMap<ScopeAware<Expression>, Symbol> newMappings = new HashMap<ScopeAware<Expression>, Symbol>();
        newMappings.putAll(this.astToSymbols);
        newMappings.putAll(mappings);
        return new TranslationMap(this.outerContext, this.scope, this.analysis, this.lambdaArguments, this.fieldSymbols, newMappings, this.session, this.plannerContext);
    }

    public List<Symbol> getFieldSymbols() {
        return Collections.unmodifiableList(Arrays.asList(this.fieldSymbols));
    }

    public Map<ScopeAware<Expression>, Symbol> getMappings() {
        return this.astToSymbols;
    }

    public Analysis getAnalysis() {
        return this.analysis;
    }

    public boolean canTranslate(Expression expression) {
        TranslationMap.verifyAstExpression(expression);
        if (this.astToSymbols.containsKey(ScopeAware.scopeAwareKey(expression, this.analysis, this.scope)) || expression instanceof FieldReference) {
            return true;
        }
        if (this.analysis.isColumnReference(expression)) {
            ResolvedField field = this.analysis.getColumnReferenceFields().get(NodeRef.of((Node)expression));
            return this.scope.isLocalScope(field.getScope());
        }
        return false;
    }

    public Expression rewrite(final Expression expression) {
        TranslationMap.verifyAstExpression(expression);
        return ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new ExpressionRewriter<Void>(){

            protected Expression rewriteExpression(Expression node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
                Optional<SymbolReference> mapped = TranslationMap.this.tryGetMapping(node);
                if (mapped.isPresent()) {
                    return this.coerceIfNecessary(node, (Expression)mapped.get());
                }
                Expression rewrittenExpression = treeRewriter.defaultRewrite(node, (Object)context);
                return this.coerceIfNecessary(node, rewrittenExpression);
            }

            public Expression rewriteFieldReference(FieldReference node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
                Optional<SymbolReference> mapped = TranslationMap.this.tryGetMapping((Expression)node);
                if (mapped.isPresent()) {
                    return this.coerceIfNecessary((Expression)node, (Expression)mapped.get());
                }
                return (Expression)TranslationMap.this.getSymbolForColumn((Expression)node).map(Symbol::toSymbolReference).orElseThrow(() -> new IllegalStateException(String.format("No symbol mapping for node '%s' (%s)", node, node.getFieldIndex())));
            }

            public Expression rewriteIdentifier(Identifier node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
                Optional<SymbolReference> mapped = TranslationMap.this.tryGetMapping((Expression)node);
                if (mapped.isPresent()) {
                    return this.coerceIfNecessary((Expression)node, (Expression)mapped.get());
                }
                LambdaArgumentDeclaration referencedLambdaArgumentDeclaration = TranslationMap.this.analysis.getLambdaArgumentReference(node);
                if (referencedLambdaArgumentDeclaration != null) {
                    Symbol symbol2 = TranslationMap.this.lambdaArguments.get(NodeRef.of((Node)referencedLambdaArgumentDeclaration));
                    return this.coerceIfNecessary((Expression)node, (Expression)symbol2.toSymbolReference());
                }
                return TranslationMap.this.getSymbolForColumn((Expression)node).map(symbol -> this.coerceIfNecessary((Expression)node, (Expression)symbol.toSymbolReference())).orElseGet(() -> this.coerceIfNecessary((Expression)node, (Expression)node));
            }

            public Expression rewriteFunctionCall(FunctionCall node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
                Optional<SymbolReference> mapped;
                if (TranslationMap.this.analysis.isPatternRecognitionFunction(node)) {
                    ImmutableList.Builder rewrittenArguments = ImmutableList.builder();
                    if (!node.getArguments().isEmpty()) {
                        rewrittenArguments.add((Object)treeRewriter.rewrite((Expression)node.getArguments().get(0), null));
                        if (node.getArguments().size() > 1) {
                            rewrittenArguments.add((Object)((Expression)node.getArguments().get(1)));
                        }
                    }
                    return this.coerceIfNecessary((Expression)node, (Expression)new FunctionCall(Optional.empty(), node.getName(), Optional.empty(), Optional.empty(), Optional.empty(), false, Optional.empty(), node.getProcessingMode(), (List)rewrittenArguments.build()));
                }
                if (!TranslationMap.this.analysis.isPatternAggregation(node) && (mapped = TranslationMap.this.tryGetMapping((Expression)node)).isPresent()) {
                    return this.coerceIfNecessary((Expression)node, (Expression)mapped.get());
                }
                ResolvedFunction resolvedFunction = TranslationMap.this.analysis.getResolvedFunction((Expression)node);
                Preconditions.checkArgument((resolvedFunction != null ? 1 : 0) != 0, (String)"Function has not been analyzed: %s", (Object)node);
                FunctionCall rewritten = (FunctionCall)treeRewriter.defaultRewrite((Expression)node, (Object)context);
                rewritten = new FunctionCall(rewritten.getLocation(), resolvedFunction.toQualifiedName(), rewritten.getWindow(), rewritten.getFilter(), rewritten.getOrderBy(), rewritten.isDistinct(), rewritten.getNullTreatment(), rewritten.getProcessingMode(), rewritten.getArguments());
                return this.coerceIfNecessary((Expression)node, (Expression)rewritten);
            }

            public Expression rewriteDereferenceExpression(DereferenceExpression node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
                ExpressionAnalyzer.LabelPrefixedReference labelDereference = TranslationMap.this.analysis.getLabelDereference(node);
                if (labelDereference != null) {
                    if (labelDereference.getColumn().isPresent()) {
                        Expression rewritten = treeRewriter.rewrite((Expression)labelDereference.getColumn().get(), null);
                        Preconditions.checkState((boolean)(rewritten instanceof SymbolReference), (Object)("expected symbol reference, got: " + rewritten));
                        return this.coerceIfNecessary((Expression)node, (Expression)new LabelDereference(labelDereference.getLabel(), (SymbolReference)rewritten));
                    }
                    return new LabelDereference(labelDereference.getLabel());
                }
                Optional<SymbolReference> mapped = TranslationMap.this.tryGetMapping((Expression)node);
                if (mapped.isPresent()) {
                    return this.coerceIfNecessary((Expression)node, (Expression)mapped.get());
                }
                if (TranslationMap.this.analysis.isColumnReference((Expression)node)) {
                    return this.coerceIfNecessary((Expression)node, (Expression)TranslationMap.this.getSymbolForColumn((Expression)node).map(Symbol::toSymbolReference).orElseThrow(() -> new IllegalStateException(String.format("No mapping for %s", node))));
                }
                RowType rowType = (RowType)TranslationMap.this.analysis.getType(node.getBase());
                String fieldName = ((Identifier)node.getField().orElseThrow()).getValue();
                List fields = rowType.getFields();
                int index = -1;
                for (int i = 0; i < fields.size(); ++i) {
                    RowType.Field field = (RowType.Field)fields.get(i);
                    if (!field.getName().isPresent() || !((String)field.getName().get()).equalsIgnoreCase(fieldName)) continue;
                    Preconditions.checkArgument((index < 0 ? 1 : 0) != 0, (String)"Ambiguous field %s in type %s", (Object)field, (Object)rowType.getDisplayName());
                    index = i;
                }
                Preconditions.checkState((index >= 0 ? 1 : 0) != 0, (String)"could not find field name: %s", (Object)fieldName);
                return this.coerceIfNecessary((Expression)node, (Expression)new SubscriptExpression(treeRewriter.rewrite(node.getBase(), (Object)context), (Expression)new LongLiteral(Long.toString(index + 1))));
            }

            public Expression rewriteArray(Array node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
                Optional<SymbolReference> mapped = TranslationMap.this.tryGetMapping((Expression)node);
                if (mapped.isPresent()) {
                    return this.coerceIfNecessary((Expression)node, (Expression)mapped.get());
                }
                Failures.checkCondition(node.getValues().size() <= 254, (ErrorCodeSupplier)StandardErrorCode.TOO_MANY_ARGUMENTS, "Too many arguments for array constructor", new Object[0]);
                List types = (List)node.getValues().stream().map(TranslationMap.this.analysis::getType).collect(ImmutableList.toImmutableList());
                List values = (List)node.getValues().stream().map(element -> treeRewriter.rewrite(element, (Object)context)).collect(ImmutableList.toImmutableList());
                FunctionCall call = FunctionCallBuilder.resolve(TranslationMap.this.session, TranslationMap.this.plannerContext.getMetadata()).setName(QualifiedName.of((String)"$array")).setArguments(types, values).build();
                return this.coerceIfNecessary((Expression)node, (Expression)call);
            }

            public Expression rewriteCurrentCatalog(CurrentCatalog node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
                Optional<SymbolReference> mapped = TranslationMap.this.tryGetMapping((Expression)node);
                if (mapped.isPresent()) {
                    return this.coerceIfNecessary((Expression)node, (Expression)mapped.get());
                }
                return this.coerceIfNecessary((Expression)node, (Expression)new FunctionCall(TranslationMap.this.plannerContext.getMetadata().resolveFunction(TranslationMap.this.session, QualifiedName.of((String)"$current_catalog"), (List<TypeSignatureProvider>)ImmutableList.of()).toQualifiedName(), (List)ImmutableList.of()));
            }

            public Expression rewriteCurrentSchema(CurrentSchema node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
                Optional<SymbolReference> mapped = TranslationMap.this.tryGetMapping((Expression)node);
                if (mapped.isPresent()) {
                    return this.coerceIfNecessary((Expression)node, (Expression)mapped.get());
                }
                return this.coerceIfNecessary((Expression)node, (Expression)new FunctionCall(TranslationMap.this.plannerContext.getMetadata().resolveFunction(TranslationMap.this.session, QualifiedName.of((String)"$current_schema"), (List<TypeSignatureProvider>)ImmutableList.of()).toQualifiedName(), (List)ImmutableList.of()));
            }

            public Expression rewriteCurrentPath(CurrentPath node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
                Optional<SymbolReference> mapped = TranslationMap.this.tryGetMapping((Expression)node);
                if (mapped.isPresent()) {
                    return this.coerceIfNecessary((Expression)node, (Expression)mapped.get());
                }
                return this.coerceIfNecessary((Expression)node, (Expression)new FunctionCall(TranslationMap.this.plannerContext.getMetadata().resolveFunction(TranslationMap.this.session, QualifiedName.of((String)"$current_path"), (List<TypeSignatureProvider>)ImmutableList.of()).toQualifiedName(), (List)ImmutableList.of()));
            }

            public Expression rewriteCurrentUser(CurrentUser node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
                Optional<SymbolReference> mapped = TranslationMap.this.tryGetMapping((Expression)node);
                if (mapped.isPresent()) {
                    return this.coerceIfNecessary((Expression)node, (Expression)mapped.get());
                }
                return this.coerceIfNecessary((Expression)node, (Expression)new FunctionCall(TranslationMap.this.plannerContext.getMetadata().resolveFunction(TranslationMap.this.session, QualifiedName.of((String)"$current_user"), (List<TypeSignatureProvider>)ImmutableList.of()).toQualifiedName(), (List)ImmutableList.of()));
            }

            public Expression rewriteCurrentTime(CurrentTime node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
                Optional<SymbolReference> mapped = TranslationMap.this.tryGetMapping((Expression)node);
                if (mapped.isPresent()) {
                    return this.coerceIfNecessary((Expression)node, (Expression)mapped.get());
                }
                FunctionCall call = switch (node.getFunction()) {
                    default -> throw new IncompatibleClassChangeError();
                    case CurrentTime.Function.DATE -> FunctionCallBuilder.resolve(TranslationMap.this.session, TranslationMap.this.plannerContext.getMetadata()).setName(QualifiedName.of((String)"current_date")).build();
                    case CurrentTime.Function.TIME -> FunctionCallBuilder.resolve(TranslationMap.this.session, TranslationMap.this.plannerContext.getMetadata()).setName(QualifiedName.of((String)"$current_time")).setArguments((List<Type>)ImmutableList.of((Object)TranslationMap.this.analysis.getType((Expression)node)), (List<Expression>)ImmutableList.of((Object)new NullLiteral())).build();
                    case CurrentTime.Function.LOCALTIME -> FunctionCallBuilder.resolve(TranslationMap.this.session, TranslationMap.this.plannerContext.getMetadata()).setName(QualifiedName.of((String)"$localtime")).setArguments((List<Type>)ImmutableList.of((Object)TranslationMap.this.analysis.getType((Expression)node)), (List<Expression>)ImmutableList.of((Object)new NullLiteral())).build();
                    case CurrentTime.Function.TIMESTAMP -> FunctionCallBuilder.resolve(TranslationMap.this.session, TranslationMap.this.plannerContext.getMetadata()).setName(QualifiedName.of((String)"$current_timestamp")).setArguments((List<Type>)ImmutableList.of((Object)TranslationMap.this.analysis.getType((Expression)node)), (List<Expression>)ImmutableList.of((Object)new NullLiteral())).build();
                    case CurrentTime.Function.LOCALTIMESTAMP -> FunctionCallBuilder.resolve(TranslationMap.this.session, TranslationMap.this.plannerContext.getMetadata()).setName(QualifiedName.of((String)"$localtimestamp")).setArguments((List<Type>)ImmutableList.of((Object)TranslationMap.this.analysis.getType((Expression)node)), (List<Expression>)ImmutableList.of((Object)new NullLiteral())).build();
                };
                return this.coerceIfNecessary((Expression)node, (Expression)call);
            }

            public Expression rewriteExtract(Extract node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
                Optional<SymbolReference> mapped = TranslationMap.this.tryGetMapping((Expression)node);
                if (mapped.isPresent()) {
                    return this.coerceIfNecessary((Expression)node, (Expression)mapped.get());
                }
                Expression value = treeRewriter.rewrite(node.getExpression(), (Object)context);
                Type type = TranslationMap.this.analysis.getType(node.getExpression());
                FunctionCall call = switch (node.getField()) {
                    default -> throw new IncompatibleClassChangeError();
                    case Extract.Field.YEAR -> FunctionCallBuilder.resolve(TranslationMap.this.session, TranslationMap.this.plannerContext.getMetadata()).setName(QualifiedName.of((String)"year")).addArgument(type, value).build();
                    case Extract.Field.QUARTER -> FunctionCallBuilder.resolve(TranslationMap.this.session, TranslationMap.this.plannerContext.getMetadata()).setName(QualifiedName.of((String)"quarter")).addArgument(type, value).build();
                    case Extract.Field.MONTH -> FunctionCallBuilder.resolve(TranslationMap.this.session, TranslationMap.this.plannerContext.getMetadata()).setName(QualifiedName.of((String)"month")).addArgument(type, value).build();
                    case Extract.Field.WEEK -> FunctionCallBuilder.resolve(TranslationMap.this.session, TranslationMap.this.plannerContext.getMetadata()).setName(QualifiedName.of((String)"week")).addArgument(type, value).build();
                    case Extract.Field.DAY, Extract.Field.DAY_OF_MONTH -> FunctionCallBuilder.resolve(TranslationMap.this.session, TranslationMap.this.plannerContext.getMetadata()).setName(QualifiedName.of((String)"day")).addArgument(type, value).build();
                    case Extract.Field.DAY_OF_WEEK, Extract.Field.DOW -> FunctionCallBuilder.resolve(TranslationMap.this.session, TranslationMap.this.plannerContext.getMetadata()).setName(QualifiedName.of((String)"day_of_week")).addArgument(type, value).build();
                    case Extract.Field.DAY_OF_YEAR, Extract.Field.DOY -> FunctionCallBuilder.resolve(TranslationMap.this.session, TranslationMap.this.plannerContext.getMetadata()).setName(QualifiedName.of((String)"day_of_year")).addArgument(type, value).build();
                    case Extract.Field.YEAR_OF_WEEK, Extract.Field.YOW -> FunctionCallBuilder.resolve(TranslationMap.this.session, TranslationMap.this.plannerContext.getMetadata()).setName(QualifiedName.of((String)"year_of_week")).addArgument(type, value).build();
                    case Extract.Field.HOUR -> FunctionCallBuilder.resolve(TranslationMap.this.session, TranslationMap.this.plannerContext.getMetadata()).setName(QualifiedName.of((String)"hour")).addArgument(type, value).build();
                    case Extract.Field.MINUTE -> FunctionCallBuilder.resolve(TranslationMap.this.session, TranslationMap.this.plannerContext.getMetadata()).setName(QualifiedName.of((String)"minute")).addArgument(type, value).build();
                    case Extract.Field.SECOND -> FunctionCallBuilder.resolve(TranslationMap.this.session, TranslationMap.this.plannerContext.getMetadata()).setName(QualifiedName.of((String)"second")).addArgument(type, value).build();
                    case Extract.Field.TIMEZONE_MINUTE -> FunctionCallBuilder.resolve(TranslationMap.this.session, TranslationMap.this.plannerContext.getMetadata()).setName(QualifiedName.of((String)"timezone_minute")).addArgument(type, value).build();
                    case Extract.Field.TIMEZONE_HOUR -> FunctionCallBuilder.resolve(TranslationMap.this.session, TranslationMap.this.plannerContext.getMetadata()).setName(QualifiedName.of((String)"timezone_hour")).addArgument(type, value).build();
                };
                return this.coerceIfNecessary((Expression)node, (Expression)call);
            }

            public Expression rewriteAtTimeZone(AtTimeZone node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
                FunctionCall call;
                Optional<SymbolReference> mapped = TranslationMap.this.tryGetMapping((Expression)node);
                if (mapped.isPresent()) {
                    return this.coerceIfNecessary((Expression)node, (Expression)mapped.get());
                }
                Type valueType = TranslationMap.this.analysis.getType(node.getValue());
                Expression value = treeRewriter.rewrite(node.getValue(), (Object)context);
                Type timeZoneType = TranslationMap.this.analysis.getType(node.getTimeZone());
                Expression timeZone = treeRewriter.rewrite(node.getTimeZone(), (Object)context);
                if (valueType instanceof TimeType) {
                    TimeType type = (TimeType)valueType;
                    call = FunctionCallBuilder.resolve(TranslationMap.this.session, TranslationMap.this.plannerContext.getMetadata()).setName(QualifiedName.of((String)"$at_timezone")).addArgument((Type)TimeWithTimeZoneType.createTimeWithTimeZoneType((int)type.getPrecision()), (Expression)new Cast(value, TypeSignatureTranslator.toSqlType((Type)TimeWithTimeZoneType.createTimeWithTimeZoneType((int)((TimeType)valueType).getPrecision())))).addArgument(timeZoneType, timeZone).build();
                } else if (valueType instanceof TimeWithTimeZoneType) {
                    call = FunctionCallBuilder.resolve(TranslationMap.this.session, TranslationMap.this.plannerContext.getMetadata()).setName(QualifiedName.of((String)"$at_timezone")).addArgument(valueType, value).addArgument(timeZoneType, timeZone).build();
                } else if (valueType instanceof TimestampType) {
                    TimestampType type = (TimestampType)valueType;
                    call = FunctionCallBuilder.resolve(TranslationMap.this.session, TranslationMap.this.plannerContext.getMetadata()).setName(QualifiedName.of((String)"at_timezone")).addArgument((Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)type.getPrecision()), (Expression)new Cast(value, TypeSignatureTranslator.toSqlType((Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)((TimestampType)valueType).getPrecision())))).addArgument(timeZoneType, timeZone).build();
                } else if (valueType instanceof TimestampWithTimeZoneType) {
                    call = FunctionCallBuilder.resolve(TranslationMap.this.session, TranslationMap.this.plannerContext.getMetadata()).setName(QualifiedName.of((String)"at_timezone")).addArgument(valueType, value).addArgument(timeZoneType, timeZone).build();
                } else {
                    throw new IllegalArgumentException("Unexpected type: " + valueType);
                }
                return this.coerceIfNecessary((Expression)node, (Expression)call);
            }

            public Expression rewriteFormat(Format node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
                Optional<SymbolReference> mapped = TranslationMap.this.tryGetMapping((Expression)node);
                if (mapped.isPresent()) {
                    return this.coerceIfNecessary((Expression)node, (Expression)mapped.get());
                }
                List arguments = (List)node.getArguments().stream().map(value -> treeRewriter.rewrite(value, (Object)context)).collect(ImmutableList.toImmutableList());
                List argumentTypes = (List)node.getArguments().stream().map(TranslationMap.this.analysis::getType).collect(ImmutableList.toImmutableList());
                FunctionCall call = FunctionCallBuilder.resolve(TranslationMap.this.session, TranslationMap.this.plannerContext.getMetadata()).setName(QualifiedName.of((String)"$format")).addArgument((Type)VarcharType.VARCHAR, (Expression)arguments.get(0)).addArgument((Type)RowType.anonymous(argumentTypes.subList(1, arguments.size())), (Expression)new Row(arguments.subList(1, arguments.size()))).build();
                return this.coerceIfNecessary((Expression)node, (Expression)call);
            }

            public Expression rewriteTryExpression(TryExpression node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
                Optional<SymbolReference> mapped = TranslationMap.this.tryGetMapping((Expression)node);
                if (mapped.isPresent()) {
                    return this.coerceIfNecessary((Expression)node, (Expression)mapped.get());
                }
                Type type = TranslationMap.this.analysis.getType((Expression)node);
                Expression expression2 = treeRewriter.rewrite(node.getInnerExpression(), (Object)context);
                FunctionCall call = FunctionCallBuilder.resolve(TranslationMap.this.session, TranslationMap.this.plannerContext.getMetadata()).setName(QualifiedName.of((String)"$internal$try")).addArgument(new FunctionType((List<Type>)ImmutableList.of(), type), (Expression)new LambdaExpression((List)ImmutableList.of(), expression2)).build();
                return this.coerceIfNecessary((Expression)node, (Expression)call);
            }

            public Expression rewriteLikePredicate(LikePredicate node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
                Optional<SymbolReference> mapped = TranslationMap.this.tryGetMapping((Expression)node);
                if (mapped.isPresent()) {
                    return this.coerceIfNecessary((Expression)node, (Expression)mapped.get());
                }
                Expression value = treeRewriter.rewrite(node.getValue(), (Object)context);
                Expression pattern = treeRewriter.rewrite(node.getPattern(), (Object)context);
                Optional<Expression> escape = node.getEscape().map(e -> treeRewriter.rewrite(e, (Object)context));
                FunctionCall patternCall = escape.isPresent() ? FunctionCallBuilder.resolve(TranslationMap.this.session, TranslationMap.this.plannerContext.getMetadata()).setName(QualifiedName.of((String)"$like_pattern")).addArgument(TranslationMap.this.analysis.getType(node.getPattern()), pattern).addArgument(TranslationMap.this.analysis.getType((Expression)node.getEscape().get()), escape.get()).build() : FunctionCallBuilder.resolve(TranslationMap.this.session, TranslationMap.this.plannerContext.getMetadata()).setName(QualifiedName.of((String)"$like_pattern")).addArgument(TranslationMap.this.analysis.getType(node.getPattern()), pattern).build();
                FunctionCall call = FunctionCallBuilder.resolve(TranslationMap.this.session, TranslationMap.this.plannerContext.getMetadata()).setName(QualifiedName.of((String)"$like")).addArgument(TranslationMap.this.analysis.getType(node.getValue()), value).addArgument((Type)LikePatternType.LIKE_PATTERN, (Expression)patternCall).build();
                return this.coerceIfNecessary((Expression)node, (Expression)call);
            }

            public Expression rewriteTrim(Trim node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
                Optional<SymbolReference> mapped = TranslationMap.this.tryGetMapping((Expression)node);
                if (mapped.isPresent()) {
                    return this.coerceIfNecessary((Expression)node, (Expression)mapped.get());
                }
                ResolvedFunction resolvedFunction = TranslationMap.this.analysis.getResolvedFunction((Expression)node);
                Preconditions.checkArgument((resolvedFunction != null ? 1 : 0) != 0, (String)"Function has not been analyzed: %s", (Object)node);
                Trim rewritten = (Trim)treeRewriter.defaultRewrite((Expression)node, (Object)context);
                ImmutableList.Builder arguments = ImmutableList.builder();
                arguments.add((Object)rewritten.getTrimSource());
                rewritten.getTrimCharacter().ifPresent(arg_0 -> ((ImmutableList.Builder)arguments).add(arg_0));
                FunctionCall functionCall = new FunctionCall(resolvedFunction.toQualifiedName(), (List)arguments.build());
                return this.coerceIfNecessary((Expression)node, (Expression)functionCall);
            }

            public Expression rewriteSubscriptExpression(SubscriptExpression node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
                Optional<SymbolReference> mapped = TranslationMap.this.tryGetMapping((Expression)node);
                if (mapped.isPresent()) {
                    return this.coerceIfNecessary((Expression)node, (Expression)mapped.get());
                }
                Type baseType = TranslationMap.this.analysis.getType(node.getBase());
                if (baseType instanceof RowType) {
                    Expression rewrittenBase = treeRewriter.rewrite(node.getBase(), (Object)context);
                    return this.coerceIfNecessary((Expression)node, (Expression)new SubscriptExpression(rewrittenBase, node.getIndex()));
                }
                Expression rewritten = treeRewriter.defaultRewrite((Expression)node, (Object)context);
                return this.coerceIfNecessary((Expression)node, rewritten);
            }

            public Expression rewriteLambdaExpression(LambdaExpression node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
                Preconditions.checkState((TranslationMap.this.analysis.getCoercion((Expression)node) == null ? 1 : 0) != 0, (Object)"cannot coerce a lambda expression");
                ImmutableList.Builder newArguments = ImmutableList.builder();
                for (LambdaArgumentDeclaration argument : node.getArguments()) {
                    Symbol symbol = TranslationMap.this.lambdaArguments.get(NodeRef.of((Node)argument));
                    newArguments.add((Object)new LambdaArgumentDeclaration(new Identifier(symbol.getName())));
                }
                Expression rewrittenBody = treeRewriter.rewrite(node.getBody(), null);
                return new LambdaExpression((List)newArguments.build(), rewrittenBody);
            }

            public Expression rewriteParameter(Parameter node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
                Optional<SymbolReference> mapped = TranslationMap.this.tryGetMapping((Expression)node);
                if (mapped.isPresent()) {
                    return this.coerceIfNecessary((Expression)node, (Expression)mapped.get());
                }
                Preconditions.checkState((TranslationMap.this.analysis.getParameters().size() > node.getId() ? 1 : 0) != 0, (Object)"Too few parameter values");
                return this.coerceIfNecessary((Expression)node, treeRewriter.rewrite(TranslationMap.this.analysis.getParameters().get(NodeRef.of((Node)node)), null));
            }

            public Expression rewriteGenericDataType(GenericDataType node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
                return node;
            }

            public Expression rewriteRowDataType(RowDataType node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
                return node;
            }

            public Expression rewriteJsonExists(JsonExists node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
                Optional<SymbolReference> mapped = TranslationMap.this.tryGetMapping((Expression)node);
                if (mapped.isPresent()) {
                    return this.coerceIfNecessary((Expression)node, (Expression)mapped.get());
                }
                ResolvedFunction resolvedFunction = TranslationMap.this.analysis.getResolvedFunction((Expression)node);
                Preconditions.checkArgument((resolvedFunction != null ? 1 : 0) != 0, (String)"Function has not been analyzed: %s", (Object)node);
                JsonExists rewritten = (JsonExists)treeRewriter.defaultRewrite((Expression)node, (Object)context);
                BooleanLiteral failOnError = new BooleanLiteral(node.getErrorBehavior() == JsonExists.ErrorBehavior.ERROR ? "true" : "false");
                ResolvedFunction inputToJson = TranslationMap.this.analysis.getJsonInputFunction(node.getJsonPathInvocation().getInputExpression());
                FunctionCall input = new FunctionCall(inputToJson.toQualifiedName(), (List)ImmutableList.of((Object)rewritten.getJsonPathInvocation().getInputExpression(), (Object)failOnError));
                ParametersRow orderedParameters = this.getParametersRow(node.getJsonPathInvocation().getPathParameters(), rewritten.getJsonPathInvocation().getPathParameters(), resolvedFunction.getSignature().getArgumentType(2), failOnError);
                IrJsonPath path = new JsonPathTranslator(TranslationMap.this.session, TranslationMap.this.plannerContext).rewriteToIr(TranslationMap.this.analysis.getJsonPathAnalysis((Expression)node), orderedParameters.getParametersOrder());
                Expression pathExpression = new LiteralEncoder(TranslationMap.this.plannerContext).toExpression(TranslationMap.this.session, path, TranslationMap.this.plannerContext.getTypeManager().getType(TypeId.of((String)"JsonPath2016")));
                ImmutableList.Builder arguments = ImmutableList.builder().add((Object)input).add((Object)pathExpression).add((Object)orderedParameters.getParametersRow()).add((Object)new GenericLiteral("tinyint", String.valueOf(rewritten.getErrorBehavior().ordinal())));
                FunctionCall result = new FunctionCall(resolvedFunction.toQualifiedName(), (List)arguments.build());
                return this.coerceIfNecessary((Expression)node, (Expression)result);
            }

            public Expression rewriteJsonValue(JsonValue node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
                Optional<SymbolReference> mapped = TranslationMap.this.tryGetMapping((Expression)node);
                if (mapped.isPresent()) {
                    return this.coerceIfNecessary((Expression)node, (Expression)mapped.get());
                }
                ResolvedFunction resolvedFunction = TranslationMap.this.analysis.getResolvedFunction((Expression)node);
                Preconditions.checkArgument((resolvedFunction != null ? 1 : 0) != 0, (String)"Function has not been analyzed: %s", (Object)node);
                JsonValue rewritten = (JsonValue)treeRewriter.defaultRewrite((Expression)node, (Object)context);
                BooleanLiteral failOnError = new BooleanLiteral(node.getErrorBehavior() == JsonValue.EmptyOrErrorBehavior.ERROR ? "true" : "false");
                ResolvedFunction inputToJson = TranslationMap.this.analysis.getJsonInputFunction(node.getJsonPathInvocation().getInputExpression());
                FunctionCall input = new FunctionCall(inputToJson.toQualifiedName(), (List)ImmutableList.of((Object)rewritten.getJsonPathInvocation().getInputExpression(), (Object)failOnError));
                ParametersRow orderedParameters = this.getParametersRow(node.getJsonPathInvocation().getPathParameters(), rewritten.getJsonPathInvocation().getPathParameters(), resolvedFunction.getSignature().getArgumentType(2), failOnError);
                IrJsonPath path = new JsonPathTranslator(TranslationMap.this.session, TranslationMap.this.plannerContext).rewriteToIr(TranslationMap.this.analysis.getJsonPathAnalysis((Expression)node), orderedParameters.getParametersOrder());
                Expression pathExpression = new LiteralEncoder(TranslationMap.this.plannerContext).toExpression(TranslationMap.this.session, path, TranslationMap.this.plannerContext.getTypeManager().getType(TypeId.of((String)"JsonPath2016")));
                ImmutableList.Builder arguments = ImmutableList.builder().add((Object)input).add((Object)pathExpression).add((Object)orderedParameters.getParametersRow()).add((Object)new GenericLiteral("tinyint", String.valueOf(rewritten.getEmptyBehavior().ordinal()))).add((Object)rewritten.getEmptyDefault().orElseGet(() -> new Cast((Expression)new NullLiteral(), TypeSignatureTranslator.toSqlType(resolvedFunction.getSignature().getReturnType())))).add((Object)new GenericLiteral("tinyint", String.valueOf(rewritten.getErrorBehavior().ordinal()))).add((Object)rewritten.getErrorDefault().orElseGet(() -> new Cast((Expression)new NullLiteral(), TypeSignatureTranslator.toSqlType(resolvedFunction.getSignature().getReturnType()))));
                FunctionCall result = new FunctionCall(resolvedFunction.toQualifiedName(), (List)arguments.build());
                return this.coerceIfNecessary((Expression)node, (Expression)result);
            }

            public Expression rewriteJsonQuery(JsonQuery node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
                Optional<SymbolReference> mapped = TranslationMap.this.tryGetMapping((Expression)node);
                if (mapped.isPresent()) {
                    return this.coerceIfNecessary((Expression)node, (Expression)mapped.get());
                }
                ResolvedFunction resolvedFunction = TranslationMap.this.analysis.getResolvedFunction((Expression)node);
                Preconditions.checkArgument((resolvedFunction != null ? 1 : 0) != 0, (String)"Function has not been analyzed: %s", (Object)node);
                JsonQuery rewritten = (JsonQuery)treeRewriter.defaultRewrite((Expression)node, (Object)context);
                BooleanLiteral failOnError = new BooleanLiteral(node.getErrorBehavior() == JsonQuery.EmptyOrErrorBehavior.ERROR ? "true" : "false");
                ResolvedFunction inputToJson = TranslationMap.this.analysis.getJsonInputFunction(node.getJsonPathInvocation().getInputExpression());
                FunctionCall input = new FunctionCall(inputToJson.toQualifiedName(), (List)ImmutableList.of((Object)rewritten.getJsonPathInvocation().getInputExpression(), (Object)failOnError));
                ParametersRow orderedParameters = this.getParametersRow(node.getJsonPathInvocation().getPathParameters(), rewritten.getJsonPathInvocation().getPathParameters(), resolvedFunction.getSignature().getArgumentType(2), failOnError);
                IrJsonPath path = new JsonPathTranslator(TranslationMap.this.session, TranslationMap.this.plannerContext).rewriteToIr(TranslationMap.this.analysis.getJsonPathAnalysis((Expression)node), orderedParameters.getParametersOrder());
                Expression pathExpression = new LiteralEncoder(TranslationMap.this.plannerContext).toExpression(TranslationMap.this.session, path, TranslationMap.this.plannerContext.getTypeManager().getType(TypeId.of((String)"JsonPath2016")));
                ImmutableList.Builder arguments = ImmutableList.builder().add((Object)input).add((Object)pathExpression).add((Object)orderedParameters.getParametersRow()).add((Object)new GenericLiteral("tinyint", String.valueOf(rewritten.getWrapperBehavior().ordinal()))).add((Object)new GenericLiteral("tinyint", String.valueOf(rewritten.getEmptyBehavior().ordinal()))).add((Object)new GenericLiteral("tinyint", String.valueOf(rewritten.getErrorBehavior().ordinal())));
                FunctionCall function = new FunctionCall(resolvedFunction.toQualifiedName(), (List)arguments.build());
                GenericLiteral errorBehavior = new GenericLiteral("tinyint", String.valueOf(rewritten.getErrorBehavior().ordinal()));
                BooleanLiteral omitQuotes = new BooleanLiteral(node.getQuotesBehavior().orElse(JsonQuery.QuotesBehavior.KEEP) == JsonQuery.QuotesBehavior.OMIT ? "true" : "false");
                ResolvedFunction outputFunction = TranslationMap.this.analysis.getJsonOutputFunction((Expression)node);
                FunctionCall result = new FunctionCall(outputFunction.toQualifiedName(), (List)ImmutableList.of((Object)function, (Object)errorBehavior, (Object)omitQuotes));
                Type returnedType = node.getReturnedType().map(TypeSignatureTranslator::toTypeSignature).map(arg_0 -> ((TypeManager)TranslationMap.this.plannerContext.getTypeManager()).getType(arg_0)).orElse((Type)VarcharType.VARCHAR);
                Type resultType = outputFunction.getSignature().getReturnType();
                if (!resultType.equals(returnedType)) {
                    result = new Cast((Expression)result, TypeSignatureTranslator.toSqlType(returnedType));
                }
                return this.coerceIfNecessary((Expression)node, (Expression)result);
            }

            private ParametersRow getParametersRow(List<JsonPathParameter> pathParameters, List<JsonPathParameter> rewrittenPathParameters, Type parameterRowType, BooleanLiteral failOnError) {
                Object parametersOrder;
                Cast parametersRow;
                if (!pathParameters.isEmpty()) {
                    ImmutableList.Builder parameters = ImmutableList.builder();
                    for (int i = 0; i < pathParameters.size(); ++i) {
                        ResolvedFunction parameterToJson = TranslationMap.this.analysis.getJsonInputFunction(pathParameters.get(i).getParameter());
                        Expression rewrittenParameter = rewrittenPathParameters.get(i).getParameter();
                        if (parameterToJson != null) {
                            parameters.add((Object)new FunctionCall(parameterToJson.toQualifiedName(), (List)ImmutableList.of((Object)rewrittenParameter, (Object)failOnError)));
                            continue;
                        }
                        parameters.add((Object)rewrittenParameter);
                    }
                    parametersRow = new Cast((Expression)new Row((List)parameters.build()), TypeSignatureTranslator.toSqlType(parameterRowType));
                    parametersOrder = (List)pathParameters.stream().map(parameter -> parameter.getName().getCanonicalValue()).collect(ImmutableList.toImmutableList());
                } else {
                    Preconditions.checkState((boolean)ExpressionAnalyzer.JSON_NO_PARAMETERS_ROW_TYPE.equals((Object)parameterRowType), (Object)"invalid type of parameters row when no parameters are passed");
                    parametersRow = new Cast((Expression)new NullLiteral(), TypeSignatureTranslator.toSqlType((Type)ExpressionAnalyzer.JSON_NO_PARAMETERS_ROW_TYPE));
                    parametersOrder = ImmutableList.of();
                }
                return new ParametersRow((Expression)parametersRow, (List<String>)parametersOrder);
            }

            public Expression rewriteJsonObject(JsonObject node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
                Row valuesRow;
                Row keysRow;
                Optional<SymbolReference> mapped = TranslationMap.this.tryGetMapping((Expression)node);
                if (mapped.isPresent()) {
                    return this.coerceIfNecessary((Expression)node, (Expression)mapped.get());
                }
                ResolvedFunction resolvedFunction = TranslationMap.this.analysis.getResolvedFunction((Expression)node);
                Preconditions.checkArgument((resolvedFunction != null ? 1 : 0) != 0, (String)"Function has not been analyzed: %s", (Object)node);
                if (node.getMembers().isEmpty()) {
                    Preconditions.checkState((boolean)ExpressionAnalyzer.JSON_NO_PARAMETERS_ROW_TYPE.equals((Object)resolvedFunction.getSignature().getArgumentType(0)));
                    Preconditions.checkState((boolean)ExpressionAnalyzer.JSON_NO_PARAMETERS_ROW_TYPE.equals((Object)resolvedFunction.getSignature().getArgumentType(1)));
                    keysRow = new Cast((Expression)new NullLiteral(), TypeSignatureTranslator.toSqlType((Type)ExpressionAnalyzer.JSON_NO_PARAMETERS_ROW_TYPE));
                    valuesRow = new Cast((Expression)new NullLiteral(), TypeSignatureTranslator.toSqlType((Type)ExpressionAnalyzer.JSON_NO_PARAMETERS_ROW_TYPE));
                } else {
                    ImmutableList.Builder keys = ImmutableList.builder();
                    ImmutableList.Builder values = ImmutableList.builder();
                    for (JsonObjectMember member : node.getMembers()) {
                        Expression key = member.getKey();
                        Expression value = member.getValue();
                        Expression rewrittenKey = treeRewriter.rewrite(key, (Object)context);
                        keys.add((Object)rewrittenKey);
                        Expression rewrittenValue = treeRewriter.rewrite(value, (Object)context);
                        ResolvedFunction valueToJson = TranslationMap.this.analysis.getJsonInputFunction(value);
                        if (valueToJson != null) {
                            values.add((Object)new FunctionCall(valueToJson.toQualifiedName(), (List)ImmutableList.of((Object)rewrittenValue, (Object)BooleanLiteral.TRUE_LITERAL)));
                            continue;
                        }
                        values.add((Object)rewrittenValue);
                    }
                    keysRow = new Row((List)keys.build());
                    valuesRow = new Row((List)values.build());
                }
                ImmutableList arguments = ImmutableList.builder().add((Object)keysRow).add((Object)valuesRow).add((Object)(node.isNullOnNull() ? BooleanLiteral.TRUE_LITERAL : BooleanLiteral.FALSE_LITERAL)).add((Object)(node.isUniqueKeys() ? BooleanLiteral.TRUE_LITERAL : BooleanLiteral.FALSE_LITERAL)).build();
                FunctionCall function = new FunctionCall(resolvedFunction.toQualifiedName(), (List)arguments);
                ResolvedFunction outputFunction = TranslationMap.this.analysis.getJsonOutputFunction((Expression)node);
                FunctionCall result = new FunctionCall(outputFunction.toQualifiedName(), (List)ImmutableList.of((Object)function, (Object)new GenericLiteral("tinyint", String.valueOf(JsonQuery.EmptyOrErrorBehavior.ERROR.ordinal())), (Object)BooleanLiteral.FALSE_LITERAL));
                Type returnedType = node.getReturnedType().map(TypeSignatureTranslator::toTypeSignature).map(arg_0 -> ((TypeManager)TranslationMap.this.plannerContext.getTypeManager()).getType(arg_0)).orElse((Type)VarcharType.VARCHAR);
                Type resultType = outputFunction.getSignature().getReturnType();
                if (!resultType.equals(returnedType)) {
                    result = new Cast((Expression)result, TypeSignatureTranslator.toSqlType(returnedType));
                }
                return this.coerceIfNecessary((Expression)node, (Expression)result);
            }

            public Expression rewriteJsonArray(JsonArray node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
                Row elementsRow;
                Optional<SymbolReference> mapped = TranslationMap.this.tryGetMapping((Expression)node);
                if (mapped.isPresent()) {
                    return this.coerceIfNecessary((Expression)node, (Expression)mapped.get());
                }
                ResolvedFunction resolvedFunction = TranslationMap.this.analysis.getResolvedFunction((Expression)node);
                Preconditions.checkArgument((resolvedFunction != null ? 1 : 0) != 0, (String)"Function has not been analyzed: %s", (Object)node);
                if (node.getElements().isEmpty()) {
                    Preconditions.checkState((boolean)ExpressionAnalyzer.JSON_NO_PARAMETERS_ROW_TYPE.equals((Object)resolvedFunction.getSignature().getArgumentType(0)));
                    elementsRow = new Cast((Expression)new NullLiteral(), TypeSignatureTranslator.toSqlType((Type)ExpressionAnalyzer.JSON_NO_PARAMETERS_ROW_TYPE));
                } else {
                    ImmutableList.Builder elements = ImmutableList.builder();
                    for (JsonArrayElement arrayElement : node.getElements()) {
                        Expression element = arrayElement.getValue();
                        Expression rewrittenElement = treeRewriter.rewrite(element, (Object)context);
                        ResolvedFunction elementToJson = TranslationMap.this.analysis.getJsonInputFunction(element);
                        if (elementToJson != null) {
                            elements.add((Object)new FunctionCall(elementToJson.toQualifiedName(), (List)ImmutableList.of((Object)rewrittenElement, (Object)BooleanLiteral.TRUE_LITERAL)));
                            continue;
                        }
                        elements.add((Object)rewrittenElement);
                    }
                    elementsRow = new Row((List)elements.build());
                }
                ImmutableList arguments = ImmutableList.builder().add((Object)elementsRow).add((Object)(node.isNullOnNull() ? BooleanLiteral.TRUE_LITERAL : BooleanLiteral.FALSE_LITERAL)).build();
                FunctionCall function = new FunctionCall(resolvedFunction.toQualifiedName(), (List)arguments);
                ResolvedFunction outputFunction = TranslationMap.this.analysis.getJsonOutputFunction((Expression)node);
                FunctionCall result = new FunctionCall(outputFunction.toQualifiedName(), (List)ImmutableList.of((Object)function, (Object)new GenericLiteral("tinyint", String.valueOf(JsonQuery.EmptyOrErrorBehavior.ERROR.ordinal())), (Object)BooleanLiteral.FALSE_LITERAL));
                Type returnedType = node.getReturnedType().map(TypeSignatureTranslator::toTypeSignature).map(arg_0 -> ((TypeManager)TranslationMap.this.plannerContext.getTypeManager()).getType(arg_0)).orElse((Type)VarcharType.VARCHAR);
                Type resultType = outputFunction.getSignature().getReturnType();
                if (!resultType.equals(returnedType)) {
                    result = new Cast((Expression)result, TypeSignatureTranslator.toSqlType(returnedType));
                }
                return this.coerceIfNecessary((Expression)node, (Expression)result);
            }

            private Expression coerceIfNecessary(Expression original, Expression rewritten) {
                if (original == expression) {
                    return rewritten;
                }
                return QueryPlanner.coerceIfNecessary(TranslationMap.this.analysis, original, rewritten);
            }
        }, (Expression)expression, null);
    }

    private Optional<SymbolReference> tryGetMapping(Expression expression) {
        return Optional.ofNullable(this.astToSymbols.get(ScopeAware.scopeAwareKey(expression, this.analysis, this.scope))).map(Symbol::toSymbolReference);
    }

    private Optional<Symbol> getSymbolForColumn(Expression expression) {
        if (!this.analysis.isColumnReference(expression)) {
            return Optional.empty();
        }
        ResolvedField field = this.analysis.getColumnReferenceFields().get(NodeRef.of((Node)expression));
        if (this.scope.isLocalScope(field.getScope())) {
            return Optional.of(this.fieldSymbols[field.getHierarchyFieldIndex()]);
        }
        if (this.outerContext.isPresent()) {
            return Optional.of(Symbol.from(this.outerContext.get().rewrite(expression)));
        }
        return Optional.empty();
    }

    private static void verifyAstExpression(Expression astExpression) {
        Verify.verify((boolean)AstUtils.preOrder((Node)astExpression).noneMatch(expression -> expression instanceof SymbolReference || expression instanceof FunctionCall && ResolvedFunction.isResolved(((FunctionCall)expression).getName())));
    }

    public Scope getScope() {
        return this.scope;
    }

    private static class ParametersRow {
        private final Expression parametersRow;
        private final List<String> parametersOrder;

        public ParametersRow(Expression parametersRow, List<String> parametersOrder) {
            this.parametersRow = Objects.requireNonNull(parametersRow, "parametersRow is null");
            this.parametersOrder = Objects.requireNonNull(parametersOrder, "parametersOrder is null");
        }

        public Expression getParametersRow() {
            return this.parametersRow;
        }

        public List<String> getParametersOrder() {
            return this.parametersOrder;
        }
    }
}

