/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableSet;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.Util;
import io.trino.sql.planner.plan.ExchangeNode;
import io.trino.sql.planner.plan.Patterns;
import java.util.Collection;
import java.util.Set;

public class PruneExchangeSourceColumns
implements Rule<ExchangeNode> {
    @Override
    public Pattern<ExchangeNode> getPattern() {
        return Patterns.exchange();
    }

    @Override
    public Rule.Result apply(ExchangeNode node, Captures captures, Rule.Context context) {
        Set[] referencedInputs = new Set[node.getSources().size()];
        for (int i = 0; i < node.getSources().size(); ++i) {
            referencedInputs[i] = ImmutableSet.copyOf((Collection)node.getInputs().get(i));
        }
        return Util.restrictChildOutputs(context.getIdAllocator(), node, referencedInputs).map(Rule.Result::ofPlanNode).orElse(Rule.Result.empty());
    }
}

