/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ListMultimap;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.optimizations.QueryCardinalityUtil;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.ExceptNode;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.ProjectNode;
import io.trino.sql.planner.plan.ValuesNode;
import io.trino.sql.tree.Expression;
import java.util.List;
import java.util.Map;

public class RemoveEmptyExceptBranches
implements Rule<ExceptNode> {
    private static final Pattern<ExceptNode> PATTERN = Patterns.except();

    @Override
    public Pattern<ExceptNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(ExceptNode node, Captures captures, Rule.Context context) {
        if (QueryCardinalityUtil.isEmpty(node.getSources().get(0), context.getLookup())) {
            return Rule.Result.ofPlanNode(new ValuesNode(node.getId(), node.getOutputSymbols(), (List<Expression>)ImmutableList.of()));
        }
        boolean hasEmptyBranches = false;
        ImmutableList.Builder newSourcesBuilder = ImmutableList.builder();
        ImmutableListMultimap.Builder outputsToInputsBuilder = ImmutableListMultimap.builder();
        for (int i = 0; i < node.getSources().size(); ++i) {
            PlanNode source = node.getSources().get(i);
            if (i == 0 || !QueryCardinalityUtil.isEmpty(source, context.getLookup())) {
                newSourcesBuilder.add((Object)source);
                for (Symbol column : node.getOutputSymbols()) {
                    outputsToInputsBuilder.put((Object)column, (Object)((Symbol)node.getSymbolMapping().get((Object)column).get(i)));
                }
                continue;
            }
            hasEmptyBranches = true;
        }
        if (!hasEmptyBranches) {
            return Rule.Result.empty();
        }
        ImmutableList newSources = newSourcesBuilder.build();
        ImmutableListMultimap outputsToInputs = outputsToInputsBuilder.build();
        if (newSources.size() == 1) {
            Assignments.Builder assignments = Assignments.builder();
            outputsToInputs.entries().forEach(entry -> assignments.put((Symbol)entry.getKey(), (Expression)((Symbol)entry.getValue()).toSymbolReference()));
            if (node.isDistinct()) {
                return Rule.Result.ofPlanNode(AggregationNode.singleAggregation(node.getId(), new ProjectNode(context.getIdAllocator().getNextId(), (PlanNode)newSources.get(0), assignments.build()), (Map<Symbol, AggregationNode.Aggregation>)ImmutableMap.of(), AggregationNode.singleGroupingSet(node.getOutputSymbols())));
            }
            return Rule.Result.ofPlanNode(new ProjectNode(node.getId(), (PlanNode)newSources.get(0), assignments.build()));
        }
        return Rule.Result.ofPlanNode(new ExceptNode(node.getId(), (List<PlanNode>)newSources, (ListMultimap<Symbol, Symbol>)outputsToInputs, node.getOutputSymbols(), node.isDistinct()));
    }
}

