/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.base.Preconditions;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.ValuesNode;

public class RemoveEmptyGlobalAggregation
implements Rule<AggregationNode> {
    private static final Pattern<AggregationNode> PATTERN = Patterns.aggregation().with(Patterns.Aggregation.step().equalTo((Object)AggregationNode.Step.SINGLE)).matching(node -> node.getAggregations().isEmpty() && node.hasSingleGlobalAggregation());

    @Override
    public Pattern<AggregationNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(AggregationNode node, Captures captures, Rule.Context context) {
        Preconditions.checkArgument((boolean)node.getHashSymbol().isEmpty(), (String)"Unexpected hash symbol: %s", node.getHashSymbol());
        Preconditions.checkArgument((boolean)node.getOutputSymbols().isEmpty(), (String)"Unexpected output symbols: %s", node.getOutputSymbols());
        return Rule.Result.ofPlanNode(new ValuesNode(node.getId(), 1));
    }
}

