/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.optimizations.Cardinality;
import io.trino.sql.planner.optimizations.QueryCardinalityUtil;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.sql.planner.plan.DistinctLimitNode;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.ValuesNode;
import io.trino.sql.tree.Expression;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class RemoveRedundantDistinctLimit
implements Rule<DistinctLimitNode> {
    private static final Pattern<DistinctLimitNode> PATTERN = Patterns.distinctLimit();

    @Override
    public Pattern<DistinctLimitNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(DistinctLimitNode node, Captures captures, Rule.Context context) {
        Preconditions.checkArgument((boolean)node.getHashSymbol().isEmpty(), (Object)"HashSymbol should be empty");
        if (node.getLimit() == 0L) {
            return Rule.Result.ofPlanNode(new ValuesNode(node.getId(), node.getOutputSymbols(), (List<Expression>)ImmutableList.of()));
        }
        Cardinality sourceCardinality = QueryCardinalityUtil.extractCardinality(node.getSource(), context.getLookup());
        if (sourceCardinality.isScalar()) {
            return Rule.Result.ofPlanNode(node.getSource());
        }
        if (sourceCardinality.isAtMost(node.getLimit())) {
            return Rule.Result.ofPlanNode(new AggregationNode(node.getId(), node.getSource(), (Map<Symbol, AggregationNode.Aggregation>)ImmutableMap.of(), AggregationNode.singleGroupingSet(node.getDistinctSymbols()), (List<Symbol>)ImmutableList.of(), AggregationNode.Step.SINGLE, node.getHashSymbol(), Optional.empty()));
        }
        return Rule.Result.empty();
    }
}

