/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.metadata.TableHandle;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.TableFunctionApplicationResult;
import io.trino.spi.predicate.TupleDomain;
import io.trino.sql.PlannerContext;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.TableFunctionProcessorNode;
import io.trino.sql.planner.plan.TableScanNode;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class RewriteTableFunctionToTableScan
implements Rule<TableFunctionProcessorNode> {
    private static final Pattern<TableFunctionProcessorNode> PATTERN = Patterns.tableFunctionProcessor().with(Pattern.empty(Patterns.sources()));
    private final PlannerContext plannerContext;

    public RewriteTableFunctionToTableScan(PlannerContext plannerContext) {
        this.plannerContext = Objects.requireNonNull(plannerContext, "plannerContext is null");
    }

    @Override
    public Pattern<TableFunctionProcessorNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(TableFunctionProcessorNode node, Captures captures, Rule.Context context) {
        Optional<TableFunctionApplicationResult<TableHandle>> result = this.plannerContext.getMetadata().applyTableFunction(context.getSession(), node.getHandle());
        if (result.isEmpty()) {
            return Rule.Result.empty();
        }
        List columnHandles = result.get().getColumnHandles();
        Preconditions.checkState((node.getOutputSymbols().size() == columnHandles.size() ? 1 : 0) != 0, (Object)"returned table does not match the node's output");
        ImmutableMap.Builder assignments = ImmutableMap.builder();
        for (int i = 0; i < columnHandles.size(); ++i) {
            assignments.put((Object)node.getOutputSymbols().get(i), (Object)((ColumnHandle)columnHandles.get(i)));
        }
        return Rule.Result.ofPlanNode(new TableScanNode(node.getId(), (TableHandle)result.get().getTableHandle(), node.getOutputSymbols(), (Map<Symbol, ColumnHandle>)assignments.buildOrThrow(), (TupleDomain<ColumnHandle>)TupleDomain.all(), Optional.empty(), false, Optional.empty()));
    }
}

