/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.plan;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import io.trino.spi.type.Type;
import io.trino.sql.planner.OrderingScheme;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.plan.DataOrganizationSpecification;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.sql.planner.plan.PlanVisitor;
import io.trino.sql.planner.plan.WindowNode;
import io.trino.sql.planner.rowpattern.LogicalIndexExtractor;
import io.trino.sql.planner.rowpattern.ir.IrLabel;
import io.trino.sql.planner.rowpattern.ir.IrRowPattern;
import io.trino.sql.tree.FrameBound;
import io.trino.sql.tree.PatternRecognitionRelation;
import io.trino.sql.tree.SkipTo;
import io.trino.sql.tree.WindowFrame;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.concurrent.Immutable;

@Immutable
public class PatternRecognitionNode
extends PlanNode {
    private final PlanNode source;
    private final DataOrganizationSpecification specification;
    private final Optional<Symbol> hashSymbol;
    private final Set<Symbol> prePartitionedInputs;
    private final int preSortedOrderPrefix;
    private final Map<Symbol, WindowNode.Function> windowFunctions;
    private final Map<Symbol, Measure> measures;
    private final Optional<WindowNode.Frame> commonBaseFrame;
    private final PatternRecognitionRelation.RowsPerMatch rowsPerMatch;
    private final Optional<IrLabel> skipToLabel;
    private final SkipTo.Position skipToPosition;
    private final boolean initial;
    private final IrRowPattern pattern;
    private final Map<IrLabel, Set<IrLabel>> subsets;
    private final Map<IrLabel, LogicalIndexExtractor.ExpressionAndValuePointers> variableDefinitions;

    @JsonCreator
    public PatternRecognitionNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="source") PlanNode source, @JsonProperty(value="specification") DataOrganizationSpecification specification, @JsonProperty(value="hashSymbol") Optional<Symbol> hashSymbol, @JsonProperty(value="prePartitionedInputs") Set<Symbol> prePartitionedInputs, @JsonProperty(value="preSortedOrderPrefix") int preSortedOrderPrefix, @JsonProperty(value="windowFunctions") Map<Symbol, WindowNode.Function> windowFunctions, @JsonProperty(value="measures") Map<Symbol, Measure> measures, @JsonProperty(value="commonBaseFrame") Optional<WindowNode.Frame> commonBaseFrame, @JsonProperty(value="rowsPerMatch") PatternRecognitionRelation.RowsPerMatch rowsPerMatch, @JsonProperty(value="skipToLabel") Optional<IrLabel> skipToLabel, @JsonProperty(value="skipToPosition") SkipTo.Position skipToPosition, @JsonProperty(value="initial") boolean initial, @JsonProperty(value="pattern") IrRowPattern pattern, @JsonProperty(value="subsets") Map<IrLabel, Set<IrLabel>> subsets, @JsonProperty(value="variableDefinitions") Map<IrLabel, LogicalIndexExtractor.ExpressionAndValuePointers> variableDefinitions) {
        super(id);
        Objects.requireNonNull(source, "source is null");
        Objects.requireNonNull(specification, "specification is null");
        Objects.requireNonNull(hashSymbol, "hashSymbol is null");
        Preconditions.checkArgument((boolean)specification.getPartitionBy().containsAll(prePartitionedInputs), (Object)"prePartitionedInputs must be contained in partitionBy");
        Optional<OrderingScheme> orderingScheme = specification.getOrderingScheme();
        Preconditions.checkArgument((preSortedOrderPrefix == 0 || orderingScheme.isPresent() && preSortedOrderPrefix <= orderingScheme.get().getOrderBy().size() ? 1 : 0) != 0, (Object)"Cannot have sorted more symbols than those requested");
        Preconditions.checkArgument((preSortedOrderPrefix == 0 || ImmutableSet.copyOf(prePartitionedInputs).equals((Object)ImmutableSet.copyOf(specification.getPartitionBy())) ? 1 : 0) != 0, (Object)"preSortedOrderPrefix can only be greater than zero if all partition symbols are pre-partitioned");
        Objects.requireNonNull(windowFunctions, "windowFunctions is null");
        Objects.requireNonNull(measures, "measures is null");
        Objects.requireNonNull(commonBaseFrame, "commonBaseFrame is null");
        Objects.requireNonNull(rowsPerMatch, "rowsPerMatch is null");
        Preconditions.checkArgument((windowFunctions.isEmpty() || commonBaseFrame.isPresent() ? 1 : 0) != 0, (Object)"Common base frame is required for pattern recognition with window functions");
        Preconditions.checkArgument((commonBaseFrame.isEmpty() || rowsPerMatch == PatternRecognitionRelation.RowsPerMatch.WINDOW ? 1 : 0) != 0, (String)"Invalid ROWS PER MATCH option for pattern recognition in window: %s", (Object)rowsPerMatch.name());
        Preconditions.checkArgument((rowsPerMatch != PatternRecognitionRelation.RowsPerMatch.WINDOW || commonBaseFrame.isPresent() ? 1 : 0) != 0, (Object)"Common base frame is required for pattern recognition in window");
        Preconditions.checkArgument((initial || rowsPerMatch == PatternRecognitionRelation.RowsPerMatch.WINDOW ? 1 : 0) != 0, (Object)"Pattern search mode SEEK is only supported in window");
        commonBaseFrame.ifPresent(frame -> Preconditions.checkArgument((frame.getType() == WindowFrame.Type.ROWS && frame.getStartType() == FrameBound.Type.CURRENT_ROW ? 1 : 0) != 0, (Object)"Invalid common base frame for pattern recognition in window"));
        Objects.requireNonNull(skipToLabel, "skipToLabel is null");
        Objects.requireNonNull(skipToPosition, "skipToPosition is null");
        Objects.requireNonNull(pattern, "pattern is null");
        Objects.requireNonNull(subsets, "subsets is null");
        Objects.requireNonNull(variableDefinitions, "variableDefinitions is null");
        this.source = source;
        this.specification = specification;
        this.hashSymbol = hashSymbol;
        this.prePartitionedInputs = ImmutableSet.copyOf(prePartitionedInputs);
        this.preSortedOrderPrefix = preSortedOrderPrefix;
        this.windowFunctions = ImmutableMap.copyOf(windowFunctions);
        this.measures = ImmutableMap.copyOf(measures);
        this.commonBaseFrame = commonBaseFrame;
        this.rowsPerMatch = rowsPerMatch;
        this.skipToLabel = skipToLabel;
        this.skipToPosition = skipToPosition;
        this.initial = initial;
        this.pattern = pattern;
        this.subsets = subsets;
        this.variableDefinitions = ImmutableMap.copyOf(variableDefinitions);
    }

    @Override
    public List<PlanNode> getSources() {
        return ImmutableList.of((Object)this.source);
    }

    @Override
    public List<Symbol> getOutputSymbols() {
        ImmutableList.Builder outputSymbols = ImmutableList.builder();
        if (this.rowsPerMatch == PatternRecognitionRelation.RowsPerMatch.ONE) {
            outputSymbols.addAll(this.getPartitionBy());
        } else {
            outputSymbols.addAll(this.source.getOutputSymbols());
        }
        outputSymbols.addAll(this.measures.keySet());
        outputSymbols.addAll(this.windowFunctions.keySet());
        return outputSymbols.build();
    }

    public Set<Symbol> getCreatedSymbols() {
        return ImmutableSet.copyOf((Iterable)Iterables.concat(this.measures.keySet(), this.windowFunctions.keySet()));
    }

    @JsonProperty
    public PlanNode getSource() {
        return this.source;
    }

    @JsonProperty
    public DataOrganizationSpecification getSpecification() {
        return this.specification;
    }

    public List<Symbol> getPartitionBy() {
        return this.specification.getPartitionBy();
    }

    public Optional<OrderingScheme> getOrderingScheme() {
        return this.specification.getOrderingScheme();
    }

    @JsonProperty
    public Optional<Symbol> getHashSymbol() {
        return this.hashSymbol;
    }

    @JsonProperty
    public Set<Symbol> getPrePartitionedInputs() {
        return this.prePartitionedInputs;
    }

    @JsonProperty
    public int getPreSortedOrderPrefix() {
        return this.preSortedOrderPrefix;
    }

    @JsonProperty
    public Map<Symbol, WindowNode.Function> getWindowFunctions() {
        return this.windowFunctions;
    }

    @JsonProperty
    public Map<Symbol, Measure> getMeasures() {
        return this.measures;
    }

    @JsonProperty
    public Optional<WindowNode.Frame> getCommonBaseFrame() {
        return this.commonBaseFrame;
    }

    @JsonProperty
    public PatternRecognitionRelation.RowsPerMatch getRowsPerMatch() {
        return this.rowsPerMatch;
    }

    @JsonProperty
    public Optional<IrLabel> getSkipToLabel() {
        return this.skipToLabel;
    }

    @JsonProperty
    public SkipTo.Position getSkipToPosition() {
        return this.skipToPosition;
    }

    @JsonProperty
    public boolean isInitial() {
        return this.initial;
    }

    @JsonProperty
    public IrRowPattern getPattern() {
        return this.pattern;
    }

    @JsonProperty
    public Map<IrLabel, Set<IrLabel>> getSubsets() {
        return this.subsets;
    }

    @JsonProperty
    public Map<IrLabel, LogicalIndexExtractor.ExpressionAndValuePointers> getVariableDefinitions() {
        return this.variableDefinitions;
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitPatternRecognition(this, context);
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        return new PatternRecognitionNode(this.getId(), (PlanNode)Iterables.getOnlyElement(newChildren), this.specification, this.hashSymbol, this.prePartitionedInputs, this.preSortedOrderPrefix, this.windowFunctions, this.measures, this.commonBaseFrame, this.rowsPerMatch, this.skipToLabel, this.skipToPosition, this.initial, this.pattern, this.subsets, this.variableDefinitions);
    }

    public static class Measure {
        private final LogicalIndexExtractor.ExpressionAndValuePointers expressionAndValuePointers;
        private final Type type;

        @JsonCreator
        public Measure(LogicalIndexExtractor.ExpressionAndValuePointers expressionAndValuePointers, Type type) {
            this.expressionAndValuePointers = Objects.requireNonNull(expressionAndValuePointers, "expressionAndValuePointers is null");
            this.type = Objects.requireNonNull(type, "type is null");
        }

        @JsonProperty
        public LogicalIndexExtractor.ExpressionAndValuePointers getExpressionAndValuePointers() {
            return this.expressionAndValuePointers;
        }

        @JsonProperty
        public Type getType() {
            return this.type;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Measure that = (Measure)o;
            return Objects.equals(this.expressionAndValuePointers, that.expressionAndValuePointers) && Objects.equals(this.type, that.type);
        }

        public int hashCode() {
            return Objects.hash(this.expressionAndValuePointers, this.type);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("expressionAndValuePointers", (Object)this.expressionAndValuePointers).add("type", (Object)this.type).toString();
        }
    }
}

