/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testing;

import com.google.common.collect.ImmutableSet;
import io.trino.Session;
import io.trino.client.ClientCapabilities;
import io.trino.execution.QueryIdGenerator;
import io.trino.metadata.SessionPropertyManager;
import io.trino.spi.security.Identity;
import io.trino.spi.type.TimeZoneKey;
import java.util.Arrays;
import java.util.Locale;
import java.util.Set;

public final class TestingSession {
    private static final QueryIdGenerator queryIdGenerator = new QueryIdGenerator();
    public static final TimeZoneKey DEFAULT_TIME_ZONE_KEY = TimeZoneKey.getTimeZoneKey((String)"Pacific/Apia");

    private TestingSession() {
    }

    public static Session.SessionBuilder testSessionBuilder() {
        return TestingSession.testSessionBuilder(new SessionPropertyManager());
    }

    public static Session.SessionBuilder testSessionBuilder(SessionPropertyManager sessionPropertyManager) {
        return Session.builder(sessionPropertyManager).setQueryId(queryIdGenerator.createNextQueryId()).setIdentity(Identity.ofUser((String)"user")).setSource("test").setCatalog("catalog").setSchema("schema").setTimeZoneKey(DEFAULT_TIME_ZONE_KEY).setLocale(Locale.ENGLISH).setClientCapabilities((Set)Arrays.stream(ClientCapabilities.values()).map(Enum::name).collect(ImmutableSet.toImmutableSet())).setRemoteUserAddress("address").setUserAgent("agent");
    }
}

