/*
 * Decompiled with CFR 0.152.
 */
package io.trino.type;

import com.google.common.collect.ImmutableList;
import io.trino.annotation.UsedByGeneratedCode;
import io.trino.metadata.PolymorphicScalarFunctionBuilder;
import io.trino.metadata.SqlScalarFunction;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.function.LiteralParameters;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.ScalarOperator;
import io.trino.spi.function.Signature;
import io.trino.spi.function.SqlType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.Decimals;
import io.trino.spi.type.Int128;
import io.trino.spi.type.Int128Math;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import java.util.List;
import java.util.Objects;

public final class DecimalOperators {
    public static final SqlScalarFunction DECIMAL_ADD_OPERATOR = DecimalOperators.decimalAddOperator();
    public static final SqlScalarFunction DECIMAL_SUBTRACT_OPERATOR = DecimalOperators.decimalSubtractOperator();
    public static final SqlScalarFunction DECIMAL_MULTIPLY_OPERATOR = DecimalOperators.decimalMultiplyOperator();
    public static final SqlScalarFunction DECIMAL_DIVIDE_OPERATOR = DecimalOperators.decimalDivideOperator();
    public static final SqlScalarFunction DECIMAL_MODULUS_OPERATOR = DecimalOperators.decimalModulusOperator();

    private DecimalOperators() {
    }

    private static SqlScalarFunction decimalAddOperator() {
        TypeSignature decimalLeftSignature = new TypeSignature("decimal", new TypeSignatureParameter[]{TypeSignatureParameter.typeVariable((String)"a_precision"), TypeSignatureParameter.typeVariable((String)"a_scale")});
        TypeSignature decimalRightSignature = new TypeSignature("decimal", new TypeSignatureParameter[]{TypeSignatureParameter.typeVariable((String)"b_precision"), TypeSignatureParameter.typeVariable((String)"b_scale")});
        TypeSignature decimalResultSignature = new TypeSignature("decimal", new TypeSignatureParameter[]{TypeSignatureParameter.typeVariable((String)"r_precision"), TypeSignatureParameter.typeVariable((String)"r_scale")});
        Signature signature = Signature.builder().operatorType(OperatorType.ADD).longVariable("r_precision", "min(38, max(a_precision - a_scale, b_precision - b_scale) + max(a_scale, b_scale) + 1)").longVariable("r_scale", "max(a_scale, b_scale)").argumentType(decimalLeftSignature).argumentType(decimalRightSignature).returnType(decimalResultSignature).build();
        return new PolymorphicScalarFunctionBuilder(DecimalOperators.class).signature(signature).deterministic(true).choice(choice -> choice.implementation(methodsGroup -> methodsGroup.methods("addShortShortShort").withExtraParameters(DecimalOperators::calculateShortRescaleParameters)).implementation(methodsGroup -> methodsGroup.methods("addShortShortLong", "addLongLongLong", "addShortLongLong", "addLongShortLong").withExtraParameters(DecimalOperators::calculateLongRescaleParameters))).build();
    }

    @UsedByGeneratedCode
    public static long addShortShortShort(long a, long b, long aRescale, long bRescale) {
        return a * aRescale + b * bRescale;
    }

    @UsedByGeneratedCode
    public static Int128 addShortShortLong(long a, long b, int rescale, boolean left) {
        return DecimalOperators.internalAddLongLongLong(a >> 63, a, b >> 63, b, rescale, left);
    }

    @UsedByGeneratedCode
    public static Int128 addLongLongLong(Int128 a, Int128 b, int rescale, boolean left) {
        return DecimalOperators.internalAddLongLongLong(a.getHigh(), a.getLow(), b.getHigh(), b.getLow(), rescale, left);
    }

    @UsedByGeneratedCode
    public static Int128 addShortLongLong(long a, Int128 b, int rescale, boolean left) {
        return DecimalOperators.addLongShortLong(b, a, rescale, !left);
    }

    @UsedByGeneratedCode
    public static Int128 addLongShortLong(Int128 a, long b, int rescale, boolean rescaleLeft) {
        return DecimalOperators.internalAddLongLongLong(a.getHigh(), a.getLow(), b >> 63, b, rescale, rescaleLeft);
    }

    private static Int128 internalAddLongLongLong(long leftHigh, long leftLow, long rightHigh, long rightLow, int rescale, boolean rescaleLeft) {
        try {
            long[] result = new long[2];
            if (rescaleLeft) {
                Int128Math.rescale((long)leftHigh, (long)leftLow, (int)rescale, (long[])result, (int)0);
                Int128Math.add((long)result[0], (long)result[1], (long)rightHigh, (long)rightLow, (long[])result, (int)0);
            } else {
                Int128Math.rescale((long)rightHigh, (long)rightLow, (int)rescale, (long[])result, (int)0);
                Int128Math.add((long)leftHigh, (long)leftLow, (long)result[0], (long)result[1], (long[])result, (int)0);
            }
            if (Decimals.overflows((long)result[0], (long)result[1])) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, "Decimal overflow");
            }
            return Int128.valueOf((long[])result);
        }
        catch (ArithmeticException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, "Decimal overflow", (Throwable)e);
        }
    }

    private static SqlScalarFunction decimalSubtractOperator() {
        TypeSignature decimalLeftSignature = new TypeSignature("decimal", new TypeSignatureParameter[]{TypeSignatureParameter.typeVariable((String)"a_precision"), TypeSignatureParameter.typeVariable((String)"a_scale")});
        TypeSignature decimalRightSignature = new TypeSignature("decimal", new TypeSignatureParameter[]{TypeSignatureParameter.typeVariable((String)"b_precision"), TypeSignatureParameter.typeVariable((String)"b_scale")});
        TypeSignature decimalResultSignature = new TypeSignature("decimal", new TypeSignatureParameter[]{TypeSignatureParameter.typeVariable((String)"r_precision"), TypeSignatureParameter.typeVariable((String)"r_scale")});
        Signature signature = Signature.builder().operatorType(OperatorType.SUBTRACT).longVariable("r_precision", "min(38, max(a_precision - a_scale, b_precision - b_scale) + max(a_scale, b_scale) + 1)").longVariable("r_scale", "max(a_scale, b_scale)").argumentType(decimalLeftSignature).argumentType(decimalRightSignature).returnType(decimalResultSignature).build();
        return new PolymorphicScalarFunctionBuilder(DecimalOperators.class).signature(signature).deterministic(true).choice(choice -> choice.implementation(methodsGroup -> methodsGroup.methods("subtractShortShortShort").withExtraParameters(DecimalOperators::calculateShortRescaleParameters)).implementation(methodsGroup -> methodsGroup.methods("subtractShortShortLong", "subtractLongLongLong", "subtractShortLongLong", "subtractLongShortLong").withExtraParameters(DecimalOperators::calculateLongRescaleParameters))).build();
    }

    @UsedByGeneratedCode
    public static long subtractShortShortShort(long a, long b, long aRescale, long bRescale) {
        return a * aRescale - b * bRescale;
    }

    @UsedByGeneratedCode
    public static Int128 subtractShortShortLong(long a, long b, int rescale, boolean left) {
        return DecimalOperators.internalSubtractLongLongLong(a >> 63, a, b >> 63, b, rescale, left);
    }

    @UsedByGeneratedCode
    public static Int128 subtractLongLongLong(Int128 a, Int128 b, int rescale, boolean left) {
        return DecimalOperators.internalSubtractLongLongLong(a.getHigh(), a.getLow(), b.getHigh(), b.getLow(), rescale, left);
    }

    @UsedByGeneratedCode
    public static Int128 subtractShortLongLong(long a, Int128 b, int rescale, boolean left) {
        return DecimalOperators.internalSubtractLongLongLong(a >> 63, a, b.getHigh(), b.getLow(), rescale, left);
    }

    @UsedByGeneratedCode
    public static Int128 subtractLongShortLong(Int128 a, long b, int rescale, boolean left) {
        return DecimalOperators.internalSubtractLongLongLong(a.getHigh(), a.getLow(), b >> 63, b, rescale, left);
    }

    private static Int128 internalSubtractLongLongLong(long leftHigh, long leftLow, long rightHigh, long rightLow, int rescale, boolean rescaleLeft) {
        try {
            long[] result = new long[2];
            if (rescaleLeft) {
                Int128Math.rescale((long)leftHigh, (long)leftLow, (int)rescale, (long[])result, (int)0);
                Int128Math.subtract((long)result[0], (long)result[1], (long)rightHigh, (long)rightLow, (long[])result, (int)0);
            } else {
                Int128Math.rescale((long)rightHigh, (long)rightLow, (int)rescale, (long[])result, (int)0);
                Int128Math.subtract((long)leftHigh, (long)leftLow, (long)result[0], (long)result[1], (long[])result, (int)0);
            }
            if (Decimals.overflows((long)result[0], (long)result[1])) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, "Decimal overflow");
            }
            return Int128.valueOf((long[])result);
        }
        catch (ArithmeticException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, "Decimal overflow", (Throwable)e);
        }
    }

    private static SqlScalarFunction decimalMultiplyOperator() {
        TypeSignature decimalLeftSignature = new TypeSignature("decimal", new TypeSignatureParameter[]{TypeSignatureParameter.typeVariable((String)"a_precision"), TypeSignatureParameter.typeVariable((String)"a_scale")});
        TypeSignature decimalRightSignature = new TypeSignature("decimal", new TypeSignatureParameter[]{TypeSignatureParameter.typeVariable((String)"b_precision"), TypeSignatureParameter.typeVariable((String)"b_scale")});
        TypeSignature decimalResultSignature = new TypeSignature("decimal", new TypeSignatureParameter[]{TypeSignatureParameter.typeVariable((String)"r_precision"), TypeSignatureParameter.typeVariable((String)"r_scale")});
        Signature signature = Signature.builder().operatorType(OperatorType.MULTIPLY).longVariable("r_precision", "min(38, a_precision + b_precision)").longVariable("r_scale", "a_scale + b_scale").argumentType(decimalLeftSignature).argumentType(decimalRightSignature).returnType(decimalResultSignature).build();
        return new PolymorphicScalarFunctionBuilder(DecimalOperators.class).signature(signature).deterministic(true).choice(choice -> choice.implementation(methodsGroup -> methodsGroup.methods("multiplyShortShortShort", "multiplyShortShortLong", "multiplyLongLongLong", "multiplyShortLongLong", "multiplyLongShortLong"))).build();
    }

    @UsedByGeneratedCode
    public static long multiplyShortShortShort(long a, long b) {
        return a * b;
    }

    @UsedByGeneratedCode
    public static Int128 multiplyShortShortLong(long a, long b) {
        try {
            return Int128Math.multiply((long)a, (long)b);
        }
        catch (ArithmeticException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, "Decimal overflow", (Throwable)e);
        }
    }

    @UsedByGeneratedCode
    public static Int128 multiplyLongLongLong(Int128 a, Int128 b) {
        try {
            Int128 result = Int128Math.multiply((Int128)a, (Int128)b);
            if (Decimals.overflows((Int128)result)) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, "Decimal overflow");
            }
            return result;
        }
        catch (ArithmeticException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, "Decimal overflow", (Throwable)e);
        }
    }

    @UsedByGeneratedCode
    public static Int128 multiplyShortLongLong(long a, Int128 b) {
        return DecimalOperators.multiplyLongShortLong(b, a);
    }

    @UsedByGeneratedCode
    public static Int128 multiplyLongShortLong(Int128 a, long b) {
        try {
            Int128 result = Int128Math.multiply((Int128)a, (long)b);
            if (Decimals.overflows((Int128)result)) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, "Decimal overflow");
            }
            return result;
        }
        catch (ArithmeticException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, "Decimal overflow", (Throwable)e);
        }
    }

    private static SqlScalarFunction decimalDivideOperator() {
        TypeSignature decimalLeftSignature = new TypeSignature("decimal", new TypeSignatureParameter[]{TypeSignatureParameter.typeVariable((String)"a_precision"), TypeSignatureParameter.typeVariable((String)"a_scale")});
        TypeSignature decimalRightSignature = new TypeSignature("decimal", new TypeSignatureParameter[]{TypeSignatureParameter.typeVariable((String)"b_precision"), TypeSignatureParameter.typeVariable((String)"b_scale")});
        TypeSignature decimalResultSignature = new TypeSignature("decimal", new TypeSignatureParameter[]{TypeSignatureParameter.typeVariable((String)"r_precision"), TypeSignatureParameter.typeVariable((String)"r_scale")});
        Signature signature = Signature.builder().operatorType(OperatorType.DIVIDE).longVariable("r_precision", "min(38, a_precision + b_scale + max(b_scale - a_scale, 0))").longVariable("r_scale", "max(a_scale, b_scale)").argumentType(decimalLeftSignature).argumentType(decimalRightSignature).returnType(decimalResultSignature).build();
        return new PolymorphicScalarFunctionBuilder(DecimalOperators.class).signature(signature).deterministic(true).choice(choice -> choice.implementation(methodsGroup -> methodsGroup.methods("divideShortShortShort", "divideShortLongShort", "divideLongShortShort", "divideShortShortLong", "divideLongLongLong", "divideShortLongLong", "divideLongShortLong").withExtraParameters(DecimalOperators::divideRescaleFactor))).build();
    }

    private static List<Object> divideRescaleFactor(PolymorphicScalarFunctionBuilder.SpecializeContext context) {
        DecimalType returnType = (DecimalType)context.getReturnType();
        int dividendScale = Math.toIntExact(Objects.requireNonNull(context.getLiteral("a_scale"), "a_scale is null"));
        int divisorScale = Math.toIntExact(Objects.requireNonNull(context.getLiteral("b_scale"), "b_scale is null"));
        int resultScale = returnType.getScale();
        int rescaleFactor = resultScale - dividendScale + divisorScale;
        return ImmutableList.of((Object)rescaleFactor);
    }

    @UsedByGeneratedCode
    public static long divideShortShortShort(long dividend, long divisor, int rescaleFactor) {
        long quotient;
        if (divisor == 0L) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.DIVISION_BY_ZERO, "Division by zero");
        }
        if (dividend == 0L) {
            return 0L;
        }
        int resultSignum = Long.signum(dividend) * Long.signum(divisor);
        long unsignedDividend = Math.abs(dividend);
        long unsignedDivisor = Math.abs(divisor);
        long rescaledUnsignedDividend = unsignedDividend * Decimals.longTenToNth((int)rescaleFactor);
        long remainder = rescaledUnsignedDividend - (quotient = rescaledUnsignedDividend / unsignedDivisor) * unsignedDivisor;
        if (Long.compareUnsigned(remainder * 2L, unsignedDivisor) >= 0) {
            ++quotient;
        }
        return (long)resultSignum * quotient;
    }

    @UsedByGeneratedCode
    public static long divideShortLongShort(long dividend, Int128 divisor, int rescaleFactor) {
        if (divisor.isZero()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.DIVISION_BY_ZERO, "Division by zero");
        }
        try {
            return Int128Math.divideRoundUp((long)(dividend >> 63), (long)dividend, (int)rescaleFactor, (long)divisor.getHigh(), (long)divisor.getLow(), (int)0).toLongExact();
        }
        catch (ArithmeticException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, "Decimal overflow", (Throwable)e);
        }
    }

    @UsedByGeneratedCode
    public static long divideLongShortShort(Int128 dividend, long divisor, int rescaleFactor) {
        if (divisor == 0L) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.DIVISION_BY_ZERO, "Division by zero");
        }
        try {
            return Int128Math.divideRoundUp((long)dividend.getHigh(), (long)dividend.getLow(), (int)rescaleFactor, (long)(divisor >> 63), (long)divisor, (int)0).toLongExact();
        }
        catch (ArithmeticException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, "Decimal overflow", (Throwable)e);
        }
    }

    @UsedByGeneratedCode
    public static Int128 divideShortShortLong(long dividend, long divisor, int rescaleFactor) {
        if (divisor == 0L) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.DIVISION_BY_ZERO, "Division by zero");
        }
        try {
            Int128 result = Int128Math.divideRoundUp((long)(dividend >> 63), (long)dividend, (int)rescaleFactor, (long)(divisor >> 63), (long)divisor, (int)0);
            if (Decimals.overflows((Int128)result)) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, "Decimal overflow");
            }
            return result;
        }
        catch (ArithmeticException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, "Decimal overflow", (Throwable)e);
        }
    }

    @UsedByGeneratedCode
    public static Int128 divideLongLongLong(Int128 dividend, Int128 divisor, int rescaleFactor) {
        if (divisor.isZero()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.DIVISION_BY_ZERO, "Division by zero");
        }
        try {
            Int128 result = Int128Math.divideRoundUp((long)dividend.getHigh(), (long)dividend.getLow(), (int)rescaleFactor, (long)divisor.getHigh(), (long)divisor.getLow(), (int)0);
            if (Decimals.overflows((Int128)result)) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, "Decimal overflow");
            }
            return result;
        }
        catch (ArithmeticException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, "Decimal overflow", (Throwable)e);
        }
    }

    @UsedByGeneratedCode
    public static Int128 divideShortLongLong(long dividend, Int128 divisor, int rescaleFactor) {
        if (divisor.isZero()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.DIVISION_BY_ZERO, "Division by zero");
        }
        try {
            Int128 result = Int128Math.divideRoundUp((long)(dividend >> 63), (long)dividend, (int)rescaleFactor, (long)divisor.getHigh(), (long)divisor.getLow(), (int)0);
            if (Decimals.overflows((Int128)result)) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, "Decimal overflow");
            }
            return result;
        }
        catch (ArithmeticException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, "Decimal overflow", (Throwable)e);
        }
    }

    @UsedByGeneratedCode
    public static Int128 divideLongShortLong(Int128 dividend, long divisor, int rescaleFactor) {
        if (divisor == 0L) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.DIVISION_BY_ZERO, "Division by zero");
        }
        try {
            Int128 result = Int128Math.divideRoundUp((long)dividend.getHigh(), (long)dividend.getLow(), (int)rescaleFactor, (long)(divisor >> 63), (long)divisor, (int)0);
            if (Decimals.overflows((Int128)result)) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, "Decimal overflow");
            }
            return result;
        }
        catch (ArithmeticException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, "Decimal overflow", (Throwable)e);
        }
    }

    private static SqlScalarFunction decimalModulusOperator() {
        Signature signature = DecimalOperators.modulusSignatureBuilder().operatorType(OperatorType.MODULUS).build();
        return DecimalOperators.modulusScalarFunction(signature);
    }

    public static SqlScalarFunction modulusScalarFunction(Signature signature) {
        return new PolymorphicScalarFunctionBuilder(DecimalOperators.class).signature(signature).deterministic(true).choice(choice -> choice.implementation(methodsGroup -> methodsGroup.methods("modulusShortShortShort", "modulusLongLongLong", "modulusShortLongLong", "modulusShortLongShort", "modulusLongShortShort", "modulusLongShortLong").withExtraParameters(DecimalOperators::modulusRescaleParameters))).build();
    }

    public static Signature.Builder modulusSignatureBuilder() {
        TypeSignature decimalLeftSignature = new TypeSignature("decimal", new TypeSignatureParameter[]{TypeSignatureParameter.typeVariable((String)"a_precision"), TypeSignatureParameter.typeVariable((String)"a_scale")});
        TypeSignature decimalRightSignature = new TypeSignature("decimal", new TypeSignatureParameter[]{TypeSignatureParameter.typeVariable((String)"b_precision"), TypeSignatureParameter.typeVariable((String)"b_scale")});
        TypeSignature decimalResultSignature = new TypeSignature("decimal", new TypeSignatureParameter[]{TypeSignatureParameter.typeVariable((String)"r_precision"), TypeSignatureParameter.typeVariable((String)"r_scale")});
        return Signature.builder().longVariable("r_precision", "min(b_precision - b_scale, a_precision - a_scale) + max(a_scale, b_scale)").longVariable("r_scale", "max(a_scale, b_scale)").argumentType(decimalLeftSignature).argumentType(decimalRightSignature).returnType(decimalResultSignature);
    }

    private static List<Object> calculateShortRescaleParameters(PolymorphicScalarFunctionBuilder.SpecializeContext context) {
        long aRescale = Decimals.longTenToNth((int)DecimalOperators.rescaleFactor(context.getLiteral("a_scale"), context.getLiteral("b_scale")));
        long bRescale = Decimals.longTenToNth((int)DecimalOperators.rescaleFactor(context.getLiteral("b_scale"), context.getLiteral("a_scale")));
        return ImmutableList.of((Object)aRescale, (Object)bRescale);
    }

    private static List<Object> calculateLongRescaleParameters(PolymorphicScalarFunctionBuilder.SpecializeContext context) {
        boolean left;
        int rescale;
        long aScale = context.getLiteral("a_scale");
        long bScale = context.getLiteral("b_scale");
        int aRescale = DecimalOperators.rescaleFactor(aScale, bScale);
        int bRescale = DecimalOperators.rescaleFactor(bScale, aScale);
        if (aRescale == 0) {
            rescale = bRescale;
            left = false;
        } else if (bRescale == 0) {
            rescale = aRescale;
            left = true;
        } else {
            throw new IllegalStateException();
        }
        return ImmutableList.of((Object)rescale, (Object)left);
    }

    private static List<Object> modulusRescaleParameters(PolymorphicScalarFunctionBuilder.SpecializeContext context) {
        int dividendScale = Math.toIntExact(Objects.requireNonNull(context.getLiteral("a_scale"), "a_scale is null"));
        int divisorScale = Math.toIntExact(Objects.requireNonNull(context.getLiteral("b_scale"), "b_scale is null"));
        int dividendRescaleFactor = DecimalOperators.rescaleFactor(dividendScale, divisorScale);
        int divisorRescaleFactor = DecimalOperators.rescaleFactor(divisorScale, dividendScale);
        return ImmutableList.of((Object)dividendRescaleFactor, (Object)divisorRescaleFactor);
    }

    private static int rescaleFactor(long fromScale, long toScale) {
        return Integer.max(0, (int)toScale - (int)fromScale);
    }

    @UsedByGeneratedCode
    public static long modulusShortShortShort(long dividend, long divisor, int dividendRescaleFactor, int divisorRescaleFactor) {
        if (divisor == 0L) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.DIVISION_BY_ZERO, "Division by zero");
        }
        try {
            return Int128Math.remainder((long)(dividend >> 63), (long)dividend, (int)dividendRescaleFactor, (long)(divisor >> 63), (long)divisor, (int)divisorRescaleFactor).toLongExact();
        }
        catch (ArithmeticException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, "Decimal overflow", (Throwable)e);
        }
    }

    @UsedByGeneratedCode
    public static long modulusShortLongShort(long dividend, Int128 divisor, int dividendRescaleFactor, int divisorRescaleFactor) {
        if (divisor.isZero()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.DIVISION_BY_ZERO, "Division by zero");
        }
        try {
            return Int128Math.remainder((long)(dividend >> 63), (long)dividend, (int)dividendRescaleFactor, (long)divisor.getHigh(), (long)divisor.getLow(), (int)divisorRescaleFactor).toLongExact();
        }
        catch (ArithmeticException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, "Decimal overflow", (Throwable)e);
        }
    }

    @UsedByGeneratedCode
    public static long modulusLongShortShort(Int128 dividend, long divisor, int dividendRescaleFactor, int divisorRescaleFactor) {
        if (divisor == 0L) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.DIVISION_BY_ZERO, "Division by zero");
        }
        try {
            return Int128Math.remainder((long)dividend.getHigh(), (long)dividend.getLow(), (int)dividendRescaleFactor, (long)(divisor >> 63), (long)divisor, (int)divisorRescaleFactor).toLongExact();
        }
        catch (ArithmeticException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, "Decimal overflow", (Throwable)e);
        }
    }

    @UsedByGeneratedCode
    public static Int128 modulusShortLongLong(long dividend, Int128 divisor, int dividendRescaleFactor, int divisorRescaleFactor) {
        if (divisor.isZero()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.DIVISION_BY_ZERO, "Division by zero");
        }
        try {
            return Int128Math.remainder((long)(dividend >> 63), (long)dividend, (int)dividendRescaleFactor, (long)divisor.getHigh(), (long)divisor.getLow(), (int)divisorRescaleFactor);
        }
        catch (ArithmeticException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, "Decimal overflow", (Throwable)e);
        }
    }

    @UsedByGeneratedCode
    public static Int128 modulusLongShortLong(Int128 dividend, long divisor, int dividendRescaleFactor, int divisorRescaleFactor) {
        if (divisor == 0L) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.DIVISION_BY_ZERO, "Division by zero");
        }
        try {
            return Int128Math.remainder((long)dividend.getHigh(), (long)dividend.getLow(), (int)dividendRescaleFactor, (long)(divisor >> 63), (long)divisor, (int)divisorRescaleFactor);
        }
        catch (ArithmeticException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, "Decimal overflow", (Throwable)e);
        }
    }

    @UsedByGeneratedCode
    public static Int128 modulusLongLongLong(Int128 dividend, Int128 divisor, int dividendRescaleFactor, int divisorRescaleFactor) {
        if (divisor.isZero()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.DIVISION_BY_ZERO, "Division by zero");
        }
        try {
            return Int128Math.remainder((long)dividend.getHigh(), (long)dividend.getLow(), (int)dividendRescaleFactor, (long)divisor.getHigh(), (long)divisor.getLow(), (int)divisorRescaleFactor);
        }
        catch (ArithmeticException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, "Decimal overflow", (Throwable)e);
        }
    }

    @ScalarOperator(value=OperatorType.NEGATION)
    public static final class Negation {
        @LiteralParameters(value={"p", "s"})
        @SqlType(value="decimal(p, s)")
        public static long negate(@SqlType(value="decimal(p, s)") long arg) {
            return -arg;
        }

        @LiteralParameters(value={"p", "s"})
        @SqlType(value="decimal(p, s)")
        public static Int128 negate(@SqlType(value="decimal(p, s)") Int128 value) {
            return Int128Math.negateExact((Int128)value);
        }
    }
}

