/*
 * Decompiled with CFR 0.152.
 */
package io.trino.type;

import com.google.common.base.Preconditions;
import io.trino.spi.type.MapType;
import io.trino.spi.type.ParameterKind;
import io.trino.spi.type.ParametricType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.TypeParameter;
import java.util.List;

public final class MapParametricType
implements ParametricType {
    public static final MapParametricType MAP = new MapParametricType();

    public String getName() {
        return "map";
    }

    public Type createType(TypeManager typeManager, List<TypeParameter> parameters) {
        Preconditions.checkArgument((parameters.size() == 2 ? 1 : 0) != 0, (String)"Expected two parameters, got %s", parameters);
        TypeParameter firstParameter = parameters.get(0);
        TypeParameter secondParameter = parameters.get(1);
        Preconditions.checkArgument((firstParameter.getKind() == ParameterKind.TYPE && secondParameter.getKind() == ParameterKind.TYPE ? 1 : 0) != 0, (String)"Expected key and type to be types, got %s", parameters);
        return new MapType(firstParameter.getType(), secondParameter.getType(), typeManager.getTypeOperators());
    }
}

