/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.stats;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Verify;
import io.airlift.stats.DecayCounter;
import io.airlift.stats.DecayTDigest;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.weakref.jmx.Managed;

@ThreadSafe
public class Distribution {
    private static final double[] SNAPSHOT_QUANTILES = new double[]{0.01, 0.05, 0.1, 0.25, 0.5, 0.75, 0.9, 0.95, 0.99};
    private static final double[] PERCENTILES = new double[100];
    private final double alpha;
    @GuardedBy(value="this")
    private DecayTDigest digest;
    private final DecayCounter total;

    public Distribution() {
        this(0.0);
    }

    public Distribution(double alpha) {
        this(alpha, new DecayTDigest(100.0, alpha), new DecayCounter(alpha));
    }

    private Distribution(double alpha, DecayTDigest digest, DecayCounter total) {
        this.alpha = alpha;
        this.digest = Objects.requireNonNull(digest, "digest is null");
        this.total = Objects.requireNonNull(total, "total is null");
    }

    public synchronized void add(long value) {
        this.digest.add(value);
        this.total.add(value);
    }

    public synchronized void add(long value, long count) {
        this.digest.add(value, count);
        this.total.add(value * count);
    }

    public synchronized Distribution duplicate() {
        return new Distribution(this.alpha, this.digest.duplicate(), this.total.duplicate());
    }

    @Managed
    public synchronized void reset() {
        this.total.reset();
        this.digest = new DecayTDigest(100.0, this.alpha);
    }

    @Managed
    public synchronized double getCount() {
        return this.digest.getCount();
    }

    @Managed
    public synchronized double getTotal() {
        return this.total.getCount();
    }

    @Managed
    public synchronized double getP01() {
        return this.digest.valueAt(0.01);
    }

    @Managed
    public synchronized double getP05() {
        return this.digest.valueAt(0.05);
    }

    @Managed
    public synchronized double getP10() {
        return this.digest.valueAt(0.1);
    }

    @Managed
    public synchronized double getP25() {
        return this.digest.valueAt(0.25);
    }

    @Managed
    public synchronized double getP50() {
        return this.digest.valueAt(0.5);
    }

    @Managed
    public synchronized double getP75() {
        return this.digest.valueAt(0.75);
    }

    @Managed
    public synchronized double getP90() {
        return this.digest.valueAt(0.9);
    }

    @Managed
    public synchronized double getP95() {
        return this.digest.valueAt(0.95);
    }

    @Managed
    public synchronized double getP99() {
        return this.digest.valueAt(0.99);
    }

    @Managed
    public synchronized double getMin() {
        return this.digest.getMin();
    }

    @Managed
    public synchronized double getMax() {
        return this.digest.getMax();
    }

    @Managed
    public synchronized double getAvg() {
        return this.getTotal() / this.getCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Managed
    public Map<Double, Double> getPercentiles() {
        double[] values;
        Distribution distribution = this;
        synchronized (distribution) {
            values = this.digest.valuesAt(PERCENTILES);
        }
        Verify.verify((values.length == PERCENTILES.length ? 1 : 0) != 0, (String)"result length mismatch", (Object[])new Object[0]);
        LinkedHashMap<Double, Double> result = new LinkedHashMap<Double, Double>(values.length);
        for (int i = 0; i < values.length; ++i) {
            result.put(PERCENTILES[i], values[i]);
        }
        return result;
    }

    public synchronized List<Double> getPercentiles(List<Double> percentiles) {
        return this.digest.valuesAt(percentiles);
    }

    public synchronized double[] getPercentiles(double ... percentiles) {
        return this.digest.valuesAt(percentiles);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DistributionSnapshot snapshot() {
        double[] quantiles;
        double max;
        double min;
        double digestCount;
        double totalCount;
        Distribution distribution = this;
        synchronized (distribution) {
            totalCount = this.total.getCount();
            digestCount = this.digest.getCount();
            min = this.digest.getMin();
            max = this.digest.getMax();
            quantiles = this.digest.valuesAt(SNAPSHOT_QUANTILES);
        }
        double average = totalCount / digestCount;
        return new DistributionSnapshot(digestCount, totalCount, quantiles[0], quantiles[1], quantiles[2], quantiles[3], quantiles[4], quantiles[5], quantiles[6], quantiles[7], quantiles[8], min, max, average);
    }

    static {
        for (int i = 0; i < 100; ++i) {
            Distribution.PERCENTILES[i] = (double)i / 100.0;
        }
    }

    public static class DistributionSnapshot {
        private final double count;
        private final double total;
        private final double p01;
        private final double p05;
        private final double p10;
        private final double p25;
        private final double p50;
        private final double p75;
        private final double p90;
        private final double p95;
        private final double p99;
        private final double min;
        private final double max;
        private final double avg;

        @JsonCreator
        public DistributionSnapshot(@JsonProperty(value="count") double count, @JsonProperty(value="total") double total, @JsonProperty(value="p01") double p01, @JsonProperty(value="p05") double p05, @JsonProperty(value="p10") double p10, @JsonProperty(value="p25") double p25, @JsonProperty(value="p50") double p50, @JsonProperty(value="p75") double p75, @JsonProperty(value="p90") double p90, @JsonProperty(value="p95") double p95, @JsonProperty(value="p99") double p99, @JsonProperty(value="min") double min, @JsonProperty(value="max") double max, @JsonProperty(value="avg") double avg) {
            this.count = count;
            this.total = total;
            this.p01 = p01;
            this.p05 = p05;
            this.p10 = p10;
            this.p25 = p25;
            this.p50 = p50;
            this.p75 = p75;
            this.p90 = p90;
            this.p95 = p95;
            this.p99 = p99;
            this.min = min;
            this.max = max;
            this.avg = avg;
        }

        @JsonProperty
        public double getCount() {
            return this.count;
        }

        @JsonProperty
        public double getTotal() {
            return this.total;
        }

        @JsonProperty
        public double getP01() {
            return this.p01;
        }

        @JsonProperty
        public double getP05() {
            return this.p05;
        }

        @JsonProperty
        public double getP10() {
            return this.p10;
        }

        @JsonProperty
        public double getP25() {
            return this.p25;
        }

        @JsonProperty
        public double getP50() {
            return this.p50;
        }

        @JsonProperty
        public double getP75() {
            return this.p75;
        }

        @JsonProperty
        public double getP90() {
            return this.p90;
        }

        @JsonProperty
        public double getP95() {
            return this.p95;
        }

        @JsonProperty
        public double getP99() {
            return this.p99;
        }

        @JsonProperty
        public double getMin() {
            return this.min;
        }

        @JsonProperty
        public double getMax() {
            return this.max;
        }

        @JsonProperty
        public double getAvg() {
            return this.avg;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("count", this.count).add("total", this.total).add("p01", this.p01).add("p05", this.p05).add("p10", this.p10).add("p25", this.p25).add("p50", this.p50).add("p75", this.p75).add("p90", this.p90).add("p95", this.p95).add("p99", this.p99).add("min", this.min).add("max", this.max).add("avg", this.avg).toString();
        }
    }
}

