/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.tpcds;

import com.google.common.collect.ImmutableList;
import io.trino.plugin.tpcds.TpcdsConfig;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.session.PropertyMetadata;
import java.util.List;
import java.util.OptionalInt;
import javax.inject.Inject;

public final class TpcdsSessionProperties {
    private static final String SPLITS_PER_NODE = "splits_per_node";
    private static final String WITH_NO_SEXISM = "with_no_sexism";
    private static final String SPLIT_COUNT = "split_count";
    private final List<PropertyMetadata<?>> sessionProperties;

    @Inject
    public TpcdsSessionProperties(TpcdsConfig config) {
        this.sessionProperties = ImmutableList.of((Object)PropertyMetadata.integerProperty((String)SPLITS_PER_NODE, (String)"Number of splits created for each worker node", (Integer)config.getSplitsPerNode(), (boolean)false), (Object)PropertyMetadata.booleanProperty((String)WITH_NO_SEXISM, (String)"With no sexism", (Boolean)config.isWithNoSexism(), (boolean)false), (Object)PropertyMetadata.integerProperty((String)SPLIT_COUNT, (String)"Number of split to be created. If not specified the number of splits is computed as 'splits_per_node * <number of active nodes>'", (Integer)config.getSplitCount(), (boolean)false));
    }

    public List<PropertyMetadata<?>> getSessionProperties() {
        return this.sessionProperties;
    }

    public static int getSplitsPerNode(ConnectorSession session) {
        return (Integer)session.getProperty(SPLITS_PER_NODE, Integer.class);
    }

    public static boolean isWithNoSexism(ConnectorSession session) {
        return (Boolean)session.getProperty(WITH_NO_SEXISM, Boolean.class);
    }

    public static OptionalInt getSplitCount(ConnectorSession session) {
        Integer value = (Integer)session.getProperty(SPLIT_COUNT, Integer.class);
        return value == null ? OptionalInt.empty() : OptionalInt.of(value);
    }
}

