/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.tpcds;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.SizeOf;
import io.trino.spi.HostAddress;
import io.trino.spi.connector.ConnectorSplit;
import java.util.List;
import java.util.Objects;

public class TpcdsSplit
implements ConnectorSplit {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(TpcdsSplit.class);
    private final int totalParts;
    private final int partNumber;
    private final List<HostAddress> addresses;
    private final boolean noSexism;

    @JsonCreator
    public TpcdsSplit(@JsonProperty(value="partNumber") int partNumber, @JsonProperty(value="totalParts") int totalParts, @JsonProperty(value="addresses") List<HostAddress> addresses, @JsonProperty(value="noSexism") boolean noSexism) {
        Preconditions.checkState((partNumber >= 0 ? 1 : 0) != 0, (Object)"partNumber must be >= 0");
        Preconditions.checkState((totalParts >= 1 ? 1 : 0) != 0, (Object)"totalParts must be >= 1");
        Preconditions.checkState((totalParts > partNumber ? 1 : 0) != 0, (Object)"totalParts must be > partNumber");
        Objects.requireNonNull(addresses, "addresses is null");
        this.partNumber = partNumber;
        this.totalParts = totalParts;
        this.addresses = ImmutableList.copyOf(addresses);
        this.noSexism = noSexism;
    }

    @JsonProperty
    public int getTotalParts() {
        return this.totalParts;
    }

    @JsonProperty
    public int getPartNumber() {
        return this.partNumber;
    }

    public Object getInfo() {
        return this;
    }

    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + SizeOf.estimatedSizeOf(this.addresses, HostAddress::getRetainedSizeInBytes);
    }

    public boolean isRemotelyAccessible() {
        return false;
    }

    @JsonProperty
    public List<HostAddress> getAddresses() {
        return this.addresses;
    }

    @JsonProperty
    public boolean isNoSexism() {
        return this.noSexism;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TpcdsSplit other = (TpcdsSplit)obj;
        return Objects.equals(this.totalParts, other.totalParts) && Objects.equals(this.partNumber, other.partNumber) && Objects.equals(this.noSexism, other.noSexism);
    }

    public int hashCode() {
        return Objects.hash(this.totalParts, this.partNumber, this.noSexism);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("partNumber", this.partNumber).add("totalParts", this.totalParts).add("noSexism", this.noSexism).toString();
    }
}

