/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.tpcds;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.plugin.tpcds.TpcdsSessionProperties;
import io.trino.plugin.tpcds.TpcdsSplit;
import io.trino.spi.HostAddress;
import io.trino.spi.Node;
import io.trino.spi.NodeManager;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplitManager;
import io.trino.spi.connector.ConnectorSplitSource;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.Constraint;
import io.trino.spi.connector.DynamicFilter;
import io.trino.spi.connector.FixedSplitSource;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;

public class TpcdsSplitManager
implements ConnectorSplitManager {
    private final NodeManager nodeManager;

    @Inject
    public TpcdsSplitManager(NodeManager nodeManager) {
        this.nodeManager = Objects.requireNonNull(nodeManager, "nodeManager is null");
    }

    public ConnectorSplitSource getSplits(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorTableHandle tableHandle, DynamicFilter dynamicFilter, Constraint constraint) {
        Set nodes = this.nodeManager.getRequiredWorkerNodes();
        Preconditions.checkState((!nodes.isEmpty() ? 1 : 0) != 0, (Object)"No TPCDS nodes available");
        boolean noSexism = TpcdsSessionProperties.isWithNoSexism(session);
        int splitCount = TpcdsSplitManager.getSplitCount(session, nodes.size());
        int partNumber = 0;
        List sortedNodes = (List)nodes.stream().sorted(Comparator.comparing(node -> node.getHostAndPort().toString())).collect(ImmutableList.toImmutableList());
        ImmutableList.Builder splits = ImmutableList.builder();
        for (int i = 0; i < splitCount; ++i) {
            Node node2 = (Node)sortedNodes.get(i % nodes.size());
            splits.add((Object)new TpcdsSplit(partNumber, splitCount, (List<HostAddress>)ImmutableList.of((Object)node2.getHostAndPort()), noSexism));
            ++partNumber;
        }
        return new FixedSplitSource((Iterable)splits.build());
    }

    public static int getSplitCount(ConnectorSession session, int nodeCount) {
        return TpcdsSessionProperties.getSplitCount(session).orElseGet(() -> TpcdsSessionProperties.getSplitsPerNode(session) * nodeCount);
    }
}

