/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hive.formats.line.sequence;

import com.google.common.collect.ImmutableMap;
import io.trino.hive.formats.compression.CompressionKind;
import io.trino.hive.formats.line.LineWriter;
import io.trino.hive.formats.line.LineWriterFactory;
import io.trino.hive.formats.line.sequence.SequenceFileWriter;
import io.trino.spi.connector.ConnectorSession;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class SequenceFileWriterFactory
implements LineWriterFactory {
    private final String trinoVersion;

    public SequenceFileWriterFactory(String trinoVersion) {
        this.trinoVersion = Objects.requireNonNull(trinoVersion, "trinoVersion is null");
    }

    @Override
    public String getHiveOutputFormatClassName() {
        return "org.apache.hadoop.hive.ql.io.HiveSequenceFileOutputFormat";
    }

    @Override
    public LineWriter createLineWriter(ConnectorSession session, OutputStream outputStream, Optional<CompressionKind> compressionKind) throws IOException {
        return new SequenceFileWriter(outputStream, compressionKind, compressionKind.isPresent(), (Map<String, String>)ImmutableMap.builder().put((Object)"trino_version", (Object)this.trinoVersion).put((Object)"trino_query_id", (Object)session.getQueryId()).buildOrThrow());
    }
}

