/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.apache.datasketches.ResizeFactor;
import org.apache.datasketches.SketchesArgumentException;
import org.apache.datasketches.hash.MurmurHash3;

public final class Util {
    public static final int MIN_LG_ARR_LONGS = 5;
    public static final int MIN_LG_NOM_LONGS = 4;
    public static final int MAX_LG_NOM_LONGS = 26;
    public static final double REBUILD_THRESHOLD = 0.9375;
    public static final double RESIZE_THRESHOLD = 0.5;
    public static final int DEFAULT_NOMINAL_ENTRIES = 4096;
    public static final long DEFAULT_UPDATE_SEED = 9001L;
    public static final String LS = System.getProperty("line.separator");
    public static final char TAB = '\t';
    public static final double LOG2 = Math.log(2.0);
    public static final long iGoldenU64 = -7046029254386353133L;
    public static final double iGolden = 0.6180339887498949;

    private Util() {
    }

    public static int bytesToInt(byte[] arr) {
        return arr[3] << 24 | (arr[2] & 0xFF) << 16 | (arr[1] & 0xFF) << 8 | arr[0] & 0xFF;
    }

    public static long bytesToLong(byte[] arr) {
        return (long)arr[7] << 56 | ((long)arr[6] & 0xFFL) << 48 | ((long)arr[5] & 0xFFL) << 40 | ((long)arr[4] & 0xFFL) << 32 | ((long)arr[3] & 0xFFL) << 24 | ((long)arr[2] & 0xFFL) << 16 | ((long)arr[1] & 0xFFL) << 8 | (long)arr[0] & 0xFFL;
    }

    public static byte[] intToBytes(int v, byte[] arr) {
        arr[3] = (byte)(v >>> 24);
        arr[2] = (byte)(v >>> 16);
        arr[1] = (byte)(v >>> 8);
        arr[0] = (byte)v;
        return arr;
    }

    public static byte[] longToBytes(long v, byte[] arr) {
        arr[7] = (byte)(v >>> 56);
        arr[6] = (byte)(v >>> 48);
        arr[5] = (byte)(v >>> 40);
        arr[4] = (byte)(v >>> 32);
        arr[3] = (byte)(v >>> 24);
        arr[2] = (byte)(v >>> 16);
        arr[1] = (byte)(v >>> 8);
        arr[0] = (byte)v;
        return arr;
    }

    public static String longToHexBytes(long v) {
        long mask = 255L;
        StringBuilder sb = new StringBuilder();
        int i = 8;
        while (i-- > 0) {
            String s = Long.toHexString(v >>> i * 8 & 0xFFL);
            sb.append(Util.zeroPad(s, 2)).append(" ");
        }
        return sb.toString();
    }

    public static String bytesToString(byte[] arr, boolean signed, boolean littleEndian, String sep) {
        StringBuilder sb = new StringBuilder();
        int mask = signed ? -1 : 255;
        int arrLen = arr.length;
        if (littleEndian) {
            for (int i = 0; i < arrLen - 1; ++i) {
                sb.append(arr[i] & mask).append(sep);
            }
            sb.append(arr[arrLen - 1] & mask);
        } else {
            int i = arrLen;
            while (i-- > 1) {
                sb.append(arr[i] & mask).append(sep);
            }
            sb.append(arr[0] & mask);
        }
        return sb.toString();
    }

    public static String nanoSecToString(long nS) {
        long rem_nS = (long)((double)nS % 1000.0);
        long rem_uS = (long)((double)nS / 1000.0 % 1000.0);
        long rem_mS = (long)((double)nS / 1000000.0 % 1000.0);
        long sec = (long)((double)nS / 1.0E9);
        String nSstr = Util.zeroPad(Long.toString(rem_nS), 3);
        String uSstr = Util.zeroPad(Long.toString(rem_uS), 3);
        String mSstr = Util.zeroPad(Long.toString(rem_mS), 3);
        return String.format("%d.%3s_%3s_%3s", sec, mSstr, uSstr, nSstr);
    }

    public static String milliSecToString(long mS) {
        long rem_mS = (long)((double)mS % 1000.0);
        long rem_sec = (long)((double)mS / 1000.0 % 60.0);
        long rem_min = (long)((double)mS / 60000.0 % 60.0);
        long hr = (long)((double)mS / 3600000.0);
        String mSstr = Util.zeroPad(Long.toString(rem_mS), 3);
        String secStr = Util.zeroPad(Long.toString(rem_sec), 2);
        String minStr = Util.zeroPad(Long.toString(rem_min), 2);
        return String.format("%d:%2s:%2s.%3s", hr, minStr, secStr, mSstr);
    }

    public static final String zeroPad(String s, int fieldLength) {
        return Util.characterPad(s, fieldLength, '0', false);
    }

    public static final String characterPad(String s, int fieldLength, char padChar, boolean postpend) {
        char[] chArr = s.toCharArray();
        int sLen = chArr.length;
        if (sLen < fieldLength) {
            char[] out = new char[fieldLength];
            int blanks = fieldLength - sLen;
            if (postpend) {
                int i;
                for (i = 0; i < sLen; ++i) {
                    out[i] = chArr[i];
                }
                for (i = sLen; i < fieldLength; ++i) {
                    out[i] = padChar;
                }
            } else {
                int i;
                for (i = 0; i < blanks; ++i) {
                    out[i] = padChar;
                }
                for (i = blanks; i < fieldLength; ++i) {
                    out[i] = chArr[i - blanks];
                }
            }
            return String.valueOf(out);
        }
        return s;
    }

    public static final short checkSeedHashes(short seedHashA, short seedHashB) {
        if (seedHashA != seedHashB) {
            throw new SketchesArgumentException("Incompatible Seed Hashes. " + Integer.toHexString(seedHashA & 0xFFFF) + ", " + Integer.toHexString(seedHashB & 0xFFFF));
        }
        return seedHashA;
    }

    public static short computeSeedHash(long seed) {
        long[] seedArr = new long[]{seed};
        short seedHash = (short)(MurmurHash3.hash(seedArr, 0L)[0] & 0xFFFFL);
        if (seedHash == 0) {
            throw new SketchesArgumentException("The given seed: " + seed + " produced a seedHash of zero. You must choose a different seed.");
        }
        return seedHash;
    }

    public static void checkIfMultipleOf8AndGT0(long v, String argName) {
        if ((v & 7L) == 0L && v > 0L) {
            return;
        }
        throw new SketchesArgumentException("The value of the parameter \"" + argName + "\" must be a positive multiple of 8 and greater than zero: " + v);
    }

    public static boolean isMultipleOf8AndGT0(long v) {
        return (v & 7L) == 0L && v > 0L;
    }

    public static boolean isPowerOf2(int v) {
        return v > 0 && (v & v - 1) == 0;
    }

    public static void checkIfPowerOf2(int v, String argName) {
        if (v > 0 && (v & v - 1) == 0) {
            return;
        }
        throw new SketchesArgumentException("The value of the parameter \"" + argName + "\" must be a positive integer-power of 2 and greater than 0: " + v);
    }

    public static int toLog2(int value, String argName) {
        Util.checkIfPowerOf2(value, argName);
        return Integer.numberOfTrailingZeros(value);
    }

    public static int ceilingPowerOf2(int n) {
        if (n <= 1) {
            return 1;
        }
        int topPwrOf2 = 0x40000000;
        return n >= 0x40000000 ? 0x40000000 : Integer.highestOneBit(n - 1 << 1);
    }

    public static int floorPowerOf2(int n) {
        if (n <= 1) {
            return 1;
        }
        return Integer.highestOneBit(n);
    }

    public static double invPow2(int e) {
        assert ((e | 1024 - e - 1) >= 0) : "e cannot be negative or greater than 1023: " + e;
        return Double.longBitsToDouble(1023L - (long)e << 52);
    }

    public static int[] evenlyLgSpaced(int lgStart, int lgEnd, int points) {
        if (points <= 0) {
            throw new SketchesArgumentException("points must be > 0");
        }
        if (lgEnd < 0 || lgStart < 0) {
            throw new SketchesArgumentException("lgStart and lgEnd must be >= 0.");
        }
        int[] out = new int[points];
        out[0] = 1 << lgStart;
        if (points == 1) {
            return out;
        }
        double delta = (double)(lgEnd - lgStart) / ((double)points - 1.0);
        for (int i = 1; i < points; ++i) {
            double mXpY = delta * (double)i + (double)lgStart;
            out[i] = (int)Math.round(Math.pow(2.0, mXpY));
        }
        return out;
    }

    public static final int pwr2LawNext(int ppo, int curPoint) {
        int next;
        int cur = curPoint < 1 ? 1 : curPoint;
        int gi = (int)Math.round(Util.log2(cur) * (double)ppo);
        while ((next = (int)Math.round(Math.pow(2.0, (double)(++gi) / (double)ppo))) <= curPoint) {
        }
        return next;
    }

    public static final int pwr2LawPrev(int ppo, int curPoint) {
        int prev;
        if (curPoint <= 1) {
            return 0;
        }
        int gi = (int)Math.round(Util.log2(curPoint) * (double)ppo);
        while ((prev = (int)Math.round(Math.pow(2.0, (double)(--gi) / (double)ppo))) >= curPoint) {
        }
        return prev;
    }

    public static final double log2(double value) {
        return Math.log(value) / LOG2;
    }

    public static int simpleIntLog2(int x) {
        int exp = Integer.numberOfTrailingZeros(x);
        if (x != 1 << exp) {
            throw new SketchesArgumentException("Argument x cannot be negative or zero.");
        }
        return exp;
    }

    public static final int startingSubMultiple(int lgTarget, ResizeFactor rf, int lgMin) {
        int lgRF = rf.lg();
        return lgTarget <= lgMin ? lgMin : (lgRF == 0 ? lgTarget : (lgTarget - lgMin) % lgRF + lgMin);
    }

    public static double ceilingPowerOfBdouble(double b, double n) {
        double x = n < 1.0 ? 1.0 : n;
        return Math.pow(b, Math.ceil(Util.logB(b, x)));
    }

    public static double floorPowerOfBdouble(double b, double n) {
        double x = n < 1.0 ? 1.0 : n;
        return Math.pow(b, Math.floor(Util.logB(b, x)));
    }

    public static final double logB(double logBase, double x) {
        return Math.log(x) / Math.log(logBase);
    }

    public static final double pwrLawNextDouble(int ppo, double curPoint, boolean roundToInt, double logBase) {
        double n;
        double next;
        double cur = curPoint < 1.0 ? 1.0 : curPoint;
        double gi = Math.round(Util.logB(logBase, cur) * (double)ppo);
        do {
            n = Math.pow(logBase, (gi += 1.0) / (double)ppo);
        } while ((next = roundToInt ? (double)Math.round(n) : n) <= cur);
        return next;
    }

    public static final int checkNomLongs(int nomLongs) {
        int lgNomLongs = Integer.numberOfTrailingZeros(Util.ceilingPowerOf2(nomLongs));
        if (lgNomLongs > 26 || lgNomLongs < 4) {
            throw new SketchesArgumentException("Nominal Entries must be >= 16 and <= 67108864: " + nomLongs);
        }
        return lgNomLongs;
    }

    public static void checkProbability(double p, String argName) {
        if (p >= 0.0 && p <= 1.0) {
            return;
        }
        throw new SketchesArgumentException("The value of the parameter \"" + argName + "\" must be between 0.0 inclusive and 1.0 inclusive: " + p);
    }

    public static boolean isLessThanUnsigned(long n1, long n2) {
        return n1 < n2 ^ n1 < 0L != n2 < 0L;
    }

    public static String getResourcePath(String shortFileName) {
        try {
            URL url = Util.class.getClassLoader().getResource(shortFileName);
            URI uri = url.toURI();
            String path = uri.getPath();
            return path;
        }
        catch (NullPointerException | URISyntaxException e) {
            throw new SketchesArgumentException("Cannot find resource: " + shortFileName + LS + e);
        }
    }

    public static File getResourceFile(String shortFileName) {
        return new File(Util.getResourcePath(shortFileName));
    }

    public static byte[] getResourceBytes(String shortFileName) {
        try {
            return Files.readAllBytes(Paths.get(Util.getResourcePath(shortFileName), new String[0]));
        }
        catch (IOException e) {
            throw new SketchesArgumentException("Cannot read resource: " + shortFileName + LS + e);
        }
    }
}

