/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.common.datatable;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.common.utils.DataTable;
import org.apache.pinot.core.common.datatable.DataTableBuilder;
import org.apache.pinot.core.common.datatable.DataTableFactory;
import org.apache.pinot.core.query.aggregation.function.AggregationFunction;
import org.apache.pinot.core.query.aggregation.function.DistinctAggregationFunction;
import org.apache.pinot.core.query.distinct.DistinctTable;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.core.query.request.context.utils.QueryContextUtils;

public class DataTableUtils {
    private DataTableUtils() {
    }

    public static int computeColumnOffsets(DataSchema dataSchema, int[] columnOffsets, int dataTableVersion) {
        int numColumns = columnOffsets.length;
        assert (numColumns == dataSchema.size());
        DataSchema.ColumnDataType[] storedColumnDataTypes = dataSchema.getStoredColumnDataTypes();
        int rowSizeInBytes = 0;
        block7: for (int i = 0; i < numColumns; ++i) {
            columnOffsets[i] = rowSizeInBytes;
            switch (storedColumnDataTypes[i]) {
                case INT: {
                    rowSizeInBytes += 4;
                    continue block7;
                }
                case LONG: {
                    rowSizeInBytes += 8;
                    continue block7;
                }
                case FLOAT: {
                    if (dataTableVersion >= 4) {
                        rowSizeInBytes += 4;
                        continue block7;
                    }
                    rowSizeInBytes += 8;
                    continue block7;
                }
                case DOUBLE: {
                    rowSizeInBytes += 8;
                    continue block7;
                }
                case STRING: {
                    rowSizeInBytes += 4;
                    continue block7;
                }
                default: {
                    rowSizeInBytes += 8;
                }
            }
        }
        return rowSizeInBytes;
    }

    public static DataTable buildEmptyDataTable(QueryContext queryContext) throws IOException {
        if (QueryContextUtils.isSelectionQuery(queryContext)) {
            return DataTableUtils.buildEmptyDataTableForSelectionQuery(queryContext);
        }
        if (QueryContextUtils.isAggregationQuery(queryContext)) {
            return DataTableUtils.buildEmptyDataTableForAggregationQuery(queryContext);
        }
        assert (QueryContextUtils.isDistinctQuery(queryContext));
        return DataTableUtils.buildEmptyDataTableForDistinctQuery(queryContext);
    }

    private static DataTable buildEmptyDataTableForSelectionQuery(QueryContext queryContext) {
        List<ExpressionContext> selectExpressions = queryContext.getSelectExpressions();
        int numSelectExpressions = selectExpressions.size();
        String[] columnNames = new String[numSelectExpressions];
        for (int i = 0; i < numSelectExpressions; ++i) {
            columnNames[i] = selectExpressions.get(i).toString();
        }
        Object[] columnDataTypes = new DataSchema.ColumnDataType[numSelectExpressions];
        Arrays.fill(columnDataTypes, DataSchema.ColumnDataType.STRING);
        DataSchema dataSchema = new DataSchema(columnNames, (DataSchema.ColumnDataType[])columnDataTypes);
        return DataTableFactory.getDataTableBuilder(dataSchema).build();
    }

    private static DataTable buildEmptyDataTableForAggregationQuery(QueryContext queryContext) throws IOException {
        AggregationFunction[] aggregationFunctions = queryContext.getAggregationFunctions();
        assert (aggregationFunctions != null);
        int numAggregations = aggregationFunctions.length;
        List<ExpressionContext> groupByExpressions = queryContext.getGroupByExpressions();
        if (groupByExpressions != null) {
            int numColumns = groupByExpressions.size() + numAggregations;
            String[] columnNames = new String[numColumns];
            DataSchema.ColumnDataType[] columnDataTypes = new DataSchema.ColumnDataType[numColumns];
            int index = 0;
            for (ExpressionContext groupByExpression : groupByExpressions) {
                columnNames[index] = groupByExpression.toString();
                columnDataTypes[index] = DataSchema.ColumnDataType.STRING;
                ++index;
            }
            for (AggregationFunction aggregationFunction : aggregationFunctions) {
                columnNames[index] = aggregationFunction.getResultColumnName();
                columnDataTypes[index] = aggregationFunction.getIntermediateResultColumnType();
                ++index;
            }
            return DataTableFactory.getDataTableBuilder(new DataSchema(columnNames, columnDataTypes)).build();
        }
        String[] aggregationColumnNames = new String[numAggregations];
        DataSchema.ColumnDataType[] columnDataTypes = new DataSchema.ColumnDataType[numAggregations];
        Object[] aggregationResults = new Object[numAggregations];
        for (int i = 0; i < numAggregations; ++i) {
            AggregationFunction aggregationFunction = aggregationFunctions[i];
            aggregationColumnNames[i] = aggregationFunction.getColumnName();
            columnDataTypes[i] = aggregationFunction.getIntermediateResultColumnType();
            aggregationResults[i] = aggregationFunction.extractAggregationResult(aggregationFunction.createAggregationResultHolder());
        }
        DataTableBuilder dataTableBuilder = DataTableFactory.getDataTableBuilder(new DataSchema(aggregationColumnNames, columnDataTypes));
        dataTableBuilder.startRow();
        block8: for (int i = 0; i < numAggregations; ++i) {
            switch (columnDataTypes[i]) {
                case LONG: {
                    dataTableBuilder.setColumn(i, ((Number)aggregationResults[i]).longValue());
                    continue block8;
                }
                case DOUBLE: {
                    dataTableBuilder.setColumn(i, (Double)aggregationResults[i]);
                    continue block8;
                }
                case OBJECT: {
                    dataTableBuilder.setColumn(i, aggregationResults[i]);
                    continue block8;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported aggregation column data type: " + columnDataTypes[i] + " for column: " + aggregationColumnNames[i]);
                }
            }
        }
        dataTableBuilder.finishRow();
        return dataTableBuilder.build();
    }

    private static DataTable buildEmptyDataTableForDistinctQuery(QueryContext queryContext) throws IOException {
        AggregationFunction[] aggregationFunctions = queryContext.getAggregationFunctions();
        assert (aggregationFunctions != null && aggregationFunctions.length == 1 && aggregationFunctions[0] instanceof DistinctAggregationFunction);
        DistinctAggregationFunction distinctAggregationFunction = (DistinctAggregationFunction)aggregationFunctions[0];
        String[] columnNames = distinctAggregationFunction.getColumns();
        Object[] columnDataTypes = new DataSchema.ColumnDataType[columnNames.length];
        Arrays.fill(columnDataTypes, DataSchema.ColumnDataType.STRING);
        DistinctTable distinctTable = new DistinctTable(new DataSchema(columnNames, (DataSchema.ColumnDataType[])columnDataTypes), Collections.emptySet(), queryContext.isNullHandlingEnabled());
        DataTableBuilder dataTableBuilder = DataTableFactory.getDataTableBuilder(new DataSchema(new String[]{distinctAggregationFunction.getColumnName()}, new DataSchema.ColumnDataType[]{DataSchema.ColumnDataType.OBJECT}));
        dataTableBuilder.startRow();
        dataTableBuilder.setColumn(0, distinctTable);
        dataTableBuilder.finishRow();
        return dataTableBuilder.build();
    }

    public static String decodeString(ByteBuffer buffer) throws IOException {
        int length = buffer.getInt();
        if (length == 0) {
            return "";
        }
        byte[] bytes = new byte[length];
        buffer.get(bytes);
        return new String(bytes, StandardCharsets.UTF_8);
    }
}

