/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.geospatial.transform.function;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import org.apache.pinot.core.geospatial.transform.function.ScalarFunctions;
import org.apache.pinot.core.operator.blocks.ProjectionBlock;
import org.apache.pinot.core.operator.transform.TransformResultMetadata;
import org.apache.pinot.core.operator.transform.function.BaseTransformFunction;
import org.apache.pinot.core.operator.transform.function.LiteralTransformFunction;
import org.apache.pinot.core.operator.transform.function.TransformFunction;
import org.apache.pinot.segment.local.utils.GeometrySerializer;
import org.apache.pinot.segment.spi.datasource.DataSource;
import org.apache.pinot.spi.data.FieldSpec;
import org.locationtech.jts.geom.Geometry;

public class GeoToH3Function
extends BaseTransformFunction {
    public static final String FUNCTION_NAME = "geoToH3";
    private TransformFunction _firstArgument;
    private TransformFunction _secondArgument;
    private TransformFunction _thirdArgument;
    private long[] _results;

    @Override
    public String getName() {
        return FUNCTION_NAME;
    }

    @Override
    public void init(List<TransformFunction> arguments, Map<String, DataSource> dataSourceMap) {
        Preconditions.checkArgument((arguments.size() == 3 || arguments.size() == 2 ? 1 : 0) != 0, (String)"Transform function %s requires 2 or 3 arguments", (Object)this.getName());
        if (arguments.size() == 3) {
            TransformFunction transformFunction = arguments.get(0);
            Preconditions.checkArgument((boolean)transformFunction.getResultMetadata().isSingleValue(), (String)"First argument must be single-valued for transform function: %s", (Object)this.getName());
            Preconditions.checkArgument((transformFunction.getResultMetadata().getDataType().getStoredType().isNumeric() || transformFunction instanceof LiteralTransformFunction ? 1 : 0) != 0, (Object)"The first argument must be numeric");
            this._firstArgument = transformFunction;
            transformFunction = arguments.get(1);
            Preconditions.checkArgument((boolean)transformFunction.getResultMetadata().isSingleValue(), (String)"Second argument must be single-valued for transform function: %s", (Object)this.getName());
            Preconditions.checkArgument((transformFunction.getResultMetadata().getDataType().getStoredType().isNumeric() || transformFunction instanceof LiteralTransformFunction ? 1 : 0) != 0, (Object)"The second argument must be numeric");
            this._secondArgument = transformFunction;
            transformFunction = arguments.get(2);
            Preconditions.checkArgument((boolean)transformFunction.getResultMetadata().isSingleValue(), (String)"Third argument must be single-valued for transform function: %s", (Object)this.getName());
            Preconditions.checkArgument((transformFunction.getResultMetadata().getDataType().getStoredType().isNumeric() || transformFunction instanceof LiteralTransformFunction ? 1 : 0) != 0, (Object)"The third argument must be numeric");
            this._thirdArgument = transformFunction;
        } else {
            TransformFunction transformFunction = arguments.get(0);
            Preconditions.checkArgument((boolean)transformFunction.getResultMetadata().isSingleValue(), (String)"First argument must be single-valued for transform function: %s", (Object)this.getName());
            Preconditions.checkArgument((transformFunction.getResultMetadata().getDataType() == FieldSpec.DataType.BYTES ? 1 : 0) != 0, (Object)"The first argument must be bytes");
            this._firstArgument = transformFunction;
            transformFunction = arguments.get(1);
            Preconditions.checkArgument((boolean)transformFunction.getResultMetadata().isSingleValue(), (String)"Second argument must be single-valued for transform function: %s", (Object)this.getName());
            Preconditions.checkArgument((transformFunction.getResultMetadata().getDataType().getStoredType().isNumeric() || transformFunction instanceof LiteralTransformFunction ? 1 : 0) != 0, (Object)"The second argument must be numeric");
            this._secondArgument = transformFunction;
        }
    }

    @Override
    public TransformResultMetadata getResultMetadata() {
        return LONG_SV_NO_DICTIONARY_METADATA;
    }

    @Override
    public long[] transformToLongValuesSV(ProjectionBlock projectionBlock) {
        if (this._results == null) {
            this._results = new long[10000];
        }
        if (this._thirdArgument == null) {
            byte[][] geoValues = this._firstArgument.transformToBytesValuesSV(projectionBlock);
            int[] resValues = this._secondArgument.transformToIntValuesSV(projectionBlock);
            for (int i = 0; i < projectionBlock.getNumDocs(); ++i) {
                Geometry geometry = GeometrySerializer.deserialize((byte[])geoValues[i]);
                this._results[i] = ScalarFunctions.geoToH3(geometry.getCoordinate().x, geometry.getCoordinate().y, resValues[i]);
            }
        } else {
            double[] lonValues = this._firstArgument.transformToDoubleValuesSV(projectionBlock);
            double[] latValues = this._secondArgument.transformToDoubleValuesSV(projectionBlock);
            int[] resValues = this._thirdArgument.transformToIntValuesSV(projectionBlock);
            for (int i = 0; i < projectionBlock.getNumDocs(); ++i) {
                this._results[i] = ScalarFunctions.geoToH3(lonValues[i], latValues[i], resValues[i]);
            }
        }
        return this._results;
    }
}

