/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.blocks;

import org.apache.pinot.core.common.Block;
import org.apache.pinot.core.common.BlockDocIdSet;
import org.apache.pinot.core.common.BlockDocIdValueSet;
import org.apache.pinot.core.common.BlockMetadata;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.operator.docidsets.ArrayBasedDocIdSet;

public class DocIdSetBlock
implements Block {
    private final int[] _docIdArray;
    private final int _searchableLength;

    public DocIdSetBlock(int[] docIdSet, int searchableLength) {
        this._docIdArray = docIdSet;
        this._searchableLength = searchableLength;
    }

    public int[] getDocIdSet() {
        return this._docIdArray;
    }

    public int getSearchableLength() {
        return this._searchableLength;
    }

    @Override
    public BlockValSet getBlockValueSet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public BlockDocIdValueSet getBlockDocIdValueSet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public BlockDocIdSet getBlockDocIdSet() {
        return new ArrayBasedDocIdSet(this._docIdArray, this._searchableLength);
    }

    @Override
    public BlockMetadata getMetadata() {
        throw new UnsupportedOperationException();
    }
}

