/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.dociditerators;

import org.apache.pinot.core.operator.dociditerators.ScanBasedDocIdIterator;
import org.apache.pinot.core.operator.filter.predicate.PredicateEvaluator;
import org.apache.pinot.segment.spi.index.reader.ForwardIndexReader;
import org.apache.pinot.segment.spi.index.reader.ForwardIndexReaderContext;
import org.roaringbitmap.BatchIterator;
import org.roaringbitmap.RoaringBitmapWriter;
import org.roaringbitmap.buffer.ImmutableRoaringBitmap;
import org.roaringbitmap.buffer.MutableRoaringBitmap;

public final class MVScanDocIdIterator
implements ScanBasedDocIdIterator {
    private final PredicateEvaluator _predicateEvaluator;
    private final ForwardIndexReader _reader;
    private final ForwardIndexReaderContext _readerContext;
    private final int _numDocs;
    private final int _maxNumValuesPerMVEntry;
    private final ValueMatcher _valueMatcher;
    private int _nextDocId = 0;
    private long _numEntriesScanned = 0L;

    public MVScanDocIdIterator(PredicateEvaluator predicateEvaluator, ForwardIndexReader reader, int numDocs, int maxNumValuesPerMVEntry) {
        this._predicateEvaluator = predicateEvaluator;
        this._reader = reader;
        this._readerContext = reader.createContext();
        this._numDocs = numDocs;
        this._maxNumValuesPerMVEntry = maxNumValuesPerMVEntry;
        this._valueMatcher = this.getValueMatcher();
    }

    @Override
    public int next() {
        while (this._nextDocId < this._numDocs) {
            int nextDocId;
            ++this._nextDocId;
            boolean doesValueMatch = this._valueMatcher.doesValueMatch(nextDocId);
            if (!doesValueMatch) continue;
            return nextDocId;
        }
        return Integer.MIN_VALUE;
    }

    @Override
    public int advance(int targetDocId) {
        this._nextDocId = targetDocId;
        return this.next();
    }

    @Override
    public MutableRoaringBitmap applyAnd(ImmutableRoaringBitmap docIds) {
        if (docIds.isEmpty()) {
            return new MutableRoaringBitmap();
        }
        RoaringBitmapWriter result = RoaringBitmapWriter.bufferWriter().expectedRange((long)docIds.first(), (long)docIds.last()).runCompress(false).get();
        BatchIterator docIdIterator = docIds.getBatchIterator();
        int[] buffer = new int[256];
        while (docIdIterator.hasNext()) {
            int limit = docIdIterator.nextBatch(buffer);
            for (int i = 0; i < limit; ++i) {
                int nextDocId = buffer[i];
                boolean doesValueMatch = this._valueMatcher.doesValueMatch(nextDocId);
                if (!doesValueMatch) continue;
                result.add(nextDocId);
            }
        }
        return (MutableRoaringBitmap)result.get();
    }

    @Override
    public long getNumEntriesScanned() {
        return this._numEntriesScanned;
    }

    private ValueMatcher getValueMatcher() {
        if (this._reader.isDictionaryEncoded()) {
            return new DictIdMatcher();
        }
        switch (this._reader.getStoredType()) {
            case INT: {
                return new IntMatcher();
            }
            case LONG: {
                return new LongMatcher();
            }
            case FLOAT: {
                return new FloatMatcher();
            }
            case DOUBLE: {
                return new DoubleMatcher();
            }
            case STRING: {
                return new StringMatcher();
            }
            case BYTES: {
                return new BytesMatcher();
            }
        }
        throw new UnsupportedOperationException("MV Scan not supported for raw MV columns of type " + this._reader.getStoredType());
    }

    private class BytesMatcher
    implements ValueMatcher {
        private final byte[][] _buffer;

        private BytesMatcher() {
            this._buffer = new byte[MVScanDocIdIterator.this._maxNumValuesPerMVEntry][];
        }

        @Override
        public boolean doesValueMatch(int docId) {
            int length = MVScanDocIdIterator.this._reader.getBytesMV(docId, this._buffer, MVScanDocIdIterator.this._readerContext);
            MVScanDocIdIterator.this._numEntriesScanned += (long)length;
            return MVScanDocIdIterator.this._predicateEvaluator.applyMV(this._buffer, length);
        }
    }

    private class StringMatcher
    implements ValueMatcher {
        private final String[] _buffer;

        private StringMatcher() {
            this._buffer = new String[MVScanDocIdIterator.this._maxNumValuesPerMVEntry];
        }

        @Override
        public boolean doesValueMatch(int docId) {
            int length = MVScanDocIdIterator.this._reader.getStringMV(docId, this._buffer, MVScanDocIdIterator.this._readerContext);
            MVScanDocIdIterator.this._numEntriesScanned += (long)length;
            return MVScanDocIdIterator.this._predicateEvaluator.applyMV(this._buffer, length);
        }
    }

    private class DoubleMatcher
    implements ValueMatcher {
        private final double[] _buffer;

        private DoubleMatcher() {
            this._buffer = new double[MVScanDocIdIterator.this._maxNumValuesPerMVEntry];
        }

        @Override
        public boolean doesValueMatch(int docId) {
            int length = MVScanDocIdIterator.this._reader.getDoubleMV(docId, this._buffer, MVScanDocIdIterator.this._readerContext);
            MVScanDocIdIterator.this._numEntriesScanned += (long)length;
            return MVScanDocIdIterator.this._predicateEvaluator.applyMV(this._buffer, length);
        }
    }

    private class FloatMatcher
    implements ValueMatcher {
        private final float[] _buffer;

        private FloatMatcher() {
            this._buffer = new float[MVScanDocIdIterator.this._maxNumValuesPerMVEntry];
        }

        @Override
        public boolean doesValueMatch(int docId) {
            int length = MVScanDocIdIterator.this._reader.getFloatMV(docId, this._buffer, MVScanDocIdIterator.this._readerContext);
            MVScanDocIdIterator.this._numEntriesScanned += (long)length;
            return MVScanDocIdIterator.this._predicateEvaluator.applyMV(this._buffer, length);
        }
    }

    private class LongMatcher
    implements ValueMatcher {
        private final long[] _buffer;

        private LongMatcher() {
            this._buffer = new long[MVScanDocIdIterator.this._maxNumValuesPerMVEntry];
        }

        @Override
        public boolean doesValueMatch(int docId) {
            int length = MVScanDocIdIterator.this._reader.getLongMV(docId, this._buffer, MVScanDocIdIterator.this._readerContext);
            MVScanDocIdIterator.this._numEntriesScanned += (long)length;
            return MVScanDocIdIterator.this._predicateEvaluator.applyMV(this._buffer, length);
        }
    }

    private class IntMatcher
    implements ValueMatcher {
        private final int[] _buffer;

        private IntMatcher() {
            this._buffer = new int[MVScanDocIdIterator.this._maxNumValuesPerMVEntry];
        }

        @Override
        public boolean doesValueMatch(int docId) {
            int length = MVScanDocIdIterator.this._reader.getIntMV(docId, this._buffer, MVScanDocIdIterator.this._readerContext);
            MVScanDocIdIterator.this._numEntriesScanned += (long)length;
            return MVScanDocIdIterator.this._predicateEvaluator.applyMV(this._buffer, length);
        }
    }

    private class DictIdMatcher
    implements ValueMatcher {
        private final int[] _buffer;

        private DictIdMatcher() {
            this._buffer = new int[MVScanDocIdIterator.this._maxNumValuesPerMVEntry];
        }

        @Override
        public boolean doesValueMatch(int docId) {
            int length = MVScanDocIdIterator.this._reader.getDictIdMV(docId, this._buffer, MVScanDocIdIterator.this._readerContext);
            MVScanDocIdIterator.this._numEntriesScanned += (long)length;
            return MVScanDocIdIterator.this._predicateEvaluator.applyMV(this._buffer, length);
        }
    }

    private static interface ValueMatcher {
        public boolean doesValueMatch(int var1);
    }
}

