/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.dociditerators;

import org.apache.pinot.core.common.BlockDocIdIterator;

public class NotDocIdIterator
implements BlockDocIdIterator {
    private final BlockDocIdIterator _childDocIdIterator;
    private final int _numDocs;
    private int _nextDocId;
    private int _nextNonMatchingDocId;

    public NotDocIdIterator(BlockDocIdIterator childDocIdIterator, int numDocs) {
        this._childDocIdIterator = childDocIdIterator;
        this._nextDocId = 0;
        int currentDocIdFromChildIterator = childDocIdIterator.next();
        this._nextNonMatchingDocId = currentDocIdFromChildIterator == Integer.MIN_VALUE ? numDocs : currentDocIdFromChildIterator;
        this._numDocs = numDocs;
    }

    @Override
    public int next() {
        while (this._nextDocId == this._nextNonMatchingDocId) {
            ++this._nextDocId;
            int nextNonMatchingDocId = this._childDocIdIterator.next();
            this._nextNonMatchingDocId = nextNonMatchingDocId == Integer.MIN_VALUE ? this._numDocs : nextNonMatchingDocId;
        }
        if (this._nextDocId >= this._numDocs) {
            return Integer.MIN_VALUE;
        }
        return this._nextDocId++;
    }

    @Override
    public int advance(int targetDocId) {
        this._nextDocId = targetDocId;
        if (targetDocId > this._nextNonMatchingDocId) {
            int nextNonMatchingDocId = this._childDocIdIterator.advance(targetDocId);
            this._nextNonMatchingDocId = nextNonMatchingDocId == Integer.MIN_VALUE ? this._numDocs : nextNonMatchingDocId;
        }
        return this.next();
    }
}

