/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.dociditerators;

import java.util.Arrays;
import org.apache.pinot.core.common.BlockDocIdIterator;

public final class OrDocIdIterator
implements BlockDocIdIterator {
    private final BlockDocIdIterator[] _docIdIterators;
    private final int[] _nextDocIds;
    private int _numNotExhaustedIterators;
    private int _previousDocId = -1;

    public OrDocIdIterator(BlockDocIdIterator[] docIdIterators) {
        this._docIdIterators = docIdIterators;
        int numDocIdIterators = docIdIterators.length;
        this._nextDocIds = new int[numDocIdIterators];
        Arrays.fill(this._nextDocIds, -1);
        this._numNotExhaustedIterators = numDocIdIterators;
    }

    @Override
    public int next() {
        int nextDocId = Integer.MAX_VALUE;
        boolean hasExhaustedIterator = false;
        for (int i = 0; i < this._numNotExhaustedIterators; ++i) {
            int docId = this._nextDocIds[i];
            if (docId == this._previousDocId) {
                this._nextDocIds[i] = docId = this._docIdIterators[i].next();
                if (docId == Integer.MIN_VALUE) {
                    hasExhaustedIterator = true;
                    continue;
                }
            }
            nextDocId = Math.min(nextDocId, docId);
        }
        if (hasExhaustedIterator) {
            this.removeExhaustedIterators();
        }
        if (nextDocId != Integer.MAX_VALUE) {
            this._previousDocId = nextDocId;
            return nextDocId;
        }
        return Integer.MIN_VALUE;
    }

    @Override
    public int advance(int targetDocId) {
        int nextDocId = Integer.MAX_VALUE;
        boolean hasExhaustedIterator = false;
        for (int i = 0; i < this._numNotExhaustedIterators; ++i) {
            int docId = this._nextDocIds[i];
            if (docId < targetDocId) {
                this._nextDocIds[i] = docId = this._docIdIterators[i].advance(targetDocId);
                if (docId == Integer.MIN_VALUE) {
                    hasExhaustedIterator = true;
                    continue;
                }
            }
            nextDocId = Math.min(nextDocId, docId);
        }
        if (hasExhaustedIterator) {
            this.removeExhaustedIterators();
        }
        if (nextDocId != Integer.MAX_VALUE) {
            this._previousDocId = nextDocId;
            return nextDocId;
        }
        return Integer.MIN_VALUE;
    }

    private void removeExhaustedIterators() {
        int i = 0;
        while (i < this._numNotExhaustedIterators) {
            if (this._nextDocIds[i] == Integer.MIN_VALUE) {
                --this._numNotExhaustedIterators;
                this._docIdIterators[i] = this._docIdIterators[this._numNotExhaustedIterators];
                this._nextDocIds[i] = this._nextDocIds[this._numNotExhaustedIterators];
                continue;
            }
            ++i;
        }
    }
}

