/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.dociditerators;

import javax.annotation.Nullable;
import org.apache.pinot.core.operator.dociditerators.ScanBasedDocIdIterator;
import org.apache.pinot.core.operator.filter.predicate.PredicateEvaluator;
import org.apache.pinot.segment.spi.index.reader.ForwardIndexReader;
import org.apache.pinot.segment.spi.index.reader.ForwardIndexReaderContext;
import org.apache.pinot.segment.spi.index.reader.NullValueVectorReader;
import org.roaringbitmap.BatchIterator;
import org.roaringbitmap.RoaringBitmapWriter;
import org.roaringbitmap.buffer.ImmutableRoaringBitmap;
import org.roaringbitmap.buffer.MutableRoaringBitmap;

public final class SVScanDocIdIterator
implements ScanBasedDocIdIterator {
    private final PredicateEvaluator _predicateEvaluator;
    private final ForwardIndexReader _reader;
    private final ForwardIndexReaderContext _readerContext;
    private final int _numDocs;
    private final ValueMatcher _valueMatcher;
    private final int[] _batch = new int[256];
    private int _firstMismatch;
    private int _cursor;
    private int _nextDocId = 0;
    private long _numEntriesScanned = 0L;

    public SVScanDocIdIterator(PredicateEvaluator predicateEvaluator, ForwardIndexReader reader, int numDocs, @Nullable NullValueVectorReader nullValueReader) {
        ImmutableRoaringBitmap nullBitmap;
        this._predicateEvaluator = predicateEvaluator;
        this._reader = reader;
        this._readerContext = reader.createContext();
        this._numDocs = numDocs;
        ImmutableRoaringBitmap immutableRoaringBitmap = nullBitmap = nullValueReader != null ? nullValueReader.getNullBitmap() : null;
        if (nullBitmap != null && nullBitmap.isEmpty()) {
            nullBitmap = null;
        }
        this._valueMatcher = this.getValueMatcher(nullBitmap);
    }

    @Override
    public int next() {
        if (this._cursor >= this._firstMismatch) {
            int limit;
            int batchSize = 0;
            do {
                if ((limit = Math.min(this._numDocs - this._nextDocId, 256)) <= 0) continue;
                for (int i = 0; i < limit; ++i) {
                    this._batch[i] = this._nextDocId + i;
                }
                batchSize = this._valueMatcher.matchValues(limit, this._batch);
                this._nextDocId += limit;
                this._numEntriesScanned += (long)limit;
            } while (limit > 0 & batchSize == 0);
            this._firstMismatch = batchSize;
            this._cursor = 0;
            if (this._firstMismatch == 0) {
                return Integer.MIN_VALUE;
            }
        }
        return this._batch[this._cursor++];
    }

    @Override
    public int advance(int targetDocId) {
        this._nextDocId = targetDocId;
        this._firstMismatch = 0;
        while (this._nextDocId < this._numDocs) {
            int nextDocId;
            ++this._nextDocId;
            ++this._numEntriesScanned;
            if (!this._valueMatcher.doesValueMatch(nextDocId)) continue;
            return nextDocId;
        }
        return Integer.MIN_VALUE;
    }

    @Override
    public MutableRoaringBitmap applyAnd(ImmutableRoaringBitmap docIds) {
        if (docIds.isEmpty()) {
            return new MutableRoaringBitmap();
        }
        RoaringBitmapWriter result = RoaringBitmapWriter.bufferWriter().expectedRange((long)docIds.first(), (long)docIds.last()).runCompress(false).get();
        BatchIterator docIdIterator = docIds.getBatchIterator();
        int[] buffer = new int[256];
        while (docIdIterator.hasNext()) {
            int limit = docIdIterator.nextBatch(buffer);
            if (limit > 0) {
                int firstMismatch = this._valueMatcher.matchValues(limit, buffer);
                for (int i = 0; i < firstMismatch; ++i) {
                    result.add(buffer[i]);
                }
            }
            this._numEntriesScanned += (long)limit;
        }
        return (MutableRoaringBitmap)result.get();
    }

    @Override
    public long getNumEntriesScanned() {
        return this._numEntriesScanned;
    }

    private ValueMatcher getValueMatcher(@Nullable ImmutableRoaringBitmap nullBitmap) {
        if (this._reader.isDictionaryEncoded()) {
            return nullBitmap == null ? new DictIdMatcher() : new DictIdMatcherAndNullHandler(nullBitmap);
        }
        switch (this._reader.getStoredType()) {
            case INT: {
                return nullBitmap == null ? new IntMatcher() : new IntMatcherAndNullHandler(nullBitmap);
            }
            case LONG: {
                return nullBitmap == null ? new LongMatcher() : new LongMatcherAndNullHandler(nullBitmap);
            }
            case FLOAT: {
                return nullBitmap == null ? new FloatMatcher() : new FloatMatcherAndNullHandler(nullBitmap);
            }
            case DOUBLE: {
                return nullBitmap == null ? new DoubleMatcher() : new DoubleMatcherAndNullHandler(nullBitmap);
            }
            case BIG_DECIMAL: {
                return nullBitmap == null ? new BigDecimalMatcher() : new BigDecimalMatcherAndNullHandler(nullBitmap);
            }
            case STRING: {
                return nullBitmap == null ? new StringMatcher() : new StringMatcherAndNullHandler(nullBitmap);
            }
            case BYTES: {
                return nullBitmap == null ? new BytesMatcher() : new BytesMatcherAndNullHandler(nullBitmap);
            }
        }
        throw new UnsupportedOperationException();
    }

    private class BytesMatcherAndNullHandler
    implements ValueMatcher {
        private final ImmutableRoaringBitmap _nullBitmap;

        public BytesMatcherAndNullHandler(ImmutableRoaringBitmap nullBitmap) {
            this._nullBitmap = nullBitmap;
        }

        @Override
        public boolean doesValueMatch(int docId) {
            if (this._nullBitmap.contains(docId)) {
                return false;
            }
            return SVScanDocIdIterator.this._predicateEvaluator.applySV(SVScanDocIdIterator.this._reader.getBytes(docId, SVScanDocIdIterator.this._readerContext));
        }
    }

    private class BytesMatcher
    implements ValueMatcher {
        private BytesMatcher() {
        }

        @Override
        public boolean doesValueMatch(int docId) {
            return SVScanDocIdIterator.this._predicateEvaluator.applySV(SVScanDocIdIterator.this._reader.getBytes(docId, SVScanDocIdIterator.this._readerContext));
        }
    }

    private class StringMatcherAndNullHandler
    implements ValueMatcher {
        private final ImmutableRoaringBitmap _nullBitmap;

        public StringMatcherAndNullHandler(ImmutableRoaringBitmap nullBitmap) {
            this._nullBitmap = nullBitmap;
        }

        @Override
        public boolean doesValueMatch(int docId) {
            if (this._nullBitmap.contains(docId)) {
                return false;
            }
            return SVScanDocIdIterator.this._predicateEvaluator.applySV(SVScanDocIdIterator.this._reader.getString(docId, SVScanDocIdIterator.this._readerContext));
        }
    }

    private class StringMatcher
    implements ValueMatcher {
        private StringMatcher() {
        }

        @Override
        public boolean doesValueMatch(int docId) {
            return SVScanDocIdIterator.this._predicateEvaluator.applySV(SVScanDocIdIterator.this._reader.getString(docId, SVScanDocIdIterator.this._readerContext));
        }
    }

    private class BigDecimalMatcherAndNullHandler
    implements ValueMatcher {
        private final ImmutableRoaringBitmap _nullBitmap;

        public BigDecimalMatcherAndNullHandler(ImmutableRoaringBitmap nullBitmap) {
            this._nullBitmap = nullBitmap;
        }

        @Override
        public boolean doesValueMatch(int docId) {
            if (this._nullBitmap.contains(docId)) {
                return false;
            }
            return SVScanDocIdIterator.this._predicateEvaluator.applySV(SVScanDocIdIterator.this._reader.getBigDecimal(docId, SVScanDocIdIterator.this._readerContext));
        }
    }

    private class BigDecimalMatcher
    implements ValueMatcher {
        private BigDecimalMatcher() {
        }

        @Override
        public boolean doesValueMatch(int docId) {
            return SVScanDocIdIterator.this._predicateEvaluator.applySV(SVScanDocIdIterator.this._reader.getBigDecimal(docId, SVScanDocIdIterator.this._readerContext));
        }
    }

    private class DoubleMatcherAndNullHandler
    implements ValueMatcher {
        private final ImmutableRoaringBitmap _nullBitmap;
        private final double[] _buffer = new double[256];

        public DoubleMatcherAndNullHandler(ImmutableRoaringBitmap nullBitmap) {
            this._nullBitmap = nullBitmap;
        }

        @Override
        public boolean doesValueMatch(int docId) {
            if (this._nullBitmap.contains(docId)) {
                return false;
            }
            return SVScanDocIdIterator.this._predicateEvaluator.applySV(SVScanDocIdIterator.this._reader.getDouble(docId, SVScanDocIdIterator.this._readerContext));
        }

        @Override
        public int matchValues(int limit, int[] docIds) {
            SVScanDocIdIterator.this._reader.readValuesSV(docIds, limit, this._buffer, SVScanDocIdIterator.this._readerContext);
            int newLimit = MatcherUtils.removeNullDocs(docIds, this._buffer, limit, this._nullBitmap);
            return SVScanDocIdIterator.this._predicateEvaluator.applySV(newLimit, docIds, this._buffer);
        }
    }

    private class DoubleMatcher
    implements ValueMatcher {
        private final double[] _buffer = new double[256];

        private DoubleMatcher() {
        }

        @Override
        public boolean doesValueMatch(int docId) {
            return SVScanDocIdIterator.this._predicateEvaluator.applySV(SVScanDocIdIterator.this._reader.getDouble(docId, SVScanDocIdIterator.this._readerContext));
        }

        @Override
        public int matchValues(int limit, int[] docIds) {
            SVScanDocIdIterator.this._reader.readValuesSV(docIds, limit, this._buffer, SVScanDocIdIterator.this._readerContext);
            return SVScanDocIdIterator.this._predicateEvaluator.applySV(limit, docIds, this._buffer);
        }
    }

    private class FloatMatcherAndNullHandler
    implements ValueMatcher {
        private final ImmutableRoaringBitmap _nullBitmap;
        private final float[] _buffer = new float[256];

        public FloatMatcherAndNullHandler(ImmutableRoaringBitmap nullBitmap) {
            this._nullBitmap = nullBitmap;
        }

        @Override
        public boolean doesValueMatch(int docId) {
            if (this._nullBitmap.contains(docId)) {
                return false;
            }
            return SVScanDocIdIterator.this._predicateEvaluator.applySV(SVScanDocIdIterator.this._reader.getFloat(docId, SVScanDocIdIterator.this._readerContext));
        }

        @Override
        public int matchValues(int limit, int[] docIds) {
            SVScanDocIdIterator.this._reader.readValuesSV(docIds, limit, this._buffer, SVScanDocIdIterator.this._readerContext);
            int newLimit = MatcherUtils.removeNullDocs(docIds, this._buffer, limit, this._nullBitmap);
            return SVScanDocIdIterator.this._predicateEvaluator.applySV(newLimit, docIds, this._buffer);
        }
    }

    private class FloatMatcher
    implements ValueMatcher {
        private final float[] _buffer = new float[256];

        private FloatMatcher() {
        }

        @Override
        public boolean doesValueMatch(int docId) {
            return SVScanDocIdIterator.this._predicateEvaluator.applySV(SVScanDocIdIterator.this._reader.getFloat(docId, SVScanDocIdIterator.this._readerContext));
        }

        @Override
        public int matchValues(int limit, int[] docIds) {
            SVScanDocIdIterator.this._reader.readValuesSV(docIds, limit, this._buffer, SVScanDocIdIterator.this._readerContext);
            return SVScanDocIdIterator.this._predicateEvaluator.applySV(limit, docIds, this._buffer);
        }
    }

    private class LongMatcherAndNullHandler
    implements ValueMatcher {
        private final ImmutableRoaringBitmap _nullBitmap;
        private final long[] _buffer = new long[256];

        public LongMatcherAndNullHandler(ImmutableRoaringBitmap nullBitmap) {
            this._nullBitmap = nullBitmap;
        }

        @Override
        public boolean doesValueMatch(int docId) {
            if (this._nullBitmap.contains(docId)) {
                return false;
            }
            return SVScanDocIdIterator.this._predicateEvaluator.applySV(SVScanDocIdIterator.this._reader.getLong(docId, SVScanDocIdIterator.this._readerContext));
        }

        @Override
        public int matchValues(int limit, int[] docIds) {
            SVScanDocIdIterator.this._reader.readValuesSV(docIds, limit, this._buffer, SVScanDocIdIterator.this._readerContext);
            int newLimit = MatcherUtils.removeNullDocs(docIds, this._buffer, limit, this._nullBitmap);
            return SVScanDocIdIterator.this._predicateEvaluator.applySV(newLimit, docIds, this._buffer);
        }
    }

    private class LongMatcher
    implements ValueMatcher {
        private final long[] _buffer = new long[256];

        private LongMatcher() {
        }

        @Override
        public boolean doesValueMatch(int docId) {
            return SVScanDocIdIterator.this._predicateEvaluator.applySV(SVScanDocIdIterator.this._reader.getLong(docId, SVScanDocIdIterator.this._readerContext));
        }

        @Override
        public int matchValues(int limit, int[] docIds) {
            SVScanDocIdIterator.this._reader.readValuesSV(docIds, limit, this._buffer, SVScanDocIdIterator.this._readerContext);
            return SVScanDocIdIterator.this._predicateEvaluator.applySV(limit, docIds, this._buffer);
        }
    }

    private class IntMatcherAndNullHandler
    implements ValueMatcher {
        private final ImmutableRoaringBitmap _nullBitmap;
        private final int[] _buffer = new int[256];

        public IntMatcherAndNullHandler(ImmutableRoaringBitmap nullBitmap) {
            this._nullBitmap = nullBitmap;
        }

        @Override
        public boolean doesValueMatch(int docId) {
            if (this._nullBitmap.contains(docId)) {
                return false;
            }
            return SVScanDocIdIterator.this._predicateEvaluator.applySV(SVScanDocIdIterator.this._reader.getInt(docId, SVScanDocIdIterator.this._readerContext));
        }

        @Override
        public int matchValues(int limit, int[] docIds) {
            SVScanDocIdIterator.this._reader.readValuesSV(docIds, limit, this._buffer, SVScanDocIdIterator.this._readerContext);
            int newLimit = MatcherUtils.removeNullDocs(docIds, this._buffer, limit, this._nullBitmap);
            return SVScanDocIdIterator.this._predicateEvaluator.applySV(newLimit, docIds, this._buffer);
        }
    }

    private class IntMatcher
    implements ValueMatcher {
        private final int[] _buffer = new int[256];

        private IntMatcher() {
        }

        @Override
        public boolean doesValueMatch(int docId) {
            return SVScanDocIdIterator.this._predicateEvaluator.applySV(SVScanDocIdIterator.this._reader.getInt(docId, SVScanDocIdIterator.this._readerContext));
        }

        @Override
        public int matchValues(int limit, int[] docIds) {
            SVScanDocIdIterator.this._reader.readValuesSV(docIds, limit, this._buffer, SVScanDocIdIterator.this._readerContext);
            return SVScanDocIdIterator.this._predicateEvaluator.applySV(limit, docIds, this._buffer);
        }
    }

    private class DictIdMatcherAndNullHandler
    implements ValueMatcher {
        private final int[] _buffer = new int[256];
        private final ImmutableRoaringBitmap _nullBitmap;

        public DictIdMatcherAndNullHandler(ImmutableRoaringBitmap nullBitmap) {
            this._nullBitmap = nullBitmap;
        }

        @Override
        public boolean doesValueMatch(int docId) {
            if (this._nullBitmap.contains(docId)) {
                return false;
            }
            return SVScanDocIdIterator.this._predicateEvaluator.applySV(SVScanDocIdIterator.this._reader.getDictId(docId, SVScanDocIdIterator.this._readerContext));
        }

        @Override
        public int matchValues(int limit, int[] docIds) {
            SVScanDocIdIterator.this._reader.readDictIds(docIds, limit, this._buffer, SVScanDocIdIterator.this._readerContext);
            int newLimit = MatcherUtils.removeNullDocs(docIds, this._buffer, limit, this._nullBitmap);
            return SVScanDocIdIterator.this._predicateEvaluator.applySV(newLimit, docIds, this._buffer);
        }
    }

    private class DictIdMatcher
    implements ValueMatcher {
        private final int[] _buffer = new int[256];

        private DictIdMatcher() {
        }

        @Override
        public boolean doesValueMatch(int docId) {
            return SVScanDocIdIterator.this._predicateEvaluator.applySV(SVScanDocIdIterator.this._reader.getDictId(docId, SVScanDocIdIterator.this._readerContext));
        }

        @Override
        public int matchValues(int limit, int[] docIds) {
            SVScanDocIdIterator.this._reader.readDictIds(docIds, limit, this._buffer, SVScanDocIdIterator.this._readerContext);
            return SVScanDocIdIterator.this._predicateEvaluator.applySV(limit, docIds, this._buffer);
        }
    }

    private static class MatcherUtils {
        private MatcherUtils() {
        }

        public static int removeNullDocs(int[] docIds, int[] values, int limit, ImmutableRoaringBitmap nullBitmap) {
            assert (!nullBitmap.isEmpty());
            int copyToIdx = 0;
            for (int i = 0; i < limit; ++i) {
                if (nullBitmap.contains(docIds[i])) continue;
                docIds[copyToIdx] = docIds[i];
                values[copyToIdx++] = values[i];
            }
            return copyToIdx;
        }

        public static int removeNullDocs(int[] docIds, long[] values, int limit, ImmutableRoaringBitmap nullBitmap) {
            assert (!nullBitmap.isEmpty());
            int copyToIdx = 0;
            for (int i = 0; i < limit; ++i) {
                if (nullBitmap.contains(docIds[i])) continue;
                docIds[copyToIdx] = docIds[i];
                values[copyToIdx++] = values[i];
            }
            return copyToIdx;
        }

        public static int removeNullDocs(int[] docIds, float[] values, int limit, ImmutableRoaringBitmap nullBitmap) {
            assert (!nullBitmap.isEmpty());
            int copyToIdx = 0;
            for (int i = 0; i < limit; ++i) {
                if (nullBitmap.contains(docIds[i])) continue;
                docIds[copyToIdx] = docIds[i];
                values[copyToIdx++] = values[i];
            }
            return copyToIdx;
        }

        public static int removeNullDocs(int[] docIds, double[] values, int limit, ImmutableRoaringBitmap nullBitmap) {
            assert (!nullBitmap.isEmpty());
            int copyToIdx = 0;
            for (int i = 0; i < limit; ++i) {
                if (nullBitmap.contains(docIds[i])) continue;
                docIds[copyToIdx] = docIds[i];
                values[copyToIdx++] = values[i];
            }
            return copyToIdx;
        }
    }

    private static interface ValueMatcher {
        public boolean doesValueMatch(int var1);

        default public int matchValues(int limit, int[] docIds) {
            int matchCount = 0;
            for (int i = 0; i < limit; ++i) {
                int docId = docIds[i];
                if (!this.doesValueMatch(docId)) continue;
                docIds[matchCount++] = docId;
            }
            return matchCount;
        }
    }
}

