/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.filter;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.pinot.common.request.context.predicate.Predicate;
import org.apache.pinot.core.operator.filter.AndFilterOperator;
import org.apache.pinot.core.operator.filter.BaseFilterOperator;
import org.apache.pinot.core.operator.filter.BitmapBasedFilterOperator;
import org.apache.pinot.core.operator.filter.EmptyFilterOperator;
import org.apache.pinot.core.operator.filter.ExpressionFilterOperator;
import org.apache.pinot.core.operator.filter.H3InclusionIndexFilterOperator;
import org.apache.pinot.core.operator.filter.H3IndexFilterOperator;
import org.apache.pinot.core.operator.filter.JsonMatchFilterOperator;
import org.apache.pinot.core.operator.filter.MatchAllFilterOperator;
import org.apache.pinot.core.operator.filter.NotFilterOperator;
import org.apache.pinot.core.operator.filter.OrFilterOperator;
import org.apache.pinot.core.operator.filter.RangeIndexBasedFilterOperator;
import org.apache.pinot.core.operator.filter.ScanBasedFilterOperator;
import org.apache.pinot.core.operator.filter.SortedIndexBasedFilterOperator;
import org.apache.pinot.core.operator.filter.TextContainsFilterOperator;
import org.apache.pinot.core.operator.filter.TextMatchFilterOperator;
import org.apache.pinot.core.operator.filter.predicate.PredicateEvaluator;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.segment.spi.datasource.DataSource;

public class FilterOperatorUtils {
    private FilterOperatorUtils() {
    }

    public static BaseFilterOperator getLeafFilterOperator(PredicateEvaluator predicateEvaluator, DataSource dataSource, int numDocs) {
        return FilterOperatorUtils.getLeafFilterOperator(predicateEvaluator, dataSource, numDocs, false);
    }

    public static BaseFilterOperator getLeafFilterOperator(PredicateEvaluator predicateEvaluator, DataSource dataSource, int numDocs, boolean nullHandlingEnabled) {
        if (predicateEvaluator.isAlwaysFalse()) {
            return EmptyFilterOperator.getInstance();
        }
        if (predicateEvaluator.isAlwaysTrue()) {
            return new MatchAllFilterOperator(numDocs);
        }
        Predicate.Type predicateType = predicateEvaluator.getPredicateType();
        if (predicateType == Predicate.Type.RANGE) {
            if (dataSource.getDataSourceMetadata().isSorted() && dataSource.getDictionary() != null) {
                return new SortedIndexBasedFilterOperator(predicateEvaluator, dataSource, numDocs);
            }
            if (dataSource.getRangeIndex() != null) {
                return new RangeIndexBasedFilterOperator(predicateEvaluator, dataSource, numDocs);
            }
            return new ScanBasedFilterOperator(predicateEvaluator, dataSource, numDocs, nullHandlingEnabled);
        }
        if (predicateType == Predicate.Type.REGEXP_LIKE) {
            if (dataSource.getFSTIndex() != null && dataSource.getDataSourceMetadata().isSorted()) {
                return new SortedIndexBasedFilterOperator(predicateEvaluator, dataSource, numDocs);
            }
            if (dataSource.getFSTIndex() != null && dataSource.getInvertedIndex() != null) {
                return new BitmapBasedFilterOperator(predicateEvaluator, dataSource, numDocs);
            }
            return new ScanBasedFilterOperator(predicateEvaluator, dataSource, numDocs, nullHandlingEnabled);
        }
        if (dataSource.getDataSourceMetadata().isSorted() && dataSource.getDictionary() != null) {
            return new SortedIndexBasedFilterOperator(predicateEvaluator, dataSource, numDocs);
        }
        if (dataSource.getInvertedIndex() != null) {
            return new BitmapBasedFilterOperator(predicateEvaluator, dataSource, numDocs);
        }
        return new ScanBasedFilterOperator(predicateEvaluator, dataSource, numDocs, nullHandlingEnabled);
    }

    public static BaseFilterOperator getAndFilterOperator(QueryContext queryContext, List<BaseFilterOperator> filterOperators, int numDocs) {
        ArrayList<BaseFilterOperator> childFilterOperators = new ArrayList<BaseFilterOperator>(filterOperators.size());
        for (BaseFilterOperator filterOperator : filterOperators) {
            if (filterOperator.isResultEmpty()) {
                return EmptyFilterOperator.getInstance();
            }
            if (filterOperator.isResultMatchingAll()) continue;
            childFilterOperators.add(filterOperator);
        }
        int numChildFilterOperators = childFilterOperators.size();
        if (numChildFilterOperators == 0) {
            return new MatchAllFilterOperator(numDocs);
        }
        if (numChildFilterOperators == 1) {
            return (BaseFilterOperator)childFilterOperators.get(0);
        }
        FilterOperatorUtils.reorderAndFilterChildOperators(queryContext, childFilterOperators);
        return new AndFilterOperator(childFilterOperators);
    }

    public static BaseFilterOperator getOrFilterOperator(QueryContext queryContext, List<BaseFilterOperator> filterOperators, int numDocs) {
        ArrayList<BaseFilterOperator> childFilterOperators = new ArrayList<BaseFilterOperator>(filterOperators.size());
        for (BaseFilterOperator filterOperator : filterOperators) {
            if (filterOperator.isResultMatchingAll()) {
                return new MatchAllFilterOperator(numDocs);
            }
            if (filterOperator.isResultEmpty()) continue;
            childFilterOperators.add(filterOperator);
        }
        int numChildFilterOperators = childFilterOperators.size();
        if (numChildFilterOperators == 0) {
            return EmptyFilterOperator.getInstance();
        }
        if (numChildFilterOperators == 1) {
            return (BaseFilterOperator)childFilterOperators.get(0);
        }
        return new OrFilterOperator(childFilterOperators, numDocs);
    }

    public static BaseFilterOperator getNotFilterOperator(QueryContext queryContext, BaseFilterOperator filterOperator, int numDocs) {
        if (filterOperator.isResultMatchingAll()) {
            return EmptyFilterOperator.getInstance();
        }
        if (filterOperator.isResultEmpty()) {
            return new MatchAllFilterOperator(numDocs);
        }
        return new NotFilterOperator(filterOperator, numDocs);
    }

    private static void reorderAndFilterChildOperators(final QueryContext queryContext, List<BaseFilterOperator> filterOperators) {
        filterOperators.sort(new Comparator<BaseFilterOperator>(){

            @Override
            public int compare(BaseFilterOperator o1, BaseFilterOperator o2) {
                return this.getPriority(o1) - this.getPriority(o2);
            }

            int getPriority(BaseFilterOperator filterOperator) {
                if (filterOperator instanceof SortedIndexBasedFilterOperator) {
                    return 0;
                }
                if (filterOperator instanceof BitmapBasedFilterOperator) {
                    return 1;
                }
                if (filterOperator instanceof RangeIndexBasedFilterOperator || filterOperator instanceof TextContainsFilterOperator || filterOperator instanceof TextMatchFilterOperator || filterOperator instanceof JsonMatchFilterOperator || filterOperator instanceof H3IndexFilterOperator || filterOperator instanceof H3InclusionIndexFilterOperator) {
                    return 2;
                }
                if (filterOperator instanceof AndFilterOperator) {
                    return 3;
                }
                if (filterOperator instanceof OrFilterOperator) {
                    return 4;
                }
                if (filterOperator instanceof NotFilterOperator) {
                    return this.getPriority(((NotFilterOperator)filterOperator).getChildFilterOperator());
                }
                if (filterOperator instanceof ScanBasedFilterOperator) {
                    return FilterOperatorUtils.getScanBasedFilterPriority(queryContext, (ScanBasedFilterOperator)filterOperator, 5);
                }
                if (filterOperator instanceof ExpressionFilterOperator) {
                    return 10;
                }
                throw new IllegalStateException(filterOperator.getClass().getSimpleName() + " should not be reordered, remove it from the list before calling this method");
            }
        });
    }

    private static int getScanBasedFilterPriority(QueryContext queryContext, ScanBasedFilterOperator scanBasedFilterOperator, int basePriority) {
        if (queryContext.isSkipScanFilterReorder()) {
            return basePriority;
        }
        if (scanBasedFilterOperator.getDataSourceMetadata().isSingleValue()) {
            return basePriority;
        }
        return basePriority + 1;
    }
}

