/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.filter;

import java.util.ArrayList;
import java.util.List;
import org.apache.pinot.core.common.Operator;
import org.apache.pinot.core.operator.blocks.FilterBlock;
import org.apache.pinot.core.operator.docidsets.FilterBlockDocIdSet;
import org.apache.pinot.core.operator.docidsets.OrDocIdSet;
import org.apache.pinot.core.operator.filter.BaseFilterOperator;
import org.apache.pinot.spi.trace.Tracing;
import org.roaringbitmap.buffer.BufferFastAggregation;
import org.roaringbitmap.buffer.ImmutableRoaringBitmap;

public class OrFilterOperator
extends BaseFilterOperator {
    private static final String EXPLAIN_NAME = "FILTER_OR";
    private final List<BaseFilterOperator> _filterOperators;
    private final int _numDocs;

    public OrFilterOperator(List<BaseFilterOperator> filterOperators, int numDocs) {
        this._filterOperators = filterOperators;
        this._numDocs = numDocs;
    }

    @Override
    protected FilterBlock getNextBlock() {
        Tracing.activeRecording().setNumChildren(this._filterOperators.size());
        ArrayList<FilterBlockDocIdSet> filterBlockDocIdSets = new ArrayList<FilterBlockDocIdSet>(this._filterOperators.size());
        for (BaseFilterOperator filterOperator : this._filterOperators) {
            filterBlockDocIdSets.add(((FilterBlock)filterOperator.nextBlock()).getBlockDocIdSet());
        }
        return new FilterBlock(new OrDocIdSet(filterBlockDocIdSets, this._numDocs));
    }

    @Override
    public String toExplainString() {
        return EXPLAIN_NAME;
    }

    @Override
    public List<Operator> getChildOperators() {
        return new ArrayList<Operator>(this._filterOperators);
    }

    @Override
    public boolean canOptimizeCount() {
        boolean allChildrenProduceBitmaps = true;
        for (BaseFilterOperator child : this._filterOperators) {
            allChildrenProduceBitmaps &= child.canProduceBitmaps();
        }
        return allChildrenProduceBitmaps;
    }

    @Override
    public int getNumMatchingDocs() {
        if (this._filterOperators.size() == 2) {
            return this._filterOperators.get(0).getBitmaps().orCardinality(this._filterOperators.get(1).getBitmaps());
        }
        ImmutableRoaringBitmap[] bitmaps = new ImmutableRoaringBitmap[this._filterOperators.size()];
        for (int i = 0; i < this._filterOperators.size(); ++i) {
            bitmaps[i] = this._filterOperators.get(i).getBitmaps().reduce();
        }
        return BufferFastAggregation.orCardinality((ImmutableRoaringBitmap[])bitmaps);
    }
}

