/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.transform.function;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.pinot.core.operator.blocks.ProjectionBlock;
import org.apache.pinot.core.operator.transform.TransformResultMetadata;
import org.apache.pinot.core.operator.transform.function.BaseTransformFunction;
import org.apache.pinot.core.operator.transform.function.LiteralTransformFunction;
import org.apache.pinot.core.operator.transform.function.TransformFunction;
import org.apache.pinot.segment.spi.datasource.DataSource;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.utils.ArrayCopyUtils;

public class AdditionTransformFunction
extends BaseTransformFunction {
    public static final String FUNCTION_NAME = "add";
    private FieldSpec.DataType _resultDataType;
    private double _literalDoubleSum = 0.0;
    private BigDecimal _literalBigDecimalSum = BigDecimal.ZERO;
    private List<TransformFunction> _transformFunctions = new ArrayList<TransformFunction>();
    private double[] _doubleSums;
    private BigDecimal[] _bigDecimalSums;

    @Override
    public String getName() {
        return FUNCTION_NAME;
    }

    @Override
    public void init(List<TransformFunction> arguments, Map<String, DataSource> dataSourceMap) {
        if (arguments.size() < 2) {
            throw new IllegalArgumentException("At least 2 arguments are required for ADD transform function");
        }
        this._resultDataType = FieldSpec.DataType.DOUBLE;
        for (TransformFunction argument : arguments) {
            if (argument instanceof LiteralTransformFunction) {
                LiteralTransformFunction literalTransformFunction = (LiteralTransformFunction)argument;
                FieldSpec.DataType dataType = literalTransformFunction.getResultMetadata().getDataType();
                if (dataType == FieldSpec.DataType.BIG_DECIMAL) {
                    this._literalBigDecimalSum = this._literalBigDecimalSum.add(new BigDecimal(literalTransformFunction.getLiteral()));
                    this._resultDataType = FieldSpec.DataType.BIG_DECIMAL;
                    continue;
                }
                this._literalDoubleSum += Double.parseDouble(((LiteralTransformFunction)argument).getLiteral());
                continue;
            }
            if (!argument.getResultMetadata().isSingleValue()) {
                throw new IllegalArgumentException("All the arguments of ADD transform function must be single-valued");
            }
            if (argument.getResultMetadata().getDataType() == FieldSpec.DataType.BIG_DECIMAL) {
                this._resultDataType = FieldSpec.DataType.BIG_DECIMAL;
            }
            this._transformFunctions.add(argument);
        }
        if (this._resultDataType == FieldSpec.DataType.BIG_DECIMAL) {
            this._literalBigDecimalSum = this._literalBigDecimalSum.add(BigDecimal.valueOf(this._literalDoubleSum));
        }
    }

    @Override
    public TransformResultMetadata getResultMetadata() {
        if (this._resultDataType == FieldSpec.DataType.BIG_DECIMAL) {
            return BIG_DECIMAL_SV_NO_DICTIONARY_METADATA;
        }
        return DOUBLE_SV_NO_DICTIONARY_METADATA;
    }

    @Override
    public double[] transformToDoubleValuesSV(ProjectionBlock projectionBlock) {
        int length = projectionBlock.getNumDocs();
        if (this._doubleSums == null || this._doubleSums.length < length) {
            this._doubleSums = new double[length];
        }
        if (this._resultDataType == FieldSpec.DataType.BIG_DECIMAL) {
            BigDecimal[] values = this.transformToBigDecimalValuesSV(projectionBlock);
            ArrayCopyUtils.copy((BigDecimal[])values, (double[])this._doubleSums, (int)length);
        } else {
            Arrays.fill(this._doubleSums, 0, length, this._literalDoubleSum);
            for (TransformFunction transformFunction : this._transformFunctions) {
                double[] values = transformFunction.transformToDoubleValuesSV(projectionBlock);
                for (int i = 0; i < length; ++i) {
                    int n = i;
                    this._doubleSums[n] = this._doubleSums[n] + values[i];
                }
            }
        }
        return this._doubleSums;
    }

    @Override
    public BigDecimal[] transformToBigDecimalValuesSV(ProjectionBlock projectionBlock) {
        int length = projectionBlock.getNumDocs();
        if (this._bigDecimalSums == null || this._bigDecimalSums.length < length) {
            this._bigDecimalSums = new BigDecimal[length];
        }
        if (this._resultDataType == FieldSpec.DataType.DOUBLE) {
            double[] values = this.transformToDoubleValuesSV(projectionBlock);
            ArrayCopyUtils.copy((double[])values, (BigDecimal[])this._bigDecimalSums, (int)length);
        } else {
            Arrays.fill(this._bigDecimalSums, 0, length, this._literalBigDecimalSum);
            for (TransformFunction transformFunction : this._transformFunctions) {
                BigDecimal[] values = transformFunction.transformToBigDecimalValuesSV(projectionBlock);
                for (int i = 0; i < length; ++i) {
                    this._bigDecimalSums[i] = this._bigDecimalSums[i].add(values[i]);
                }
            }
        }
        return this._bigDecimalSums;
    }
}

