/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.transform.function;

import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.pinot.core.operator.blocks.ProjectionBlock;
import org.apache.pinot.core.operator.transform.TransformResultMetadata;
import org.apache.pinot.core.operator.transform.function.BaseTransformFunction;
import org.apache.pinot.core.operator.transform.function.LiteralTransformFunction;
import org.apache.pinot.core.operator.transform.function.TransformFunction;
import org.apache.pinot.segment.spi.datasource.DataSource;
import org.apache.pinot.spi.data.FieldSpec;

public class ArrayMaxTransformFunction
extends BaseTransformFunction {
    public static final String FUNCTION_NAME = "arrayMax";
    private int[] _intValuesSV;
    private long[] _longValuesSV;
    private float[] _floatValuesSV;
    private double[] _doubleValuesSV;
    private String[] _stringValuesSV;
    private TransformFunction _argument;
    private TransformResultMetadata _resultMetadata;

    @Override
    public String getName() {
        return FUNCTION_NAME;
    }

    @Override
    public void init(List<TransformFunction> arguments, Map<String, DataSource> dataSourceMap) {
        if (arguments.size() != 1) {
            throw new IllegalArgumentException("Exactly 1 argument is required for ArrayMax transform function");
        }
        TransformFunction firstArgument = arguments.get(0);
        if (firstArgument instanceof LiteralTransformFunction || firstArgument.getResultMetadata().isSingleValue()) {
            throw new IllegalArgumentException("The argument of ArrayMax transform function must be a multi-valued column or a transform function");
        }
        this._resultMetadata = new TransformResultMetadata(firstArgument.getResultMetadata().getDataType(), true, false);
        this._argument = firstArgument;
    }

    @Override
    public TransformResultMetadata getResultMetadata() {
        return this._resultMetadata;
    }

    @Override
    public int[] transformToIntValuesSV(ProjectionBlock projectionBlock) {
        if (this._argument.getResultMetadata().getDataType().getStoredType() != FieldSpec.DataType.INT) {
            return super.transformToIntValuesSV(projectionBlock);
        }
        int length = projectionBlock.getNumDocs();
        if (this._intValuesSV == null || this._intValuesSV.length < length) {
            this._intValuesSV = new int[length];
        }
        int[][] intValuesMV = this._argument.transformToIntValuesMV(projectionBlock);
        for (int i = 0; i < length; ++i) {
            int maxRes = Integer.MIN_VALUE;
            for (int value : intValuesMV[i]) {
                maxRes = Math.max(maxRes, value);
            }
            this._intValuesSV[i] = maxRes;
        }
        return this._intValuesSV;
    }

    @Override
    public long[] transformToLongValuesSV(ProjectionBlock projectionBlock) {
        if (this._argument.getResultMetadata().getDataType().getStoredType() != FieldSpec.DataType.LONG) {
            return super.transformToLongValuesSV(projectionBlock);
        }
        int length = projectionBlock.getNumDocs();
        if (this._longValuesSV == null || this._longValuesSV.length < length) {
            this._longValuesSV = new long[length];
        }
        long[][] longValuesMV = this._argument.transformToLongValuesMV(projectionBlock);
        for (int i = 0; i < length; ++i) {
            long maxRes = Long.MIN_VALUE;
            for (long value : longValuesMV[i]) {
                maxRes = Math.max(maxRes, value);
            }
            this._longValuesSV[i] = maxRes;
        }
        return this._longValuesSV;
    }

    @Override
    public float[] transformToFloatValuesSV(ProjectionBlock projectionBlock) {
        if (this._argument.getResultMetadata().getDataType().getStoredType() != FieldSpec.DataType.FLOAT) {
            return super.transformToFloatValuesSV(projectionBlock);
        }
        int length = projectionBlock.getNumDocs();
        if (this._floatValuesSV == null || this._floatValuesSV.length < length) {
            this._floatValuesSV = new float[length];
        }
        float[][] floatValuesMV = this._argument.transformToFloatValuesMV(projectionBlock);
        for (int i = 0; i < length; ++i) {
            float maxRes = Float.NEGATIVE_INFINITY;
            for (float value : floatValuesMV[i]) {
                maxRes = Math.max(maxRes, value);
            }
            this._floatValuesSV[i] = maxRes;
        }
        return this._floatValuesSV;
    }

    @Override
    public double[] transformToDoubleValuesSV(ProjectionBlock projectionBlock) {
        if (this._argument.getResultMetadata().getDataType().getStoredType() != FieldSpec.DataType.DOUBLE) {
            return super.transformToDoubleValuesSV(projectionBlock);
        }
        int length = projectionBlock.getNumDocs();
        if (this._doubleValuesSV == null || this._doubleValuesSV.length < length) {
            this._doubleValuesSV = new double[length];
        }
        double[][] doubleValuesMV = this._argument.transformToDoubleValuesMV(projectionBlock);
        for (int i = 0; i < length; ++i) {
            double maxRes = Double.NEGATIVE_INFINITY;
            for (double value : doubleValuesMV[i]) {
                maxRes = Math.max(maxRes, value);
            }
            this._doubleValuesSV[i] = maxRes;
        }
        return this._doubleValuesSV;
    }

    @Override
    public String[] transformToStringValuesSV(ProjectionBlock projectionBlock) {
        if (this._argument.getResultMetadata().getDataType().getStoredType() != FieldSpec.DataType.STRING) {
            return super.transformToStringValuesSV(projectionBlock);
        }
        int length = projectionBlock.getNumDocs();
        if (this._stringValuesSV == null || this._stringValuesSV.length < length) {
            this._stringValuesSV = new String[length];
        }
        String[][] stringValuesMV = this._argument.transformToStringValuesMV(projectionBlock);
        for (int i = 0; i < length; ++i) {
            String maxRes = null;
            for (String value : stringValuesMV[i]) {
                if (StringUtils.compare(maxRes, (String)value) >= 0) continue;
                maxRes = value;
            }
            this._stringValuesSV[i] = maxRes;
        }
        return this._stringValuesSV;
    }
}

