/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.transform.function;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import org.apache.pinot.common.function.TransformFunctionType;
import org.apache.pinot.core.operator.blocks.ProjectionBlock;
import org.apache.pinot.core.operator.transform.TransformResultMetadata;
import org.apache.pinot.core.operator.transform.function.BaseTransformFunction;
import org.apache.pinot.core.operator.transform.function.LiteralTransformFunction;
import org.apache.pinot.core.operator.transform.function.TransformFunction;
import org.apache.pinot.segment.spi.datasource.DataSource;
import org.apache.pinot.spi.data.FieldSpec;
import org.joda.time.Chronology;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeZone;
import org.joda.time.chrono.ISOChronology;

public abstract class DateTimeTransformFunction
extends BaseTransformFunction {
    private static final TransformResultMetadata METADATA = new TransformResultMetadata(FieldSpec.DataType.INT, true, false);
    private final String _name;
    private TransformFunction _timestampsFunction;
    protected static final Chronology UTC = ISOChronology.getInstanceUTC();
    protected Chronology _chronology;

    protected DateTimeTransformFunction(String name) {
        this._name = name;
    }

    @Override
    public void init(List<TransformFunction> arguments, Map<String, DataSource> dataSourceMap) {
        Preconditions.checkArgument((!arguments.isEmpty() && arguments.size() <= 2 ? 1 : 0) != 0, (String)"%s takes one or two arguments", (Object)this._name);
        this._timestampsFunction = arguments.get(0);
        if (arguments.size() == 2) {
            Preconditions.checkArgument((boolean)(arguments.get(1) instanceof LiteralTransformFunction), (String)"zoneId parameter %s must be a literal", (Object)this._name);
            this._chronology = ISOChronology.getInstance((DateTimeZone)DateTimeZone.forID((String)((LiteralTransformFunction)arguments.get(1)).getLiteral()));
        } else {
            this._chronology = UTC;
        }
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public TransformResultMetadata getResultMetadata() {
        return METADATA;
    }

    @Override
    public int[] transformToIntValuesSV(ProjectionBlock projectionBlock) {
        int numDocs = projectionBlock.getNumDocs();
        if (this._intValuesSV == null || this._intValuesSV.length < numDocs) {
            this._intValuesSV = new int[numDocs];
        }
        long[] timestamps = this._timestampsFunction.transformToLongValuesSV(projectionBlock);
        this.convert(timestamps, numDocs, this._intValuesSV);
        return this._intValuesSV;
    }

    protected abstract void convert(long[] var1, int var2, int[] var3);

    public static final class Quarter
    extends DateTimeTransformFunction {
        public Quarter() {
            super(TransformFunctionType.QUARTER.getName());
        }

        @Override
        protected void convert(long[] timestamps, int numDocs, int[] output) {
            DateTimeField accessor = this._chronology.monthOfYear();
            for (int i = 0; i < numDocs; ++i) {
                output[i] = (accessor.get(timestamps[i]) - 1) / 3 + 1;
            }
        }
    }

    public static final class Millisecond
    extends DateTimeTransformFunction {
        public Millisecond() {
            super(TransformFunctionType.MILLISECOND.getName());
        }

        @Override
        protected void convert(long[] timestamps, int numDocs, int[] output) {
            DateTimeField accessor = this._chronology.millisOfSecond();
            for (int i = 0; i < numDocs; ++i) {
                output[i] = accessor.get(timestamps[i]);
            }
        }
    }

    public static final class Second
    extends DateTimeTransformFunction {
        public Second() {
            super(TransformFunctionType.SECOND.getName());
        }

        @Override
        protected void convert(long[] timestamps, int numDocs, int[] output) {
            DateTimeField accessor = this._chronology.secondOfMinute();
            for (int i = 0; i < numDocs; ++i) {
                output[i] = accessor.get(timestamps[i]);
            }
        }
    }

    public static final class Minute
    extends DateTimeTransformFunction {
        public Minute() {
            super(TransformFunctionType.MINUTE.getName());
        }

        @Override
        protected void convert(long[] timestamps, int numDocs, int[] output) {
            DateTimeField accessor = this._chronology.minuteOfHour();
            for (int i = 0; i < numDocs; ++i) {
                output[i] = accessor.get(timestamps[i]);
            }
        }
    }

    public static final class Hour
    extends DateTimeTransformFunction {
        public Hour() {
            super(TransformFunctionType.HOUR.getName());
        }

        @Override
        protected void convert(long[] timestamps, int numDocs, int[] output) {
            DateTimeField accessor = this._chronology.hourOfDay();
            for (int i = 0; i < numDocs; ++i) {
                output[i] = accessor.get(timestamps[i]);
            }
        }
    }

    public static final class DayOfWeek
    extends DateTimeTransformFunction {
        public DayOfWeek() {
            super(TransformFunctionType.DAY_OF_WEEK.getName());
        }

        @Override
        protected void convert(long[] timestamps, int numDocs, int[] output) {
            DateTimeField accessor = this._chronology.dayOfWeek();
            for (int i = 0; i < numDocs; ++i) {
                output[i] = accessor.get(timestamps[i]);
            }
        }
    }

    public static final class DayOfMonth
    extends DateTimeTransformFunction {
        public DayOfMonth() {
            super(TransformFunctionType.DAY_OF_MONTH.getName());
        }

        @Override
        protected void convert(long[] timestamps, int numDocs, int[] output) {
            DateTimeField accessor = this._chronology.dayOfMonth();
            for (int i = 0; i < numDocs; ++i) {
                output[i] = accessor.get(timestamps[i]);
            }
        }
    }

    public static final class DayOfYear
    extends DateTimeTransformFunction {
        public DayOfYear() {
            super(TransformFunctionType.DAY_OF_YEAR.getName());
        }

        @Override
        protected void convert(long[] timestamps, int numDocs, int[] output) {
            DateTimeField accessor = this._chronology.dayOfYear();
            for (int i = 0; i < numDocs; ++i) {
                output[i] = accessor.get(timestamps[i]);
            }
        }
    }

    public static final class WeekOfYear
    extends DateTimeTransformFunction {
        public WeekOfYear() {
            super(TransformFunctionType.WEEK_OF_YEAR.getName());
        }

        @Override
        protected void convert(long[] timestamps, int numDocs, int[] output) {
            DateTimeField accessor = this._chronology.weekOfWeekyear();
            for (int i = 0; i < numDocs; ++i) {
                output[i] = accessor.get(timestamps[i]);
            }
        }
    }

    public static final class Month
    extends DateTimeTransformFunction {
        public Month() {
            super(TransformFunctionType.MONTH_OF_YEAR.getName());
        }

        @Override
        protected void convert(long[] timestamps, int numDocs, int[] output) {
            DateTimeField accessor = this._chronology.monthOfYear();
            for (int i = 0; i < numDocs; ++i) {
                output[i] = accessor.get(timestamps[i]);
            }
        }
    }

    public static final class YearOfWeek
    extends DateTimeTransformFunction {
        public YearOfWeek() {
            super(TransformFunctionType.YEAR_OF_WEEK.getName());
        }

        @Override
        protected void convert(long[] timestamps, int numDocs, int[] output) {
            DateTimeField accessor = this._chronology.weekyear();
            for (int i = 0; i < numDocs; ++i) {
                output[i] = accessor.get(timestamps[i]);
            }
        }
    }

    public static final class Year
    extends DateTimeTransformFunction {
        public Year() {
            super(TransformFunctionType.YEAR.getName());
        }

        @Override
        protected void convert(long[] timestamps, int numDocs, int[] output) {
            DateTimeField accessor = this._chronology.year();
            for (int i = 0; i < numDocs; ++i) {
                output[i] = accessor.get(timestamps[i]);
            }
        }
    }
}

