/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.transform.function;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.pinot.common.function.TransformFunctionType;
import org.apache.pinot.core.operator.blocks.ProjectionBlock;
import org.apache.pinot.core.operator.transform.TransformResultMetadata;
import org.apache.pinot.core.operator.transform.function.BaseTransformFunction;
import org.apache.pinot.core.operator.transform.function.IdentifierTransformFunction;
import org.apache.pinot.core.operator.transform.function.TransformFunction;
import org.apache.pinot.segment.spi.datasource.DataSource;
import org.apache.pinot.segment.spi.index.reader.NullValueVectorReader;
import org.roaringbitmap.PeekableIntIterator;

public class IsNotNullTransformFunction
extends BaseTransformFunction {
    private int[] _results;
    private PeekableIntIterator _nullValueVectorIterator;

    @Override
    public String getName() {
        return TransformFunctionType.IS_NOT_NULL.getName();
    }

    @Override
    public void init(List<TransformFunction> arguments, Map<String, DataSource> dataSourceMap) {
        Preconditions.checkArgument((arguments.size() == 1 ? 1 : 0) != 0, (Object)"Exact 1 argument is required for IS_NOT_NULL operator function");
        TransformFunction transformFunction = arguments.get(0);
        if (!(transformFunction instanceof IdentifierTransformFunction)) {
            throw new IllegalArgumentException("Only column names are supported in IS_NOT_NULL. Support for functions is planned for future release");
        }
        String columnName = ((IdentifierTransformFunction)transformFunction).getColumnName();
        NullValueVectorReader nullValueVectorReader = dataSourceMap.get(columnName).getNullValueVector();
        this._nullValueVectorIterator = nullValueVectorReader != null ? nullValueVectorReader.getNullBitmap().getIntIterator() : null;
    }

    @Override
    public TransformResultMetadata getResultMetadata() {
        return BOOLEAN_SV_NO_DICTIONARY_METADATA;
    }

    @Override
    public int[] transformToIntValuesSV(ProjectionBlock projectionBlock) {
        int length = projectionBlock.getNumDocs();
        if (this._results == null || this._results.length < length) {
            this._results = new int[length];
        }
        int[] docIds = projectionBlock.getDocIds();
        Arrays.fill(this._results, 1);
        if (this._nullValueVectorIterator != null) {
            int currentDocIdIndex = 0;
            while (this._nullValueVectorIterator.hasNext() & currentDocIdIndex < length) {
                this._nullValueVectorIterator.advanceIfNeeded(docIds[currentDocIdIndex]);
                currentDocIdIndex = Arrays.binarySearch(docIds, currentDocIdIndex, length, this._nullValueVectorIterator.next());
                if (currentDocIdIndex >= 0) {
                    this._results[currentDocIdIndex] = 0;
                    ++currentDocIdIndex;
                    continue;
                }
                currentDocIdIndex = -currentDocIdIndex - 1;
            }
        }
        return this._results;
    }
}

