/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.transform.function;

import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.Map;
import org.apache.pinot.core.operator.blocks.ProjectionBlock;
import org.apache.pinot.core.operator.transform.TransformResultMetadata;
import org.apache.pinot.core.operator.transform.function.BaseTransformFunction;
import org.apache.pinot.core.operator.transform.function.LiteralTransformFunction;
import org.apache.pinot.core.operator.transform.function.TransformFunction;
import org.apache.pinot.segment.spi.datasource.DataSource;
import org.apache.pinot.spi.data.FieldSpec;

public abstract class SingleParamMathTransformFunction
extends BaseTransformFunction {
    private TransformFunction _transformFunction;

    @Override
    public void init(List<TransformFunction> arguments, Map<String, DataSource> dataSourceMap) {
        Preconditions.checkArgument((arguments.size() == 1 ? 1 : 0) != 0, (String)"Exactly 1 argument is required for transform function: %s", (Object)this.getName());
        TransformFunction transformFunction = arguments.get(0);
        Preconditions.checkArgument((!(transformFunction instanceof LiteralTransformFunction) ? 1 : 0) != 0, (String)"Argument cannot be literal for transform function: %s", (Object)this.getName());
        Preconditions.checkArgument((boolean)transformFunction.getResultMetadata().isSingleValue(), (String)"Argument must be single-valued for transform function: %s", (Object)this.getName());
        this._transformFunction = transformFunction;
    }

    @Override
    public TransformResultMetadata getResultMetadata() {
        if (this._transformFunction.getResultMetadata().getDataType() == FieldSpec.DataType.BIG_DECIMAL) {
            return BIG_DECIMAL_SV_NO_DICTIONARY_METADATA;
        }
        return DOUBLE_SV_NO_DICTIONARY_METADATA;
    }

    @Override
    public double[] transformToDoubleValuesSV(ProjectionBlock projectionBlock) {
        int length = projectionBlock.getNumDocs();
        if (this._doubleValuesSV == null || this._doubleValuesSV.length < length) {
            this._doubleValuesSV = new double[length];
        }
        double[] values = this._transformFunction.transformToDoubleValuesSV(projectionBlock);
        this.applyMathOperator(values, projectionBlock.getNumDocs());
        return this._doubleValuesSV;
    }

    @Override
    public BigDecimal[] transformToBigDecimalValuesSV(ProjectionBlock projectionBlock) {
        int length = projectionBlock.getNumDocs();
        if (this._bigDecimalValuesSV == null || this._bigDecimalValuesSV.length < length) {
            this._bigDecimalValuesSV = new BigDecimal[length];
        }
        BigDecimal[] values = this._transformFunction.transformToBigDecimalValuesSV(projectionBlock);
        this.applyMathOperator(values, projectionBlock.getNumDocs());
        return this._bigDecimalValuesSV;
    }

    protected abstract void applyMathOperator(double[] var1, int var2);

    protected void applyMathOperator(BigDecimal[] values, int length) {
        throw new UnsupportedOperationException("Math operator does not support BIG_DECIMAL data type");
    }

    public static class SignTransformFunction
    extends SingleParamMathTransformFunction {
        public static final String FUNCTION_NAME = "sign";

        @Override
        public String getName() {
            return FUNCTION_NAME;
        }

        @Override
        protected void applyMathOperator(double[] values, int length) {
            for (int i = 0; i < length; ++i) {
                this._doubleValuesSV[i] = Math.signum(values[i]);
            }
        }
    }

    public static class SqrtTransformFunction
    extends SingleParamMathTransformFunction {
        public static final String FUNCTION_NAME = "sqrt";

        @Override
        public String getName() {
            return FUNCTION_NAME;
        }

        @Override
        protected void applyMathOperator(double[] values, int length) {
            for (int i = 0; i < length; ++i) {
                this._doubleValuesSV[i] = Math.sqrt(values[i]);
            }
        }
    }

    public static class Log10TransformFunction
    extends SingleParamMathTransformFunction {
        public static final String FUNCTION_NAME = "log10";

        @Override
        public String getName() {
            return FUNCTION_NAME;
        }

        @Override
        protected void applyMathOperator(double[] values, int length) {
            for (int i = 0; i < length; ++i) {
                this._doubleValuesSV[i] = Math.log10(values[i]);
            }
        }
    }

    public static class Log2TransformFunction
    extends SingleParamMathTransformFunction {
        public static final String FUNCTION_NAME = "log2";
        public static final double LOG_BASE = Math.log(2.0);

        @Override
        public String getName() {
            return FUNCTION_NAME;
        }

        @Override
        protected void applyMathOperator(double[] values, int length) {
            for (int i = 0; i < length; ++i) {
                this._doubleValuesSV[i] = Math.log(values[i]) / LOG_BASE;
            }
        }
    }

    public static class LnTransformFunction
    extends SingleParamMathTransformFunction {
        public static final String FUNCTION_NAME = "ln";

        @Override
        public String getName() {
            return FUNCTION_NAME;
        }

        @Override
        protected void applyMathOperator(double[] values, int length) {
            for (int i = 0; i < length; ++i) {
                this._doubleValuesSV[i] = Math.log(values[i]);
            }
        }
    }

    public static class FloorTransformFunction
    extends SingleParamMathTransformFunction {
        public static final String FUNCTION_NAME = "floor";

        @Override
        public String getName() {
            return FUNCTION_NAME;
        }

        @Override
        protected void applyMathOperator(double[] values, int length) {
            for (int i = 0; i < length; ++i) {
                this._doubleValuesSV[i] = Math.floor(values[i]);
            }
        }

        @Override
        protected void applyMathOperator(BigDecimal[] values, int length) {
            for (int i = 0; i < length; ++i) {
                this._bigDecimalValuesSV[i] = values[i].setScale(0, RoundingMode.FLOOR);
            }
        }
    }

    public static class ExpTransformFunction
    extends SingleParamMathTransformFunction {
        public static final String FUNCTION_NAME = "exp";

        @Override
        public String getName() {
            return FUNCTION_NAME;
        }

        @Override
        protected void applyMathOperator(double[] values, int length) {
            for (int i = 0; i < length; ++i) {
                this._doubleValuesSV[i] = Math.exp(values[i]);
            }
        }
    }

    public static class CeilTransformFunction
    extends SingleParamMathTransformFunction {
        public static final String FUNCTION_NAME = "ceil";

        @Override
        public String getName() {
            return FUNCTION_NAME;
        }

        @Override
        protected void applyMathOperator(double[] values, int length) {
            for (int i = 0; i < length; ++i) {
                this._doubleValuesSV[i] = Math.ceil(values[i]);
            }
        }

        @Override
        protected void applyMathOperator(BigDecimal[] values, int length) {
            for (int i = 0; i < length; ++i) {
                this._bigDecimalValuesSV[i] = values[i].setScale(0, RoundingMode.CEILING);
            }
        }
    }

    public static class AbsTransformFunction
    extends SingleParamMathTransformFunction {
        public static final String FUNCTION_NAME = "abs";

        @Override
        public String getName() {
            return FUNCTION_NAME;
        }

        @Override
        protected void applyMathOperator(double[] values, int length) {
            for (int i = 0; i < length; ++i) {
                this._doubleValuesSV[i] = Math.abs(values[i]);
            }
        }

        @Override
        protected void applyMathOperator(BigDecimal[] values, int length) {
            for (int i = 0; i < length; ++i) {
                this._bigDecimalValuesSV[i] = values[i].abs();
            }
        }
    }
}

