/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.plan;

import com.google.common.base.Preconditions;
import java.util.List;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.core.operator.streaming.StreamingSelectionOnlyOperator;
import org.apache.pinot.core.operator.transform.TransformOperator;
import org.apache.pinot.core.plan.PlanNode;
import org.apache.pinot.core.plan.TransformPlanNode;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.core.query.selection.SelectionOperatorUtils;
import org.apache.pinot.segment.spi.IndexSegment;

public class StreamingSelectionPlanNode
implements PlanNode {
    private final IndexSegment _indexSegment;
    private final QueryContext _queryContext;

    public StreamingSelectionPlanNode(IndexSegment indexSegment, QueryContext queryContext) {
        Preconditions.checkState((queryContext.getOrderByExpressions() == null ? 1 : 0) != 0, (Object)"Selection order-by is not supported for streaming");
        this._indexSegment = indexSegment;
        this._queryContext = queryContext;
    }

    public StreamingSelectionOnlyOperator run() {
        List<ExpressionContext> expressions = SelectionOperatorUtils.extractExpressions(this._queryContext, this._indexSegment);
        TransformOperator transformOperator = new TransformPlanNode(this._indexSegment, this._queryContext, expressions, Math.min(this._queryContext.getLimit(), 10000)).run();
        return new StreamingSelectionOnlyOperator(this._indexSegment, this._queryContext, expressions, transformOperator);
    }
}

