/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.function;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.theta.AnotB;
import org.apache.datasketches.theta.Intersection;
import org.apache.datasketches.theta.SetOperationBuilder;
import org.apache.datasketches.theta.Sketch;
import org.apache.datasketches.theta.Union;
import org.apache.datasketches.theta.UpdateSketch;
import org.apache.datasketches.theta.UpdateSketchBuilder;
import org.apache.pinot.common.request.Expression;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.request.context.FilterContext;
import org.apache.pinot.common.request.context.FunctionContext;
import org.apache.pinot.common.request.context.RequestContextUtils;
import org.apache.pinot.common.request.context.predicate.Predicate;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.operator.filter.predicate.PredicateEvaluator;
import org.apache.pinot.core.operator.filter.predicate.PredicateEvaluatorProvider;
import org.apache.pinot.core.query.aggregation.AggregationResultHolder;
import org.apache.pinot.core.query.aggregation.ObjectAggregationResultHolder;
import org.apache.pinot.core.query.aggregation.function.BaseSingleInputAggregationFunction;
import org.apache.pinot.core.query.aggregation.groupby.GroupByResultHolder;
import org.apache.pinot.core.query.aggregation.groupby.ObjectGroupByResultHolder;
import org.apache.pinot.segment.spi.AggregationFunctionType;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.sql.parsers.CalciteSqlParser;

public class DistinctCountThetaSketchAggregationFunction
extends BaseSingleInputAggregationFunction<List<Sketch>, Comparable> {
    private static final String SET_UNION = "setunion";
    private static final String SET_INTERSECT = "setintersect";
    private static final String SET_DIFF = "setdiff";
    private static final String DEFAULT_SKETCH_IDENTIFIER = "$0";
    private static final Sketch EMPTY_SKETCH = new UpdateSketchBuilder().build().compact();
    private final List<ExpressionContext> _inputExpressions;
    private final boolean _includeDefaultSketch;
    private final List<FilterEvaluator> _filterEvaluators;
    private final ExpressionContext _postAggregationExpression;
    private final UpdateSketchBuilder _updateSketchBuilder = new UpdateSketchBuilder();
    private final SetOperationBuilder _setOperationBuilder = new SetOperationBuilder();

    public DistinctCountThetaSketchAggregationFunction(List<ExpressionContext> arguments) {
        super(arguments.get(0));
        int numArguments = arguments.size();
        if (numArguments > 1) {
            ExpressionContext paramsExpression = arguments.get(1);
            Preconditions.checkArgument((paramsExpression.getType() == ExpressionContext.Type.LITERAL ? 1 : 0) != 0, (Object)"Second argument of DISTINCT_COUNT_THETA_SKETCH aggregation function must be literal (parameters)");
            Parameters parameters = new Parameters(paramsExpression.getLiteral());
            int nominalEntries = parameters.getNominalEntries();
            this._updateSketchBuilder.setNominalEntries(nominalEntries);
            this._setOperationBuilder.setNominalEntries(nominalEntries);
        }
        if (numArguments < 4) {
            this._inputExpressions = Collections.singletonList(this._expression);
            this._includeDefaultSketch = true;
            this._filterEvaluators = Collections.emptyList();
            this._postAggregationExpression = ExpressionContext.forIdentifier((String)DEFAULT_SKETCH_IDENTIFIER);
        } else {
            this._inputExpressions = new ArrayList<ExpressionContext>();
            this._inputExpressions.add(this._expression);
            HashMap<ExpressionContext, Integer> expressionIndexMap = new HashMap<ExpressionContext, Integer>();
            expressionIndexMap.put(this._expression, 0);
            this._filterEvaluators = new ArrayList<FilterEvaluator>(numArguments - 3);
            for (int i = 2; i < numArguments - 1; ++i) {
                ExpressionContext filterExpression = arguments.get(i);
                Preconditions.checkArgument((filterExpression.getType() == ExpressionContext.Type.LITERAL ? 1 : 0) != 0, (Object)"Third to second last argument of DISTINCT_COUNT_THETA_SKETCH aggregation function must be literal (filter expression)");
                FilterContext filter = RequestContextUtils.getFilter((Expression)CalciteSqlParser.compileToExpression((String)filterExpression.getLiteral()));
                DistinctCountThetaSketchAggregationFunction.collectExpressions(filter, this._inputExpressions, expressionIndexMap);
                this._filterEvaluators.add(DistinctCountThetaSketchAggregationFunction.getFilterEvaluator(filter, expressionIndexMap));
            }
            ExpressionContext postAggregationExpression = arguments.get(numArguments - 1);
            Preconditions.checkArgument((postAggregationExpression.getType() == ExpressionContext.Type.LITERAL ? 1 : 0) != 0, (Object)"Last argument of DISTINCT_COUNT_THETA_SKETCH aggregation function must be literal (post-aggregation expression)");
            this._postAggregationExpression = RequestContextUtils.getExpression((Expression)CalciteSqlParser.compileToExpression((String)postAggregationExpression.getLiteral()));
            this._includeDefaultSketch = DistinctCountThetaSketchAggregationFunction.validatePostAggregationExpression(this._postAggregationExpression, this._filterEvaluators.size());
        }
    }

    @Override
    public AggregationFunctionType getType() {
        return AggregationFunctionType.DISTINCTCOUNTTHETASKETCH;
    }

    @Override
    public List<ExpressionContext> getInputExpressions() {
        return this._inputExpressions;
    }

    @Override
    public AggregationResultHolder createAggregationResultHolder() {
        return new ObjectAggregationResultHolder();
    }

    @Override
    public GroupByResultHolder createGroupByResultHolder(int initialCapacity, int maxCapacity) {
        return new ObjectGroupByResultHolder(initialCapacity, maxCapacity);
    }

    @Override
    public void aggregate(int length, AggregationResultHolder aggregationResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        block70: {
            int numFilters;
            Object[] valueArrays;
            FieldSpec.DataType[] valueTypes;
            boolean[] singleValues;
            block68: {
                List<UpdateSketch> updateSketches;
                block69: {
                    int numExpressions = this._inputExpressions.size();
                    singleValues = new boolean[numExpressions];
                    valueTypes = new FieldSpec.DataType[numExpressions];
                    valueArrays = new Object[numExpressions];
                    this.extractValues(blockValSetMap, singleValues, valueTypes, valueArrays);
                    numFilters = this._filterEvaluators.size();
                    if (valueTypes[0] == FieldSpec.DataType.BYTES) break block68;
                    updateSketches = this.getUpdateSketches(aggregationResultHolder);
                    if (!singleValues[0]) break block69;
                    switch (valueTypes[0]) {
                        case INT: {
                            int[] intValues = (int[])valueArrays[0];
                            if (this._includeDefaultSketch) {
                                UpdateSketch defaultSketch = updateSketches.get(0);
                                for (int i = 0; i < length; ++i) {
                                    defaultSketch.update((long)intValues[i]);
                                }
                            }
                            for (int i = 0; i < numFilters; ++i) {
                                FilterEvaluator filterEvaluator = this._filterEvaluators.get(i);
                                UpdateSketch updateSketch = updateSketches.get(i + 1);
                                for (int j = 0; j < length; ++j) {
                                    if (!filterEvaluator.evaluate(singleValues, valueTypes, valueArrays, j)) continue;
                                    updateSketch.update((long)intValues[j]);
                                }
                            }
                            break block70;
                        }
                        case LONG: {
                            long[] longValues = (long[])valueArrays[0];
                            if (this._includeDefaultSketch) {
                                UpdateSketch defaultSketch = updateSketches.get(0);
                                for (int i = 0; i < length; ++i) {
                                    defaultSketch.update(longValues[i]);
                                }
                            }
                            for (int i = 0; i < numFilters; ++i) {
                                FilterEvaluator filterEvaluator = this._filterEvaluators.get(i);
                                UpdateSketch updateSketch = updateSketches.get(i + 1);
                                for (int j = 0; j < length; ++j) {
                                    if (!filterEvaluator.evaluate(singleValues, valueTypes, valueArrays, j)) continue;
                                    updateSketch.update(longValues[j]);
                                }
                            }
                            break block70;
                        }
                        case FLOAT: {
                            float[] floatValues = (float[])valueArrays[0];
                            if (this._includeDefaultSketch) {
                                UpdateSketch defaultSketch = updateSketches.get(0);
                                for (int i = 0; i < length; ++i) {
                                    defaultSketch.update((double)floatValues[i]);
                                }
                            }
                            for (int i = 0; i < numFilters; ++i) {
                                FilterEvaluator filterEvaluator = this._filterEvaluators.get(i);
                                UpdateSketch updateSketch = updateSketches.get(i + 1);
                                for (int j = 0; j < length; ++j) {
                                    if (!filterEvaluator.evaluate(singleValues, valueTypes, valueArrays, j)) continue;
                                    updateSketch.update((double)floatValues[j]);
                                }
                            }
                            break block70;
                        }
                        case DOUBLE: {
                            double[] doubleValues = (double[])valueArrays[0];
                            if (this._includeDefaultSketch) {
                                UpdateSketch defaultSketch = updateSketches.get(0);
                                for (int i = 0; i < length; ++i) {
                                    defaultSketch.update(doubleValues[i]);
                                }
                            }
                            for (int i = 0; i < numFilters; ++i) {
                                FilterEvaluator filterEvaluator = this._filterEvaluators.get(i);
                                UpdateSketch updateSketch = updateSketches.get(i + 1);
                                for (int j = 0; j < length; ++j) {
                                    if (!filterEvaluator.evaluate(singleValues, valueTypes, valueArrays, j)) continue;
                                    updateSketch.update(doubleValues[j]);
                                }
                            }
                            break block70;
                        }
                        case STRING: {
                            String[] stringValues = (String[])valueArrays[0];
                            if (this._includeDefaultSketch) {
                                UpdateSketch defaultSketch = updateSketches.get(0);
                                for (int i = 0; i < length; ++i) {
                                    defaultSketch.update(stringValues[i]);
                                }
                            }
                            for (int i = 0; i < numFilters; ++i) {
                                FilterEvaluator filterEvaluator = this._filterEvaluators.get(i);
                                UpdateSketch updateSketch = updateSketches.get(i + 1);
                                for (int j = 0; j < length; ++j) {
                                    if (!filterEvaluator.evaluate(singleValues, valueTypes, valueArrays, j)) continue;
                                    updateSketch.update(stringValues[j]);
                                }
                            }
                            break block70;
                        }
                        default: {
                            throw new IllegalStateException("Illegal single-value data type for DISTINCT_COUNT_THETA_SKETCH aggregation function: " + valueTypes[0]);
                        }
                    }
                }
                switch (valueTypes[0]) {
                    case INT: {
                        int[][] intValues = (int[][])valueArrays[0];
                        if (this._includeDefaultSketch) {
                            UpdateSketch defaultSketch = updateSketches.get(0);
                            for (int i = 0; i < length; ++i) {
                                for (int value : intValues[i]) {
                                    defaultSketch.update((long)value);
                                }
                            }
                        }
                        for (int i = 0; i < numFilters; ++i) {
                            FilterEvaluator filterEvaluator = this._filterEvaluators.get(i);
                            UpdateSketch updateSketch = updateSketches.get(i + 1);
                            for (int j = 0; j < length; ++j) {
                                if (!filterEvaluator.evaluate(singleValues, valueTypes, valueArrays, j)) continue;
                                for (int value : intValues[j]) {
                                    updateSketch.update((long)value);
                                }
                            }
                        }
                        break block70;
                    }
                    case LONG: {
                        long[][] longValues = (long[][])valueArrays[0];
                        if (this._includeDefaultSketch) {
                            UpdateSketch defaultSketch = updateSketches.get(0);
                            for (int i = 0; i < length; ++i) {
                                for (long value : longValues[i]) {
                                    defaultSketch.update(value);
                                }
                            }
                        }
                        for (int i = 0; i < numFilters; ++i) {
                            FilterEvaluator filterEvaluator = this._filterEvaluators.get(i);
                            UpdateSketch updateSketch = updateSketches.get(i + 1);
                            for (int j = 0; j < length; ++j) {
                                if (!filterEvaluator.evaluate(singleValues, valueTypes, valueArrays, j)) continue;
                                for (long value : longValues[j]) {
                                    updateSketch.update(value);
                                }
                            }
                        }
                        break block70;
                    }
                    case FLOAT: {
                        float[][] floatValues = (float[][])valueArrays[0];
                        if (this._includeDefaultSketch) {
                            UpdateSketch defaultSketch = updateSketches.get(0);
                            for (int i = 0; i < length; ++i) {
                                for (float value : floatValues[i]) {
                                    defaultSketch.update((double)value);
                                }
                            }
                        }
                        for (int i = 0; i < numFilters; ++i) {
                            FilterEvaluator filterEvaluator = this._filterEvaluators.get(i);
                            UpdateSketch updateSketch = updateSketches.get(i + 1);
                            for (int j = 0; j < length; ++j) {
                                if (!filterEvaluator.evaluate(singleValues, valueTypes, valueArrays, j)) continue;
                                for (float value : floatValues[j]) {
                                    updateSketch.update((double)value);
                                }
                            }
                        }
                        break block70;
                    }
                    case DOUBLE: {
                        double[][] doubleValues = (double[][])valueArrays[0];
                        if (this._includeDefaultSketch) {
                            UpdateSketch defaultSketch = updateSketches.get(0);
                            for (int i = 0; i < length; ++i) {
                                for (double value : doubleValues[i]) {
                                    defaultSketch.update(value);
                                }
                            }
                        }
                        for (int i = 0; i < numFilters; ++i) {
                            FilterEvaluator filterEvaluator = this._filterEvaluators.get(i);
                            UpdateSketch updateSketch = updateSketches.get(i + 1);
                            for (int j = 0; j < length; ++j) {
                                if (!filterEvaluator.evaluate(singleValues, valueTypes, valueArrays, j)) continue;
                                for (double value : doubleValues[j]) {
                                    updateSketch.update(value);
                                }
                            }
                        }
                        break block70;
                    }
                    case STRING: {
                        String[][] stringValues = (String[][])valueArrays[0];
                        if (this._includeDefaultSketch) {
                            UpdateSketch defaultSketch = updateSketches.get(0);
                            for (int i = 0; i < length; ++i) {
                                for (String value : stringValues[i]) {
                                    defaultSketch.update(value);
                                }
                            }
                        }
                        for (int i = 0; i < numFilters; ++i) {
                            FilterEvaluator filterEvaluator = this._filterEvaluators.get(i);
                            UpdateSketch updateSketch = updateSketches.get(i + 1);
                            for (int j = 0; j < length; ++j) {
                                if (!filterEvaluator.evaluate(singleValues, valueTypes, valueArrays, j)) continue;
                                for (String value : stringValues[j]) {
                                    updateSketch.update(value);
                                }
                            }
                        }
                        break block70;
                    }
                    default: {
                        throw new IllegalStateException("Illegal multi-value data type for DISTINCT_COUNT_THETA_SKETCH aggregation function: " + valueTypes[0]);
                    }
                }
            }
            List<Union> unions = this.getUnions(aggregationResultHolder);
            Sketch[] sketches = this.deserializeSketches((byte[][])valueArrays[0], length);
            if (this._includeDefaultSketch) {
                Union defaultUnion = unions.get(0);
                for (Sketch sketch : sketches) {
                    defaultUnion.update(sketch);
                }
            }
            for (int i = 0; i < numFilters; ++i) {
                FilterEvaluator filterEvaluator = this._filterEvaluators.get(i);
                Union union = unions.get(i + 1);
                for (int j = 0; j < length; ++j) {
                    if (!filterEvaluator.evaluate(singleValues, valueTypes, valueArrays, j)) continue;
                    union.update(sketches[j]);
                }
            }
        }
    }

    @Override
    public void aggregateGroupBySV(int length, int[] groupKeyArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        block59: {
            int numFilters;
            Object[] valueArrays;
            FieldSpec.DataType[] valueTypes;
            boolean[] singleValues;
            block57: {
                block58: {
                    int numExpressions = this._inputExpressions.size();
                    singleValues = new boolean[numExpressions];
                    valueTypes = new FieldSpec.DataType[numExpressions];
                    valueArrays = new Object[numExpressions];
                    this.extractValues(blockValSetMap, singleValues, valueTypes, valueArrays);
                    numFilters = this._filterEvaluators.size();
                    if (valueTypes[0] == FieldSpec.DataType.BYTES) break block57;
                    if (!singleValues[0]) break block58;
                    switch (valueTypes[0]) {
                        case INT: {
                            int[] intValues = (int[])valueArrays[0];
                            for (int i = 0; i < length; ++i) {
                                List<UpdateSketch> updateSketches = this.getUpdateSketches(groupByResultHolder, groupKeyArray[i]);
                                int value = intValues[i];
                                if (this._includeDefaultSketch) {
                                    updateSketches.get(0).update((long)value);
                                }
                                for (int j = 0; j < numFilters; ++j) {
                                    if (!this._filterEvaluators.get(j).evaluate(singleValues, valueTypes, valueArrays, i)) continue;
                                    updateSketches.get(j + 1).update((long)value);
                                }
                            }
                            break block59;
                        }
                        case LONG: {
                            long[] longValues = (long[])valueArrays[0];
                            for (int i = 0; i < length; ++i) {
                                List<UpdateSketch> updateSketches = this.getUpdateSketches(groupByResultHolder, groupKeyArray[i]);
                                long value = longValues[i];
                                if (this._includeDefaultSketch) {
                                    updateSketches.get(0).update(value);
                                }
                                for (int j = 0; j < numFilters; ++j) {
                                    if (!this._filterEvaluators.get(j).evaluate(singleValues, valueTypes, valueArrays, i)) continue;
                                    updateSketches.get(j + 1).update(value);
                                }
                            }
                            break block59;
                        }
                        case FLOAT: {
                            float[] floatValues = (float[])valueArrays[0];
                            for (int i = 0; i < length; ++i) {
                                List<UpdateSketch> updateSketches = this.getUpdateSketches(groupByResultHolder, groupKeyArray[i]);
                                float value = floatValues[i];
                                if (this._includeDefaultSketch) {
                                    updateSketches.get(0).update((double)value);
                                }
                                for (int j = 0; j < numFilters; ++j) {
                                    if (!this._filterEvaluators.get(j).evaluate(singleValues, valueTypes, valueArrays, i)) continue;
                                    updateSketches.get(j + 1).update((double)value);
                                }
                            }
                            break block59;
                        }
                        case DOUBLE: {
                            double[] doubleValues = (double[])valueArrays[0];
                            for (int i = 0; i < length; ++i) {
                                List<UpdateSketch> updateSketches = this.getUpdateSketches(groupByResultHolder, groupKeyArray[i]);
                                double value = doubleValues[i];
                                if (this._includeDefaultSketch) {
                                    updateSketches.get(0).update(value);
                                }
                                for (int j = 0; j < numFilters; ++j) {
                                    if (!this._filterEvaluators.get(j).evaluate(singleValues, valueTypes, valueArrays, i)) continue;
                                    updateSketches.get(j + 1).update(value);
                                }
                            }
                            break block59;
                        }
                        case STRING: {
                            String[] stringValues = (String[])valueArrays[0];
                            for (int i = 0; i < length; ++i) {
                                List<UpdateSketch> updateSketches2 = this.getUpdateSketches(groupByResultHolder, groupKeyArray[i]);
                                String value = stringValues[i];
                                if (this._includeDefaultSketch) {
                                    updateSketches2.get(0).update(value);
                                }
                                for (int j = 0; j < numFilters; ++j) {
                                    if (!this._filterEvaluators.get(j).evaluate(singleValues, valueTypes, valueArrays, i)) continue;
                                    updateSketches2.get(j + 1).update(value);
                                }
                            }
                            break block59;
                        }
                        default: {
                            throw new IllegalStateException("Illegal single-value data type for DISTINCT_COUNT_THETA_SKETCH aggregation function: " + valueTypes[0]);
                        }
                    }
                }
                switch (valueTypes[0]) {
                    case INT: {
                        int[][] intValues = (int[][])valueArrays[0];
                        for (int i = 0; i < length; ++i) {
                            List<UpdateSketch> updateSketches = this.getUpdateSketches(groupByResultHolder, groupKeyArray[i]);
                            int[] values = intValues[i];
                            if (this._includeDefaultSketch) {
                                UpdateSketch defaultSketch = updateSketches.get(0);
                                for (int value2 : values) {
                                    defaultSketch.update((long)value2);
                                }
                            }
                            for (int j = 0; j < numFilters; ++j) {
                                if (!this._filterEvaluators.get(j).evaluate(singleValues, valueTypes, valueArrays, i)) continue;
                                UpdateSketch updateSketch = updateSketches.get(j + 1);
                                int[] updateSketches2 = values;
                                int value = updateSketches2.length;
                                for (int value2 = 0; value2 < value; ++value2) {
                                    int value3 = updateSketches2[value2];
                                    updateSketch.update((long)value3);
                                }
                            }
                        }
                        break block59;
                    }
                    case LONG: {
                        long[][] longValues = (long[][])valueArrays[0];
                        for (int i = 0; i < length; ++i) {
                            List<UpdateSketch> updateSketches = this.getUpdateSketches(groupByResultHolder, groupKeyArray[i]);
                            long[] values = longValues[i];
                            if (this._includeDefaultSketch) {
                                UpdateSketch defaultSketch = updateSketches.get(0);
                                for (long value : values) {
                                    defaultSketch.update(value);
                                }
                            }
                            for (int j = 0; j < numFilters; ++j) {
                                if (!this._filterEvaluators.get(j).evaluate(singleValues, valueTypes, valueArrays, i)) continue;
                                UpdateSketch updateSketch = updateSketches.get(j + 1);
                                for (long value : values) {
                                    updateSketch.update(value);
                                }
                            }
                        }
                        break block59;
                    }
                    case FLOAT: {
                        float[][] floatValues = (float[][])valueArrays[0];
                        for (int i = 0; i < length; ++i) {
                            List<UpdateSketch> updateSketches = this.getUpdateSketches(groupByResultHolder, groupKeyArray[i]);
                            float[] values = floatValues[i];
                            if (this._includeDefaultSketch) {
                                UpdateSketch defaultSketch = updateSketches.get(0);
                                for (float value : values) {
                                    defaultSketch.update((double)value);
                                }
                            }
                            for (int j = 0; j < numFilters; ++j) {
                                if (!this._filterEvaluators.get(j).evaluate(singleValues, valueTypes, valueArrays, i)) continue;
                                UpdateSketch updateSketch = updateSketches.get(j + 1);
                                for (float value : values) {
                                    updateSketch.update((double)value);
                                }
                            }
                        }
                        break block59;
                    }
                    case DOUBLE: {
                        double[][] doubleValues = (double[][])valueArrays[0];
                        for (int i = 0; i < length; ++i) {
                            List<UpdateSketch> updateSketches = this.getUpdateSketches(groupByResultHolder, groupKeyArray[i]);
                            double[] values = doubleValues[i];
                            if (this._includeDefaultSketch) {
                                UpdateSketch defaultSketch = updateSketches.get(0);
                                for (double value : values) {
                                    defaultSketch.update(value);
                                }
                            }
                            for (int j = 0; j < numFilters; ++j) {
                                if (!this._filterEvaluators.get(j).evaluate(singleValues, valueTypes, valueArrays, i)) continue;
                                UpdateSketch updateSketch = updateSketches.get(j + 1);
                                for (double value : values) {
                                    updateSketch.update(value);
                                }
                            }
                        }
                        break block59;
                    }
                    case STRING: {
                        String[][] stringValues = (String[][])valueArrays[0];
                        for (int i = 0; i < length; ++i) {
                            List<UpdateSketch> updateSketches = this.getUpdateSketches(groupByResultHolder, groupKeyArray[i]);
                            String[] values = stringValues[i];
                            if (this._includeDefaultSketch) {
                                UpdateSketch defaultSketch = updateSketches.get(0);
                                for (String value : values) {
                                    defaultSketch.update(value);
                                }
                            }
                            for (int j = 0; j < numFilters; ++j) {
                                if (!this._filterEvaluators.get(j).evaluate(singleValues, valueTypes, valueArrays, i)) continue;
                                UpdateSketch updateSketch = updateSketches.get(j + 1);
                                for (String value : values) {
                                    updateSketch.update(value);
                                }
                            }
                        }
                        break block59;
                    }
                    default: {
                        throw new IllegalStateException("Illegal multi-value data type for DISTINCT_COUNT_THETA_SKETCH aggregation function: " + valueTypes[0]);
                    }
                }
            }
            Sketch[] sketches = this.deserializeSketches((byte[][])valueArrays[0], length);
            for (int i = 0; i < length; ++i) {
                List<Union> unions = this.getUnions(groupByResultHolder, groupKeyArray[i]);
                Sketch sketch = sketches[i];
                if (this._includeDefaultSketch) {
                    unions.get(0).update(sketch);
                }
                for (int j = 0; j < numFilters; ++j) {
                    if (!this._filterEvaluators.get(j).evaluate(singleValues, valueTypes, valueArrays, i)) continue;
                    unions.get(j + 1).update(sketch);
                }
            }
        }
    }

    @Override
    public void aggregateGroupByMV(int length, int[][] groupKeysArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        block92: {
            int i;
            int numFilters;
            Object[] valueArrays;
            FieldSpec.DataType[] valueTypes;
            boolean[] singleValues;
            block90: {
                block91: {
                    int numExpressions = this._inputExpressions.size();
                    singleValues = new boolean[numExpressions];
                    valueTypes = new FieldSpec.DataType[numExpressions];
                    valueArrays = new Object[numExpressions];
                    this.extractValues(blockValSetMap, singleValues, valueTypes, valueArrays);
                    numFilters = this._filterEvaluators.size();
                    if (valueTypes[0] == FieldSpec.DataType.BYTES) break block90;
                    if (!singleValues[0]) break block91;
                    switch (valueTypes[0]) {
                        case INT: {
                            int i2;
                            int[] intValues = (int[])valueArrays[0];
                            if (this._includeDefaultSketch) {
                                for (i2 = 0; i2 < length; ++i2) {
                                    for (int groupKey : groupKeysArray[i2]) {
                                        this.getUpdateSketches(groupByResultHolder, groupKey).get(0).update((long)intValues[i2]);
                                    }
                                }
                            }
                            for (i2 = 0; i2 < numFilters; ++i2) {
                                FilterEvaluator filterEvaluator = this._filterEvaluators.get(i2);
                                for (int j = 0; j < length; ++j) {
                                    if (!filterEvaluator.evaluate(singleValues, valueTypes, valueArrays, j)) continue;
                                    for (int groupKey : groupKeysArray[i2]) {
                                        this.getUpdateSketches(groupByResultHolder, groupKey).get(i2 + 1).update((long)intValues[j]);
                                    }
                                }
                            }
                            break block92;
                        }
                        case LONG: {
                            int i3;
                            long[] longValues = (long[])valueArrays[0];
                            if (this._includeDefaultSketch) {
                                for (i3 = 0; i3 < length; ++i3) {
                                    for (int groupKey : groupKeysArray[i3]) {
                                        this.getUpdateSketches(groupByResultHolder, groupKey).get(0).update(longValues[i3]);
                                    }
                                }
                            }
                            for (i3 = 0; i3 < numFilters; ++i3) {
                                FilterEvaluator filterEvaluator = this._filterEvaluators.get(i3);
                                for (int j = 0; j < length; ++j) {
                                    if (!filterEvaluator.evaluate(singleValues, valueTypes, valueArrays, j)) continue;
                                    for (int groupKey : groupKeysArray[i3]) {
                                        this.getUpdateSketches(groupByResultHolder, groupKey).get(i3 + 1).update(longValues[j]);
                                    }
                                }
                            }
                            break block92;
                        }
                        case FLOAT: {
                            int i4;
                            float[] floatValues = (float[])valueArrays[0];
                            if (this._includeDefaultSketch) {
                                for (i4 = 0; i4 < length; ++i4) {
                                    for (int groupKey : groupKeysArray[i4]) {
                                        this.getUpdateSketches(groupByResultHolder, groupKey).get(0).update((double)floatValues[i4]);
                                    }
                                }
                            }
                            for (i4 = 0; i4 < numFilters; ++i4) {
                                FilterEvaluator filterEvaluator = this._filterEvaluators.get(i4);
                                for (int j = 0; j < length; ++j) {
                                    if (!filterEvaluator.evaluate(singleValues, valueTypes, valueArrays, j)) continue;
                                    for (int groupKey : groupKeysArray[i4]) {
                                        this.getUpdateSketches(groupByResultHolder, groupKey).get(i4 + 1).update((double)floatValues[j]);
                                    }
                                }
                            }
                            break block92;
                        }
                        case DOUBLE: {
                            int i5;
                            double[] doubleValues = (double[])valueArrays[0];
                            if (this._includeDefaultSketch) {
                                for (i5 = 0; i5 < length; ++i5) {
                                    for (int groupKey : groupKeysArray[i5]) {
                                        this.getUpdateSketches(groupByResultHolder, groupKey).get(0).update(doubleValues[i5]);
                                    }
                                }
                            }
                            for (i5 = 0; i5 < numFilters; ++i5) {
                                FilterEvaluator filterEvaluator = this._filterEvaluators.get(i5);
                                for (int j = 0; j < length; ++j) {
                                    if (!filterEvaluator.evaluate(singleValues, valueTypes, valueArrays, j)) continue;
                                    for (int groupKey : groupKeysArray[i5]) {
                                        this.getUpdateSketches(groupByResultHolder, groupKey).get(i5 + 1).update(doubleValues[j]);
                                    }
                                }
                            }
                            break block92;
                        }
                        case STRING: {
                            int i6;
                            String[] stringValues = (String[])valueArrays[0];
                            if (this._includeDefaultSketch) {
                                for (i6 = 0; i6 < length; ++i6) {
                                    for (int groupKey : groupKeysArray[i6]) {
                                        this.getUpdateSketches(groupByResultHolder, groupKey).get(0).update(stringValues[i6]);
                                    }
                                }
                            }
                            for (i6 = 0; i6 < numFilters; ++i6) {
                                FilterEvaluator filterEvaluator = this._filterEvaluators.get(i6);
                                for (int j = 0; j < length; ++j) {
                                    if (!filterEvaluator.evaluate(singleValues, valueTypes, valueArrays, j)) continue;
                                    for (int groupKey : groupKeysArray[i6]) {
                                        this.getUpdateSketches(groupByResultHolder, groupKey).get(i6 + 1).update(stringValues[j]);
                                    }
                                }
                            }
                            break block92;
                        }
                        default: {
                            throw new IllegalStateException("Illegal single-value data type for DISTINCT_COUNT_THETA_SKETCH aggregation function: " + valueTypes[0]);
                        }
                    }
                }
                switch (valueTypes[0]) {
                    case INT: {
                        int i7;
                        int[][] intValues = (int[][])valueArrays[0];
                        if (this._includeDefaultSketch) {
                            for (i7 = 0; i7 < length; ++i7) {
                                for (int groupKey : groupKeysArray[i7]) {
                                    UpdateSketch defaultSketch = this.getUpdateSketches(groupByResultHolder, groupKey).get(0);
                                    for (int value : intValues[i7]) {
                                        defaultSketch.update((long)value);
                                    }
                                }
                            }
                        }
                        for (i7 = 0; i7 < numFilters; ++i7) {
                            FilterEvaluator filterEvaluator = this._filterEvaluators.get(i7);
                            for (int j = 0; j < length; ++j) {
                                if (!filterEvaluator.evaluate(singleValues, valueTypes, valueArrays, j)) continue;
                                for (int groupKey : groupKeysArray[i7]) {
                                    UpdateSketch updateSketch = this.getUpdateSketches(groupByResultHolder, groupKey).get(i7 + 1);
                                    for (int value : intValues[i7]) {
                                        updateSketch.update((long)value);
                                    }
                                }
                            }
                        }
                        break block92;
                    }
                    case LONG: {
                        int i8;
                        long[][] longValues = (long[][])valueArrays[0];
                        if (this._includeDefaultSketch) {
                            for (i8 = 0; i8 < length; ++i8) {
                                for (int groupKey : groupKeysArray[i8]) {
                                    UpdateSketch defaultSketch = this.getUpdateSketches(groupByResultHolder, groupKey).get(0);
                                    for (long value : longValues[i8]) {
                                        defaultSketch.update(value);
                                    }
                                }
                            }
                        }
                        for (i8 = 0; i8 < numFilters; ++i8) {
                            FilterEvaluator filterEvaluator = this._filterEvaluators.get(i8);
                            for (int j = 0; j < length; ++j) {
                                if (!filterEvaluator.evaluate(singleValues, valueTypes, valueArrays, j)) continue;
                                for (int groupKey : groupKeysArray[i8]) {
                                    UpdateSketch updateSketch = this.getUpdateSketches(groupByResultHolder, groupKey).get(i8 + 1);
                                    for (long value : longValues[i8]) {
                                        updateSketch.update(value);
                                    }
                                }
                            }
                        }
                        break block92;
                    }
                    case FLOAT: {
                        int i9;
                        float[][] floatValues = (float[][])valueArrays[0];
                        if (this._includeDefaultSketch) {
                            for (i9 = 0; i9 < length; ++i9) {
                                for (int groupKey : groupKeysArray[i9]) {
                                    UpdateSketch defaultSketch = this.getUpdateSketches(groupByResultHolder, groupKey).get(0);
                                    for (float value : floatValues[i9]) {
                                        defaultSketch.update((double)value);
                                    }
                                }
                            }
                        }
                        for (i9 = 0; i9 < numFilters; ++i9) {
                            FilterEvaluator filterEvaluator = this._filterEvaluators.get(i9);
                            for (int j = 0; j < length; ++j) {
                                if (!filterEvaluator.evaluate(singleValues, valueTypes, valueArrays, j)) continue;
                                for (int groupKey : groupKeysArray[i9]) {
                                    UpdateSketch updateSketch = this.getUpdateSketches(groupByResultHolder, groupKey).get(i9 + 1);
                                    for (float value : floatValues[i9]) {
                                        updateSketch.update((double)value);
                                    }
                                }
                            }
                        }
                        break block92;
                    }
                    case DOUBLE: {
                        int i10;
                        double[][] doubleValues = (double[][])valueArrays[0];
                        if (this._includeDefaultSketch) {
                            for (i10 = 0; i10 < length; ++i10) {
                                for (int groupKey : groupKeysArray[i10]) {
                                    UpdateSketch defaultSketch = this.getUpdateSketches(groupByResultHolder, groupKey).get(0);
                                    for (double value : doubleValues[i10]) {
                                        defaultSketch.update(value);
                                    }
                                }
                            }
                        }
                        for (i10 = 0; i10 < numFilters; ++i10) {
                            FilterEvaluator filterEvaluator = this._filterEvaluators.get(i10);
                            for (int j = 0; j < length; ++j) {
                                if (!filterEvaluator.evaluate(singleValues, valueTypes, valueArrays, j)) continue;
                                for (int groupKey : groupKeysArray[i10]) {
                                    UpdateSketch updateSketch = this.getUpdateSketches(groupByResultHolder, groupKey).get(i10 + 1);
                                    for (double value : doubleValues[i10]) {
                                        updateSketch.update(value);
                                    }
                                }
                            }
                        }
                        break block92;
                    }
                    case STRING: {
                        int i11;
                        String[][] stringValues = (String[][])valueArrays[0];
                        if (this._includeDefaultSketch) {
                            for (i11 = 0; i11 < length; ++i11) {
                                for (int groupKey : groupKeysArray[i11]) {
                                    UpdateSketch defaultSketch = this.getUpdateSketches(groupByResultHolder, groupKey).get(0);
                                    for (String value : stringValues[i11]) {
                                        defaultSketch.update(value);
                                    }
                                }
                            }
                        }
                        for (i11 = 0; i11 < numFilters; ++i11) {
                            FilterEvaluator filterEvaluator = this._filterEvaluators.get(i11);
                            for (int j = 0; j < length; ++j) {
                                if (!filterEvaluator.evaluate(singleValues, valueTypes, valueArrays, j)) continue;
                                for (int groupKey : groupKeysArray[i11]) {
                                    UpdateSketch updateSketch = this.getUpdateSketches(groupByResultHolder, groupKey).get(i11 + 1);
                                    for (String value : stringValues[i11]) {
                                        updateSketch.update(value);
                                    }
                                }
                            }
                        }
                        break block92;
                    }
                    default: {
                        throw new IllegalStateException("Illegal multi-value data type for DISTINCT_COUNT_THETA_SKETCH aggregation function: " + valueTypes[0]);
                    }
                }
            }
            Sketch[] sketches = this.deserializeSketches((byte[][])valueArrays[0], length);
            if (this._includeDefaultSketch) {
                for (i = 0; i < length; ++i) {
                    for (int groupKey : groupKeysArray[i]) {
                        this.getUnions(groupByResultHolder, groupKey).get(0).update(sketches[i]);
                    }
                }
            }
            for (i = 0; i < numFilters; ++i) {
                FilterEvaluator filterEvaluator = this._filterEvaluators.get(i);
                for (int j = 0; j < length; ++j) {
                    if (!filterEvaluator.evaluate(singleValues, valueTypes, valueArrays, j)) continue;
                    for (int groupKey : groupKeysArray[i]) {
                        this.getUnions(groupByResultHolder, groupKey).get(i + 1).update(sketches[i]);
                    }
                }
            }
        }
    }

    @Override
    public List<Sketch> extractAggregationResult(AggregationResultHolder aggregationResultHolder) {
        List result = (List)aggregationResultHolder.getResult();
        if (result == null) {
            int numSketches = this._filterEvaluators.size() + 1;
            ArrayList<Sketch> sketches = new ArrayList<Sketch>(numSketches);
            for (int i = 0; i < numSketches; ++i) {
                sketches.add(EMPTY_SKETCH);
            }
            return sketches;
        }
        if (result.get(0) instanceof Sketch) {
            return result;
        }
        return this.convertToSketches(result);
    }

    @Override
    public List<Sketch> extractGroupByResult(GroupByResultHolder groupByResultHolder, int groupKey) {
        List result = (List)groupByResultHolder.getResult(groupKey);
        if (result.get(0) instanceof Sketch) {
            return result;
        }
        return this.convertToSketches(result);
    }

    @Override
    public List<Sketch> merge(List<Sketch> sketches1, List<Sketch> sketches2) {
        int numSketches = sketches1.size();
        ArrayList<Sketch> mergedSketches = new ArrayList<Sketch>(numSketches);
        for (int i = 0; i < numSketches; ++i) {
            Sketch sketch1 = sketches1.get(i);
            Sketch sketch2 = sketches2.get(i);
            if (sketch1.isEmpty()) {
                mergedSketches.add(sketch2);
                continue;
            }
            if (sketch2.isEmpty()) {
                mergedSketches.add(sketch1);
                continue;
            }
            Union union = this._setOperationBuilder.buildUnion();
            union.update(sketch1);
            union.update(sketch2);
            mergedSketches.add((Sketch)union.getResult(false, null));
        }
        return mergedSketches;
    }

    @Override
    public DataSchema.ColumnDataType getIntermediateResultColumnType() {
        return DataSchema.ColumnDataType.OBJECT;
    }

    @Override
    public DataSchema.ColumnDataType getFinalResultColumnType() {
        return DataSchema.ColumnDataType.LONG;
    }

    @Override
    public Comparable extractFinalResult(List<Sketch> sketches) {
        return Long.valueOf(Math.round(this.evaluatePostAggregationExpression(this._postAggregationExpression, sketches).getEstimate()));
    }

    private static void collectExpressions(FilterContext filter, List<ExpressionContext> expressions, Map<ExpressionContext, Integer> expressionIndexMap) {
        List children = filter.getChildren();
        if (children != null) {
            for (FilterContext child : children) {
                DistinctCountThetaSketchAggregationFunction.collectExpressions(child, expressions, expressionIndexMap);
            }
        } else {
            ExpressionContext expression = filter.getPredicate().getLhs();
            if (expressionIndexMap.putIfAbsent(expression, expressions.size()) == null) {
                expressions.add(expression);
            }
        }
    }

    private static FilterEvaluator getFilterEvaluator(FilterContext filter, Map<ExpressionContext, Integer> expressionIndexMap) {
        switch (filter.getType()) {
            case AND: {
                List children = filter.getChildren();
                ArrayList<FilterEvaluator> childEvaluators = new ArrayList<FilterEvaluator>(children.size());
                for (FilterContext child : children) {
                    childEvaluators.add(DistinctCountThetaSketchAggregationFunction.getFilterEvaluator(child, expressionIndexMap));
                }
                return new AndFilterEvaluator(childEvaluators);
            }
            case OR: {
                List children = filter.getChildren();
                ArrayList<FilterEvaluator> childEvaluators = new ArrayList<FilterEvaluator>(children.size());
                for (FilterContext child : children) {
                    childEvaluators.add(DistinctCountThetaSketchAggregationFunction.getFilterEvaluator(child, expressionIndexMap));
                }
                return new OrFilterEvaluator(childEvaluators);
            }
            case NOT: {
                assert (filter.getChildren().size() == 1);
                return new NotFilterEvaluator(DistinctCountThetaSketchAggregationFunction.getFilterEvaluator((FilterContext)filter.getChildren().get(0), expressionIndexMap));
            }
            case PREDICATE: {
                Predicate predicate = filter.getPredicate();
                int expressionIndex = expressionIndexMap.get(predicate.getLhs());
                return new PredicateFilterEvaluator(predicate, expressionIndex);
            }
        }
        throw new IllegalStateException();
    }

    private static boolean validatePostAggregationExpression(ExpressionContext expression, int numFilters) {
        Preconditions.checkArgument((expression.getType() != ExpressionContext.Type.LITERAL ? 1 : 0) != 0, (String)"Post-aggregation expression should not contain literal expression: %s", (Object)expression.getLiteral());
        if (expression.getType() == ExpressionContext.Type.IDENTIFIER) {
            int sketchId = DistinctCountThetaSketchAggregationFunction.extractSketchId(expression.getIdentifier());
            Preconditions.checkArgument((sketchId <= numFilters ? 1 : 0) != 0, (String)"Sketch id: %s exceeds number of filters: %s", (int)sketchId, (int)numFilters);
            return sketchId == 0;
        }
        FunctionContext function = expression.getFunction();
        String functionName = function.getFunctionName();
        List arguments = function.getArguments();
        int numArguments = arguments.size();
        boolean includeDefaultSketch = false;
        switch (functionName) {
            case "setunion": 
            case "setintersect": {
                Preconditions.checkArgument((numArguments >= 2 ? 1 : 0) != 0, (String)"SET_UNION and SET_INTERSECT should have at least 2 arguments, got: %s", (int)numArguments);
                for (ExpressionContext argument : arguments) {
                    includeDefaultSketch |= DistinctCountThetaSketchAggregationFunction.validatePostAggregationExpression(argument, numFilters);
                }
                break;
            }
            case "setdiff": {
                Preconditions.checkArgument((numArguments == 2 ? 1 : 0) != 0, (String)"SET_DIFF should have 2 arguments, got: %s", (int)numArguments);
                for (ExpressionContext argument : arguments) {
                    includeDefaultSketch |= DistinctCountThetaSketchAggregationFunction.validatePostAggregationExpression(argument, numFilters);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid set operation: " + functionName);
            }
        }
        return includeDefaultSketch;
    }

    private static int extractSketchId(String identifier) {
        Preconditions.checkArgument((identifier.charAt(0) == '$' ? 1 : 0) != 0, (String)"Invalid identifier: %s, expecting $0, $1, etc.", (Object)identifier);
        int sketchId = Integer.parseInt(identifier.substring(1));
        Preconditions.checkArgument((sketchId >= 0 ? 1 : 0) != 0, (String)"Invalid identifier: %s, expecting $0, $1, etc.", (Object)identifier);
        return sketchId;
    }

    private void extractValues(Map<ExpressionContext, BlockValSet> blockValSetMap, boolean[] singleValues, FieldSpec.DataType[] valueTypes, Object[] valueArrays) {
        int numExpressions = this._inputExpressions.size();
        block15: for (int i = 0; i < numExpressions; ++i) {
            BlockValSet blockValSet = blockValSetMap.get(this._inputExpressions.get(i));
            boolean singleValue = blockValSet.isSingleValue();
            FieldSpec.DataType storedType = blockValSet.getValueType().getStoredType();
            singleValues[i] = singleValue;
            valueTypes[i] = storedType;
            if (singleValue) {
                switch (storedType) {
                    case INT: {
                        valueArrays[i] = blockValSet.getIntValuesSV();
                        continue block15;
                    }
                    case LONG: {
                        valueArrays[i] = blockValSet.getLongValuesSV();
                        continue block15;
                    }
                    case FLOAT: {
                        valueArrays[i] = blockValSet.getFloatValuesSV();
                        continue block15;
                    }
                    case DOUBLE: {
                        valueArrays[i] = blockValSet.getDoubleValuesSV();
                        continue block15;
                    }
                    case STRING: {
                        valueArrays[i] = blockValSet.getStringValuesSV();
                        continue block15;
                    }
                    case BYTES: {
                        valueArrays[i] = blockValSet.getBytesValuesSV();
                        continue block15;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
            switch (storedType) {
                case INT: {
                    valueArrays[i] = blockValSet.getIntValuesMV();
                    continue block15;
                }
                case LONG: {
                    valueArrays[i] = blockValSet.getLongValuesMV();
                    continue block15;
                }
                case FLOAT: {
                    valueArrays[i] = blockValSet.getFloatValuesMV();
                    continue block15;
                }
                case DOUBLE: {
                    valueArrays[i] = blockValSet.getDoubleValuesMV();
                    continue block15;
                }
                case STRING: {
                    valueArrays[i] = blockValSet.getStringValuesMV();
                    continue block15;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
    }

    private List<UpdateSketch> getUpdateSketches(AggregationResultHolder aggregationResultHolder) {
        List<UpdateSketch> updateSketches = (List<UpdateSketch>)aggregationResultHolder.getResult();
        if (updateSketches == null) {
            updateSketches = this.buildUpdateSketches();
            aggregationResultHolder.setValue(updateSketches);
        }
        return updateSketches;
    }

    private List<Union> getUnions(AggregationResultHolder aggregationResultHolder) {
        List<Union> unions = (List<Union>)aggregationResultHolder.getResult();
        if (unions == null) {
            unions = this.buildUnions();
            aggregationResultHolder.setValue(unions);
        }
        return unions;
    }

    private List<UpdateSketch> getUpdateSketches(GroupByResultHolder groupByResultHolder, int groupKey) {
        List<UpdateSketch> updateSketches = (List<UpdateSketch>)groupByResultHolder.getResult(groupKey);
        if (updateSketches == null) {
            updateSketches = this.buildUpdateSketches();
            groupByResultHolder.setValueForKey(groupKey, updateSketches);
        }
        return updateSketches;
    }

    private List<Union> getUnions(GroupByResultHolder groupByResultHolder, int groupKey) {
        List<Union> unions = (List<Union>)groupByResultHolder.getResult(groupKey);
        if (unions == null) {
            unions = this.buildUnions();
            groupByResultHolder.setValueForKey(groupKey, unions);
        }
        return unions;
    }

    private List<UpdateSketch> buildUpdateSketches() {
        int numSketches = this._filterEvaluators.size() + 1;
        ArrayList<UpdateSketch> updateSketches = new ArrayList<UpdateSketch>(numSketches);
        for (int i = 0; i < numSketches; ++i) {
            updateSketches.add(this._updateSketchBuilder.build());
        }
        return updateSketches;
    }

    private List<Union> buildUnions() {
        int numUnions = this._filterEvaluators.size() + 1;
        ArrayList<Union> unions = new ArrayList<Union>(numUnions);
        for (int i = 0; i < numUnions; ++i) {
            unions.add(this._setOperationBuilder.buildUnion());
        }
        return unions;
    }

    private Sketch[] deserializeSketches(byte[][] serializedSketches, int length) {
        Sketch[] sketches = new Sketch[length];
        for (int i = 0; i < length; ++i) {
            sketches[i] = Sketch.wrap((Memory)Memory.wrap((byte[])serializedSketches[i]));
        }
        return sketches;
    }

    private List<Sketch> convertToSketches(List<Union> unions) {
        int numUnions = unions.size();
        ArrayList<Sketch> sketches = new ArrayList<Sketch>(numUnions);
        for (Union union : unions) {
            sketches.add((Sketch)union.getResult(false, null));
        }
        return sketches;
    }

    protected Sketch evaluatePostAggregationExpression(List<Sketch> sketches) {
        return this.evaluatePostAggregationExpression(this._postAggregationExpression, sketches);
    }

    private Sketch evaluatePostAggregationExpression(ExpressionContext expression, List<Sketch> sketches) {
        if (expression.getType() == ExpressionContext.Type.IDENTIFIER) {
            return sketches.get(DistinctCountThetaSketchAggregationFunction.extractSketchId(expression.getIdentifier()));
        }
        FunctionContext function = expression.getFunction();
        String functionName = function.getFunctionName();
        List arguments = function.getArguments();
        switch (functionName) {
            case "setunion": {
                Union union = this._setOperationBuilder.buildUnion();
                for (ExpressionContext argument : arguments) {
                    union.update(this.evaluatePostAggregationExpression(argument, sketches));
                }
                return union.getResult(false, null);
            }
            case "setintersect": {
                Intersection intersection = this._setOperationBuilder.buildIntersection();
                for (ExpressionContext argument : arguments) {
                    intersection.update(this.evaluatePostAggregationExpression(argument, sketches));
                }
                return intersection.getResult(false, null);
            }
            case "setdiff": {
                AnotB diff = this._setOperationBuilder.buildANotB();
                diff.update(this.evaluatePostAggregationExpression((ExpressionContext)arguments.get(0), sketches), this.evaluatePostAggregationExpression((ExpressionContext)arguments.get(1), sketches));
                return diff.getResult(false, null);
            }
        }
        throw new IllegalStateException();
    }

    private static class PredicateFilterEvaluator
    implements FilterEvaluator {
        final Predicate _predicate;
        final int _expressionIndex;
        PredicateEvaluator _predicateEvaluator;

        private PredicateFilterEvaluator(Predicate predicate, int expressionIndex) {
            this._predicate = predicate;
            this._expressionIndex = expressionIndex;
        }

        @Override
        public boolean evaluate(boolean[] singleValues, FieldSpec.DataType[] valueTypes, Object[] valueArrays, int index) {
            boolean singleValue = singleValues[this._expressionIndex];
            FieldSpec.DataType valueType = valueTypes[this._expressionIndex];
            Object valueArray = valueArrays[this._expressionIndex];
            if (this._predicateEvaluator == null) {
                this._predicateEvaluator = PredicateEvaluatorProvider.getPredicateEvaluator(this._predicate, null, valueType);
            }
            if (singleValue) {
                switch (valueType) {
                    case INT: {
                        return this._predicateEvaluator.applySV(((int[])valueArray)[index]);
                    }
                    case LONG: {
                        return this._predicateEvaluator.applySV(((long[])valueArray)[index]);
                    }
                    case FLOAT: {
                        return this._predicateEvaluator.applySV(((float[])valueArray)[index]);
                    }
                    case DOUBLE: {
                        return this._predicateEvaluator.applySV(((double[])valueArray)[index]);
                    }
                    case STRING: {
                        return this._predicateEvaluator.applySV(((String[])valueArray)[index]);
                    }
                    case BYTES: {
                        return this._predicateEvaluator.applySV(((byte[][])valueArray)[index]);
                    }
                }
                throw new IllegalStateException();
            }
            switch (valueType) {
                case INT: {
                    int[] intValues = ((int[][])valueArray)[index];
                    return this._predicateEvaluator.applyMV(intValues, intValues.length);
                }
                case LONG: {
                    long[] longValues = ((long[][])valueArray)[index];
                    return this._predicateEvaluator.applyMV(longValues, longValues.length);
                }
                case FLOAT: {
                    float[] floatValues = ((float[][])valueArray)[index];
                    return this._predicateEvaluator.applyMV(floatValues, floatValues.length);
                }
                case DOUBLE: {
                    double[] doubleValues = ((double[][])valueArray)[index];
                    return this._predicateEvaluator.applyMV(doubleValues, doubleValues.length);
                }
                case STRING: {
                    String[] stringValues = ((String[][])valueArray)[index];
                    return this._predicateEvaluator.applyMV(stringValues, stringValues.length);
                }
            }
            throw new IllegalStateException();
        }
    }

    private static class NotFilterEvaluator
    implements FilterEvaluator {
        final FilterEvaluator _child;

        private NotFilterEvaluator(FilterEvaluator child) {
            this._child = child;
        }

        @Override
        public boolean evaluate(boolean[] singleValues, FieldSpec.DataType[] valueTypes, Object[] valueArrays, int index) {
            return !this._child.evaluate(singleValues, valueTypes, valueArrays, index);
        }
    }

    private static class OrFilterEvaluator
    implements FilterEvaluator {
        final List<FilterEvaluator> _children;

        private OrFilterEvaluator(List<FilterEvaluator> children) {
            this._children = children;
        }

        @Override
        public boolean evaluate(boolean[] singleValues, FieldSpec.DataType[] valueTypes, Object[] valueArrays, int index) {
            for (FilterEvaluator child : this._children) {
                if (!child.evaluate(singleValues, valueTypes, valueArrays, index)) continue;
                return true;
            }
            return false;
        }
    }

    private static class AndFilterEvaluator
    implements FilterEvaluator {
        final List<FilterEvaluator> _children;

        private AndFilterEvaluator(List<FilterEvaluator> children) {
            this._children = children;
        }

        @Override
        public boolean evaluate(boolean[] singleValues, FieldSpec.DataType[] valueTypes, Object[] valueArrays, int index) {
            for (FilterEvaluator child : this._children) {
                if (child.evaluate(singleValues, valueTypes, valueArrays, index)) continue;
                return false;
            }
            return true;
        }
    }

    private static interface FilterEvaluator {
        public boolean evaluate(boolean[] var1, FieldSpec.DataType[] var2, Object[] var3, int var4);
    }

    private static class Parameters {
        private static final char PARAMETER_DELIMITER = ';';
        private static final char PARAMETER_KEY_VALUE_SEPARATOR = '=';
        private static final String NOMINAL_ENTRIES_KEY = "nominalEntries";
        private int _nominalEntries = 4096;

        Parameters(String parametersString) {
            String[] keyValuePairs;
            StringUtils.deleteWhitespace((String)parametersString);
            for (String keyValuePair : keyValuePairs = StringUtils.split((String)parametersString, (char)';')) {
                String[] keyAndValue = StringUtils.split((String)keyValuePair, (char)'=');
                Preconditions.checkArgument((keyAndValue.length == 2 ? 1 : 0) != 0, (String)"Invalid parameter: %s", (Object)keyValuePair);
                String key = keyAndValue[0];
                String value = keyAndValue[1];
                if (!key.equalsIgnoreCase(NOMINAL_ENTRIES_KEY)) {
                    throw new IllegalArgumentException("Invalid parameter key: " + key);
                }
                this._nominalEntries = Integer.parseInt(value);
            }
        }

        int getNominalEntries() {
            return this._nominalEntries;
        }
    }
}

