/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.function;

import java.math.BigDecimal;
import java.util.Map;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.query.aggregation.AggregationResultHolder;
import org.apache.pinot.core.query.aggregation.DoubleAggregationResultHolder;
import org.apache.pinot.core.query.aggregation.ObjectAggregationResultHolder;
import org.apache.pinot.core.query.aggregation.function.BaseSingleInputAggregationFunction;
import org.apache.pinot.core.query.aggregation.groupby.DoubleGroupByResultHolder;
import org.apache.pinot.core.query.aggregation.groupby.GroupByResultHolder;
import org.apache.pinot.core.query.aggregation.groupby.ObjectGroupByResultHolder;
import org.apache.pinot.segment.spi.AggregationFunctionType;
import org.roaringbitmap.RoaringBitmap;

public class MinAggregationFunction
extends BaseSingleInputAggregationFunction<Double, Double> {
    private static final double DEFAULT_VALUE = Double.POSITIVE_INFINITY;
    private final boolean _nullHandlingEnabled;

    public MinAggregationFunction(ExpressionContext expression) {
        this(expression, false);
    }

    public MinAggregationFunction(ExpressionContext expression, boolean nullHandlingEnabled) {
        super(expression);
        this._nullHandlingEnabled = nullHandlingEnabled;
    }

    @Override
    public AggregationFunctionType getType() {
        return AggregationFunctionType.MIN;
    }

    @Override
    public AggregationResultHolder createAggregationResultHolder() {
        if (this._nullHandlingEnabled) {
            return new ObjectAggregationResultHolder();
        }
        return new DoubleAggregationResultHolder(Double.POSITIVE_INFINITY);
    }

    @Override
    public GroupByResultHolder createGroupByResultHolder(int initialCapacity, int maxCapacity) {
        if (this._nullHandlingEnabled) {
            return new ObjectGroupByResultHolder(initialCapacity, maxCapacity);
        }
        return new DoubleGroupByResultHolder(initialCapacity, maxCapacity, Double.POSITIVE_INFINITY);
    }

    @Override
    public void aggregate(int length, AggregationResultHolder aggregationResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        RoaringBitmap nullBitmap;
        BlockValSet blockValSet = blockValSetMap.get(this._expression);
        if (this._nullHandlingEnabled && (nullBitmap = blockValSet.getNullBitmap()) != null && !nullBitmap.isEmpty()) {
            this.aggregateNullHandlingEnabled(length, aggregationResultHolder, blockValSet, nullBitmap);
            return;
        }
        switch (blockValSet.getValueType().getStoredType()) {
            case INT: {
                Object[] values = blockValSet.getIntValuesSV();
                int min = values[0];
                int i = 0;
                while (i < length & i < values.length) {
                    min = Math.min(values[i], min);
                    ++i;
                }
                aggregationResultHolder.setValue(Math.min((double)min, aggregationResultHolder.getDoubleResult()));
                break;
            }
            case LONG: {
                Object[] values = blockValSet.getLongValuesSV();
                int min = values[0];
                int i = 0;
                while (i < length & i < values.length) {
                    min = (int)Math.min((long)values[i], (long)min);
                    ++i;
                }
                aggregationResultHolder.setValue(Math.min((double)min, aggregationResultHolder.getDoubleResult()));
                break;
            }
            case FLOAT: {
                Object[] values = blockValSet.getFloatValuesSV();
                int min = values[0];
                int i = 0;
                while (i < length & i < values.length) {
                    min = (int)Math.min((float)values[i], (float)min);
                    ++i;
                }
                aggregationResultHolder.setValue(Math.min((double)min, aggregationResultHolder.getDoubleResult()));
                break;
            }
            case DOUBLE: {
                Object[] values = blockValSet.getDoubleValuesSV();
                int min = values[0];
                int i = 0;
                while (i < length & i < values.length) {
                    min = (int)Math.min((double)values[i], (double)min);
                    ++i;
                }
                aggregationResultHolder.setValue(Math.min((double)min, aggregationResultHolder.getDoubleResult()));
                break;
            }
            case BIG_DECIMAL: {
                Object[] values = blockValSet.getBigDecimalValuesSV();
                Object min = values[0];
                int i = 0;
                while (i < length & i < values.length) {
                    min = values[i].min((BigDecimal)min);
                    ++i;
                }
                aggregationResultHolder.setValue(Math.min(min.doubleValue(), aggregationResultHolder.getDoubleResult()));
                break;
            }
            default: {
                throw new IllegalStateException("Cannot compute min for non-numeric type: " + blockValSet.getValueType());
            }
        }
    }

    private void aggregateNullHandlingEnabled(int length, AggregationResultHolder aggregationResultHolder, BlockValSet blockValSet, RoaringBitmap nullBitmap) {
        switch (blockValSet.getValueType().getStoredType()) {
            case INT: {
                if (nullBitmap.getCardinality() >= length) break;
                int[] values = blockValSet.getIntValuesSV();
                int min = Integer.MAX_VALUE;
                int i = 0;
                while (i < length & i < values.length) {
                    if (!nullBitmap.contains(i)) {
                        min = Math.min(values[i], min);
                    }
                    ++i;
                }
                this.updateAggregationResultHolder(aggregationResultHolder, min);
                break;
            }
            case LONG: {
                if (nullBitmap.getCardinality() >= length) break;
                long[] values = blockValSet.getLongValuesSV();
                long min = Long.MAX_VALUE;
                int i = 0;
                while (i < length & i < values.length) {
                    if (!nullBitmap.contains(i)) {
                        min = Math.min(values[i], min);
                    }
                    ++i;
                }
                this.updateAggregationResultHolder(aggregationResultHolder, min);
                break;
            }
            case FLOAT: {
                if (nullBitmap.getCardinality() >= length) break;
                float[] values = blockValSet.getFloatValuesSV();
                float min = Float.POSITIVE_INFINITY;
                int i = 0;
                while (i < length & i < values.length) {
                    if (!nullBitmap.contains(i)) {
                        min = Math.min(values[i], min);
                    }
                    ++i;
                }
                this.updateAggregationResultHolder(aggregationResultHolder, min);
                break;
            }
            case DOUBLE: {
                if (nullBitmap.getCardinality() >= length) break;
                double[] values = blockValSet.getDoubleValuesSV();
                double min = Double.POSITIVE_INFINITY;
                int i = 0;
                while (i < length & i < values.length) {
                    if (!nullBitmap.contains(i)) {
                        min = Math.min(values[i], min);
                    }
                    ++i;
                }
                this.updateAggregationResultHolder(aggregationResultHolder, min);
                break;
            }
            case BIG_DECIMAL: {
                if (nullBitmap.getCardinality() >= length) break;
                BigDecimal[] values = blockValSet.getBigDecimalValuesSV();
                BigDecimal min = null;
                int i = 0;
                while (i < length & i < values.length) {
                    if (!nullBitmap.contains(i)) {
                        min = min == null ? values[i] : values[i].min(min);
                    }
                    ++i;
                }
                assert (min != null);
                this.updateAggregationResultHolder(aggregationResultHolder, min.doubleValue());
                break;
            }
            default: {
                throw new IllegalStateException("Cannot compute min for non-numeric type: " + blockValSet.getValueType());
            }
        }
    }

    private void updateAggregationResultHolder(AggregationResultHolder aggregationResultHolder, double min) {
        Double otherMin = (Double)aggregationResultHolder.getResult();
        aggregationResultHolder.setValue(otherMin == null ? min : Math.min(min, otherMin));
    }

    @Override
    public void aggregateGroupBySV(int length, int[] groupKeyArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        RoaringBitmap nullBitmap;
        BlockValSet blockValSet = blockValSetMap.get(this._expression);
        if (this._nullHandlingEnabled && (nullBitmap = blockValSet.getNullBitmap()) != null && !nullBitmap.isEmpty()) {
            if (nullBitmap.getCardinality() < length) {
                double[] valueArray = blockValSet.getDoubleValuesSV();
                for (int i = 0; i < length; ++i) {
                    double value = valueArray[i];
                    int groupKey = groupKeyArray[i];
                    Double result = (Double)groupByResultHolder.getResult(groupKey);
                    if (nullBitmap.contains(i) || result != null && !(value < result)) continue;
                    groupByResultHolder.setValueForKey(groupKey, value);
                }
            }
            return;
        }
        double[] valueArray = blockValSet.getDoubleValuesSV();
        for (int i = 0; i < length; ++i) {
            double value = valueArray[i];
            int groupKey = groupKeyArray[i];
            if (!(value < groupByResultHolder.getDoubleResult(groupKey))) continue;
            groupByResultHolder.setValueForKey(groupKey, value);
        }
    }

    @Override
    public void aggregateGroupByMV(int length, int[][] groupKeysArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        double[] valueArray = blockValSetMap.get(this._expression).getDoubleValuesSV();
        for (int i = 0; i < length; ++i) {
            double value = valueArray[i];
            for (int groupKey : groupKeysArray[i]) {
                if (!(value < groupByResultHolder.getDoubleResult(groupKey))) continue;
                groupByResultHolder.setValueForKey(groupKey, value);
            }
        }
    }

    @Override
    public Double extractAggregationResult(AggregationResultHolder aggregationResultHolder) {
        if (this._nullHandlingEnabled) {
            return (Double)aggregationResultHolder.getResult();
        }
        return aggregationResultHolder.getDoubleResult();
    }

    @Override
    public Double extractGroupByResult(GroupByResultHolder groupByResultHolder, int groupKey) {
        if (this._nullHandlingEnabled) {
            return (Double)groupByResultHolder.getResult(groupKey);
        }
        return groupByResultHolder.getDoubleResult(groupKey);
    }

    @Override
    public Double merge(Double intermediateMinResult1, Double intermediateMinResult2) {
        if (this._nullHandlingEnabled) {
            if (intermediateMinResult1 == null) {
                return intermediateMinResult2;
            }
            if (intermediateMinResult2 == null) {
                return intermediateMinResult1;
            }
        }
        if (intermediateMinResult1 < intermediateMinResult2) {
            return intermediateMinResult1;
        }
        return intermediateMinResult2;
    }

    @Override
    public DataSchema.ColumnDataType getIntermediateResultColumnType() {
        return DataSchema.ColumnDataType.DOUBLE;
    }

    @Override
    public DataSchema.ColumnDataType getFinalResultColumnType() {
        return DataSchema.ColumnDataType.DOUBLE;
    }

    @Override
    public Double extractFinalResult(Double intermediateResult) {
        return intermediateResult;
    }
}

