/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.pruner;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.request.context.FilterContext;
import org.apache.pinot.common.request.context.predicate.EqPredicate;
import org.apache.pinot.common.request.context.predicate.InPredicate;
import org.apache.pinot.common.request.context.predicate.Predicate;
import org.apache.pinot.common.request.context.predicate.RangePredicate;
import org.apache.pinot.core.query.pruner.SegmentPruner;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.segment.local.segment.index.readers.bloom.GuavaBloomFilterReaderUtils;
import org.apache.pinot.segment.spi.FetchContext;
import org.apache.pinot.segment.spi.ImmutableSegment;
import org.apache.pinot.segment.spi.IndexSegment;
import org.apache.pinot.segment.spi.datasource.DataSource;
import org.apache.pinot.segment.spi.datasource.DataSourceMetadata;
import org.apache.pinot.segment.spi.index.reader.BloomFilterReader;
import org.apache.pinot.segment.spi.partition.PartitionFunction;
import org.apache.pinot.segment.spi.store.ColumnIndexType;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.env.PinotConfiguration;
import org.apache.pinot.spi.exception.BadQueryRequestException;

public class ColumnValueSegmentPruner
implements SegmentPruner {
    public static final String IN_PREDICATE_THRESHOLD = "inpredicate.threshold";
    private int _inPredicateThreshold;

    @Override
    public void init(PinotConfiguration config) {
        this._inPredicateThreshold = config.getProperty(IN_PREDICATE_THRESHOLD, 10);
    }

    @Override
    public boolean isApplicableTo(QueryContext query) {
        return query.getFilter() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IndexSegment> prune(List<IndexSegment> segments, QueryContext query) {
        if (segments.isEmpty()) {
            return segments;
        }
        FilterContext filter = Objects.requireNonNull(query.getFilter());
        HashSet<String> eqInColumns = new HashSet<String>();
        HashSet<String> rangeColumns = new HashSet<String>();
        ValueCache cachedValues = new ValueCache();
        this.extractPredicateColumns(filter, eqInColumns, rangeColumns, cachedValues);
        if (eqInColumns.isEmpty() && rangeColumns.isEmpty()) {
            return segments;
        }
        int numSegments = segments.size();
        ArrayList<IndexSegment> selectedSegments = new ArrayList<IndexSegment>(numSegments);
        if (!eqInColumns.isEmpty() && query.isEnablePrefetch()) {
            int i;
            Map[] dataSourceCaches = new Map[numSegments];
            FetchContext[] fetchContexts = new FetchContext[numSegments];
            try {
                IndexSegment segment;
                for (i = 0; i < numSegments; ++i) {
                    segment = segments.get(i);
                    HashMap<String, DataSource> dataSourceCache = new HashMap<String, DataSource>();
                    HashMap<String, List<ColumnIndexType>> columnToIndexList = new HashMap<String, List<ColumnIndexType>>();
                    for (String column : eqInColumns) {
                        DataSource dataSource = segment.getDataSource(column);
                        dataSourceCache.put(column, dataSource);
                        if (dataSource.getBloomFilter() == null) continue;
                        columnToIndexList.put(column, Collections.singletonList(ColumnIndexType.BLOOM_FILTER));
                    }
                    dataSourceCaches[i] = dataSourceCache;
                    if (columnToIndexList.isEmpty()) continue;
                    FetchContext fetchContext = new FetchContext(UUID.randomUUID(), segment.getSegmentName(), columnToIndexList);
                    segment.prefetch(fetchContext);
                    fetchContexts[i] = fetchContext;
                }
                for (i = 0; i < numSegments; ++i) {
                    segment = segments.get(i);
                    FetchContext fetchContext = fetchContexts[i];
                    if (fetchContext != null) {
                        segment.acquire(fetchContext);
                        try {
                            if (this.pruneSegment(segment, filter, dataSourceCaches[i], cachedValues)) continue;
                            selectedSegments.add(segment);
                            continue;
                        }
                        finally {
                            segment.release(fetchContext);
                        }
                    }
                    if (this.pruneSegment(segment, filter, dataSourceCaches[i], cachedValues)) continue;
                    selectedSegments.add(segment);
                }
            }
            finally {
                for (i = 0; i < numSegments; ++i) {
                    FetchContext fetchContext = fetchContexts[i];
                    if (fetchContext == null) continue;
                    segments.get(i).release(fetchContext);
                }
            }
        } else {
            HashMap<String, DataSource> dataSourceCache = new HashMap<String, DataSource>();
            for (IndexSegment segment : segments) {
                dataSourceCache.clear();
                if (this.pruneSegment(segment, filter, dataSourceCache, cachedValues)) continue;
                selectedSegments.add(segment);
            }
        }
        return selectedSegments;
    }

    private void extractPredicateColumns(FilterContext filter, Set<String> eqInColumns, Set<String> rangeColumns, ValueCache valueCache) {
        block0 : switch (filter.getType()) {
            case AND: 
            case OR: {
                for (FilterContext child : filter.getChildren()) {
                    this.extractPredicateColumns(child, eqInColumns, rangeColumns, valueCache);
                }
                break;
            }
            case NOT: {
                break;
            }
            case PREDICATE: {
                Predicate predicate = filter.getPredicate();
                ExpressionContext lhs = predicate.getLhs();
                if (lhs.getType() != ExpressionContext.Type.IDENTIFIER) break;
                String column = lhs.getIdentifier();
                Predicate.Type predicateType = predicate.getType();
                switch (predicateType) {
                    case EQ: {
                        eqInColumns.add(column);
                        valueCache.add((EqPredicate)predicate);
                        break;
                    }
                    case IN: {
                        InPredicate inPredicate = (InPredicate)predicate;
                        if (inPredicate.getValues().size() > this._inPredicateThreshold) break block0;
                        eqInColumns.add(column);
                        valueCache.add(inPredicate);
                        break;
                    }
                    case RANGE: {
                        rangeColumns.add(column);
                        break;
                    }
                }
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    private boolean pruneSegment(IndexSegment segment, FilterContext filter, Map<String, DataSource> dataSourceCache, ValueCache cachedValues) {
        switch (filter.getType()) {
            case AND: {
                for (FilterContext child : filter.getChildren()) {
                    if (!this.pruneSegment(segment, child, dataSourceCache, cachedValues)) continue;
                    return true;
                }
                return false;
            }
            case OR: {
                for (FilterContext child : filter.getChildren()) {
                    if (this.pruneSegment(segment, child, dataSourceCache, cachedValues)) continue;
                    return false;
                }
                return true;
            }
            case NOT: {
                return false;
            }
            case PREDICATE: {
                Predicate predicate = filter.getPredicate();
                if (predicate.getLhs().getType() != ExpressionContext.Type.IDENTIFIER) {
                    return false;
                }
                Predicate.Type predicateType = predicate.getType();
                if (predicateType == Predicate.Type.EQ) {
                    return this.pruneEqPredicate(segment, (EqPredicate)predicate, dataSourceCache, cachedValues);
                }
                if (predicateType == Predicate.Type.IN) {
                    return this.pruneInPredicate(segment, (InPredicate)predicate, dataSourceCache, cachedValues);
                }
                if (predicateType == Predicate.Type.RANGE) {
                    return this.pruneRangePredicate(segment, (RangePredicate)predicate, dataSourceCache);
                }
                return false;
            }
        }
        throw new IllegalStateException();
    }

    private boolean pruneEqPredicate(IndexSegment segment, EqPredicate eqPredicate, Map<String, DataSource> dataSourceCache, ValueCache valueCache) {
        BloomFilterReader bloomFilter;
        ValueCache.CachedValue cachedValue;
        Comparable value;
        DataSource dataSource;
        String column = eqPredicate.getLhs().getIdentifier();
        DataSource dataSource2 = dataSource = segment instanceof ImmutableSegment ? segment.getDataSource(column) : dataSourceCache.computeIfAbsent(column, arg_0 -> ((IndexSegment)segment).getDataSource(arg_0));
        assert (dataSource != null);
        DataSourceMetadata dataSourceMetadata = dataSource.getDataSourceMetadata();
        if (!this.checkMinMaxRange(dataSourceMetadata, value = (cachedValue = valueCache.get(eqPredicate, dataSourceMetadata.getDataType())).getComparableValue())) {
            return true;
        }
        PartitionFunction partitionFunction = dataSourceMetadata.getPartitionFunction();
        if (partitionFunction != null) {
            Set partitions = dataSourceMetadata.getPartitions();
            assert (partitions != null);
            if (!partitions.contains(partitionFunction.getPartition((Object)value))) {
                return true;
            }
        }
        return (bloomFilter = dataSource.getBloomFilter()) != null && !cachedValue.mightBeContained(bloomFilter);
    }

    private boolean pruneInPredicate(IndexSegment segment, InPredicate inPredicate, Map<String, DataSource> dataSourceCache, ValueCache valueCache) {
        DataSource dataSource;
        String column = inPredicate.getLhs().getIdentifier();
        DataSource dataSource2 = dataSource = segment instanceof ImmutableSegment ? segment.getDataSource(column) : dataSourceCache.computeIfAbsent(column, arg_0 -> ((IndexSegment)segment).getDataSource(arg_0));
        assert (dataSource != null);
        DataSourceMetadata dataSourceMetadata = dataSource.getDataSourceMetadata();
        List values = inPredicate.getValues();
        if (values.size() > this._inPredicateThreshold) {
            return false;
        }
        List<ValueCache.CachedValue> cachedValues = valueCache.get(inPredicate, dataSourceMetadata.getDataType());
        boolean someInRange = false;
        for (ValueCache.CachedValue value : cachedValues) {
            if (!this.checkMinMaxRange(dataSourceMetadata, value.getComparableValue())) continue;
            someInRange = true;
            break;
        }
        if (!someInRange) {
            return true;
        }
        BloomFilterReader bloomFilter = dataSource.getBloomFilter();
        if (bloomFilter == null) {
            return false;
        }
        for (ValueCache.CachedValue value : cachedValues) {
            if (!value.mightBeContained(bloomFilter)) continue;
            return false;
        }
        return true;
    }

    private boolean checkMinMaxRange(DataSourceMetadata dataSourceMetadata, Comparable value) {
        Comparable minValue = dataSourceMetadata.getMinValue();
        if (minValue != null && value.compareTo(minValue) < 0) {
            return false;
        }
        Comparable maxValue = dataSourceMetadata.getMaxValue();
        return maxValue == null || value.compareTo(maxValue) <= 0;
    }

    private boolean pruneRangePredicate(IndexSegment segment, RangePredicate rangePredicate, Map<String, DataSource> dataSourceCache) {
        DataSource dataSource;
        String column = rangePredicate.getLhs().getIdentifier();
        DataSource dataSource2 = dataSource = segment instanceof ImmutableSegment ? segment.getDataSource(column) : dataSourceCache.computeIfAbsent(column, arg_0 -> ((IndexSegment)segment).getDataSource(arg_0));
        assert (dataSource != null);
        DataSourceMetadata dataSourceMetadata = dataSource.getDataSourceMetadata();
        FieldSpec.DataType dataType = dataSourceMetadata.getDataType();
        String lowerBound = rangePredicate.getLowerBound();
        Comparable lowerBoundValue = null;
        if (!lowerBound.equals("*")) {
            lowerBoundValue = ColumnValueSegmentPruner.convertValue(lowerBound, dataType);
        }
        boolean lowerInclusive = rangePredicate.isLowerInclusive();
        String upperBound = rangePredicate.getUpperBound();
        Comparable upperBoundValue = null;
        if (!upperBound.equals("*")) {
            upperBoundValue = ColumnValueSegmentPruner.convertValue(upperBound, dataType);
        }
        boolean upperInclusive = rangePredicate.isUpperInclusive();
        if (lowerBoundValue != null && upperBoundValue != null && (lowerInclusive && upperInclusive ? lowerBoundValue.compareTo(upperBoundValue) > 0 : lowerBoundValue.compareTo(upperBoundValue) >= 0)) {
            return true;
        }
        Comparable minValue = dataSourceMetadata.getMinValue();
        if (minValue != null && upperBoundValue != null && (upperInclusive ? upperBoundValue.compareTo(minValue) < 0 : upperBoundValue.compareTo(minValue) <= 0)) {
            return true;
        }
        Comparable maxValue = dataSourceMetadata.getMaxValue();
        return maxValue != null && lowerBoundValue != null && (lowerInclusive ? lowerBoundValue.compareTo(maxValue) > 0 : lowerBoundValue.compareTo(maxValue) >= 0);
    }

    private static Comparable convertValue(String stringValue, FieldSpec.DataType dataType) {
        try {
            return dataType.convertInternal(stringValue);
        }
        catch (Exception e) {
            throw new BadQueryRequestException((Throwable)e);
        }
    }

    private static class ValueCache {
        private final Map<Predicate, Object> _cache = new IdentityHashMap<Predicate, Object>();

        private ValueCache() {
        }

        public void add(EqPredicate pred) {
            this._cache.put((Predicate)pred, new CachedValue(pred.getValue()));
        }

        public void add(InPredicate pred) {
            ArrayList<CachedValue> list = new ArrayList<CachedValue>(pred.getValues().size());
            for (String value : pred.getValues()) {
                list.add(new CachedValue(value));
            }
            this._cache.put((Predicate)pred, list);
        }

        public CachedValue get(EqPredicate pred, FieldSpec.DataType dt) {
            CachedValue cachedValue = (CachedValue)this._cache.get(pred);
            cachedValue.ensureDataType(dt);
            return cachedValue;
        }

        public List<CachedValue> get(InPredicate pred, FieldSpec.DataType dt) {
            List cachedValues = (List)this._cache.get(pred);
            for (CachedValue cachedValue : cachedValues) {
                cachedValue.ensureDataType(dt);
            }
            return cachedValues;
        }

        public static class CachedValue {
            private final Object _value;
            private boolean _hashed = false;
            private long _hash1;
            private long _hash2;
            private FieldSpec.DataType _dt;
            private Comparable _comparableValue;

            private CachedValue(Object value) {
                this._value = value;
            }

            private Comparable getComparableValue() {
                assert (this._dt != null);
                return this._comparableValue;
            }

            private void ensureDataType(FieldSpec.DataType dt) {
                if (dt != this._dt) {
                    String strValue = this._value.toString();
                    this._dt = dt;
                    this._comparableValue = ColumnValueSegmentPruner.convertValue(strValue, dt);
                    this._hashed = false;
                }
            }

            private boolean mightBeContained(BloomFilterReader bloomFilter) {
                if (!this._hashed) {
                    GuavaBloomFilterReaderUtils.Hash128AsLongs hash128AsLongs = GuavaBloomFilterReaderUtils.hashAsLongs((String)this._comparableValue.toString());
                    this._hash1 = hash128AsLongs.getHash1();
                    this._hash2 = hash128AsLongs.getHash2();
                    this._hashed = true;
                }
                return bloomFilter.mightContain(this._hash1, this._hash2);
            }
        }
    }
}

