/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.reduce.filter;

import java.util.List;
import org.apache.pinot.common.request.context.FilterContext;
import org.apache.pinot.core.query.reduce.filter.RowMatcher;
import org.apache.pinot.core.query.reduce.filter.RowMatcherFactory;
import org.apache.pinot.core.query.reduce.filter.ValueExtractorFactory;

public class AndRowMatcher
implements RowMatcher {
    private final RowMatcher[] _childMatchers;

    public AndRowMatcher(List<FilterContext> childFilters, ValueExtractorFactory valueExtractorFactory, boolean nullHandlingEnabled) {
        int numChildren = childFilters.size();
        this._childMatchers = new RowMatcher[numChildren];
        for (int i = 0; i < numChildren; ++i) {
            this._childMatchers[i] = RowMatcherFactory.getRowMatcher(childFilters.get(i), valueExtractorFactory, nullHandlingEnabled);
        }
    }

    @Override
    public boolean isMatch(Object[] row) {
        for (RowMatcher childMatcher : this._childMatchers) {
            if (childMatcher.isMatch(row)) continue;
            return false;
        }
        return true;
    }
}

