/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.scheduler;

import com.google.common.base.Preconditions;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.pinot.core.query.scheduler.SchedulerGroup;
import org.apache.pinot.core.query.scheduler.SchedulerQueryContext;

public abstract class AbstractSchedulerGroup
implements SchedulerGroup {
    protected final ConcurrentLinkedQueue<SchedulerQueryContext> _pendingQueries = new ConcurrentLinkedQueue();
    protected final String _name;
    protected final AtomicInteger _numRunning = new AtomicInteger(0);
    protected final AtomicInteger _threadsInUse = new AtomicInteger(0);
    protected final AtomicInteger _reservedThreads = new AtomicInteger(0);

    public AbstractSchedulerGroup(String name) {
        Preconditions.checkNotNull((Object)name);
        this._name = name;
    }

    @Override
    public String name() {
        return this._name;
    }

    @Override
    public void addLast(SchedulerQueryContext query) {
        this._pendingQueries.add(query);
    }

    @Override
    public SchedulerQueryContext peekFirst() {
        return this._pendingQueries.peek();
    }

    @Override
    public SchedulerQueryContext removeFirst() {
        return this._pendingQueries.poll();
    }

    @Override
    public void trimExpired(long deadlineMillis) {
        Iterator<SchedulerQueryContext> iter = this._pendingQueries.iterator();
        while (iter.hasNext()) {
            SchedulerQueryContext next = iter.next();
            if (next.getArrivalTimeMs() >= deadlineMillis) continue;
            iter.remove();
        }
    }

    @Override
    public boolean isEmpty() {
        return this._pendingQueries.isEmpty();
    }

    @Override
    public int numPending() {
        return this._pendingQueries.size();
    }

    @Override
    public int numRunning() {
        return this._numRunning.get();
    }

    @Override
    public void incrementThreads() {
        this._threadsInUse.incrementAndGet();
    }

    @Override
    public void decrementThreads() {
        this._threadsInUse.decrementAndGet();
    }

    @Override
    public int getThreadsInUse() {
        return this._threadsInUse.get();
    }

    @Override
    public void addReservedThreads(int threads) {
        this._reservedThreads.addAndGet(threads);
    }

    @Override
    public void releasedReservedThreads(int threads) {
        this._reservedThreads.addAndGet(-1 * threads);
    }

    @Override
    public int totalReservedThreads() {
        return this._reservedThreads.get();
    }

    @Override
    public void startQuery() {
        this.incrementThreads();
        this._numRunning.incrementAndGet();
    }

    @Override
    public void endQuery() {
        this.decrementThreads();
        this._numRunning.decrementAndGet();
    }
}

