/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.scheduler.fcfs;

import java.util.concurrent.atomic.LongAccumulator;
import org.apache.pinot.common.metrics.ServerMetrics;
import org.apache.pinot.core.query.executor.QueryExecutor;
import org.apache.pinot.core.query.scheduler.MultiLevelPriorityQueue;
import org.apache.pinot.core.query.scheduler.PriorityScheduler;
import org.apache.pinot.core.query.scheduler.SchedulerGroup;
import org.apache.pinot.core.query.scheduler.SchedulerGroupFactory;
import org.apache.pinot.core.query.scheduler.SchedulerPriorityQueue;
import org.apache.pinot.core.query.scheduler.TableBasedGroupMapper;
import org.apache.pinot.core.query.scheduler.fcfs.FCFSSchedulerGroup;
import org.apache.pinot.core.query.scheduler.resources.PolicyBasedResourceManager;
import org.apache.pinot.core.query.scheduler.resources.ResourceManager;
import org.apache.pinot.spi.env.PinotConfiguration;

public class BoundedFCFSScheduler
extends PriorityScheduler {
    public static BoundedFCFSScheduler create(PinotConfiguration config, QueryExecutor queryExecutor, ServerMetrics serverMetrics, LongAccumulator latestQueryTime) {
        PolicyBasedResourceManager rm = new PolicyBasedResourceManager(config);
        SchedulerGroupFactory groupFactory = new SchedulerGroupFactory(){

            @Override
            public SchedulerGroup create(PinotConfiguration config, String groupName) {
                return new FCFSSchedulerGroup(groupName);
            }
        };
        MultiLevelPriorityQueue queue = new MultiLevelPriorityQueue(config, rm, groupFactory, new TableBasedGroupMapper());
        return new BoundedFCFSScheduler(config, rm, queryExecutor, queue, serverMetrics, latestQueryTime);
    }

    private BoundedFCFSScheduler(PinotConfiguration config, ResourceManager resourceManager, QueryExecutor queryExecutor, SchedulerPriorityQueue queue, ServerMetrics metrics, LongAccumulator latestQueryTime) {
        super(config, resourceManager, queryExecutor, queue, metrics, latestQueryTime);
    }

    @Override
    public String name() {
        return "BoundedFCFS";
    }
}

