/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.segment.processing.timehandler;

import org.apache.pinot.core.segment.processing.timehandler.TimeHandler;

public class TimeHandlerConfig {
    private final TimeHandler.Type _type;
    private final long _startTimeMs;
    private final long _endTimeMs;
    private final boolean _negateWindowFilter;
    private final long _roundBucketMs;
    private final long _partitionBucketMs;

    private TimeHandlerConfig(TimeHandler.Type type, long startTimeMs, long endTimeMs, boolean negateWindowFilter, long roundBucketMs, long partitionBucketMs) {
        this._type = type;
        this._startTimeMs = startTimeMs;
        this._endTimeMs = endTimeMs;
        this._negateWindowFilter = negateWindowFilter;
        this._roundBucketMs = roundBucketMs;
        this._partitionBucketMs = partitionBucketMs;
    }

    public TimeHandler.Type getType() {
        return this._type;
    }

    public long getStartTimeMs() {
        return this._startTimeMs;
    }

    public long getEndTimeMs() {
        return this._endTimeMs;
    }

    public boolean isNegateWindowFilter() {
        return this._negateWindowFilter;
    }

    public long getRoundBucketMs() {
        return this._roundBucketMs;
    }

    public long getPartitionBucketMs() {
        return this._partitionBucketMs;
    }

    public String toString() {
        return "TimeHandlerConfig{_type=" + this._type + ", _startTimeMs=" + this._startTimeMs + ", _endTimeMs=" + this._endTimeMs + ", _negateWindowFilter=" + this._negateWindowFilter + ", _roundBucketMs=" + this._roundBucketMs + ", _partitionBucketMs=" + this._partitionBucketMs + "}";
    }

    public static class Builder {
        private final TimeHandler.Type _type;
        private long _startTimeMs = -1L;
        private long _endTimeMs = -1L;
        private boolean _negateWindowFilter = false;
        private long _roundBucketMs = -1L;
        private long _partitionBucketMs = -1L;

        public Builder(TimeHandler.Type type) {
            this._type = type;
        }

        public Builder setTimeRange(long startTimeMs, long endTimeMs) {
            this._startTimeMs = startTimeMs;
            this._endTimeMs = endTimeMs;
            return this;
        }

        public Builder setNegateWindowFilter(boolean negateWindowFilter) {
            this._negateWindowFilter = negateWindowFilter;
            return this;
        }

        public Builder setRoundBucketMs(long roundBucketMs) {
            this._roundBucketMs = roundBucketMs;
            return this;
        }

        public Builder setPartitionBucketMs(long partitionBucketMs) {
            this._partitionBucketMs = partitionBucketMs;
            return this;
        }

        public TimeHandlerConfig build() {
            return new TimeHandlerConfig(this._type, this._startTimeMs, this._endTimeMs, this._negateWindowFilter, this._roundBucketMs, this._partitionBucketMs);
        }
    }
}

