/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.transport;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.kqueue.KQueue;
import io.netty.channel.kqueue.KQueueEventLoopGroup;
import io.netty.channel.kqueue.KQueueServerSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.ServerSocketChannel;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import java.util.concurrent.TimeUnit;
import org.apache.pinot.common.config.NettyConfig;
import org.apache.pinot.common.config.TlsConfig;
import org.apache.pinot.common.metrics.ServerMetrics;
import org.apache.pinot.core.query.scheduler.QueryScheduler;
import org.apache.pinot.core.transport.ChannelHandlerFactory;
import org.apache.pinot.core.util.OsCheck;
import org.apache.pinot.server.access.AccessControl;
import org.apache.pinot.server.access.AllowAllAccessFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryServer.class);
    private final int _port;
    private final QueryScheduler _queryScheduler;
    private final ServerMetrics _serverMetrics;
    private final TlsConfig _tlsConfig;
    private final AccessControl _accessControl;
    private final EventLoopGroup _bossGroup;
    private final EventLoopGroup _workerGroup;
    private final Class<? extends ServerSocketChannel> _channelClass;
    private Channel _channel;

    public QueryServer(int port, QueryScheduler queryScheduler, ServerMetrics serverMetrics, NettyConfig nettyConfig) {
        this(port, queryScheduler, serverMetrics, nettyConfig, null, new AllowAllAccessFactory().create());
    }

    public QueryServer(int port, QueryScheduler queryScheduler, ServerMetrics serverMetrics, NettyConfig nettyConfig, TlsConfig tlsConfig, AccessControl accessControl) {
        this._port = port;
        this._queryScheduler = queryScheduler;
        this._serverMetrics = serverMetrics;
        this._tlsConfig = tlsConfig;
        this._accessControl = accessControl;
        boolean enableNativeTransports = nettyConfig != null && nettyConfig.isNativeTransportsEnabled();
        OsCheck.OSType operatingSystemType = OsCheck.getOperatingSystemType();
        if (enableNativeTransports && operatingSystemType == OsCheck.OSType.Linux && Epoll.isAvailable()) {
            this._bossGroup = new EpollEventLoopGroup();
            this._workerGroup = new EpollEventLoopGroup();
            this._channelClass = EpollServerSocketChannel.class;
            LOGGER.info("Using Epoll event loop");
        } else if (enableNativeTransports && operatingSystemType == OsCheck.OSType.MacOS && KQueue.isAvailable()) {
            this._bossGroup = new KQueueEventLoopGroup();
            this._workerGroup = new KQueueEventLoopGroup();
            this._channelClass = KQueueServerSocketChannel.class;
            LOGGER.info("Using KQueue event loop");
        } else {
            this._bossGroup = new NioEventLoopGroup();
            this._workerGroup = new NioEventLoopGroup();
            this._channelClass = NioServerSocketChannel.class;
            StringBuilder log = new StringBuilder("Using NIO event loop");
            if (operatingSystemType == OsCheck.OSType.Linux && enableNativeTransports) {
                log.append(", as Epoll is not available: ").append(Epoll.unavailabilityCause());
            } else if (operatingSystemType == OsCheck.OSType.MacOS && enableNativeTransports) {
                log.append(", as KQueue is not available: ").append(KQueue.unavailabilityCause());
            }
            LOGGER.info(log.toString());
        }
    }

    public void start() {
        try {
            ServerBootstrap serverBootstrap = new ServerBootstrap();
            this._channel = ((ServerBootstrap)((ServerBootstrap)serverBootstrap.group(this._bossGroup, this._workerGroup).channel(this._channelClass)).option(ChannelOption.SO_BACKLOG, (Object)128)).childOption(ChannelOption.SO_KEEPALIVE, (Object)true).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel ch) {
                    if (QueryServer.this._tlsConfig != null) {
                        ch.pipeline().addLast("ssl", ChannelHandlerFactory.getServerTlsHandler(QueryServer.this._tlsConfig, ch));
                    }
                    ch.pipeline().addLast(new ChannelHandler[]{ChannelHandlerFactory.getLengthFieldBasedFrameDecoder()});
                    ch.pipeline().addLast(new ChannelHandler[]{ChannelHandlerFactory.getLengthFieldPrepender()});
                    ch.pipeline().addLast(new ChannelHandler[]{ChannelHandlerFactory.getInstanceRequestHandler(QueryServer.this._queryScheduler, QueryServer.this._serverMetrics, QueryServer.this._accessControl)});
                }
            }).bind(this._port).sync().channel();
        }
        catch (Exception e) {
            this._workerGroup.shutdownGracefully(0L, 0L, TimeUnit.SECONDS);
            this._bossGroup.shutdownGracefully(0L, 0L, TimeUnit.SECONDS);
            throw new RuntimeException(e);
        }
    }

    public void shutDown() {
        try {
            this._channel.close().sync();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this._workerGroup.shutdownGracefully(0L, 0L, TimeUnit.SECONDS);
            this._bossGroup.shutdownGracefully(0L, 0L, TimeUnit.SECONDS);
        }
    }
}

