/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tpch;

import io.trino.tpch.TpchEntity;
import java.util.Locale;
import java.util.Objects;

public class Nation
implements TpchEntity {
    private final long rowNumber;
    private final long nationKey;
    private final String name;
    private final long regionKey;
    private final String comment;

    public Nation(long rowNumber, long nationKey, String name, long regionKey, String comment) {
        this.rowNumber = rowNumber;
        this.nationKey = nationKey;
        this.name = Objects.requireNonNull(name, "name is null");
        this.regionKey = regionKey;
        this.comment = Objects.requireNonNull(comment, "comment is null");
    }

    @Override
    public long getRowNumber() {
        return this.rowNumber;
    }

    public long getNationKey() {
        return this.nationKey;
    }

    public String getName() {
        return this.name;
    }

    public long getRegionKey() {
        return this.regionKey;
    }

    public String getComment() {
        return this.comment;
    }

    @Override
    public String toLine() {
        return String.format(Locale.ENGLISH, "%d|%s|%d|%s|", this.nationKey, this.name, this.regionKey, this.comment);
    }
}

